# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeWorkersActivationArgs', 'EdgeWorkersActivation']

@pulumi.input_type
class EdgeWorkersActivationArgs:
    def __init__(__self__, *,
                 edgeworker_id: pulumi.Input[_builtins.int],
                 network: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['EdgeWorkersActivationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a EdgeWorkersActivation resource.
        :param pulumi.Input[_builtins.int] edgeworker_id: Id of the EdgeWorker to activate
        :param pulumi.Input[_builtins.str] network: The network on which the version will be activated
        :param pulumi.Input[_builtins.str] version: The version of EdgeWorker to activate
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the activation request
        :param pulumi.Input['EdgeWorkersActivationTimeoutsArgs'] timeouts: Enables to set timeout for processing
        """
        pulumi.set(__self__, "edgeworker_id", edgeworker_id)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "version", version)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="edgeworkerId")
    def edgeworker_id(self) -> pulumi.Input[_builtins.int]:
        """
        Id of the EdgeWorker to activate
        """
        return pulumi.get(self, "edgeworker_id")

    @edgeworker_id.setter
    def edgeworker_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "edgeworker_id", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        The network on which the version will be activated
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of EdgeWorker to activate
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assigns a log message to the activation request
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['EdgeWorkersActivationTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['EdgeWorkersActivationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _EdgeWorkersActivationState:
    def __init__(__self__, *,
                 activation_id: Optional[pulumi.Input[_builtins.int]] = None,
                 edgeworker_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['EdgeWorkersActivationTimeoutsArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EdgeWorkersActivation resources.
        :param pulumi.Input[_builtins.int] activation_id: A unique identifier of the activation
        :param pulumi.Input[_builtins.int] edgeworker_id: Id of the EdgeWorker to activate
        :param pulumi.Input[_builtins.str] network: The network on which the version will be activated
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the activation request
        :param pulumi.Input['EdgeWorkersActivationTimeoutsArgs'] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] version: The version of EdgeWorker to activate
        """
        if activation_id is not None:
            pulumi.set(__self__, "activation_id", activation_id)
        if edgeworker_id is not None:
            pulumi.set(__self__, "edgeworker_id", edgeworker_id)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A unique identifier of the activation
        """
        return pulumi.get(self, "activation_id")

    @activation_id.setter
    def activation_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "activation_id", value)

    @_builtins.property
    @pulumi.getter(name="edgeworkerId")
    def edgeworker_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Id of the EdgeWorker to activate
        """
        return pulumi.get(self, "edgeworker_id")

    @edgeworker_id.setter
    def edgeworker_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "edgeworker_id", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network on which the version will be activated
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assigns a log message to the activation request
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['EdgeWorkersActivationTimeoutsArgs']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['EdgeWorkersActivationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of EdgeWorker to activate
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("akamai:index/edgeWorkersActivation:EdgeWorkersActivation")
class EdgeWorkersActivation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edgeworker_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['EdgeWorkersActivationTimeoutsArgs', 'EdgeWorkersActivationTimeoutsArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a EdgeWorkersActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] edgeworker_id: Id of the EdgeWorker to activate
        :param pulumi.Input[_builtins.str] network: The network on which the version will be activated
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the activation request
        :param pulumi.Input[Union['EdgeWorkersActivationTimeoutsArgs', 'EdgeWorkersActivationTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] version: The version of EdgeWorker to activate
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeWorkersActivationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a EdgeWorkersActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param EdgeWorkersActivationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeWorkersActivationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edgeworker_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['EdgeWorkersActivationTimeoutsArgs', 'EdgeWorkersActivationTimeoutsArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeWorkersActivationArgs.__new__(EdgeWorkersActivationArgs)

            if edgeworker_id is None and not opts.urn:
                raise TypeError("Missing required property 'edgeworker_id'")
            __props__.__dict__["edgeworker_id"] = edgeworker_id
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["note"] = note
            __props__.__dict__["timeouts"] = timeouts
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["activation_id"] = None
        super(EdgeWorkersActivation, __self__).__init__(
            'akamai:index/edgeWorkersActivation:EdgeWorkersActivation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_id: Optional[pulumi.Input[_builtins.int]] = None,
            edgeworker_id: Optional[pulumi.Input[_builtins.int]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            note: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['EdgeWorkersActivationTimeoutsArgs', 'EdgeWorkersActivationTimeoutsArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'EdgeWorkersActivation':
        """
        Get an existing EdgeWorkersActivation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] activation_id: A unique identifier of the activation
        :param pulumi.Input[_builtins.int] edgeworker_id: Id of the EdgeWorker to activate
        :param pulumi.Input[_builtins.str] network: The network on which the version will be activated
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the activation request
        :param pulumi.Input[Union['EdgeWorkersActivationTimeoutsArgs', 'EdgeWorkersActivationTimeoutsArgsDict']] timeouts: Enables to set timeout for processing
        :param pulumi.Input[_builtins.str] version: The version of EdgeWorker to activate
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeWorkersActivationState.__new__(_EdgeWorkersActivationState)

        __props__.__dict__["activation_id"] = activation_id
        __props__.__dict__["edgeworker_id"] = edgeworker_id
        __props__.__dict__["network"] = network
        __props__.__dict__["note"] = note
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["version"] = version
        return EdgeWorkersActivation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> pulumi.Output[_builtins.int]:
        """
        A unique identifier of the activation
        """
        return pulumi.get(self, "activation_id")

    @_builtins.property
    @pulumi.getter(name="edgeworkerId")
    def edgeworker_id(self) -> pulumi.Output[_builtins.int]:
        """
        Id of the EdgeWorker to activate
        """
        return pulumi.get(self, "edgeworker_id")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The network on which the version will be activated
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Assigns a log message to the activation request
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.EdgeWorkersActivationTimeouts']]:
        """
        Enables to set timeout for processing
        """
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of EdgeWorker to activate
        """
        return pulumi.get(self, "version")

