# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IamApiClientArgs', 'IamApiClient']

@pulumi.input_type
class IamApiClientArgs:
    def __init__(__self__, *,
                 api_access: pulumi.Input['IamApiClientApiAccessArgs'],
                 authorized_users: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 client_name: pulumi.Input[_builtins.str],
                 client_type: pulumi.Input[_builtins.str],
                 credential: pulumi.Input['IamApiClientCredentialArgs'],
                 group_access: pulumi.Input['IamApiClientGroupAccessArgs'],
                 allow_account_switch: Optional[pulumi.Input[_builtins.bool]] = None,
                 can_auto_create_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_acl: Optional[pulumi.Input['IamApiClientIpAclArgs']] = None,
                 lock: Optional[pulumi.Input[_builtins.bool]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 purge_options: Optional[pulumi.Input['IamApiClientPurgeOptionsArgs']] = None):
        """
        The set of arguments for constructing a IamApiClient resource.
        :param pulumi.Input['IamApiClientApiAccessArgs'] api_access: The APIs the API client can access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_users: The API client's valid users. When the 'client_type' is either 'CLIENT' or 'USER_CLIENT', you need to specify a single username in an array.
        :param pulumi.Input[_builtins.str] client_name: A human-readable name for the API client.
        :param pulumi.Input[_builtins.str] client_type: Specifies the API client's ownership and credential management. 'CLIENT' indicates the creator owns and manages the credentials. 'USER_CLIENT' indicates another user owns the client and manages the credentials.
        :param pulumi.Input['IamApiClientGroupAccessArgs'] group_access: Specifies the API client's group access.
        :param pulumi.Input[_builtins.bool] allow_account_switch: Enables the API client to manage more than one account.
        :param pulumi.Input[_builtins.bool] can_auto_create_credential: Whether the API client can create a credential for a new API client. The default is false.
        :param pulumi.Input[_builtins.str] client_description: A human-readable description of the API client.
        :param pulumi.Input['IamApiClientIpAclArgs'] ip_acl: Specifies the API client's IP list restriction.
        :param pulumi.Input[_builtins.bool] lock: Whether to lock or unlock the API client.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: Email addresses to notify users when credentials expire.
        :param pulumi.Input['IamApiClientPurgeOptionsArgs'] purge_options: Configures the API client to access the Fast Purge API. Provide it only if the `apis` attribute includes an `api_name` of `CCU API`.
        """
        pulumi.set(__self__, "api_access", api_access)
        pulumi.set(__self__, "authorized_users", authorized_users)
        pulumi.set(__self__, "client_name", client_name)
        pulumi.set(__self__, "client_type", client_type)
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "group_access", group_access)
        if allow_account_switch is not None:
            pulumi.set(__self__, "allow_account_switch", allow_account_switch)
        if can_auto_create_credential is not None:
            pulumi.set(__self__, "can_auto_create_credential", can_auto_create_credential)
        if client_description is not None:
            pulumi.set(__self__, "client_description", client_description)
        if ip_acl is not None:
            pulumi.set(__self__, "ip_acl", ip_acl)
        if lock is not None:
            pulumi.set(__self__, "lock", lock)
        if notification_emails is not None:
            pulumi.set(__self__, "notification_emails", notification_emails)
        if purge_options is not None:
            pulumi.set(__self__, "purge_options", purge_options)

    @_builtins.property
    @pulumi.getter(name="apiAccess")
    def api_access(self) -> pulumi.Input['IamApiClientApiAccessArgs']:
        """
        The APIs the API client can access.
        """
        return pulumi.get(self, "api_access")

    @api_access.setter
    def api_access(self, value: pulumi.Input['IamApiClientApiAccessArgs']):
        pulumi.set(self, "api_access", value)

    @_builtins.property
    @pulumi.getter(name="authorizedUsers")
    def authorized_users(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The API client's valid users. When the 'client_type' is either 'CLIENT' or 'USER_CLIENT', you need to specify a single username in an array.
        """
        return pulumi.get(self, "authorized_users")

    @authorized_users.setter
    def authorized_users(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "authorized_users", value)

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> pulumi.Input[_builtins.str]:
        """
        A human-readable name for the API client.
        """
        return pulumi.get(self, "client_name")

    @client_name.setter
    def client_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_name", value)

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the API client's ownership and credential management. 'CLIENT' indicates the creator owns and manages the credentials. 'USER_CLIENT' indicates another user owns the client and manages the credentials.
        """
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_type", value)

    @_builtins.property
    @pulumi.getter
    def credential(self) -> pulumi.Input['IamApiClientCredentialArgs']:
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: pulumi.Input['IamApiClientCredentialArgs']):
        pulumi.set(self, "credential", value)

    @_builtins.property
    @pulumi.getter(name="groupAccess")
    def group_access(self) -> pulumi.Input['IamApiClientGroupAccessArgs']:
        """
        Specifies the API client's group access.
        """
        return pulumi.get(self, "group_access")

    @group_access.setter
    def group_access(self, value: pulumi.Input['IamApiClientGroupAccessArgs']):
        pulumi.set(self, "group_access", value)

    @_builtins.property
    @pulumi.getter(name="allowAccountSwitch")
    def allow_account_switch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables the API client to manage more than one account.
        """
        return pulumi.get(self, "allow_account_switch")

    @allow_account_switch.setter
    def allow_account_switch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_account_switch", value)

    @_builtins.property
    @pulumi.getter(name="canAutoCreateCredential")
    def can_auto_create_credential(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the API client can create a credential for a new API client. The default is false.
        """
        return pulumi.get(self, "can_auto_create_credential")

    @can_auto_create_credential.setter
    def can_auto_create_credential(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "can_auto_create_credential", value)

    @_builtins.property
    @pulumi.getter(name="clientDescription")
    def client_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the API client.
        """
        return pulumi.get(self, "client_description")

    @client_description.setter
    def client_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_description", value)

    @_builtins.property
    @pulumi.getter(name="ipAcl")
    def ip_acl(self) -> Optional[pulumi.Input['IamApiClientIpAclArgs']]:
        """
        Specifies the API client's IP list restriction.
        """
        return pulumi.get(self, "ip_acl")

    @ip_acl.setter
    def ip_acl(self, value: Optional[pulumi.Input['IamApiClientIpAclArgs']]):
        pulumi.set(self, "ip_acl", value)

    @_builtins.property
    @pulumi.getter
    def lock(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to lock or unlock the API client.
        """
        return pulumi.get(self, "lock")

    @lock.setter
    def lock(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lock", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Email addresses to notify users when credentials expire.
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter(name="purgeOptions")
    def purge_options(self) -> Optional[pulumi.Input['IamApiClientPurgeOptionsArgs']]:
        """
        Configures the API client to access the Fast Purge API. Provide it only if the `apis` attribute includes an `api_name` of `CCU API`.
        """
        return pulumi.get(self, "purge_options")

    @purge_options.setter
    def purge_options(self, value: Optional[pulumi.Input['IamApiClientPurgeOptionsArgs']]):
        pulumi.set(self, "purge_options", value)


@pulumi.input_type
class _IamApiClientState:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 actions: Optional[pulumi.Input['IamApiClientActionsArgs']] = None,
                 active_credential_count: Optional[pulumi.Input[_builtins.int]] = None,
                 allow_account_switch: Optional[pulumi.Input[_builtins.bool]] = None,
                 api_access: Optional[pulumi.Input['IamApiClientApiAccessArgs']] = None,
                 authorized_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 base_url: Optional[pulumi.Input[_builtins.str]] = None,
                 can_auto_create_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_description: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_name: Optional[pulumi.Input[_builtins.str]] = None,
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_date: Optional[pulumi.Input[_builtins.str]] = None,
                 credential: Optional[pulumi.Input['IamApiClientCredentialArgs']] = None,
                 group_access: Optional[pulumi.Input['IamApiClientGroupAccessArgs']] = None,
                 ip_acl: Optional[pulumi.Input['IamApiClientIpAclArgs']] = None,
                 lock: Optional[pulumi.Input[_builtins.bool]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 purge_options: Optional[pulumi.Input['IamApiClientPurgeOptionsArgs']] = None):
        """
        Input properties used for looking up and filtering IamApiClient resources.
        :param pulumi.Input[_builtins.str] access_token: The part of the client secret that identifies your API client and lets you access applications and resources.
        :param pulumi.Input['IamApiClientActionsArgs'] actions: Specifies activities available for the API client.
        :param pulumi.Input[_builtins.int] active_credential_count: The number of credentials active for the API client. When the count is zero, you can delete the API client without interruption.
        :param pulumi.Input[_builtins.bool] allow_account_switch: Enables the API client to manage more than one account.
        :param pulumi.Input['IamApiClientApiAccessArgs'] api_access: The APIs the API client can access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_users: The API client's valid users. When the 'client_type' is either 'CLIENT' or 'USER_CLIENT', you need to specify a single username in an array.
        :param pulumi.Input[_builtins.str] base_url: The base URL for the service.
        :param pulumi.Input[_builtins.bool] can_auto_create_credential: Whether the API client can create a credential for a new API client. The default is false.
        :param pulumi.Input[_builtins.str] client_description: A human-readable description of the API client.
        :param pulumi.Input[_builtins.str] client_id: A unique identifier for the API client.
        :param pulumi.Input[_builtins.str] client_name: A human-readable name for the API client.
        :param pulumi.Input[_builtins.str] client_type: Specifies the API client's ownership and credential management. 'CLIENT' indicates the creator owns and manages the credentials. 'USER_CLIENT' indicates another user owns the client and manages the credentials.
        :param pulumi.Input[_builtins.str] created_by: The user who created the API client.
        :param pulumi.Input[_builtins.str] created_date: The ISO 8601 timestamp indicating when the API client was created.
        :param pulumi.Input['IamApiClientGroupAccessArgs'] group_access: Specifies the API client's group access.
        :param pulumi.Input['IamApiClientIpAclArgs'] ip_acl: Specifies the API client's IP list restriction.
        :param pulumi.Input[_builtins.bool] lock: Whether to lock or unlock the API client.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: Email addresses to notify users when credentials expire.
        :param pulumi.Input['IamApiClientPurgeOptionsArgs'] purge_options: Configures the API client to access the Fast Purge API. Provide it only if the `apis` attribute includes an `api_name` of `CCU API`.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if active_credential_count is not None:
            pulumi.set(__self__, "active_credential_count", active_credential_count)
        if allow_account_switch is not None:
            pulumi.set(__self__, "allow_account_switch", allow_account_switch)
        if api_access is not None:
            pulumi.set(__self__, "api_access", api_access)
        if authorized_users is not None:
            pulumi.set(__self__, "authorized_users", authorized_users)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if can_auto_create_credential is not None:
            pulumi.set(__self__, "can_auto_create_credential", can_auto_create_credential)
        if client_description is not None:
            pulumi.set(__self__, "client_description", client_description)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_name is not None:
            pulumi.set(__self__, "client_name", client_name)
        if client_type is not None:
            pulumi.set(__self__, "client_type", client_type)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if group_access is not None:
            pulumi.set(__self__, "group_access", group_access)
        if ip_acl is not None:
            pulumi.set(__self__, "ip_acl", ip_acl)
        if lock is not None:
            pulumi.set(__self__, "lock", lock)
        if notification_emails is not None:
            pulumi.set(__self__, "notification_emails", notification_emails)
        if purge_options is not None:
            pulumi.set(__self__, "purge_options", purge_options)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The part of the client secret that identifies your API client and lets you access applications and resources.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_token", value)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input['IamApiClientActionsArgs']]:
        """
        Specifies activities available for the API client.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input['IamApiClientActionsArgs']]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="activeCredentialCount")
    def active_credential_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of credentials active for the API client. When the count is zero, you can delete the API client without interruption.
        """
        return pulumi.get(self, "active_credential_count")

    @active_credential_count.setter
    def active_credential_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "active_credential_count", value)

    @_builtins.property
    @pulumi.getter(name="allowAccountSwitch")
    def allow_account_switch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables the API client to manage more than one account.
        """
        return pulumi.get(self, "allow_account_switch")

    @allow_account_switch.setter
    def allow_account_switch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_account_switch", value)

    @_builtins.property
    @pulumi.getter(name="apiAccess")
    def api_access(self) -> Optional[pulumi.Input['IamApiClientApiAccessArgs']]:
        """
        The APIs the API client can access.
        """
        return pulumi.get(self, "api_access")

    @api_access.setter
    def api_access(self, value: Optional[pulumi.Input['IamApiClientApiAccessArgs']]):
        pulumi.set(self, "api_access", value)

    @_builtins.property
    @pulumi.getter(name="authorizedUsers")
    def authorized_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The API client's valid users. When the 'client_type' is either 'CLIENT' or 'USER_CLIENT', you need to specify a single username in an array.
        """
        return pulumi.get(self, "authorized_users")

    @authorized_users.setter
    def authorized_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_users", value)

    @_builtins.property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base URL for the service.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_url", value)

    @_builtins.property
    @pulumi.getter(name="canAutoCreateCredential")
    def can_auto_create_credential(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the API client can create a credential for a new API client. The default is false.
        """
        return pulumi.get(self, "can_auto_create_credential")

    @can_auto_create_credential.setter
    def can_auto_create_credential(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "can_auto_create_credential", value)

    @_builtins.property
    @pulumi.getter(name="clientDescription")
    def client_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the API client.
        """
        return pulumi.get(self, "client_description")

    @client_description.setter
    def client_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_description", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for the API client.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable name for the API client.
        """
        return pulumi.get(self, "client_name")

    @client_name.setter
    def client_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_name", value)

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the API client's ownership and credential management. 'CLIENT' indicates the creator owns and manages the credentials. 'USER_CLIENT' indicates another user owns the client and manages the credentials.
        """
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_type", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user who created the API client.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO 8601 timestamp indicating when the API client was created.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_date", value)

    @_builtins.property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input['IamApiClientCredentialArgs']]:
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input['IamApiClientCredentialArgs']]):
        pulumi.set(self, "credential", value)

    @_builtins.property
    @pulumi.getter(name="groupAccess")
    def group_access(self) -> Optional[pulumi.Input['IamApiClientGroupAccessArgs']]:
        """
        Specifies the API client's group access.
        """
        return pulumi.get(self, "group_access")

    @group_access.setter
    def group_access(self, value: Optional[pulumi.Input['IamApiClientGroupAccessArgs']]):
        pulumi.set(self, "group_access", value)

    @_builtins.property
    @pulumi.getter(name="ipAcl")
    def ip_acl(self) -> Optional[pulumi.Input['IamApiClientIpAclArgs']]:
        """
        Specifies the API client's IP list restriction.
        """
        return pulumi.get(self, "ip_acl")

    @ip_acl.setter
    def ip_acl(self, value: Optional[pulumi.Input['IamApiClientIpAclArgs']]):
        pulumi.set(self, "ip_acl", value)

    @_builtins.property
    @pulumi.getter
    def lock(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to lock or unlock the API client.
        """
        return pulumi.get(self, "lock")

    @lock.setter
    def lock(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lock", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Email addresses to notify users when credentials expire.
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter(name="purgeOptions")
    def purge_options(self) -> Optional[pulumi.Input['IamApiClientPurgeOptionsArgs']]:
        """
        Configures the API client to access the Fast Purge API. Provide it only if the `apis` attribute includes an `api_name` of `CCU API`.
        """
        return pulumi.get(self, "purge_options")

    @purge_options.setter
    def purge_options(self, value: Optional[pulumi.Input['IamApiClientPurgeOptionsArgs']]):
        pulumi.set(self, "purge_options", value)


@pulumi.type_token("akamai:index/iamApiClient:IamApiClient")
class IamApiClient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_account_switch: Optional[pulumi.Input[_builtins.bool]] = None,
                 api_access: Optional[pulumi.Input[Union['IamApiClientApiAccessArgs', 'IamApiClientApiAccessArgsDict']]] = None,
                 authorized_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 can_auto_create_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_description: Optional[pulumi.Input[_builtins.str]] = None,
                 client_name: Optional[pulumi.Input[_builtins.str]] = None,
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 credential: Optional[pulumi.Input[Union['IamApiClientCredentialArgs', 'IamApiClientCredentialArgsDict']]] = None,
                 group_access: Optional[pulumi.Input[Union['IamApiClientGroupAccessArgs', 'IamApiClientGroupAccessArgsDict']]] = None,
                 ip_acl: Optional[pulumi.Input[Union['IamApiClientIpAclArgs', 'IamApiClientIpAclArgsDict']]] = None,
                 lock: Optional[pulumi.Input[_builtins.bool]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 purge_options: Optional[pulumi.Input[Union['IamApiClientPurgeOptionsArgs', 'IamApiClientPurgeOptionsArgsDict']]] = None,
                 __props__=None):
        """
        Create a IamApiClient resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_account_switch: Enables the API client to manage more than one account.
        :param pulumi.Input[Union['IamApiClientApiAccessArgs', 'IamApiClientApiAccessArgsDict']] api_access: The APIs the API client can access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_users: The API client's valid users. When the 'client_type' is either 'CLIENT' or 'USER_CLIENT', you need to specify a single username in an array.
        :param pulumi.Input[_builtins.bool] can_auto_create_credential: Whether the API client can create a credential for a new API client. The default is false.
        :param pulumi.Input[_builtins.str] client_description: A human-readable description of the API client.
        :param pulumi.Input[_builtins.str] client_name: A human-readable name for the API client.
        :param pulumi.Input[_builtins.str] client_type: Specifies the API client's ownership and credential management. 'CLIENT' indicates the creator owns and manages the credentials. 'USER_CLIENT' indicates another user owns the client and manages the credentials.
        :param pulumi.Input[Union['IamApiClientGroupAccessArgs', 'IamApiClientGroupAccessArgsDict']] group_access: Specifies the API client's group access.
        :param pulumi.Input[Union['IamApiClientIpAclArgs', 'IamApiClientIpAclArgsDict']] ip_acl: Specifies the API client's IP list restriction.
        :param pulumi.Input[_builtins.bool] lock: Whether to lock or unlock the API client.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: Email addresses to notify users when credentials expire.
        :param pulumi.Input[Union['IamApiClientPurgeOptionsArgs', 'IamApiClientPurgeOptionsArgsDict']] purge_options: Configures the API client to access the Fast Purge API. Provide it only if the `apis` attribute includes an `api_name` of `CCU API`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamApiClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a IamApiClient resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param IamApiClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamApiClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_account_switch: Optional[pulumi.Input[_builtins.bool]] = None,
                 api_access: Optional[pulumi.Input[Union['IamApiClientApiAccessArgs', 'IamApiClientApiAccessArgsDict']]] = None,
                 authorized_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 can_auto_create_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_description: Optional[pulumi.Input[_builtins.str]] = None,
                 client_name: Optional[pulumi.Input[_builtins.str]] = None,
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 credential: Optional[pulumi.Input[Union['IamApiClientCredentialArgs', 'IamApiClientCredentialArgsDict']]] = None,
                 group_access: Optional[pulumi.Input[Union['IamApiClientGroupAccessArgs', 'IamApiClientGroupAccessArgsDict']]] = None,
                 ip_acl: Optional[pulumi.Input[Union['IamApiClientIpAclArgs', 'IamApiClientIpAclArgsDict']]] = None,
                 lock: Optional[pulumi.Input[_builtins.bool]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 purge_options: Optional[pulumi.Input[Union['IamApiClientPurgeOptionsArgs', 'IamApiClientPurgeOptionsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamApiClientArgs.__new__(IamApiClientArgs)

            __props__.__dict__["allow_account_switch"] = allow_account_switch
            if api_access is None and not opts.urn:
                raise TypeError("Missing required property 'api_access'")
            __props__.__dict__["api_access"] = api_access
            if authorized_users is None and not opts.urn:
                raise TypeError("Missing required property 'authorized_users'")
            __props__.__dict__["authorized_users"] = authorized_users
            __props__.__dict__["can_auto_create_credential"] = can_auto_create_credential
            __props__.__dict__["client_description"] = client_description
            if client_name is None and not opts.urn:
                raise TypeError("Missing required property 'client_name'")
            __props__.__dict__["client_name"] = client_name
            if client_type is None and not opts.urn:
                raise TypeError("Missing required property 'client_type'")
            __props__.__dict__["client_type"] = client_type
            if credential is None and not opts.urn:
                raise TypeError("Missing required property 'credential'")
            __props__.__dict__["credential"] = credential
            if group_access is None and not opts.urn:
                raise TypeError("Missing required property 'group_access'")
            __props__.__dict__["group_access"] = group_access
            __props__.__dict__["ip_acl"] = ip_acl
            __props__.__dict__["lock"] = lock
            __props__.__dict__["notification_emails"] = notification_emails
            __props__.__dict__["purge_options"] = purge_options
            __props__.__dict__["access_token"] = None
            __props__.__dict__["actions"] = None
            __props__.__dict__["active_credential_count"] = None
            __props__.__dict__["base_url"] = None
            __props__.__dict__["client_id"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_date"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessToken", "baseUrl"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IamApiClient, __self__).__init__(
            'akamai:index/iamApiClient:IamApiClient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token: Optional[pulumi.Input[_builtins.str]] = None,
            actions: Optional[pulumi.Input[Union['IamApiClientActionsArgs', 'IamApiClientActionsArgsDict']]] = None,
            active_credential_count: Optional[pulumi.Input[_builtins.int]] = None,
            allow_account_switch: Optional[pulumi.Input[_builtins.bool]] = None,
            api_access: Optional[pulumi.Input[Union['IamApiClientApiAccessArgs', 'IamApiClientApiAccessArgsDict']]] = None,
            authorized_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            base_url: Optional[pulumi.Input[_builtins.str]] = None,
            can_auto_create_credential: Optional[pulumi.Input[_builtins.bool]] = None,
            client_description: Optional[pulumi.Input[_builtins.str]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_name: Optional[pulumi.Input[_builtins.str]] = None,
            client_type: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_date: Optional[pulumi.Input[_builtins.str]] = None,
            credential: Optional[pulumi.Input[Union['IamApiClientCredentialArgs', 'IamApiClientCredentialArgsDict']]] = None,
            group_access: Optional[pulumi.Input[Union['IamApiClientGroupAccessArgs', 'IamApiClientGroupAccessArgsDict']]] = None,
            ip_acl: Optional[pulumi.Input[Union['IamApiClientIpAclArgs', 'IamApiClientIpAclArgsDict']]] = None,
            lock: Optional[pulumi.Input[_builtins.bool]] = None,
            notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            purge_options: Optional[pulumi.Input[Union['IamApiClientPurgeOptionsArgs', 'IamApiClientPurgeOptionsArgsDict']]] = None) -> 'IamApiClient':
        """
        Get an existing IamApiClient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_token: The part of the client secret that identifies your API client and lets you access applications and resources.
        :param pulumi.Input[Union['IamApiClientActionsArgs', 'IamApiClientActionsArgsDict']] actions: Specifies activities available for the API client.
        :param pulumi.Input[_builtins.int] active_credential_count: The number of credentials active for the API client. When the count is zero, you can delete the API client without interruption.
        :param pulumi.Input[_builtins.bool] allow_account_switch: Enables the API client to manage more than one account.
        :param pulumi.Input[Union['IamApiClientApiAccessArgs', 'IamApiClientApiAccessArgsDict']] api_access: The APIs the API client can access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_users: The API client's valid users. When the 'client_type' is either 'CLIENT' or 'USER_CLIENT', you need to specify a single username in an array.
        :param pulumi.Input[_builtins.str] base_url: The base URL for the service.
        :param pulumi.Input[_builtins.bool] can_auto_create_credential: Whether the API client can create a credential for a new API client. The default is false.
        :param pulumi.Input[_builtins.str] client_description: A human-readable description of the API client.
        :param pulumi.Input[_builtins.str] client_id: A unique identifier for the API client.
        :param pulumi.Input[_builtins.str] client_name: A human-readable name for the API client.
        :param pulumi.Input[_builtins.str] client_type: Specifies the API client's ownership and credential management. 'CLIENT' indicates the creator owns and manages the credentials. 'USER_CLIENT' indicates another user owns the client and manages the credentials.
        :param pulumi.Input[_builtins.str] created_by: The user who created the API client.
        :param pulumi.Input[_builtins.str] created_date: The ISO 8601 timestamp indicating when the API client was created.
        :param pulumi.Input[Union['IamApiClientGroupAccessArgs', 'IamApiClientGroupAccessArgsDict']] group_access: Specifies the API client's group access.
        :param pulumi.Input[Union['IamApiClientIpAclArgs', 'IamApiClientIpAclArgsDict']] ip_acl: Specifies the API client's IP list restriction.
        :param pulumi.Input[_builtins.bool] lock: Whether to lock or unlock the API client.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: Email addresses to notify users when credentials expire.
        :param pulumi.Input[Union['IamApiClientPurgeOptionsArgs', 'IamApiClientPurgeOptionsArgsDict']] purge_options: Configures the API client to access the Fast Purge API. Provide it only if the `apis` attribute includes an `api_name` of `CCU API`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamApiClientState.__new__(_IamApiClientState)

        __props__.__dict__["access_token"] = access_token
        __props__.__dict__["actions"] = actions
        __props__.__dict__["active_credential_count"] = active_credential_count
        __props__.__dict__["allow_account_switch"] = allow_account_switch
        __props__.__dict__["api_access"] = api_access
        __props__.__dict__["authorized_users"] = authorized_users
        __props__.__dict__["base_url"] = base_url
        __props__.__dict__["can_auto_create_credential"] = can_auto_create_credential
        __props__.__dict__["client_description"] = client_description
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_name"] = client_name
        __props__.__dict__["client_type"] = client_type
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["credential"] = credential
        __props__.__dict__["group_access"] = group_access
        __props__.__dict__["ip_acl"] = ip_acl
        __props__.__dict__["lock"] = lock
        __props__.__dict__["notification_emails"] = notification_emails
        __props__.__dict__["purge_options"] = purge_options
        return IamApiClient(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[_builtins.str]:
        """
        The part of the client secret that identifies your API client and lets you access applications and resources.
        """
        return pulumi.get(self, "access_token")

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output['outputs.IamApiClientActions']:
        """
        Specifies activities available for the API client.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="activeCredentialCount")
    def active_credential_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of credentials active for the API client. When the count is zero, you can delete the API client without interruption.
        """
        return pulumi.get(self, "active_credential_count")

    @_builtins.property
    @pulumi.getter(name="allowAccountSwitch")
    def allow_account_switch(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables the API client to manage more than one account.
        """
        return pulumi.get(self, "allow_account_switch")

    @_builtins.property
    @pulumi.getter(name="apiAccess")
    def api_access(self) -> pulumi.Output['outputs.IamApiClientApiAccess']:
        """
        The APIs the API client can access.
        """
        return pulumi.get(self, "api_access")

    @_builtins.property
    @pulumi.getter(name="authorizedUsers")
    def authorized_users(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The API client's valid users. When the 'client_type' is either 'CLIENT' or 'USER_CLIENT', you need to specify a single username in an array.
        """
        return pulumi.get(self, "authorized_users")

    @_builtins.property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[_builtins.str]:
        """
        The base URL for the service.
        """
        return pulumi.get(self, "base_url")

    @_builtins.property
    @pulumi.getter(name="canAutoCreateCredential")
    def can_auto_create_credential(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the API client can create a credential for a new API client. The default is false.
        """
        return pulumi.get(self, "can_auto_create_credential")

    @_builtins.property
    @pulumi.getter(name="clientDescription")
    def client_description(self) -> pulumi.Output[_builtins.str]:
        """
        A human-readable description of the API client.
        """
        return pulumi.get(self, "client_description")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for the API client.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> pulumi.Output[_builtins.str]:
        """
        A human-readable name for the API client.
        """
        return pulumi.get(self, "client_name")

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the API client's ownership and credential management. 'CLIENT' indicates the creator owns and manages the credentials. 'USER_CLIENT' indicates another user owns the client and manages the credentials.
        """
        return pulumi.get(self, "client_type")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The user who created the API client.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[_builtins.str]:
        """
        The ISO 8601 timestamp indicating when the API client was created.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def credential(self) -> pulumi.Output['outputs.IamApiClientCredential']:
        return pulumi.get(self, "credential")

    @_builtins.property
    @pulumi.getter(name="groupAccess")
    def group_access(self) -> pulumi.Output['outputs.IamApiClientGroupAccess']:
        """
        Specifies the API client's group access.
        """
        return pulumi.get(self, "group_access")

    @_builtins.property
    @pulumi.getter(name="ipAcl")
    def ip_acl(self) -> pulumi.Output[Optional['outputs.IamApiClientIpAcl']]:
        """
        Specifies the API client's IP list restriction.
        """
        return pulumi.get(self, "ip_acl")

    @_builtins.property
    @pulumi.getter
    def lock(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to lock or unlock the API client.
        """
        return pulumi.get(self, "lock")

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Email addresses to notify users when credentials expire.
        """
        return pulumi.get(self, "notification_emails")

    @_builtins.property
    @pulumi.getter(name="purgeOptions")
    def purge_options(self) -> pulumi.Output[Optional['outputs.IamApiClientPurgeOptions']]:
        """
        Configures the API client to access the Fast Purge API. Provide it only if the `apis` attribute includes an `api_name` of `CCU API`.
        """
        return pulumi.get(self, "purge_options")

