# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ImagingPolicyVideoArgs', 'ImagingPolicyVideo']

@pulumi.input_type
class ImagingPolicyVideoArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[_builtins.str],
                 json: pulumi.Input[_builtins.str],
                 policy_id: pulumi.Input[_builtins.str],
                 policyset_id: pulumi.Input[_builtins.str],
                 activate_on_production: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ImagingPolicyVideo resource.
        :param pulumi.Input[_builtins.str] contract_id: Unique identifier for the Akamai Contract containing the Policy Set(s)
        :param pulumi.Input[_builtins.str] json: A JSON encoded policy
        :param pulumi.Input[_builtins.str] policy_id: Unique identifier for a Policy. It is not possible to modify the id of the policy.
        :param pulumi.Input[_builtins.str] policyset_id: Unique identifier for the Image & Video Manager Policy Set.
        :param pulumi.Input[_builtins.bool] activate_on_production: With this flag set to false, the user can perform modifications on staging without affecting the version already saved to production. With this flag set to true, the policy will be saved on the production network. It is possible to change it back to false only when there are any changes to the policy qualifying it for the new version.
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "json", json)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "policyset_id", policyset_id)
        if activate_on_production is not None:
            pulumi.set(__self__, "activate_on_production", activate_on_production)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier for the Akamai Contract containing the Policy Set(s)
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter
    def json(self) -> pulumi.Input[_builtins.str]:
        """
        A JSON encoded policy
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "json", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier for a Policy. It is not possible to modify the id of the policy.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="policysetId")
    def policyset_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier for the Image & Video Manager Policy Set.
        """
        return pulumi.get(self, "policyset_id")

    @policyset_id.setter
    def policyset_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policyset_id", value)

    @_builtins.property
    @pulumi.getter(name="activateOnProduction")
    def activate_on_production(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        With this flag set to false, the user can perform modifications on staging without affecting the version already saved to production. With this flag set to true, the policy will be saved on the production network. It is possible to change it back to false only when there are any changes to the policy qualifying it for the new version.
        """
        return pulumi.get(self, "activate_on_production")

    @activate_on_production.setter
    def activate_on_production(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activate_on_production", value)


@pulumi.input_type
class _ImagingPolicyVideoState:
    def __init__(__self__, *,
                 activate_on_production: Optional[pulumi.Input[_builtins.bool]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 json: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policyset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ImagingPolicyVideo resources.
        :param pulumi.Input[_builtins.bool] activate_on_production: With this flag set to false, the user can perform modifications on staging without affecting the version already saved to production. With this flag set to true, the policy will be saved on the production network. It is possible to change it back to false only when there are any changes to the policy qualifying it for the new version.
        :param pulumi.Input[_builtins.str] contract_id: Unique identifier for the Akamai Contract containing the Policy Set(s)
        :param pulumi.Input[_builtins.str] json: A JSON encoded policy
        :param pulumi.Input[_builtins.str] policy_id: Unique identifier for a Policy. It is not possible to modify the id of the policy.
        :param pulumi.Input[_builtins.str] policyset_id: Unique identifier for the Image & Video Manager Policy Set.
        :param pulumi.Input[_builtins.int] version: The version number of this policy version
        """
        if activate_on_production is not None:
            pulumi.set(__self__, "activate_on_production", activate_on_production)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policyset_id is not None:
            pulumi.set(__self__, "policyset_id", policyset_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="activateOnProduction")
    def activate_on_production(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        With this flag set to false, the user can perform modifications on staging without affecting the version already saved to production. With this flag set to true, the policy will be saved on the production network. It is possible to change it back to false only when there are any changes to the policy qualifying it for the new version.
        """
        return pulumi.get(self, "activate_on_production")

    @activate_on_production.setter
    def activate_on_production(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activate_on_production", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the Akamai Contract containing the Policy Set(s)
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON encoded policy
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "json", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for a Policy. It is not possible to modify the id of the policy.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="policysetId")
    def policyset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the Image & Video Manager Policy Set.
        """
        return pulumi.get(self, "policyset_id")

    @policyset_id.setter
    def policyset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policyset_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of this policy version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("akamai:index/imagingPolicyVideo:ImagingPolicyVideo")
class ImagingPolicyVideo(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activate_on_production: Optional[pulumi.Input[_builtins.bool]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 json: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policyset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ImagingPolicyVideo resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] activate_on_production: With this flag set to false, the user can perform modifications on staging without affecting the version already saved to production. With this flag set to true, the policy will be saved on the production network. It is possible to change it back to false only when there are any changes to the policy qualifying it for the new version.
        :param pulumi.Input[_builtins.str] contract_id: Unique identifier for the Akamai Contract containing the Policy Set(s)
        :param pulumi.Input[_builtins.str] json: A JSON encoded policy
        :param pulumi.Input[_builtins.str] policy_id: Unique identifier for a Policy. It is not possible to modify the id of the policy.
        :param pulumi.Input[_builtins.str] policyset_id: Unique identifier for the Image & Video Manager Policy Set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImagingPolicyVideoArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ImagingPolicyVideo resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ImagingPolicyVideoArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImagingPolicyVideoArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activate_on_production: Optional[pulumi.Input[_builtins.bool]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 json: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policyset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImagingPolicyVideoArgs.__new__(ImagingPolicyVideoArgs)

            __props__.__dict__["activate_on_production"] = activate_on_production
            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if json is None and not opts.urn:
                raise TypeError("Missing required property 'json'")
            __props__.__dict__["json"] = json
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            if policyset_id is None and not opts.urn:
                raise TypeError("Missing required property 'policyset_id'")
            __props__.__dict__["policyset_id"] = policyset_id
            __props__.__dict__["version"] = None
        super(ImagingPolicyVideo, __self__).__init__(
            'akamai:index/imagingPolicyVideo:ImagingPolicyVideo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activate_on_production: Optional[pulumi.Input[_builtins.bool]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            json: Optional[pulumi.Input[_builtins.str]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            policyset_id: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'ImagingPolicyVideo':
        """
        Get an existing ImagingPolicyVideo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] activate_on_production: With this flag set to false, the user can perform modifications on staging without affecting the version already saved to production. With this flag set to true, the policy will be saved on the production network. It is possible to change it back to false only when there are any changes to the policy qualifying it for the new version.
        :param pulumi.Input[_builtins.str] contract_id: Unique identifier for the Akamai Contract containing the Policy Set(s)
        :param pulumi.Input[_builtins.str] json: A JSON encoded policy
        :param pulumi.Input[_builtins.str] policy_id: Unique identifier for a Policy. It is not possible to modify the id of the policy.
        :param pulumi.Input[_builtins.str] policyset_id: Unique identifier for the Image & Video Manager Policy Set.
        :param pulumi.Input[_builtins.int] version: The version number of this policy version
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImagingPolicyVideoState.__new__(_ImagingPolicyVideoState)

        __props__.__dict__["activate_on_production"] = activate_on_production
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["json"] = json
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["policyset_id"] = policyset_id
        __props__.__dict__["version"] = version
        return ImagingPolicyVideo(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activateOnProduction")
    def activate_on_production(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        With this flag set to false, the user can perform modifications on staging without affecting the version already saved to production. With this flag set to true, the policy will be saved on the production network. It is possible to change it back to false only when there are any changes to the policy qualifying it for the new version.
        """
        return pulumi.get(self, "activate_on_production")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the Akamai Contract containing the Policy Set(s)
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter
    def json(self) -> pulumi.Output[_builtins.str]:
        """
        A JSON encoded policy
        """
        return pulumi.get(self, "json")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for a Policy. It is not possible to modify the id of the policy.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="policysetId")
    def policyset_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the Image & Video Manager Policy Set.
        """
        return pulumi.get(self, "policyset_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version number of this policy version
        """
        return pulumi.get(self, "version")

