# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MtlskeystoreClientCertificateAkamaiArgs', 'MtlskeystoreClientCertificateAkamai']

@pulumi.input_type
class MtlskeystoreClientCertificateAkamaiArgs:
    def __init__(__self__, *,
                 certificate_name: pulumi.Input[_builtins.str],
                 contract_id: pulumi.Input[_builtins.str],
                 geography: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.int],
                 notification_emails: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 secure_network: pulumi.Input[_builtins.str],
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MtlskeystoreClientCertificateAkamai resource.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the client certificate. Must be between 1 and 64 characters.
        :param pulumi.Input[_builtins.str] contract_id: The contract assigned to the client certificate. Must have a length of at least 1.
        :param pulumi.Input[_builtins.str] geography: Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        :param pulumi.Input[_builtins.int] group_id: The group assigned to the client certificate. Must be greater than or equal to 0.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: The email addresses to notify for client certificate-related issues. Must have at least one email address.
        :param pulumi.Input[_builtins.str] secure_network: Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        :param pulumi.Input[_builtins.str] key_algorithm: The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`.
        :param pulumi.Input[_builtins.str] subject: The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        """
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "geography", geography)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "notification_emails", notification_emails)
        pulumi.set(__self__, "secure_network", secure_network)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the client certificate. Must be between 1 and 64 characters.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        The contract assigned to the client certificate. Must have a length of at least 1.
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter
    def geography(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        """
        return pulumi.get(self, "geography")

    @geography.setter
    def geography(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "geography", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.int]:
        """
        The group assigned to the client certificate. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The email addresses to notify for client certificate-related issues. Must have at least one email address.
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        """
        return pulumi.get(self, "secure_network")

    @secure_network.setter
    def secure_network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secure_network", value)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)


@pulumi.input_type
class _MtlskeystoreClientCertificateAkamaiState:
    def __init__(__self__, *,
                 certificate_id: Optional[pulumi.Input[_builtins.int]] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_date: Optional[pulumi.Input[_builtins.str]] = None,
                 current_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 geography: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 previous_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_network: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input['MtlskeystoreClientCertificateAkamaiVersionArgs']]]] = None):
        """
        Input properties used for looking up and filtering MtlskeystoreClientCertificateAkamai resources.
        :param pulumi.Input[_builtins.int] certificate_id: The unique identifier of the client certificate.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the client certificate. Must be between 1 and 64 characters.
        :param pulumi.Input[_builtins.str] contract_id: The contract assigned to the client certificate. Must have a length of at least 1.
        :param pulumi.Input[_builtins.str] created_by: The user who created the client certificate. Read-only.
        :param pulumi.Input[_builtins.str] created_date: An ISO 8601 timestamp indicating the client certificate's creation. Read-only.
        :param pulumi.Input[_builtins.str] current_guid: Unique identifier for the `current` client certificate version.
        :param pulumi.Input[_builtins.str] geography: Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        :param pulumi.Input[_builtins.int] group_id: The group assigned to the client certificate. Must be greater than or equal to 0.
        :param pulumi.Input[_builtins.str] key_algorithm: The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: The email addresses to notify for client certificate-related issues. Must have at least one email address.
        :param pulumi.Input[_builtins.str] previous_guid: Unique identifier for the `previous` client certificate version.
        :param pulumi.Input[_builtins.str] secure_network: Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        :param pulumi.Input[_builtins.str] subject: The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        :param pulumi.Input[Sequence[pulumi.Input['MtlskeystoreClientCertificateAkamaiVersionArgs']]] versions: A list of client certificate versions. Each version represents a specific iteration of the client certificate.
        """
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if current_guid is not None:
            pulumi.set(__self__, "current_guid", current_guid)
        if geography is not None:
            pulumi.set(__self__, "geography", geography)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if notification_emails is not None:
            pulumi.set(__self__, "notification_emails", notification_emails)
        if previous_guid is not None:
            pulumi.set(__self__, "previous_guid", previous_guid)
        if secure_network is not None:
            pulumi.set(__self__, "secure_network", secure_network)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier of the client certificate.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the client certificate. Must be between 1 and 64 characters.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The contract assigned to the client certificate. Must have a length of at least 1.
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user who created the client certificate. Read-only.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An ISO 8601 timestamp indicating the client certificate's creation. Read-only.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_date", value)

    @_builtins.property
    @pulumi.getter(name="currentGuid")
    def current_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the `current` client certificate version.
        """
        return pulumi.get(self, "current_guid")

    @current_guid.setter
    def current_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_guid", value)

    @_builtins.property
    @pulumi.getter
    def geography(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        """
        return pulumi.get(self, "geography")

    @geography.setter
    def geography(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geography", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The group assigned to the client certificate. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The email addresses to notify for client certificate-related issues. Must have at least one email address.
        """
        return pulumi.get(self, "notification_emails")

    @notification_emails.setter
    def notification_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_emails", value)

    @_builtins.property
    @pulumi.getter(name="previousGuid")
    def previous_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the `previous` client certificate version.
        """
        return pulumi.get(self, "previous_guid")

    @previous_guid.setter
    def previous_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "previous_guid", value)

    @_builtins.property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        """
        return pulumi.get(self, "secure_network")

    @secure_network.setter
    def secure_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secure_network", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MtlskeystoreClientCertificateAkamaiVersionArgs']]]]:
        """
        A list of client certificate versions. Each version represents a specific iteration of the client certificate.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MtlskeystoreClientCertificateAkamaiVersionArgs']]]]):
        pulumi.set(self, "versions", value)


@pulumi.type_token("akamai:index/mtlskeystoreClientCertificateAkamai:MtlskeystoreClientCertificateAkamai")
class MtlskeystoreClientCertificateAkamai(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geography: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_network: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a MtlskeystoreClientCertificateAkamai resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the client certificate. Must be between 1 and 64 characters.
        :param pulumi.Input[_builtins.str] contract_id: The contract assigned to the client certificate. Must have a length of at least 1.
        :param pulumi.Input[_builtins.str] geography: Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        :param pulumi.Input[_builtins.int] group_id: The group assigned to the client certificate. Must be greater than or equal to 0.
        :param pulumi.Input[_builtins.str] key_algorithm: The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: The email addresses to notify for client certificate-related issues. Must have at least one email address.
        :param pulumi.Input[_builtins.str] secure_network: Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        :param pulumi.Input[_builtins.str] subject: The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MtlskeystoreClientCertificateAkamaiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a MtlskeystoreClientCertificateAkamai resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MtlskeystoreClientCertificateAkamaiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MtlskeystoreClientCertificateAkamaiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geography: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secure_network: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MtlskeystoreClientCertificateAkamaiArgs.__new__(MtlskeystoreClientCertificateAkamaiArgs)

            if certificate_name is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_name'")
            __props__.__dict__["certificate_name"] = certificate_name
            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if geography is None and not opts.urn:
                raise TypeError("Missing required property 'geography'")
            __props__.__dict__["geography"] = geography
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["key_algorithm"] = key_algorithm
            if notification_emails is None and not opts.urn:
                raise TypeError("Missing required property 'notification_emails'")
            __props__.__dict__["notification_emails"] = notification_emails
            if secure_network is None and not opts.urn:
                raise TypeError("Missing required property 'secure_network'")
            __props__.__dict__["secure_network"] = secure_network
            __props__.__dict__["subject"] = subject
            __props__.__dict__["certificate_id"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["current_guid"] = None
            __props__.__dict__["previous_guid"] = None
            __props__.__dict__["versions"] = None
        super(MtlskeystoreClientCertificateAkamai, __self__).__init__(
            'akamai:index/mtlskeystoreClientCertificateAkamai:MtlskeystoreClientCertificateAkamai',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_id: Optional[pulumi.Input[_builtins.int]] = None,
            certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_date: Optional[pulumi.Input[_builtins.str]] = None,
            current_guid: Optional[pulumi.Input[_builtins.str]] = None,
            geography: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.int]] = None,
            key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            notification_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            previous_guid: Optional[pulumi.Input[_builtins.str]] = None,
            secure_network: Optional[pulumi.Input[_builtins.str]] = None,
            subject: Optional[pulumi.Input[_builtins.str]] = None,
            versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MtlskeystoreClientCertificateAkamaiVersionArgs', 'MtlskeystoreClientCertificateAkamaiVersionArgsDict']]]]] = None) -> 'MtlskeystoreClientCertificateAkamai':
        """
        Get an existing MtlskeystoreClientCertificateAkamai resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] certificate_id: The unique identifier of the client certificate.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the client certificate. Must be between 1 and 64 characters.
        :param pulumi.Input[_builtins.str] contract_id: The contract assigned to the client certificate. Must have a length of at least 1.
        :param pulumi.Input[_builtins.str] created_by: The user who created the client certificate. Read-only.
        :param pulumi.Input[_builtins.str] created_date: An ISO 8601 timestamp indicating the client certificate's creation. Read-only.
        :param pulumi.Input[_builtins.str] current_guid: Unique identifier for the `current` client certificate version.
        :param pulumi.Input[_builtins.str] geography: Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        :param pulumi.Input[_builtins.int] group_id: The group assigned to the client certificate. Must be greater than or equal to 0.
        :param pulumi.Input[_builtins.str] key_algorithm: The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_emails: The email addresses to notify for client certificate-related issues. Must have at least one email address.
        :param pulumi.Input[_builtins.str] previous_guid: Unique identifier for the `previous` client certificate version.
        :param pulumi.Input[_builtins.str] secure_network: Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        :param pulumi.Input[_builtins.str] subject: The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MtlskeystoreClientCertificateAkamaiVersionArgs', 'MtlskeystoreClientCertificateAkamaiVersionArgsDict']]]] versions: A list of client certificate versions. Each version represents a specific iteration of the client certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MtlskeystoreClientCertificateAkamaiState.__new__(_MtlskeystoreClientCertificateAkamaiState)

        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["certificate_name"] = certificate_name
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["current_guid"] = current_guid
        __props__.__dict__["geography"] = geography
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["key_algorithm"] = key_algorithm
        __props__.__dict__["notification_emails"] = notification_emails
        __props__.__dict__["previous_guid"] = previous_guid
        __props__.__dict__["secure_network"] = secure_network
        __props__.__dict__["subject"] = subject
        __props__.__dict__["versions"] = versions
        return MtlskeystoreClientCertificateAkamai(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier of the client certificate.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the client certificate. Must be between 1 and 64 characters.
        """
        return pulumi.get(self, "certificate_name")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        The contract assigned to the client certificate. Must have a length of at least 1.
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The user who created the client certificate. Read-only.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[_builtins.str]:
        """
        An ISO 8601 timestamp indicating the client certificate's creation. Read-only.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter(name="currentGuid")
    def current_guid(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the `current` client certificate version.
        """
        return pulumi.get(self, "current_guid")

    @_builtins.property
    @pulumi.getter
    def geography(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of network to deploy the client certificate. Possible values: `CORE`, `RUSSIA_AND_CORE`, or `CHINA_AND_CORE`.
        """
        return pulumi.get(self, "geography")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.int]:
        """
        The group assigned to the client certificate. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The cryptographic algorithm used for key generation. Possible values: `RSA` or `ECDSA`.
        """
        return pulumi.get(self, "key_algorithm")

    @_builtins.property
    @pulumi.getter(name="notificationEmails")
    def notification_emails(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The email addresses to notify for client certificate-related issues. Must have at least one email address.
        """
        return pulumi.get(self, "notification_emails")

    @_builtins.property
    @pulumi.getter(name="previousGuid")
    def previous_guid(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the `previous` client certificate version.
        """
        return pulumi.get(self, "previous_guid")

    @_builtins.property
    @pulumi.getter(name="secureNetwork")
    def secure_network(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the network deployment type. Possible values: `STANDARD_TLS` or `ENHANCED_TLS`.
        """
        return pulumi.get(self, "secure_network")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Output[_builtins.str]:
        """
        The CA certificate’s key value details. The `CN` attribute is required and included in the subject. When not specified, the subject is constructed in this format: `/C=US/O=Akamai Technologies, Inc./OU={vcd_id} {contract_id} {group_id}/CN={certificate_name}/`.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Output[Sequence['outputs.MtlskeystoreClientCertificateAkamaiVersion']]:
        """
        A list of client certificate versions. Each version represents a specific iteration of the client certificate.
        """
        return pulumi.get(self, "versions")

