# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MtlskeystoreClientCertificateUploadArgs', 'MtlskeystoreClientCertificateUpload']

@pulumi.input_type
class MtlskeystoreClientCertificateUploadArgs:
    def __init__(__self__, *,
                 client_certificate_id: pulumi.Input[_builtins.int],
                 signed_certificate: pulumi.Input[_builtins.str],
                 version_number: pulumi.Input[_builtins.int],
                 auto_acknowledge_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['MtlskeystoreClientCertificateUploadTimeoutsArgs']] = None,
                 trust_chain: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a MtlskeystoreClientCertificateUpload resource.
        :param pulumi.Input[_builtins.int] client_certificate_id: The ID of the client certificate to which the signed certificate will be uploaded.
        :param pulumi.Input[_builtins.str] signed_certificate: The signed certificate to upload.
        :param pulumi.Input[_builtins.int] version_number: The version number of the client certificate to upload the signed certificate to.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_warnings: If set to true, all warnings will be acknowledged automatically. Defaults to `false`.
        :param pulumi.Input[_builtins.str] trust_chain: The optional trust chain associated with the signed certificate.
        :param pulumi.Input[_builtins.bool] wait_for_deployment: Indicates whether to wait for the deployment of the uploaded certificate. Defaults to `true`.
        """
        pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        pulumi.set(__self__, "signed_certificate", signed_certificate)
        pulumi.set(__self__, "version_number", version_number)
        if auto_acknowledge_warnings is not None:
            pulumi.set(__self__, "auto_acknowledge_warnings", auto_acknowledge_warnings)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if trust_chain is not None:
            pulumi.set(__self__, "trust_chain", trust_chain)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)

    @_builtins.property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the client certificate to which the signed certificate will be uploaded.
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "client_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="signedCertificate")
    def signed_certificate(self) -> pulumi.Input[_builtins.str]:
        """
        The signed certificate to upload.
        """
        return pulumi.get(self, "signed_certificate")

    @signed_certificate.setter
    def signed_certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "signed_certificate", value)

    @_builtins.property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> pulumi.Input[_builtins.int]:
        """
        The version number of the client certificate to upload the signed certificate to.
        """
        return pulumi.get(self, "version_number")

    @version_number.setter
    def version_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "version_number", value)

    @_builtins.property
    @pulumi.getter(name="autoAcknowledgeWarnings")
    def auto_acknowledge_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, all warnings will be acknowledged automatically. Defaults to `false`.
        """
        return pulumi.get(self, "auto_acknowledge_warnings")

    @auto_acknowledge_warnings.setter
    def auto_acknowledge_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_acknowledge_warnings", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['MtlskeystoreClientCertificateUploadTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['MtlskeystoreClientCertificateUploadTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="trustChain")
    def trust_chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The optional trust chain associated with the signed certificate.
        """
        return pulumi.get(self, "trust_chain")

    @trust_chain.setter
    def trust_chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_chain", value)

    @_builtins.property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to wait for the deployment of the uploaded certificate. Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_deployment", value)


@pulumi.input_type
class _MtlskeystoreClientCertificateUploadState:
    def __init__(__self__, *,
                 auto_acknowledge_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_id: Optional[pulumi.Input[_builtins.int]] = None,
                 signed_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['MtlskeystoreClientCertificateUploadTimeoutsArgs']] = None,
                 trust_chain: Optional[pulumi.Input[_builtins.str]] = None,
                 version_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 version_number: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering MtlskeystoreClientCertificateUpload resources.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_warnings: If set to true, all warnings will be acknowledged automatically. Defaults to `false`.
        :param pulumi.Input[_builtins.int] client_certificate_id: The ID of the client certificate to which the signed certificate will be uploaded.
        :param pulumi.Input[_builtins.str] signed_certificate: The signed certificate to upload.
        :param pulumi.Input[_builtins.str] trust_chain: The optional trust chain associated with the signed certificate.
        :param pulumi.Input[_builtins.str] version_guid: A unique identifier for the client certificate version.
        :param pulumi.Input[_builtins.int] version_number: The version number of the client certificate to upload the signed certificate to.
        :param pulumi.Input[_builtins.bool] wait_for_deployment: Indicates whether to wait for the deployment of the uploaded certificate. Defaults to `true`.
        """
        if auto_acknowledge_warnings is not None:
            pulumi.set(__self__, "auto_acknowledge_warnings", auto_acknowledge_warnings)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if signed_certificate is not None:
            pulumi.set(__self__, "signed_certificate", signed_certificate)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if trust_chain is not None:
            pulumi.set(__self__, "trust_chain", trust_chain)
        if version_guid is not None:
            pulumi.set(__self__, "version_guid", version_guid)
        if version_number is not None:
            pulumi.set(__self__, "version_number", version_number)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)

    @_builtins.property
    @pulumi.getter(name="autoAcknowledgeWarnings")
    def auto_acknowledge_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, all warnings will be acknowledged automatically. Defaults to `false`.
        """
        return pulumi.get(self, "auto_acknowledge_warnings")

    @auto_acknowledge_warnings.setter
    def auto_acknowledge_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_acknowledge_warnings", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the client certificate to which the signed certificate will be uploaded.
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="signedCertificate")
    def signed_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signed certificate to upload.
        """
        return pulumi.get(self, "signed_certificate")

    @signed_certificate.setter
    def signed_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signed_certificate", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['MtlskeystoreClientCertificateUploadTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['MtlskeystoreClientCertificateUploadTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="trustChain")
    def trust_chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The optional trust chain associated with the signed certificate.
        """
        return pulumi.get(self, "trust_chain")

    @trust_chain.setter
    def trust_chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_chain", value)

    @_builtins.property
    @pulumi.getter(name="versionGuid")
    def version_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for the client certificate version.
        """
        return pulumi.get(self, "version_guid")

    @version_guid.setter
    def version_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_guid", value)

    @_builtins.property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the client certificate to upload the signed certificate to.
        """
        return pulumi.get(self, "version_number")

    @version_number.setter
    def version_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version_number", value)

    @_builtins.property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to wait for the deployment of the uploaded certificate. Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_deployment", value)


@pulumi.type_token("akamai:index/mtlskeystoreClientCertificateUpload:MtlskeystoreClientCertificateUpload")
class MtlskeystoreClientCertificateUpload(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_acknowledge_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_id: Optional[pulumi.Input[_builtins.int]] = None,
                 signed_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['MtlskeystoreClientCertificateUploadTimeoutsArgs', 'MtlskeystoreClientCertificateUploadTimeoutsArgsDict']]] = None,
                 trust_chain: Optional[pulumi.Input[_builtins.str]] = None,
                 version_number: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Create a MtlskeystoreClientCertificateUpload resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_warnings: If set to true, all warnings will be acknowledged automatically. Defaults to `false`.
        :param pulumi.Input[_builtins.int] client_certificate_id: The ID of the client certificate to which the signed certificate will be uploaded.
        :param pulumi.Input[_builtins.str] signed_certificate: The signed certificate to upload.
        :param pulumi.Input[_builtins.str] trust_chain: The optional trust chain associated with the signed certificate.
        :param pulumi.Input[_builtins.int] version_number: The version number of the client certificate to upload the signed certificate to.
        :param pulumi.Input[_builtins.bool] wait_for_deployment: Indicates whether to wait for the deployment of the uploaded certificate. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MtlskeystoreClientCertificateUploadArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a MtlskeystoreClientCertificateUpload resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MtlskeystoreClientCertificateUploadArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MtlskeystoreClientCertificateUploadArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_acknowledge_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_id: Optional[pulumi.Input[_builtins.int]] = None,
                 signed_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['MtlskeystoreClientCertificateUploadTimeoutsArgs', 'MtlskeystoreClientCertificateUploadTimeoutsArgsDict']]] = None,
                 trust_chain: Optional[pulumi.Input[_builtins.str]] = None,
                 version_number: Optional[pulumi.Input[_builtins.int]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MtlskeystoreClientCertificateUploadArgs.__new__(MtlskeystoreClientCertificateUploadArgs)

            __props__.__dict__["auto_acknowledge_warnings"] = auto_acknowledge_warnings
            if client_certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_certificate_id'")
            __props__.__dict__["client_certificate_id"] = client_certificate_id
            if signed_certificate is None and not opts.urn:
                raise TypeError("Missing required property 'signed_certificate'")
            __props__.__dict__["signed_certificate"] = signed_certificate
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["trust_chain"] = trust_chain
            if version_number is None and not opts.urn:
                raise TypeError("Missing required property 'version_number'")
            __props__.__dict__["version_number"] = version_number
            __props__.__dict__["wait_for_deployment"] = wait_for_deployment
            __props__.__dict__["version_guid"] = None
        super(MtlskeystoreClientCertificateUpload, __self__).__init__(
            'akamai:index/mtlskeystoreClientCertificateUpload:MtlskeystoreClientCertificateUpload',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_acknowledge_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
            client_certificate_id: Optional[pulumi.Input[_builtins.int]] = None,
            signed_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['MtlskeystoreClientCertificateUploadTimeoutsArgs', 'MtlskeystoreClientCertificateUploadTimeoutsArgsDict']]] = None,
            trust_chain: Optional[pulumi.Input[_builtins.str]] = None,
            version_guid: Optional[pulumi.Input[_builtins.str]] = None,
            version_number: Optional[pulumi.Input[_builtins.int]] = None,
            wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None) -> 'MtlskeystoreClientCertificateUpload':
        """
        Get an existing MtlskeystoreClientCertificateUpload resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_acknowledge_warnings: If set to true, all warnings will be acknowledged automatically. Defaults to `false`.
        :param pulumi.Input[_builtins.int] client_certificate_id: The ID of the client certificate to which the signed certificate will be uploaded.
        :param pulumi.Input[_builtins.str] signed_certificate: The signed certificate to upload.
        :param pulumi.Input[_builtins.str] trust_chain: The optional trust chain associated with the signed certificate.
        :param pulumi.Input[_builtins.str] version_guid: A unique identifier for the client certificate version.
        :param pulumi.Input[_builtins.int] version_number: The version number of the client certificate to upload the signed certificate to.
        :param pulumi.Input[_builtins.bool] wait_for_deployment: Indicates whether to wait for the deployment of the uploaded certificate. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MtlskeystoreClientCertificateUploadState.__new__(_MtlskeystoreClientCertificateUploadState)

        __props__.__dict__["auto_acknowledge_warnings"] = auto_acknowledge_warnings
        __props__.__dict__["client_certificate_id"] = client_certificate_id
        __props__.__dict__["signed_certificate"] = signed_certificate
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["trust_chain"] = trust_chain
        __props__.__dict__["version_guid"] = version_guid
        __props__.__dict__["version_number"] = version_number
        __props__.__dict__["wait_for_deployment"] = wait_for_deployment
        return MtlskeystoreClientCertificateUpload(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoAcknowledgeWarnings")
    def auto_acknowledge_warnings(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to true, all warnings will be acknowledged automatically. Defaults to `false`.
        """
        return pulumi.get(self, "auto_acknowledge_warnings")

    @_builtins.property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the client certificate to which the signed certificate will be uploaded.
        """
        return pulumi.get(self, "client_certificate_id")

    @_builtins.property
    @pulumi.getter(name="signedCertificate")
    def signed_certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The signed certificate to upload.
        """
        return pulumi.get(self, "signed_certificate")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.MtlskeystoreClientCertificateUploadTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="trustChain")
    def trust_chain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The optional trust chain associated with the signed certificate.
        """
        return pulumi.get(self, "trust_chain")

    @_builtins.property
    @pulumi.getter(name="versionGuid")
    def version_guid(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for the client certificate version.
        """
        return pulumi.get(self, "version_guid")

    @_builtins.property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> pulumi.Output[_builtins.int]:
        """
        The version number of the client certificate to upload the signed certificate to.
        """
        return pulumi.get(self, "version_number")

    @_builtins.property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether to wait for the deployment of the uploaded certificate. Defaults to `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

