# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 cache_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 config: Optional[pulumi.Input['ProviderConfigArgs']] = None,
                 config_section: Optional[pulumi.Input[_builtins.str]] = None,
                 edgerc: Optional[pulumi.Input[_builtins.str]] = None,
                 request_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 retry_max: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_wait_max: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_wait_min: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] config_section: The section of the edgerc file to use for configuration
        :param pulumi.Input[_builtins.int] request_limit: The maximum number of API requests to be made per second (0 for no limit)
        :param pulumi.Input[_builtins.bool] retry_disabled: Should the retries of API requests be disabled, default false
        :param pulumi.Input[_builtins.int] retry_max: The maximum number retires of API requests, default 10
        :param pulumi.Input[_builtins.int] retry_wait_max: The maximum wait time in seconds between API requests retries, default is 30 sec
        :param pulumi.Input[_builtins.int] retry_wait_min: The minimum wait time in seconds between API requests retries, default is 1 sec
        """
        if cache_enabled is not None:
            pulumi.set(__self__, "cache_enabled", cache_enabled)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_section is not None:
            pulumi.set(__self__, "config_section", config_section)
        if edgerc is not None:
            pulumi.set(__self__, "edgerc", edgerc)
        if request_limit is not None:
            pulumi.set(__self__, "request_limit", request_limit)
        if retry_disabled is not None:
            pulumi.set(__self__, "retry_disabled", retry_disabled)
        if retry_max is not None:
            pulumi.set(__self__, "retry_max", retry_max)
        if retry_wait_max is not None:
            pulumi.set(__self__, "retry_wait_max", retry_wait_max)
        if retry_wait_min is not None:
            pulumi.set(__self__, "retry_wait_min", retry_wait_min)

    @_builtins.property
    @pulumi.getter(name="cacheEnabled")
    def cache_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "cache_enabled")

    @cache_enabled.setter
    def cache_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cache_enabled", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ProviderConfigArgs']]:
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ProviderConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="configSection")
    def config_section(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The section of the edgerc file to use for configuration
        """
        return pulumi.get(self, "config_section")

    @config_section.setter
    def config_section(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_section", value)

    @_builtins.property
    @pulumi.getter
    def edgerc(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "edgerc")

    @edgerc.setter
    def edgerc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edgerc", value)

    @_builtins.property
    @pulumi.getter(name="requestLimit")
    def request_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of API requests to be made per second (0 for no limit)
        """
        return pulumi.get(self, "request_limit")

    @request_limit.setter
    def request_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_limit", value)

    @_builtins.property
    @pulumi.getter(name="retryDisabled")
    def retry_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the retries of API requests be disabled, default false
        """
        return pulumi.get(self, "retry_disabled")

    @retry_disabled.setter
    def retry_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retry_disabled", value)

    @_builtins.property
    @pulumi.getter(name="retryMax")
    def retry_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number retires of API requests, default 10
        """
        return pulumi.get(self, "retry_max")

    @retry_max.setter
    def retry_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_max", value)

    @_builtins.property
    @pulumi.getter(name="retryWaitMax")
    def retry_wait_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum wait time in seconds between API requests retries, default is 30 sec
        """
        return pulumi.get(self, "retry_wait_max")

    @retry_wait_max.setter
    def retry_wait_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_wait_max", value)

    @_builtins.property
    @pulumi.getter(name="retryWaitMin")
    def retry_wait_min(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum wait time in seconds between API requests retries, default is 1 sec
        """
        return pulumi.get(self, "retry_wait_min")

    @retry_wait_min.setter
    def retry_wait_min(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_wait_min", value)


@pulumi.type_token("pulumi:providers:akamai")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 config: Optional[pulumi.Input[Union['ProviderConfigArgs', 'ProviderConfigArgsDict']]] = None,
                 config_section: Optional[pulumi.Input[_builtins.str]] = None,
                 edgerc: Optional[pulumi.Input[_builtins.str]] = None,
                 request_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 retry_max: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_wait_max: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_wait_min: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        The provider type for the akamai package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config_section: The section of the edgerc file to use for configuration
        :param pulumi.Input[_builtins.int] request_limit: The maximum number of API requests to be made per second (0 for no limit)
        :param pulumi.Input[_builtins.bool] retry_disabled: Should the retries of API requests be disabled, default false
        :param pulumi.Input[_builtins.int] retry_max: The maximum number retires of API requests, default 10
        :param pulumi.Input[_builtins.int] retry_wait_max: The maximum wait time in seconds between API requests retries, default is 30 sec
        :param pulumi.Input[_builtins.int] retry_wait_min: The minimum wait time in seconds between API requests retries, default is 1 sec
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the akamai package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 config: Optional[pulumi.Input[Union['ProviderConfigArgs', 'ProviderConfigArgsDict']]] = None,
                 config_section: Optional[pulumi.Input[_builtins.str]] = None,
                 edgerc: Optional[pulumi.Input[_builtins.str]] = None,
                 request_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 retry_max: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_wait_max: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_wait_min: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["cache_enabled"] = pulumi.Output.from_input(cache_enabled).apply(pulumi.runtime.to_json) if cache_enabled is not None else None
            __props__.__dict__["config"] = pulumi.Output.from_input(config).apply(pulumi.runtime.to_json) if config is not None else None
            __props__.__dict__["config_section"] = config_section
            __props__.__dict__["edgerc"] = edgerc
            __props__.__dict__["request_limit"] = pulumi.Output.from_input(request_limit).apply(pulumi.runtime.to_json) if request_limit is not None else None
            __props__.__dict__["retry_disabled"] = pulumi.Output.from_input(retry_disabled).apply(pulumi.runtime.to_json) if retry_disabled is not None else None
            __props__.__dict__["retry_max"] = pulumi.Output.from_input(retry_max).apply(pulumi.runtime.to_json) if retry_max is not None else None
            __props__.__dict__["retry_wait_max"] = pulumi.Output.from_input(retry_wait_max).apply(pulumi.runtime.to_json) if retry_wait_max is not None else None
            __props__.__dict__["retry_wait_min"] = pulumi.Output.from_input(retry_wait_min).apply(pulumi.runtime.to_json) if retry_wait_min is not None else None
        super(Provider, __self__).__init__(
            'akamai',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="configSection")
    def config_section(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The section of the edgerc file to use for configuration
        """
        return pulumi.get(self, "config_section")

    @_builtins.property
    @pulumi.getter
    def edgerc(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "edgerc")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:akamai/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

