# CCUX — AI-Powered Website Generator
CCUX uses **Claude AI** to transform a simple product description into production-ready code — no design tools required.

---

## Features

- **One-line generation** — describe your product and get a landing page or full site in minutes  
- **Professional themes** — choose from 13 styles (minimal, corporate, brutalist, animated, etc.)  
- **Precision editing** — regenerate specific sections without rebuilding everything  
- **Interactive workflow** — guided wizard for multi-page sites, live editing, and theme switching  
- **Production-ready output** — responsive HTML or React components with TailwindCSS, SEO, and accessibility  

---

## Installation

```bash
pip install ccux
```

**Prerequisites:**  
- Python 3.9+  
- [Claude CLI](https://claude.ai/code) (used for AI generation)  

---

## Getting Started

### Interactive Mode (Recommended)

```bash
ccux init
```

The interactive terminal app provides:
- Guided website creation wizard  
- Visual project management  
- Live section editing and theme switching  
- Multi-page website generation  
- Form management and customization  
- Press `ESC` anytime to exit  

### Command Line Usage

```bash
# Generate single landing page
ccux gen --desc "AI project management tool" --theme minimal

# Generate complete multi-page website
ccux multipage --desc "SaaS platform for remote teams"

# Regenerate specific sections
ccux regen --section hero,pricing

# Load description from file
ccux gen --desc-file product.pdf --theme brutalist
```

---

## Commands

| Command          | Description                         |
|------------------|-------------------------------------|
| `ccux init`      | Interactive wizard for new projects |
| `ccux gen`       | Generate a single landing page      |
| `ccux multipage` | Generate a complete multi-page site |
| `ccux regen`     | Update specific sections            |
| `ccux projects`  | List existing projects              |
| `ccux help`      | Detailed help for any topic         |

---

## What You Get

### Professional Quality Output
- Production-ready HTML or React components  
- Mobile-responsive design with TailwindCSS  
- SEO optimization and accessibility features  
- Clean, semantic code structure  

### AI Design Process
- Automatic competitor analysis and research  
- Structured UX methodology for layouts and flows  
- Conversion-optimized copywriting  
- Consistent visual design across 13 themes  

### 13 Design Themes
From minimal and corporate to brutalist, animated, and illustrated styles.  

---

## Examples

**Single Page:**
```bash
ccux gen --desc "AI-powered project management tool for remote teams"
```

**Multi-Page Website:**
```bash
ccux multipage --desc "SaaS platform with features, pricing, and about pages"
```

**Edit Existing:**
```bash
ccux regen --section hero,pricing
```

---

## View Your Pages

```bash
cd output/
python -m http.server 3000
# Open http://localhost:3000
```

---

## Links

- **PyPI:** [pypi.org/project/ccux](https://pypi.org/project/ccux/)  
- **Claude CLI:** [claude.ai/code](https://claude.ai/code)  
- **Help:** Run `ccux help` for detailed documentation  

---
