window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"mlsauce": {"fullname": "mlsauce", "modulename": "mlsauce", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.AdaOpt": {"fullname": "mlsauce.AdaOpt", "modulename": "mlsauce", "qualname": "AdaOpt", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.LSBoostClassifier": {"fullname": "mlsauce.LSBoostClassifier", "modulename": "mlsauce", "qualname": "LSBoostClassifier", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.GenericBoostingClassifier": {"fullname": "mlsauce.GenericBoostingClassifier", "modulename": "mlsauce", "qualname": "GenericBoostingClassifier", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.GenericBoostingRegressor": {"fullname": "mlsauce.GenericBoostingRegressor", "modulename": "mlsauce", "qualname": "GenericBoostingRegressor", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.StumpClassifier": {"fullname": "mlsauce.StumpClassifier", "modulename": "mlsauce", "qualname": "StumpClassifier", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.ElasticNetRegressor": {"fullname": "mlsauce.ElasticNetRegressor", "modulename": "mlsauce", "qualname": "ElasticNetRegressor", "kind": "class", "doc": "<p>Elasticnet.</p>\n\n<p>Attributes:</p>\n\n<pre><code>reg_lambda: float\n    regularization parameter.\n\nalpha: float\n    compromise between L1 and L2 regularization (must be in [0, 1]),\n    for `solver` == 'enet'.\n\nbackend: str\n    type of backend; must be in ('cpu', 'gpu', 'tpu')\n</code></pre>\n", "bases": "sklearn.base.BaseEstimator, sklearn.base.RegressorMixin"}, "mlsauce.ElasticNetRegressor.__init__": {"fullname": "mlsauce.ElasticNetRegressor.__init__", "modulename": "mlsauce", "qualname": "ElasticNetRegressor.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">reg_lambda</span><span class=\"o\">=</span><span class=\"mf\">0.1</span>, </span><span class=\"param\"><span class=\"n\">alpha</span><span class=\"o\">=</span><span class=\"mf\">0.5</span>, </span><span class=\"param\"><span class=\"n\">backend</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span></span>)</span>"}, "mlsauce.ElasticNetRegressor.reg_lambda": {"fullname": "mlsauce.ElasticNetRegressor.reg_lambda", "modulename": "mlsauce", "qualname": "ElasticNetRegressor.reg_lambda", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.ElasticNetRegressor.alpha": {"fullname": "mlsauce.ElasticNetRegressor.alpha", "modulename": "mlsauce", "qualname": "ElasticNetRegressor.alpha", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.ElasticNetRegressor.backend": {"fullname": "mlsauce.ElasticNetRegressor.backend", "modulename": "mlsauce", "qualname": "ElasticNetRegressor.backend", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.ElasticNetRegressor.fit": {"fullname": "mlsauce.ElasticNetRegressor.fit", "modulename": "mlsauce", "qualname": "ElasticNetRegressor.fit", "kind": "function", "doc": "<p>Fit matrixops (classifier) to training data (X, y)</p>\n\n<p>Args:</p>\n\n<pre><code>X: {array-like}, shape = [n_samples, n_features]\n    Training vectors, where n_samples is the number\n    of samples and n_features is the number of features.\n\ny: array-like, shape = [n_samples]\n    Target values.\n\n**kwargs: additional parameters to be passed to self.cook_training_set.\n</code></pre>\n\n<p>Returns:</p>\n\n<pre><code>self: object.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.ElasticNetRegressor.predict": {"fullname": "mlsauce.ElasticNetRegressor.predict", "modulename": "mlsauce", "qualname": "ElasticNetRegressor.predict", "kind": "function", "doc": "<p>Predict test data X.</p>\n\n<p>Args:</p>\n\n<pre><code>X: {array-like}, shape = [n_samples, n_features]\n    Training vectors, where n_samples is the number\n    of samples and n_features is the number of features.\n\n**kwargs: additional parameters to be passed to `predict_proba`\n</code></pre>\n\n<p>Returns:</p>\n\n<pre><code>model predictions: {array-like}\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.ElasticNetRegressor.set_score_request": {"fullname": "mlsauce.ElasticNetRegressor.set_score_request", "modulename": "mlsauce", "qualname": "ElasticNetRegressor.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.KRLSRegressor": {"fullname": "mlsauce.KRLSRegressor", "modulename": "mlsauce", "qualname": "KRLSRegressor", "kind": "class", "doc": "<p>Base class for all estimators in scikit-learn.</p>\n\n<p>Inheriting from this class provides default implementations of:</p>\n\n<ul>\n<li>setting and getting parameters used by <code>GridSearchCV</code> and friends;</li>\n<li>textual and HTML representation displayed in terminals and IDEs;</li>\n<li>estimator serialization;</li>\n<li>parameters validation;</li>\n<li>data validation;</li>\n<li>feature names validation.</li>\n</ul>\n\n<p>Read more in the :ref:<code>User Guide &lt;rolling_your_own_estimator&gt;</code>.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>All estimators should specify all the parameters that can be set\nat the class level in their <code>__init__</code> as explicit keyword\narguments (no <code>*args</code> or <code>**kwargs</code>).</p>\n\n<h2 id=\"examples\">Examples</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">numpy</span> <span class=\"k\">as</span> <span class=\"nn\">np</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sklearn.base</span> <span class=\"kn\">import</span> <span class=\"n\">BaseEstimator</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">class</span> <span class=\"nc\">MyEstimator</span><span class=\"p\">(</span><span class=\"n\">BaseEstimator</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"fm\">__init__</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"o\">*</span><span class=\"p\">,</span> <span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">param</span> <span class=\"o\">=</span> <span class=\"n\">param</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"nf\">fit</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"o\">=</span><span class=\"kc\">None</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">is_fitted_</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>\n<span class=\"gp\">... </span>        <span class=\"k\">return</span> <span class=\"bp\">self</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"nf\">predict</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">X</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"k\">return</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">full</span><span class=\"p\">(</span><span class=\"n\">shape</span><span class=\"o\">=</span><span class=\"n\">X</span><span class=\"o\">.</span><span class=\"n\">shape</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">],</span> <span class=\"n\">fill_value</span><span class=\"o\">=</span><span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">param</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span> <span class=\"o\">=</span> <span class=\"n\">MyEstimator</span><span class=\"p\">(</span><span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">get_params</span><span class=\"p\">()</span>\n<span class=\"go\">{&#39;param&#39;: 2}</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">X</span> <span class=\"o\">=</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">array</span><span class=\"p\">([[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"mi\">4</span><span class=\"p\">]])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">y</span> <span class=\"o\">=</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">array</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">1</span><span class=\"p\">])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">fit</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">predict</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">)</span>\n<span class=\"go\">array([2, 2, 2])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">set_params</span><span class=\"p\">(</span><span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">3</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">fit</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">predict</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">)</span>\n<span class=\"go\">array([3, 3, 3])</span>\n</code></pre>\n</div>\n", "bases": "sklearn.base.BaseEstimator, sklearn.base.RegressorMixin"}, "mlsauce.KRLSRegressor.__init__": {"fullname": "mlsauce.KRLSRegressor.__init__", "modulename": "mlsauce", "qualname": "KRLSRegressor.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">regularization</span><span class=\"o\">=</span><span class=\"mf\">0.1</span>, </span><span class=\"param\"><span class=\"n\">kernel</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">backend</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span></span>)</span>"}, "mlsauce.KRLSRegressor.backend": {"fullname": "mlsauce.KRLSRegressor.backend", "modulename": "mlsauce", "qualname": "KRLSRegressor.backend", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.KRLSRegressor.kernel": {"fullname": "mlsauce.KRLSRegressor.kernel", "modulename": "mlsauce", "qualname": "KRLSRegressor.kernel", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.KRLSRegressor.regularization": {"fullname": "mlsauce.KRLSRegressor.regularization", "modulename": "mlsauce", "qualname": "KRLSRegressor.regularization", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.KRLSRegressor.ym_": {"fullname": "mlsauce.KRLSRegressor.ym_", "modulename": "mlsauce", "qualname": "KRLSRegressor.ym_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.KRLSRegressor.scaler_": {"fullname": "mlsauce.KRLSRegressor.scaler_", "modulename": "mlsauce", "qualname": "KRLSRegressor.scaler_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.KRLSRegressor.X_": {"fullname": "mlsauce.KRLSRegressor.X_", "modulename": "mlsauce", "qualname": "KRLSRegressor.X_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.KRLSRegressor.coef_": {"fullname": "mlsauce.KRLSRegressor.coef_", "modulename": "mlsauce", "qualname": "KRLSRegressor.coef_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.KRLSRegressor.fit": {"fullname": "mlsauce.KRLSRegressor.fit", "modulename": "mlsauce", "qualname": "KRLSRegressor.fit", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.KRLSRegressor.predict": {"fullname": "mlsauce.KRLSRegressor.predict", "modulename": "mlsauce", "qualname": "KRLSRegressor.predict", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.KRLSRegressor.set_score_request": {"fullname": "mlsauce.KRLSRegressor.set_score_request", "modulename": "mlsauce", "qualname": "KRLSRegressor.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.LassoRegressor": {"fullname": "mlsauce.LassoRegressor", "modulename": "mlsauce", "qualname": "LassoRegressor", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.LSBoostRegressor": {"fullname": "mlsauce.LSBoostRegressor", "modulename": "mlsauce", "qualname": "LSBoostRegressor", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.RidgeRegressor": {"fullname": "mlsauce.RidgeRegressor", "modulename": "mlsauce", "qualname": "RidgeRegressor", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.LazyBoostingClassifier": {"fullname": "mlsauce.LazyBoostingClassifier", "modulename": "mlsauce", "qualname": "LazyBoostingClassifier", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.LazyBoostingMTS": {"fullname": "mlsauce.LazyBoostingMTS", "modulename": "mlsauce", "qualname": "LazyBoostingMTS", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.LazyBoostingRegressor": {"fullname": "mlsauce.LazyBoostingRegressor", "modulename": "mlsauce", "qualname": "LazyBoostingRegressor", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.MultiTaskRegressor": {"fullname": "mlsauce.MultiTaskRegressor", "modulename": "mlsauce", "qualname": "MultiTaskRegressor", "kind": "class", "doc": "<p>A class for multi-task regression</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>regr: object\n    A regressor object</p>\n\n<h2 id=\"attributes\">Attributes</h2>\n\n<p>objs: list\n    A list containing the fitted regressor objects</p>\n", "bases": "sklearn.base.BaseEstimator, sklearn.base.RegressorMixin"}, "mlsauce.MultiTaskRegressor.__init__": {"fullname": "mlsauce.MultiTaskRegressor.__init__", "modulename": "mlsauce", "qualname": "MultiTaskRegressor.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">regr</span></span>)</span>"}, "mlsauce.MultiTaskRegressor.regr": {"fullname": "mlsauce.MultiTaskRegressor.regr", "modulename": "mlsauce", "qualname": "MultiTaskRegressor.regr", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.MultiTaskRegressor.objs": {"fullname": "mlsauce.MultiTaskRegressor.objs", "modulename": "mlsauce", "qualname": "MultiTaskRegressor.objs", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.MultiTaskRegressor.fit": {"fullname": "mlsauce.MultiTaskRegressor.fit", "modulename": "mlsauce", "qualname": "MultiTaskRegressor.fit", "kind": "function", "doc": "<p>Fit the regressor</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>X: array-like\n    The input data\ny: array-like\n    The target values</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.MultiTaskRegressor.predict": {"fullname": "mlsauce.MultiTaskRegressor.predict", "modulename": "mlsauce", "qualname": "MultiTaskRegressor.predict", "kind": "function", "doc": "<p>Predict the target values</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>X: array-like\n    The input data</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>y_pred: array-like\n    The predicted target values</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.MultiTaskRegressor.set_score_request": {"fullname": "mlsauce.MultiTaskRegressor.set_score_request", "modulename": "mlsauce", "qualname": "MultiTaskRegressor.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.IsotonicRegressor": {"fullname": "mlsauce.IsotonicRegressor", "modulename": "mlsauce", "qualname": "IsotonicRegressor", "kind": "class", "doc": "<p>Isotonic Regressor with postprocessing.</p>\n\n<p>This class takes a base regressor and applies isotonic regression as\npostprocessing in the predict method. The isotonic regression ensures\nthat the predictions are monotonically increasing or decreasing.</p>\n\n<p>Attributes:\n    regr: estimator\n        Base regressor to use for initial predictions.</p>\n\n<pre><code>increasing: bool, default=True\n    If True, the isotonic regression will be monotonically increasing.\n    If False, it will be monotonically decreasing.\n\nout_of_bounds: str, default='nan'\n    The out_of_bounds parameter for IsotonicRegression.\n    Can be 'nan', 'clip', or 'raise'.\n</code></pre>\n", "bases": "sklearn.base.BaseEstimator, sklearn.base.RegressorMixin"}, "mlsauce.IsotonicRegressor.__init__": {"fullname": "mlsauce.IsotonicRegressor.__init__", "modulename": "mlsauce", "qualname": "IsotonicRegressor.__init__", "kind": "function", "doc": "<p>Initialize the IsotonicRegressor.</p>\n\n<p>Args:\n    regr: estimator\n        Base regressor to use for initial predictions.</p>\n\n<pre><code>increasing: bool, default=True\n    If True, the isotonic regression will be monotonically increasing.\n    If False, it will be monotonically decreasing.\n\nout_of_bounds: str, default='nan'\n    The out_of_bounds parameter for IsotonicRegression.\n    Can be 'nan', 'clip', or 'raise'.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">regr</span>, </span><span class=\"param\"><span class=\"n\">increasing</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">out_of_bounds</span><span class=\"o\">=</span><span class=\"s1\">&#39;nan&#39;</span></span>)</span>"}, "mlsauce.IsotonicRegressor.regr": {"fullname": "mlsauce.IsotonicRegressor.regr", "modulename": "mlsauce", "qualname": "IsotonicRegressor.regr", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.IsotonicRegressor.increasing": {"fullname": "mlsauce.IsotonicRegressor.increasing", "modulename": "mlsauce", "qualname": "IsotonicRegressor.increasing", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.IsotonicRegressor.out_of_bounds": {"fullname": "mlsauce.IsotonicRegressor.out_of_bounds", "modulename": "mlsauce", "qualname": "IsotonicRegressor.out_of_bounds", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.IsotonicRegressor.fit": {"fullname": "mlsauce.IsotonicRegressor.fit", "modulename": "mlsauce", "qualname": "IsotonicRegressor.fit", "kind": "function", "doc": "<p>Fit the model.</p>\n\n<p>Args:\n    X: {array-like}, shape = [n_samples, n_features]\n        Training vectors, where n_samples is the number\n        of samples and n_features is the number of features.</p>\n\n<pre><code>y: array-like, shape = [n_samples]\n    Target values.\n\n**kwargs: additional parameters to be passed to the base regressor.\n</code></pre>\n\n<p>Returns:\n    self: object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.IsotonicRegressor.predict": {"fullname": "mlsauce.IsotonicRegressor.predict", "modulename": "mlsauce", "qualname": "IsotonicRegressor.predict", "kind": "function", "doc": "<p>Predict using the model.</p>\n\n<p>Args:\n    X: {array-like}, shape = [n_samples, n_features]\n        Samples.</p>\n\n<pre><code>**kwargs: additional parameters to be passed to the base regressor.\n</code></pre>\n\n<p>Returns:\n    y_pred: array-like, shape = [n_samples]\n        Predicted values.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.IsotonicRegressor.set_score_request": {"fullname": "mlsauce.IsotonicRegressor.set_score_request", "modulename": "mlsauce", "qualname": "IsotonicRegressor.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.GenericFunctionalForecaster": {"fullname": "mlsauce.GenericFunctionalForecaster", "modulename": "mlsauce", "qualname": "GenericFunctionalForecaster", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.download": {"fullname": "mlsauce.download", "modulename": "mlsauce", "qualname": "download", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">pkgname</span><span class=\"o\">=</span><span class=\"s1\">&#39;MASS&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">dataset</span><span class=\"o\">=</span><span class=\"s1\">&#39;Boston&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">source</span><span class=\"o\">=</span><span class=\"s1\">&#39;https://cran.r-universe.dev/&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.get_config": {"fullname": "mlsauce.get_config", "modulename": "mlsauce", "qualname": "get_config", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.set_config": {"fullname": "mlsauce.set_config", "modulename": "mlsauce", "qualname": "set_config", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.config_context": {"fullname": "mlsauce.config_context", "modulename": "mlsauce", "qualname": "config_context", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.adaopt": {"fullname": "mlsauce.adaopt", "modulename": "mlsauce.adaopt", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.adaopt.AdaOpt": {"fullname": "mlsauce.adaopt.AdaOpt", "modulename": "mlsauce.adaopt", "qualname": "AdaOpt", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.booster": {"fullname": "mlsauce.booster", "modulename": "mlsauce.booster", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.booster.LSBoostClassifier": {"fullname": "mlsauce.booster.LSBoostClassifier", "modulename": "mlsauce.booster", "qualname": "LSBoostClassifier", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.booster.LSBoostRegressor": {"fullname": "mlsauce.booster.LSBoostRegressor", "modulename": "mlsauce.booster", "qualname": "LSBoostRegressor", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.booster.GenericBoostingClassifier": {"fullname": "mlsauce.booster.GenericBoostingClassifier", "modulename": "mlsauce.booster", "qualname": "GenericBoostingClassifier", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.booster.GenericBoostingRegressor": {"fullname": "mlsauce.booster.GenericBoostingRegressor", "modulename": "mlsauce.booster", "qualname": "GenericBoostingRegressor", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.datasets": {"fullname": "mlsauce.datasets", "modulename": "mlsauce.datasets", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.datasets.dowload": {"fullname": "mlsauce.datasets.dowload", "modulename": "mlsauce.datasets.dowload", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.datasets.dowload.download": {"fullname": "mlsauce.datasets.dowload.download", "modulename": "mlsauce.datasets.dowload", "qualname": "download", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">pkgname</span><span class=\"o\">=</span><span class=\"s1\">&#39;MASS&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">dataset</span><span class=\"o\">=</span><span class=\"s1\">&#39;Boston&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">source</span><span class=\"o\">=</span><span class=\"s1\">&#39;https://cran.r-universe.dev/&#39;</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.demo": {"fullname": "mlsauce.demo", "modulename": "mlsauce.demo", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.elasticnet": {"fullname": "mlsauce.elasticnet", "modulename": "mlsauce.elasticnet", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.elasticnet.ElasticNetRegressor": {"fullname": "mlsauce.elasticnet.ElasticNetRegressor", "modulename": "mlsauce.elasticnet", "qualname": "ElasticNetRegressor", "kind": "class", "doc": "<p>Elasticnet.</p>\n\n<p>Attributes:</p>\n\n<pre><code>reg_lambda: float\n    regularization parameter.\n\nalpha: float\n    compromise between L1 and L2 regularization (must be in [0, 1]),\n    for `solver` == 'enet'.\n\nbackend: str\n    type of backend; must be in ('cpu', 'gpu', 'tpu')\n</code></pre>\n", "bases": "sklearn.base.BaseEstimator, sklearn.base.RegressorMixin"}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"fullname": "mlsauce.elasticnet.ElasticNetRegressor.__init__", "modulename": "mlsauce.elasticnet", "qualname": "ElasticNetRegressor.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">reg_lambda</span><span class=\"o\">=</span><span class=\"mf\">0.1</span>, </span><span class=\"param\"><span class=\"n\">alpha</span><span class=\"o\">=</span><span class=\"mf\">0.5</span>, </span><span class=\"param\"><span class=\"n\">backend</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span></span>)</span>"}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"fullname": "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda", "modulename": "mlsauce.elasticnet", "qualname": "ElasticNetRegressor.reg_lambda", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.elasticnet.ElasticNetRegressor.alpha": {"fullname": "mlsauce.elasticnet.ElasticNetRegressor.alpha", "modulename": "mlsauce.elasticnet", "qualname": "ElasticNetRegressor.alpha", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.elasticnet.ElasticNetRegressor.backend": {"fullname": "mlsauce.elasticnet.ElasticNetRegressor.backend", "modulename": "mlsauce.elasticnet", "qualname": "ElasticNetRegressor.backend", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"fullname": "mlsauce.elasticnet.ElasticNetRegressor.fit", "modulename": "mlsauce.elasticnet", "qualname": "ElasticNetRegressor.fit", "kind": "function", "doc": "<p>Fit matrixops (classifier) to training data (X, y)</p>\n\n<p>Args:</p>\n\n<pre><code>X: {array-like}, shape = [n_samples, n_features]\n    Training vectors, where n_samples is the number\n    of samples and n_features is the number of features.\n\ny: array-like, shape = [n_samples]\n    Target values.\n\n**kwargs: additional parameters to be passed to self.cook_training_set.\n</code></pre>\n\n<p>Returns:</p>\n\n<pre><code>self: object.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"fullname": "mlsauce.elasticnet.ElasticNetRegressor.predict", "modulename": "mlsauce.elasticnet", "qualname": "ElasticNetRegressor.predict", "kind": "function", "doc": "<p>Predict test data X.</p>\n\n<p>Args:</p>\n\n<pre><code>X: {array-like}, shape = [n_samples, n_features]\n    Training vectors, where n_samples is the number\n    of samples and n_features is the number of features.\n\n**kwargs: additional parameters to be passed to `predict_proba`\n</code></pre>\n\n<p>Returns:</p>\n\n<pre><code>model predictions: {array-like}\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"fullname": "mlsauce.elasticnet.ElasticNetRegressor.set_score_request", "modulename": "mlsauce.elasticnet", "qualname": "ElasticNetRegressor.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.fpca": {"fullname": "mlsauce.fpca", "modulename": "mlsauce.fpca", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.fpca.GenericFunctionalForecaster": {"fullname": "mlsauce.fpca.GenericFunctionalForecaster", "modulename": "mlsauce.fpca", "qualname": "GenericFunctionalForecaster", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.isotonicregressor": {"fullname": "mlsauce.isotonicregressor", "modulename": "mlsauce.isotonicregressor", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.isotonicregressor.IsotonicRegressor": {"fullname": "mlsauce.isotonicregressor.IsotonicRegressor", "modulename": "mlsauce.isotonicregressor", "qualname": "IsotonicRegressor", "kind": "class", "doc": "<p>Isotonic Regressor with postprocessing.</p>\n\n<p>This class takes a base regressor and applies isotonic regression as\npostprocessing in the predict method. The isotonic regression ensures\nthat the predictions are monotonically increasing or decreasing.</p>\n\n<p>Attributes:\n    regr: estimator\n        Base regressor to use for initial predictions.</p>\n\n<pre><code>increasing: bool, default=True\n    If True, the isotonic regression will be monotonically increasing.\n    If False, it will be monotonically decreasing.\n\nout_of_bounds: str, default='nan'\n    The out_of_bounds parameter for IsotonicRegression.\n    Can be 'nan', 'clip', or 'raise'.\n</code></pre>\n", "bases": "sklearn.base.BaseEstimator, sklearn.base.RegressorMixin"}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"fullname": "mlsauce.isotonicregressor.IsotonicRegressor.__init__", "modulename": "mlsauce.isotonicregressor", "qualname": "IsotonicRegressor.__init__", "kind": "function", "doc": "<p>Initialize the IsotonicRegressor.</p>\n\n<p>Args:\n    regr: estimator\n        Base regressor to use for initial predictions.</p>\n\n<pre><code>increasing: bool, default=True\n    If True, the isotonic regression will be monotonically increasing.\n    If False, it will be monotonically decreasing.\n\nout_of_bounds: str, default='nan'\n    The out_of_bounds parameter for IsotonicRegression.\n    Can be 'nan', 'clip', or 'raise'.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">regr</span>, </span><span class=\"param\"><span class=\"n\">increasing</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">out_of_bounds</span><span class=\"o\">=</span><span class=\"s1\">&#39;nan&#39;</span></span>)</span>"}, "mlsauce.isotonicregressor.IsotonicRegressor.regr": {"fullname": "mlsauce.isotonicregressor.IsotonicRegressor.regr", "modulename": "mlsauce.isotonicregressor", "qualname": "IsotonicRegressor.regr", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.isotonicregressor.IsotonicRegressor.increasing": {"fullname": "mlsauce.isotonicregressor.IsotonicRegressor.increasing", "modulename": "mlsauce.isotonicregressor", "qualname": "IsotonicRegressor.increasing", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"fullname": "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds", "modulename": "mlsauce.isotonicregressor", "qualname": "IsotonicRegressor.out_of_bounds", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"fullname": "mlsauce.isotonicregressor.IsotonicRegressor.fit", "modulename": "mlsauce.isotonicregressor", "qualname": "IsotonicRegressor.fit", "kind": "function", "doc": "<p>Fit the model.</p>\n\n<p>Args:\n    X: {array-like}, shape = [n_samples, n_features]\n        Training vectors, where n_samples is the number\n        of samples and n_features is the number of features.</p>\n\n<pre><code>y: array-like, shape = [n_samples]\n    Target values.\n\n**kwargs: additional parameters to be passed to the base regressor.\n</code></pre>\n\n<p>Returns:\n    self: object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"fullname": "mlsauce.isotonicregressor.IsotonicRegressor.predict", "modulename": "mlsauce.isotonicregressor", "qualname": "IsotonicRegressor.predict", "kind": "function", "doc": "<p>Predict using the model.</p>\n\n<p>Args:\n    X: {array-like}, shape = [n_samples, n_features]\n        Samples.</p>\n\n<pre><code>**kwargs: additional parameters to be passed to the base regressor.\n</code></pre>\n\n<p>Returns:\n    y_pred: array-like, shape = [n_samples]\n        Predicted values.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"fullname": "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request", "modulename": "mlsauce.isotonicregressor", "qualname": "IsotonicRegressor.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.kernelridge": {"fullname": "mlsauce.kernelridge", "modulename": "mlsauce.kernelridge", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.kernelridge.KRLSRegressor": {"fullname": "mlsauce.kernelridge.KRLSRegressor", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor", "kind": "class", "doc": "<p>Base class for all estimators in scikit-learn.</p>\n\n<p>Inheriting from this class provides default implementations of:</p>\n\n<ul>\n<li>setting and getting parameters used by <code>GridSearchCV</code> and friends;</li>\n<li>textual and HTML representation displayed in terminals and IDEs;</li>\n<li>estimator serialization;</li>\n<li>parameters validation;</li>\n<li>data validation;</li>\n<li>feature names validation.</li>\n</ul>\n\n<p>Read more in the :ref:<code>User Guide &lt;rolling_your_own_estimator&gt;</code>.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>All estimators should specify all the parameters that can be set\nat the class level in their <code>__init__</code> as explicit keyword\narguments (no <code>*args</code> or <code>**kwargs</code>).</p>\n\n<h2 id=\"examples\">Examples</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">numpy</span> <span class=\"k\">as</span> <span class=\"nn\">np</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sklearn.base</span> <span class=\"kn\">import</span> <span class=\"n\">BaseEstimator</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">class</span> <span class=\"nc\">MyEstimator</span><span class=\"p\">(</span><span class=\"n\">BaseEstimator</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"fm\">__init__</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"o\">*</span><span class=\"p\">,</span> <span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">param</span> <span class=\"o\">=</span> <span class=\"n\">param</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"nf\">fit</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"o\">=</span><span class=\"kc\">None</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">is_fitted_</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>\n<span class=\"gp\">... </span>        <span class=\"k\">return</span> <span class=\"bp\">self</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"nf\">predict</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">X</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"k\">return</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">full</span><span class=\"p\">(</span><span class=\"n\">shape</span><span class=\"o\">=</span><span class=\"n\">X</span><span class=\"o\">.</span><span class=\"n\">shape</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">],</span> <span class=\"n\">fill_value</span><span class=\"o\">=</span><span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">param</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span> <span class=\"o\">=</span> <span class=\"n\">MyEstimator</span><span class=\"p\">(</span><span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">get_params</span><span class=\"p\">()</span>\n<span class=\"go\">{&#39;param&#39;: 2}</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">X</span> <span class=\"o\">=</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">array</span><span class=\"p\">([[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"mi\">4</span><span class=\"p\">]])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">y</span> <span class=\"o\">=</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">array</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">1</span><span class=\"p\">])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">fit</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">predict</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">)</span>\n<span class=\"go\">array([2, 2, 2])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">set_params</span><span class=\"p\">(</span><span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">3</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">fit</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">predict</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">)</span>\n<span class=\"go\">array([3, 3, 3])</span>\n</code></pre>\n</div>\n", "bases": "sklearn.base.BaseEstimator, sklearn.base.RegressorMixin"}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"fullname": "mlsauce.kernelridge.KRLSRegressor.__init__", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">regularization</span><span class=\"o\">=</span><span class=\"mf\">0.1</span>, </span><span class=\"param\"><span class=\"n\">kernel</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">backend</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span></span>)</span>"}, "mlsauce.kernelridge.KRLSRegressor.backend": {"fullname": "mlsauce.kernelridge.KRLSRegressor.backend", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.backend", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.kernelridge.KRLSRegressor.kernel": {"fullname": "mlsauce.kernelridge.KRLSRegressor.kernel", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.kernel", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.kernelridge.KRLSRegressor.regularization": {"fullname": "mlsauce.kernelridge.KRLSRegressor.regularization", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.regularization", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"fullname": "mlsauce.kernelridge.KRLSRegressor.ym_", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.ym_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"fullname": "mlsauce.kernelridge.KRLSRegressor.scaler_", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.scaler_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.kernelridge.KRLSRegressor.X_": {"fullname": "mlsauce.kernelridge.KRLSRegressor.X_", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.X_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"fullname": "mlsauce.kernelridge.KRLSRegressor.coef_", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.coef_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.kernelridge.KRLSRegressor.fit": {"fullname": "mlsauce.kernelridge.KRLSRegressor.fit", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.fit", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.kernelridge.KRLSRegressor.predict": {"fullname": "mlsauce.kernelridge.KRLSRegressor.predict", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.predict", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"fullname": "mlsauce.kernelridge.KRLSRegressor.set_score_request", "modulename": "mlsauce.kernelridge", "qualname": "KRLSRegressor.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.lasso": {"fullname": "mlsauce.lasso", "modulename": "mlsauce.lasso", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.lasso.LassoRegressor": {"fullname": "mlsauce.lasso.LassoRegressor", "modulename": "mlsauce.lasso", "qualname": "LassoRegressor", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.lazybooster": {"fullname": "mlsauce.lazybooster", "modulename": "mlsauce.lazybooster", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.lazybooster.LazyBoostingClassifier": {"fullname": "mlsauce.lazybooster.LazyBoostingClassifier", "modulename": "mlsauce.lazybooster", "qualname": "LazyBoostingClassifier", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.lazybooster.LazyBoostingRegressor": {"fullname": "mlsauce.lazybooster.LazyBoostingRegressor", "modulename": "mlsauce.lazybooster", "qualname": "LazyBoostingRegressor", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.lazybooster.LazyBoostingMTS": {"fullname": "mlsauce.lazybooster.LazyBoostingMTS", "modulename": "mlsauce.lazybooster", "qualname": "LazyBoostingMTS", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.multitaskregressor": {"fullname": "mlsauce.multitaskregressor", "modulename": "mlsauce.multitaskregressor", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"fullname": "mlsauce.multitaskregressor.MultiTaskRegressor", "modulename": "mlsauce.multitaskregressor", "qualname": "MultiTaskRegressor", "kind": "class", "doc": "<p>A class for multi-task regression</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>regr: object\n    A regressor object</p>\n\n<h2 id=\"attributes\">Attributes</h2>\n\n<p>objs: list\n    A list containing the fitted regressor objects</p>\n", "bases": "sklearn.base.BaseEstimator, sklearn.base.RegressorMixin"}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"fullname": "mlsauce.multitaskregressor.MultiTaskRegressor.__init__", "modulename": "mlsauce.multitaskregressor", "qualname": "MultiTaskRegressor.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">regr</span></span>)</span>"}, "mlsauce.multitaskregressor.MultiTaskRegressor.regr": {"fullname": "mlsauce.multitaskregressor.MultiTaskRegressor.regr", "modulename": "mlsauce.multitaskregressor", "qualname": "MultiTaskRegressor.regr", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.multitaskregressor.MultiTaskRegressor.objs": {"fullname": "mlsauce.multitaskregressor.MultiTaskRegressor.objs", "modulename": "mlsauce.multitaskregressor", "qualname": "MultiTaskRegressor.objs", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"fullname": "mlsauce.multitaskregressor.MultiTaskRegressor.fit", "modulename": "mlsauce.multitaskregressor", "qualname": "MultiTaskRegressor.fit", "kind": "function", "doc": "<p>Fit the regressor</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>X: array-like\n    The input data\ny: array-like\n    The target values</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"fullname": "mlsauce.multitaskregressor.MultiTaskRegressor.predict", "modulename": "mlsauce.multitaskregressor", "qualname": "MultiTaskRegressor.predict", "kind": "function", "doc": "<p>Predict the target values</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>X: array-like\n    The input data</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>y_pred: array-like\n    The predicted target values</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"fullname": "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request", "modulename": "mlsauce.multitaskregressor", "qualname": "MultiTaskRegressor.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist": {"fullname": "mlsauce.nonconformist", "modulename": "mlsauce.nonconformist", "kind": "module", "doc": "<p>docstring</p>\n"}, "mlsauce.nonconformist.AbsErrorErrFunc": {"fullname": "mlsauce.nonconformist.AbsErrorErrFunc", "modulename": "mlsauce.nonconformist", "qualname": "AbsErrorErrFunc", "kind": "class", "doc": "<p>Calculates absolute error nonconformity for regression problems.</p>\n\n<p>For each correct output in <code>y</code>, nonconformity is defined as</p>\n\n<p>$$| y_i - \\hat{y}_i |$$</p>\n", "bases": "mlsauce.nonconformist.nc.RegressionErrFunc"}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"fullname": "mlsauce.nonconformist.AbsErrorErrFunc.apply", "modulename": "mlsauce.nonconformist", "qualname": "AbsErrorErrFunc.apply", "kind": "function", "doc": "<p>Apply the nonconformity function.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>prediction : numpy array of shape [n_samples, n_classes]\n    Class probability estimates for each sample.</p>\n\n<p>y : numpy array of shape [n_samples]\n    True output labels of each sample.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>nc : numpy array of shape [n_samples]\n    Nonconformity scores of the samples.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">prediction</span>, </span><span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"fullname": "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse", "modulename": "mlsauce.nonconformist", "qualname": "AbsErrorErrFunc.apply_inverse", "kind": "function", "doc": "<p>Apply the inverse of the nonconformity function (i.e.,\ncalculate prediction interval).</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>nc : numpy array of shape [n_calibration_samples]\n    Nonconformity scores obtained for conformal predictor.</p>\n\n<p>significance : float\n    Significance level (0, 1).</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>interval : numpy array of shape [n_samples, 2]\n    Minimum and maximum interval boundaries for each prediction.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">nc</span>, </span><span class=\"param\"><span class=\"n\">significance</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.QuantileRegErrFunc": {"fullname": "mlsauce.nonconformist.QuantileRegErrFunc", "modulename": "mlsauce.nonconformist", "qualname": "QuantileRegErrFunc", "kind": "class", "doc": "<p>Calculates conformalized quantile regression error.</p>\n\n<p>For each correct output in <code>y</code>, nonconformity is defined as</p>\n\n<p>$$max{\\hat{q}_low - y, y - \\hat{q}_high}$$</p>\n", "bases": "mlsauce.nonconformist.nc.RegressionErrFunc"}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"fullname": "mlsauce.nonconformist.QuantileRegErrFunc.apply", "modulename": "mlsauce.nonconformist", "qualname": "QuantileRegErrFunc.apply", "kind": "function", "doc": "<p>Apply the nonconformity function.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>prediction : numpy array of shape [n_samples, n_classes]\n    Class probability estimates for each sample.</p>\n\n<p>y : numpy array of shape [n_samples]\n    True output labels of each sample.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>nc : numpy array of shape [n_samples]\n    Nonconformity scores of the samples.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">prediction</span>, </span><span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"fullname": "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse", "modulename": "mlsauce.nonconformist", "qualname": "QuantileRegErrFunc.apply_inverse", "kind": "function", "doc": "<p>Apply the inverse of the nonconformity function (i.e.,\ncalculate prediction interval).</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>nc : numpy array of shape [n_calibration_samples]\n    Nonconformity scores obtained for conformal predictor.</p>\n\n<p>significance : float\n    Significance level (0, 1).</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>interval : numpy array of shape [n_samples, 2]\n    Minimum and maximum interval boundaries for each prediction.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">nc</span>, </span><span class=\"param\"><span class=\"n\">significance</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.RegressorAdapter": {"fullname": "mlsauce.nonconformist.RegressorAdapter", "modulename": "mlsauce.nonconformist", "qualname": "RegressorAdapter", "kind": "class", "doc": "<p>Base class for all estimators in scikit-learn.</p>\n\n<p>Inheriting from this class provides default implementations of:</p>\n\n<ul>\n<li>setting and getting parameters used by <code>GridSearchCV</code> and friends;</li>\n<li>textual and HTML representation displayed in terminals and IDEs;</li>\n<li>estimator serialization;</li>\n<li>parameters validation;</li>\n<li>data validation;</li>\n<li>feature names validation.</li>\n</ul>\n\n<p>Read more in the :ref:<code>User Guide &lt;rolling_your_own_estimator&gt;</code>.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>All estimators should specify all the parameters that can be set\nat the class level in their <code>__init__</code> as explicit keyword\narguments (no <code>*args</code> or <code>**kwargs</code>).</p>\n\n<h2 id=\"examples\">Examples</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">numpy</span> <span class=\"k\">as</span> <span class=\"nn\">np</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sklearn.base</span> <span class=\"kn\">import</span> <span class=\"n\">BaseEstimator</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">class</span> <span class=\"nc\">MyEstimator</span><span class=\"p\">(</span><span class=\"n\">BaseEstimator</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"fm\">__init__</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"o\">*</span><span class=\"p\">,</span> <span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">param</span> <span class=\"o\">=</span> <span class=\"n\">param</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"nf\">fit</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"o\">=</span><span class=\"kc\">None</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">is_fitted_</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>\n<span class=\"gp\">... </span>        <span class=\"k\">return</span> <span class=\"bp\">self</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"nf\">predict</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">X</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"k\">return</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">full</span><span class=\"p\">(</span><span class=\"n\">shape</span><span class=\"o\">=</span><span class=\"n\">X</span><span class=\"o\">.</span><span class=\"n\">shape</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">],</span> <span class=\"n\">fill_value</span><span class=\"o\">=</span><span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">param</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span> <span class=\"o\">=</span> <span class=\"n\">MyEstimator</span><span class=\"p\">(</span><span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">get_params</span><span class=\"p\">()</span>\n<span class=\"go\">{&#39;param&#39;: 2}</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">X</span> <span class=\"o\">=</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">array</span><span class=\"p\">([[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"mi\">4</span><span class=\"p\">]])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">y</span> <span class=\"o\">=</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">array</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">1</span><span class=\"p\">])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">fit</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">predict</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">)</span>\n<span class=\"go\">array([2, 2, 2])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">set_params</span><span class=\"p\">(</span><span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">3</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">fit</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">predict</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">)</span>\n<span class=\"go\">array([3, 3, 3])</span>\n</code></pre>\n</div>\n", "bases": "mlsauce.nonconformist.base.BaseModelAdapter"}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"fullname": "mlsauce.nonconformist.RegressorAdapter.__init__", "modulename": "mlsauce.nonconformist", "qualname": "RegressorAdapter.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">model</span>, </span><span class=\"param\"><span class=\"n\">fit_params</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"fullname": "mlsauce.nonconformist.RegressorAdapter.set_fit_request", "modulename": "mlsauce.nonconformist", "qualname": "RegressorAdapter.set_fit_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"fullname": "mlsauce.nonconformist.RegressorAdapter.set_predict_request", "modulename": "mlsauce.nonconformist", "qualname": "RegressorAdapter.set_predict_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.RegressorNc": {"fullname": "mlsauce.nonconformist.RegressorNc", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNc", "kind": "class", "doc": "<p>Nonconformity scorer using an underlying regression model.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>model : RegressorAdapter\n    Underlying regression model used for calculating nonconformity scores.</p>\n\n<p>err_func : RegressionErrFunc\n    Error function object.</p>\n\n<p>normalizer : BaseScorer\n    Normalization model.</p>\n\n<p>beta : float\n    Normalization smoothing parameter. As the beta-value increases,\n    the normalized nonconformity function approaches a non-normalized\n    equivalent.</p>\n\n<h2 id=\"attributes\">Attributes</h2>\n\n<p>model : RegressorAdapter\n    Underlying model object.</p>\n\n<p>err_func : RegressionErrFunc\n    Scorer function used to calculate nonconformity scores.</p>\n\n<h2 id=\"see-also\">See also</h2>\n\n<p>ProbEstClassifierNc, NormalizedRegressorNc</p>\n", "bases": "mlsauce.nonconformist.nc.BaseModelNc"}, "mlsauce.nonconformist.RegressorNc.__init__": {"fullname": "mlsauce.nonconformist.RegressorNc.__init__", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNc.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">model</span>,</span><span class=\"param\">\t<span class=\"n\">err_func</span><span class=\"o\">=&lt;</span><span class=\"n\">mlsauce</span><span class=\"o\">.</span><span class=\"n\">nonconformist</span><span class=\"o\">.</span><span class=\"n\">nc</span><span class=\"o\">.</span><span class=\"n\">AbsErrorErrFunc</span> <span class=\"nb\">object</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">normalizer</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">beta</span><span class=\"o\">=</span><span class=\"mf\">1e-06</span></span>)</span>"}, "mlsauce.nonconformist.RegressorNc.predict": {"fullname": "mlsauce.nonconformist.RegressorNc.predict", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNc.predict", "kind": "function", "doc": "<p>Constructs prediction intervals for a set of test examples.</p>\n\n<p>Predicts the output of each test pattern using the underlying model,\nand applies the (partial) inverse nonconformity function to each\nprediction, resulting in a prediction interval for each test pattern.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>x : numpy array of shape [n_samples, n_features]\n    Inputs of patters for which to predict output values.</p>\n\n<p>significance : float\n    Significance level (maximum allowed error rate) of predictions.\n    Should be a float between 0 and 1. If <code>None</code>, then intervals for\n    all significance levels (0.01, 0.02, ..., 0.99) are output in a\n    3d-matrix.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>p : numpy array of shape [n_samples, 2] or [n_samples, 2, 99]\n    If significance is <code>None</code>, then p contains the interval (minimum\n    and maximum boundaries) for each test pattern, and each significance\n    level (0.01, 0.02, ..., 0.99). If significance is a float between\n    0 and 1, then p contains the prediction intervals (minimum and\n    maximum     boundaries) for the set of test patterns at the chosen\n    significance level.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">nc</span>, </span><span class=\"param\"><span class=\"n\">significance</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"fullname": "mlsauce.nonconformist.RegressorNc.set_fit_request", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNc.set_fit_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"fullname": "mlsauce.nonconformist.RegressorNc.set_predict_request", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNc.set_predict_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"fullname": "mlsauce.nonconformist.RegressorNc.set_score_request", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNc.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.RegressorNormalizer": {"fullname": "mlsauce.nonconformist.RegressorNormalizer", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNormalizer", "kind": "class", "doc": "<p>Base class for all estimators in scikit-learn.</p>\n\n<p>Inheriting from this class provides default implementations of:</p>\n\n<ul>\n<li>setting and getting parameters used by <code>GridSearchCV</code> and friends;</li>\n<li>textual and HTML representation displayed in terminals and IDEs;</li>\n<li>estimator serialization;</li>\n<li>parameters validation;</li>\n<li>data validation;</li>\n<li>feature names validation.</li>\n</ul>\n\n<p>Read more in the :ref:<code>User Guide &lt;rolling_your_own_estimator&gt;</code>.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>All estimators should specify all the parameters that can be set\nat the class level in their <code>__init__</code> as explicit keyword\narguments (no <code>*args</code> or <code>**kwargs</code>).</p>\n\n<h2 id=\"examples\">Examples</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">numpy</span> <span class=\"k\">as</span> <span class=\"nn\">np</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sklearn.base</span> <span class=\"kn\">import</span> <span class=\"n\">BaseEstimator</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">class</span> <span class=\"nc\">MyEstimator</span><span class=\"p\">(</span><span class=\"n\">BaseEstimator</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"fm\">__init__</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"o\">*</span><span class=\"p\">,</span> <span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">1</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">param</span> <span class=\"o\">=</span> <span class=\"n\">param</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"nf\">fit</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"o\">=</span><span class=\"kc\">None</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">is_fitted_</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>\n<span class=\"gp\">... </span>        <span class=\"k\">return</span> <span class=\"bp\">self</span>\n<span class=\"gp\">... </span>    <span class=\"k\">def</span> <span class=\"nf\">predict</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">X</span><span class=\"p\">):</span>\n<span class=\"gp\">... </span>        <span class=\"k\">return</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">full</span><span class=\"p\">(</span><span class=\"n\">shape</span><span class=\"o\">=</span><span class=\"n\">X</span><span class=\"o\">.</span><span class=\"n\">shape</span><span class=\"p\">[</span><span class=\"mi\">0</span><span class=\"p\">],</span> <span class=\"n\">fill_value</span><span class=\"o\">=</span><span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">param</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span> <span class=\"o\">=</span> <span class=\"n\">MyEstimator</span><span class=\"p\">(</span><span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">2</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">get_params</span><span class=\"p\">()</span>\n<span class=\"go\">{&#39;param&#39;: 2}</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">X</span> <span class=\"o\">=</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">array</span><span class=\"p\">([[</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">2</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">2</span><span class=\"p\">,</span> <span class=\"mi\">3</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"mi\">3</span><span class=\"p\">,</span> <span class=\"mi\">4</span><span class=\"p\">]])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">y</span> <span class=\"o\">=</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">array</span><span class=\"p\">([</span><span class=\"mi\">1</span><span class=\"p\">,</span> <span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"mi\">1</span><span class=\"p\">])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">fit</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">predict</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">)</span>\n<span class=\"go\">array([2, 2, 2])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">estimator</span><span class=\"o\">.</span><span class=\"n\">set_params</span><span class=\"p\">(</span><span class=\"n\">param</span><span class=\"o\">=</span><span class=\"mi\">3</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">fit</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">,</span> <span class=\"n\">y</span><span class=\"p\">)</span><span class=\"o\">.</span><span class=\"n\">predict</span><span class=\"p\">(</span><span class=\"n\">X</span><span class=\"p\">)</span>\n<span class=\"go\">array([3, 3, 3])</span>\n</code></pre>\n</div>\n", "bases": "mlsauce.nonconformist.nc.BaseScorer"}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"fullname": "mlsauce.nonconformist.RegressorNormalizer.__init__", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNormalizer.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">base_model</span>, </span><span class=\"param\"><span class=\"n\">normalizer_model</span>, </span><span class=\"param\"><span class=\"n\">err_func</span></span>)</span>"}, "mlsauce.nonconformist.RegressorNormalizer.base_model": {"fullname": "mlsauce.nonconformist.RegressorNormalizer.base_model", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNormalizer.base_model", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"fullname": "mlsauce.nonconformist.RegressorNormalizer.normalizer_model", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNormalizer.normalizer_model", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.nonconformist.RegressorNormalizer.err_func": {"fullname": "mlsauce.nonconformist.RegressorNormalizer.err_func", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNormalizer.err_func", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"fullname": "mlsauce.nonconformist.RegressorNormalizer.fit", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNormalizer.fit", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.RegressorNormalizer.score": {"fullname": "mlsauce.nonconformist.RegressorNormalizer.score", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNormalizer.score", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"fullname": "mlsauce.nonconformist.RegressorNormalizer.set_fit_request", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNormalizer.set_fit_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"fullname": "mlsauce.nonconformist.RegressorNormalizer.set_score_request", "modulename": "mlsauce.nonconformist", "qualname": "RegressorNormalizer.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.IcpRegressor": {"fullname": "mlsauce.nonconformist.IcpRegressor", "modulename": "mlsauce.nonconformist", "qualname": "IcpRegressor", "kind": "class", "doc": "<p>Inductive conformal regressor.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>nc_function : BaseScorer\n        Nonconformity scorer object used to calculate nonconformity of\n        calibration examples and test patterns. Should implement <code>fit(x, y)</code>,\n        <code>calc_nc(x, y)</code> and <code>predict(x, nc_scores, significance)</code>.</p>\n\n<h2 id=\"attributes\">Attributes</h2>\n\n<p>cal_x : numpy array of shape [n_cal_examples, n_features]\n        Inputs of calibration set.</p>\n\n<p>cal_y : numpy array of shape [n_cal_examples]\n        Outputs of calibration set.</p>\n\n<p>nc_function : BaseScorer\n        Nonconformity scorer object used to calculate nonconformity scores.</p>\n\n<h2 id=\"see-also\">See also</h2>\n\n<p>IcpClassifier</p>\n\n<h2 id=\"references\">References</h2>\n\n<h2 id=\"examples\">Examples</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">import</span> <span class=\"nn\">numpy</span> <span class=\"k\">as</span> <span class=\"nn\">np</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sklearn.datasets</span> <span class=\"kn\">import</span> <span class=\"n\">load_boston</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">sklearn.tree</span> <span class=\"kn\">import</span> <span class=\"n\">DecisionTreeRegressor</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">nonconformist.base</span> <span class=\"kn\">import</span> <span class=\"n\">RegressorAdapter</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">nonconformist.icp</span> <span class=\"kn\">import</span> <span class=\"n\">IcpRegressor</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">nonconformist.nc</span> <span class=\"kn\">import</span> <span class=\"n\">RegressorNc</span><span class=\"p\">,</span> <span class=\"n\">AbsErrorErrFunc</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">boston</span> <span class=\"o\">=</span> <span class=\"n\">load_boston</span><span class=\"p\">()</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">idx</span> <span class=\"o\">=</span> <span class=\"n\">np</span><span class=\"o\">.</span><span class=\"n\">random</span><span class=\"o\">.</span><span class=\"n\">permutation</span><span class=\"p\">(</span><span class=\"n\">boston</span><span class=\"o\">.</span><span class=\"n\">target</span><span class=\"o\">.</span><span class=\"n\">size</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">train</span> <span class=\"o\">=</span> <span class=\"n\">idx</span><span class=\"p\">[:</span><span class=\"nb\">int</span><span class=\"p\">(</span><span class=\"n\">idx</span><span class=\"o\">.</span><span class=\"n\">size</span> <span class=\"o\">/</span> <span class=\"mi\">3</span><span class=\"p\">)]</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">cal</span> <span class=\"o\">=</span> <span class=\"n\">idx</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">(</span><span class=\"n\">idx</span><span class=\"o\">.</span><span class=\"n\">size</span> <span class=\"o\">/</span> <span class=\"mi\">3</span><span class=\"p\">):</span><span class=\"nb\">int</span><span class=\"p\">(</span><span class=\"mi\">2</span> <span class=\"o\">*</span> <span class=\"n\">idx</span><span class=\"o\">.</span><span class=\"n\">size</span> <span class=\"o\">/</span> <span class=\"mi\">3</span><span class=\"p\">)]</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">test</span> <span class=\"o\">=</span> <span class=\"n\">idx</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">(</span><span class=\"mi\">2</span> <span class=\"o\">*</span> <span class=\"n\">idx</span><span class=\"o\">.</span><span class=\"n\">size</span> <span class=\"o\">/</span> <span class=\"mi\">3</span><span class=\"p\">):]</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">model</span> <span class=\"o\">=</span> <span class=\"n\">RegressorAdapter</span><span class=\"p\">(</span><span class=\"n\">DecisionTreeRegressor</span><span class=\"p\">())</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">nc</span> <span class=\"o\">=</span> <span class=\"n\">RegressorNc</span><span class=\"p\">(</span><span class=\"n\">model</span><span class=\"p\">,</span> <span class=\"n\">AbsErrorErrFunc</span><span class=\"p\">())</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">icp</span> <span class=\"o\">=</span> <span class=\"n\">IcpRegressor</span><span class=\"p\">(</span><span class=\"n\">nc</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">icp</span><span class=\"o\">.</span><span class=\"n\">fit</span><span class=\"p\">(</span><span class=\"n\">boston</span><span class=\"o\">.</span><span class=\"n\">data</span><span class=\"p\">[</span><span class=\"n\">train</span><span class=\"p\">,</span> <span class=\"p\">:],</span> <span class=\"n\">boston</span><span class=\"o\">.</span><span class=\"n\">target</span><span class=\"p\">[</span><span class=\"n\">train</span><span class=\"p\">])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">icp</span><span class=\"o\">.</span><span class=\"n\">calibrate</span><span class=\"p\">(</span><span class=\"n\">boston</span><span class=\"o\">.</span><span class=\"n\">data</span><span class=\"p\">[</span><span class=\"n\">cal</span><span class=\"p\">,</span> <span class=\"p\">:],</span> <span class=\"n\">boston</span><span class=\"o\">.</span><span class=\"n\">target</span><span class=\"p\">[</span><span class=\"n\">cal</span><span class=\"p\">])</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">icp</span><span class=\"o\">.</span><span class=\"n\">predict</span><span class=\"p\">(</span><span class=\"n\">boston</span><span class=\"o\">.</span><span class=\"n\">data</span><span class=\"p\">[</span><span class=\"n\">test</span><span class=\"p\">,</span> <span class=\"p\">:],</span> <span class=\"n\">significance</span><span class=\"o\">=</span><span class=\"mf\">0.10</span><span class=\"p\">)</span>\n<span class=\"gp\">... </span>    <span class=\"c1\"># doctest: +SKIP</span>\n<span class=\"go\">array([[  5. ,  20.6],</span>\n<span class=\"go\">        [ 15.5,  31.1],</span>\n<span class=\"go\">        ...,</span>\n<span class=\"go\">        [ 14.2,  29.8],</span>\n<span class=\"go\">        [ 11.6,  27.2]])</span>\n</code></pre>\n</div>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n</ol>\n</div>\n", "bases": "mlsauce.nonconformist.icp.BaseIcp, mlsauce.nonconformist.base.RegressorMixin"}, "mlsauce.nonconformist.IcpRegressor.__init__": {"fullname": "mlsauce.nonconformist.IcpRegressor.__init__", "modulename": "mlsauce.nonconformist", "qualname": "IcpRegressor.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">nc_function</span>, </span><span class=\"param\"><span class=\"n\">condition</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "mlsauce.nonconformist.IcpRegressor.predict": {"fullname": "mlsauce.nonconformist.IcpRegressor.predict", "modulename": "mlsauce.nonconformist", "qualname": "IcpRegressor.predict", "kind": "function", "doc": "<p>Predict the output values for a set of input patterns.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>x : numpy array of shape [n_samples, n_features]\n        Inputs of patters for which to predict output values.</p>\n\n<p>significance : float\n        Significance level (maximum allowed error rate) of predictions.\n        Should be a float between 0 and 1. If <code>None</code>, then intervals for\n        all significance levels (0.01, 0.02, ..., 0.99) are output in a\n        3d-matrix.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>p : numpy array of shape [n_samples, 2] or [n_samples, 2, 99}\n        If significance is <code>None</code>, then p contains the interval (minimum\n        and maximum boundaries) for each test pattern, and each significance\n        level (0.01, 0.02, ..., 0.99). If significance is a float between\n        0 and 1, then p contains the prediction intervals (minimum and\n        maximum boundaries) for the set of test patterns at the chosen\n        significance level.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">significance</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"fullname": "mlsauce.nonconformist.IcpRegressor.set_fit_request", "modulename": "mlsauce.nonconformist", "qualname": "IcpRegressor.set_fit_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"fullname": "mlsauce.nonconformist.IcpRegressor.set_predict_request", "modulename": "mlsauce.nonconformist", "qualname": "IcpRegressor.set_predict_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.predictioninterval": {"fullname": "mlsauce.predictioninterval", "modulename": "mlsauce.predictioninterval", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval": {"fullname": "mlsauce.predictioninterval.PredictionInterval", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval", "kind": "class", "doc": "<p>Class PredictionInterval: Obtain prediction intervals.</p>\n\n<p>Attributes:</p>\n\n<pre><code>obj: an object;\n    fitted object containing methods `fit` and `predict`\n\nmethod: a string;\n    method for constructing the prediction intervals.\n    Currently \"splitconformal\" (default) and \"localconformal\"\n\nlevel: a float;\n    Confidence level for prediction intervals. Default is 95,\n    equivalent to a miscoverage error of 5 (%)\n\nreplications: an integer;\n    Number of replications for simulated conformal (default is `None`)\n\ntype_pi: a string;\n    type of prediction interval: currently \"kde\" (default) or \"bootstrap\"\n\nseed: an integer;\n    Reproducibility of fit (there's a random split between fitting and calibration data)\n</code></pre>\n", "bases": "sklearn.base.BaseEstimator, sklearn.base.RegressorMixin"}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"fullname": "mlsauce.predictioninterval.PredictionInterval.__init__", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">obj</span>,</span><span class=\"param\">\t<span class=\"n\">method</span><span class=\"o\">=</span><span class=\"s1\">&#39;splitconformal&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">level</span><span class=\"o\">=</span><span class=\"mi\">95</span>,</span><span class=\"param\">\t<span class=\"n\">type_pi</span><span class=\"o\">=</span><span class=\"s1\">&#39;bootstrap&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">replications</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">kernel</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">agg</span><span class=\"o\">=</span><span class=\"s1\">&#39;mean&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">seed</span><span class=\"o\">=</span><span class=\"mi\">123</span></span>)</span>"}, "mlsauce.predictioninterval.PredictionInterval.obj": {"fullname": "mlsauce.predictioninterval.PredictionInterval.obj", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.obj", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.method": {"fullname": "mlsauce.predictioninterval.PredictionInterval.method", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.method", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.level": {"fullname": "mlsauce.predictioninterval.PredictionInterval.level", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.level", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.type_pi": {"fullname": "mlsauce.predictioninterval.PredictionInterval.type_pi", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.type_pi", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.replications": {"fullname": "mlsauce.predictioninterval.PredictionInterval.replications", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.replications", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.kernel": {"fullname": "mlsauce.predictioninterval.PredictionInterval.kernel", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.kernel", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.agg": {"fullname": "mlsauce.predictioninterval.PredictionInterval.agg", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.agg", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.seed": {"fullname": "mlsauce.predictioninterval.PredictionInterval.seed", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.seed", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.alpha_": {"fullname": "mlsauce.predictioninterval.PredictionInterval.alpha_", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.alpha_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.quantile_": {"fullname": "mlsauce.predictioninterval.PredictionInterval.quantile_", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.quantile_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.icp_": {"fullname": "mlsauce.predictioninterval.PredictionInterval.icp_", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.icp_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"fullname": "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.calibrated_residuals_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"fullname": "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.scaled_calibrated_residuals_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"fullname": "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.calibrated_residuals_scaler_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.kde_": {"fullname": "mlsauce.predictioninterval.PredictionInterval.kde_", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.kde_", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.predictioninterval.PredictionInterval.fit": {"fullname": "mlsauce.predictioninterval.PredictionInterval.fit", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.fit", "kind": "function", "doc": "<p>Fit the <code>method</code> to training data (X, y).</p>\n\n<p>Args:</p>\n\n<pre><code>X: array-like, shape = [n_samples, n_features];\n    Training set vectors, where n_samples is the number\n    of samples and n_features is the number of features.\n\ny: array-like, shape = [n_samples, ]; Target values.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.predictioninterval.PredictionInterval.predict": {"fullname": "mlsauce.predictioninterval.PredictionInterval.predict", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.predict", "kind": "function", "doc": "<p>Obtain predictions and prediction intervals</p>\n\n<p>Args:</p>\n\n<pre><code>X: array-like, shape = [n_samples, n_features];\n    Testing set vectors, where n_samples is the number\n    of samples and n_features is the number of features.\n\nreturn_pi: boolean\n    Whether the prediction interval is returned or not.\n    Default is False, for compatibility with other _estimators_.\n    If True, a tuple containing the predictions + lower and upper\n    bounds is returned.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">return_pi</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"fullname": "mlsauce.predictioninterval.PredictionInterval.set_predict_request", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.set_predict_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"fullname": "mlsauce.predictioninterval.PredictionInterval.set_score_request", "modulename": "mlsauce.predictioninterval", "qualname": "PredictionInterval.set_score_request", "kind": "function", "doc": "<p>A descriptor for request methods.</p>\n\n<p><em>New in version 1.3.</em></p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    The name of the method for which the request function should be\n    created, e.g. <code>\"fit\"</code> would create a <code>set_fit_request</code> function.</p>\n\n<p>keys : list of str\n    A list of strings which are accepted parameters by the created\n    function, e.g. <code>[\"sample_weight\"]</code> if the corresponding method\n    accepts it as a metadata.</p>\n\n<p>validate_keys : bool, default=True\n    Whether to check if the requested parameters fit the actual parameters\n    of the method.</p>\n\n<h2 id=\"notes\">Notes</h2>\n\n<p>This class is a descriptor <sup class=\"footnote-ref\" id=\"fnref-1\"><a href=\"#fn-1\">1</a></sup> and uses PEP-362 to set the signature of\nthe returned function <sup class=\"footnote-ref\" id=\"fnref-2\"><a href=\"#fn-2\">2</a></sup>.</p>\n\n<h2 id=\"references\">References</h2>\n\n<div class=\"footnotes\">\n<hr />\n<ol>\n<li id=\"fn-1\">\n<p><a href=\"https://docs.python.org/3/howto/descriptor.html\">https://docs.python.org/3/howto/descriptor.html</a>&#160;<a href=\"#fnref-1\" class=\"footnoteBackLink\" title=\"Jump back to footnote 1 in the text.\">&#8617;</a></p>\n</li>\n\n<li id=\"fn-2\">\n<p><a href=\"https://www.python.org/dev/peps/pep-0362/\">https://www.python.org/dev/peps/pep-0362/</a>&#160;<a href=\"#fnref-2\" class=\"footnoteBackLink\" title=\"Jump back to footnote 2 in the text.\">&#8617;</a></p>\n</li>\n</ol>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">unknown</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.ridge": {"fullname": "mlsauce.ridge", "modulename": "mlsauce.ridge", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.ridge.RidgeRegressor": {"fullname": "mlsauce.ridge.RidgeRegressor", "modulename": "mlsauce.ridge", "qualname": "RidgeRegressor", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.stump": {"fullname": "mlsauce.stump", "modulename": "mlsauce.stump", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.stump.StumpClassifier": {"fullname": "mlsauce.stump.StumpClassifier", "modulename": "mlsauce.stump", "qualname": "StumpClassifier", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.utils": {"fullname": "mlsauce.utils", "modulename": "mlsauce.utils", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.utils.cluster": {"fullname": "mlsauce.utils.cluster", "modulename": "mlsauce.utils", "qualname": "cluster", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">X</span>,</span><span class=\"param\">\t<span class=\"n\">n_clusters</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">method</span><span class=\"o\">=</span><span class=\"s1\">&#39;kmeans&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">type_scaling</span><span class=\"o\">=</span><span class=\"s1\">&#39;standard&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">training</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">scaler</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">label_encoder</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">clusterer</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">seed</span><span class=\"o\">=</span><span class=\"mi\">123</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.subsample": {"fullname": "mlsauce.utils.subsample", "modulename": "mlsauce.utils", "qualname": "subsample", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">row_sample</span><span class=\"o\">=</span><span class=\"mf\">0.8</span>, </span><span class=\"param\"><span class=\"n\">seed</span><span class=\"o\">=</span><span class=\"mi\">123</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.merge_two_dicts": {"fullname": "mlsauce.utils.merge_two_dicts", "modulename": "mlsauce.utils", "qualname": "merge_two_dicts", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span>, </span><span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.flatten": {"fullname": "mlsauce.utils.flatten", "modulename": "mlsauce.utils", "qualname": "flatten", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">l</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.is_float": {"fullname": "mlsauce.utils.is_float", "modulename": "mlsauce.utils", "qualname": "is_float", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">x</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.is_factor": {"fullname": "mlsauce.utils.is_factor", "modulename": "mlsauce.utils", "qualname": "is_factor", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">y</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.Progbar": {"fullname": "mlsauce.utils.Progbar", "modulename": "mlsauce.utils", "qualname": "Progbar", "kind": "class", "doc": "<p>Displays a progress bar.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<pre><code>target: Total number of steps expected, None if unknown.\nwidth: Progress bar width on screen.\nverbose: Verbosity mode, 0 (silent), 1 (verbose), 2 (semi-verbose)\nstateful_metrics: Iterable of string names of metrics that\n    should *not* be averaged over time. Metrics in this list\n    will be displayed as-is. All others will be averaged\n    by the progbar before display.\ninterval: Minimum visual progress update interval (in seconds).\n</code></pre>\n"}, "mlsauce.utils.Progbar.__init__": {"fullname": "mlsauce.utils.Progbar.__init__", "modulename": "mlsauce.utils", "qualname": "Progbar.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">width</span><span class=\"o\">=</span><span class=\"mi\">30</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">interval</span><span class=\"o\">=</span><span class=\"mf\">0.05</span>, </span><span class=\"param\"><span class=\"n\">stateful_metrics</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "mlsauce.utils.Progbar.target": {"fullname": "mlsauce.utils.Progbar.target", "modulename": "mlsauce.utils", "qualname": "Progbar.target", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.utils.Progbar.width": {"fullname": "mlsauce.utils.Progbar.width", "modulename": "mlsauce.utils", "qualname": "Progbar.width", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.utils.Progbar.verbose": {"fullname": "mlsauce.utils.Progbar.verbose", "modulename": "mlsauce.utils", "qualname": "Progbar.verbose", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.utils.Progbar.interval": {"fullname": "mlsauce.utils.Progbar.interval", "modulename": "mlsauce.utils", "qualname": "Progbar.interval", "kind": "variable", "doc": "<p></p>\n"}, "mlsauce.utils.Progbar.update": {"fullname": "mlsauce.utils.Progbar.update", "modulename": "mlsauce.utils", "qualname": "Progbar.update", "kind": "function", "doc": "<p>Updates the progress bar.</p>\n\n<h1 id=\"arguments\">Arguments</h1>\n\n<pre><code>current: Index of current step.\nvalues: List of tuples:\n    `(name, value_for_last_step)`.\n    If `name` is in `stateful_metrics`,\n    `value_for_last_step` will be displayed as-is.\n    Else, an average of the metric over time will be displayed.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">current</span>, </span><span class=\"param\"><span class=\"n\">values</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.Progbar.add": {"fullname": "mlsauce.utils.Progbar.add", "modulename": "mlsauce.utils", "qualname": "Progbar.add", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">n</span>, </span><span class=\"param\"><span class=\"n\">values</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.get_beta": {"fullname": "mlsauce.utils.get_beta", "modulename": "mlsauce.utils.get_beta", "kind": "module", "doc": "<p></p>\n"}, "mlsauce.utils.check_and_install": {"fullname": "mlsauce.utils.check_and_install", "modulename": "mlsauce.utils", "qualname": "check_and_install", "kind": "function", "doc": "<p>Check if a package is installed; if not, install it.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">package_name</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.is_multitask_estimator": {"fullname": "mlsauce.utils.is_multitask_estimator", "modulename": "mlsauce.utils", "qualname": "is_multitask_estimator", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">estimator</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.get_histo_features": {"fullname": "mlsauce.utils.get_histo_features", "modulename": "mlsauce.utils", "qualname": "get_histo_features", "kind": "function", "doc": "<p>Computes histogram features for the input data.</p>\n\n<p>Args:\nX {np.array or pd.DataFrame}: Input data.</p>\n\n<p>Returns:\nX_hist {np.array or pd.DataFrame}: Input data with histogram features.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">bin_value_dict</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.safe_sparse_dot": {"fullname": "mlsauce.utils.safe_sparse_dot", "modulename": "mlsauce.utils", "qualname": "safe_sparse_dot", "kind": "function", "doc": "<p>Dot product that handle the sparse matrix case correctly</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>a : array or sparse matrix\nb : array or sparse matrix\ndense_output : boolean, (default=False)\n    When False, <code>a</code> and <code>b</code> both being sparse will yield sparse output.\n    When True, output will always be a dense array.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>dot_product : array or sparse matrix\n    sparse if <code>a</code> and <code>b</code> are sparse and <code>dense_output=False</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">a</span>, </span><span class=\"param\"><span class=\"n\">b</span>, </span><span class=\"param\"><span class=\"n\">backend</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span>, </span><span class=\"param\"><span class=\"n\">dense_output</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.mean_errors": {"fullname": "mlsauce.utils.mean_errors", "modulename": "mlsauce.utils", "qualname": "mean_errors", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">pred</span>, </span><span class=\"param\"><span class=\"n\">actual</span>, </span><span class=\"param\"><span class=\"n\">scoring</span><span class=\"o\">=</span><span class=\"s1\">&#39;root_mean_squared_error&#39;</span>, </span><span class=\"param\"><span class=\"n\">per_series</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.winkler_score": {"fullname": "mlsauce.utils.winkler_score", "modulename": "mlsauce.utils", "qualname": "winkler_score", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">obj</span>, </span><span class=\"param\"><span class=\"n\">actual</span>, </span><span class=\"param\"><span class=\"n\">level</span><span class=\"o\">=</span><span class=\"mi\">95</span>, </span><span class=\"param\"><span class=\"n\">per_series</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.coverage": {"fullname": "mlsauce.utils.coverage", "modulename": "mlsauce.utils", "qualname": "coverage", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">obj</span>, </span><span class=\"param\"><span class=\"n\">actual</span>, </span><span class=\"param\"><span class=\"n\">level</span><span class=\"o\">=</span><span class=\"mi\">95</span>, </span><span class=\"param\"><span class=\"n\">per_series</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.convert_df_to_numeric": {"fullname": "mlsauce.utils.convert_df_to_numeric", "modulename": "mlsauce.utils", "qualname": "convert_df_to_numeric", "kind": "function", "doc": "<p>Convert all columns of DataFrame to numeric type using astype with loop.</p>\n\n<p>Parameters:\n    df (pd.DataFrame): Input DataFrame with mixed data types.</p>\n\n<p>Returns:\n    pd.DataFrame: DataFrame with all columns converted to numeric type.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">df</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.dict_to_dataframe_series": {"fullname": "mlsauce.utils.dict_to_dataframe_series", "modulename": "mlsauce.utils", "qualname": "dict_to_dataframe_series", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"n\">series_names</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.get_beta.get_beta": {"fullname": "mlsauce.utils.get_beta.get_beta", "modulename": "mlsauce.utils.get_beta", "qualname": "get_beta", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">backend</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.get_beta.get_beta_ridge": {"fullname": "mlsauce.utils.get_beta.get_beta_ridge", "modulename": "mlsauce.utils.get_beta", "qualname": "get_beta_ridge", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">lam</span>, </span><span class=\"param\"><span class=\"n\">backend</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "mlsauce.utils.get_beta.get_best_beta": {"fullname": "mlsauce.utils.get_beta.get_best_beta", "modulename": "mlsauce.utils.get_beta", "qualname": "get_best_beta", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">X</span>, </span><span class=\"param\"><span class=\"n\">y</span>, </span><span class=\"param\"><span class=\"n\">lambdas</span>, </span><span class=\"param\"><span class=\"n\">backend</span><span class=\"o\">=</span><span class=\"s1\">&#39;cpu&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}}, "docInfo": {"mlsauce": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.AdaOpt": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.LSBoostClassifier": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.GenericBoostingClassifier": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.GenericBoostingRegressor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.StumpClassifier": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.ElasticNetRegressor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 44}, "mlsauce.ElasticNetRegressor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 3}, "mlsauce.ElasticNetRegressor.reg_lambda": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.ElasticNetRegressor.alpha": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.ElasticNetRegressor.backend": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.ElasticNetRegressor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 28, "bases": 0, "doc": 74}, "mlsauce.ElasticNetRegressor.predict": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 62}, "mlsauce.ElasticNetRegressor.set_score_request": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.KRLSRegressor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 675}, "mlsauce.KRLSRegressor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 3}, "mlsauce.KRLSRegressor.backend": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.KRLSRegressor.kernel": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.KRLSRegressor.regularization": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.KRLSRegressor.ym_": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.KRLSRegressor.scaler_": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.KRLSRegressor.X_": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.KRLSRegressor.coef_": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.KRLSRegressor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 3}, "mlsauce.KRLSRegressor.predict": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "mlsauce.KRLSRegressor.set_score_request": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.LassoRegressor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.LSBoostRegressor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.RidgeRegressor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.LazyBoostingClassifier": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.LazyBoostingMTS": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.LazyBoostingRegressor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.MultiTaskRegressor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 32}, "mlsauce.MultiTaskRegressor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 3}, "mlsauce.MultiTaskRegressor.regr": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.MultiTaskRegressor.objs": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.MultiTaskRegressor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "mlsauce.MultiTaskRegressor.predict": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 30}, "mlsauce.MultiTaskRegressor.set_score_request": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.IsotonicRegressor": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 95}, "mlsauce.IsotonicRegressor.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 63}, "mlsauce.IsotonicRegressor.regr": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.IsotonicRegressor.increasing": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.IsotonicRegressor.out_of_bounds": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.IsotonicRegressor.fit": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 28, "bases": 0, "doc": 65}, "mlsauce.IsotonicRegressor.predict": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 48}, "mlsauce.IsotonicRegressor.set_score_request": {"qualname": 4, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.GenericFunctionalForecaster": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.download": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 3}, "mlsauce.get_config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.set_config": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.config_context": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.adaopt": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.adaopt.AdaOpt": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.booster": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.booster.LSBoostClassifier": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.booster.LSBoostRegressor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.booster.GenericBoostingClassifier": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.booster.GenericBoostingRegressor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.datasets": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.datasets.dowload": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.datasets.dowload.download": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 3}, "mlsauce.demo": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.elasticnet": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.elasticnet.ElasticNetRegressor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 44}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 3}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.elasticnet.ElasticNetRegressor.alpha": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.elasticnet.ElasticNetRegressor.backend": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 28, "bases": 0, "doc": 74}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 62}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.fpca": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.fpca.GenericFunctionalForecaster": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.isotonicregressor": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.isotonicregressor.IsotonicRegressor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 95}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 63}, "mlsauce.isotonicregressor.IsotonicRegressor.regr": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.isotonicregressor.IsotonicRegressor.increasing": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 28, "bases": 0, "doc": 65}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 48}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.kernelridge": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 675}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor.backend": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor.kernel": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor.regularization": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor.X_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor.predict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.lasso": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.lasso.LassoRegressor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.lazybooster": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.lazybooster.LazyBoostingClassifier": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.lazybooster.LazyBoostingRegressor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.lazybooster.LazyBoostingMTS": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.multitaskregressor": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 32}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 3}, "mlsauce.multitaskregressor.MultiTaskRegressor.regr": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.multitaskregressor.MultiTaskRegressor.objs": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 22}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 30}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.nonconformist": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.nonconformist.AbsErrorErrFunc": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 65}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 69}, "mlsauce.nonconformist.QuantileRegErrFunc": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 30}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 65}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 69}, "mlsauce.nonconformist.RegressorAdapter": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 675}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 3}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.nonconformist.RegressorNc": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 102}, "mlsauce.nonconformist.RegressorNc.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 68, "bases": 0, "doc": 3}, "mlsauce.nonconformist.RegressorNc.predict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 193}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.nonconformist.RegressorNormalizer": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 675}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "mlsauce.nonconformist.RegressorNormalizer.base_model": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.nonconformist.RegressorNormalizer.err_func": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 3}, "mlsauce.nonconformist.RegressorNormalizer.score": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 3}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.nonconformist.IcpRegressor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 8, "doc": 748}, "mlsauce.nonconformist.IcpRegressor.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 3}, "mlsauce.nonconformist.IcpRegressor.predict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 161}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.predictioninterval": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 6, "doc": 100}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 100, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.obj": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.method": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.level": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.type_pi": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.replications": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.kernel": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.agg": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.seed": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.alpha_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.quantile_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.icp_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.kde_": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.predictioninterval.PredictionInterval.fit": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 57}, "mlsauce.predictioninterval.PredictionInterval.predict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 75}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 198}, "mlsauce.ridge": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.ridge.RidgeRegressor": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.stump": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.stump.StumpClassifier": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.utils": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.utils.cluster": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 111, "bases": 0, "doc": 3}, "mlsauce.utils.subsample": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 3}, "mlsauce.utils.merge_two_dicts": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "mlsauce.utils.flatten": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "mlsauce.utils.is_float": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "mlsauce.utils.is_factor": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "mlsauce.utils.Progbar": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 82}, "mlsauce.utils.Progbar.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 51, "bases": 0, "doc": 3}, "mlsauce.utils.Progbar.target": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.utils.Progbar.width": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.utils.Progbar.verbose": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.utils.Progbar.interval": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.utils.Progbar.update": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 57}, "mlsauce.utils.Progbar.add": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 3}, "mlsauce.utils.get_beta": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "mlsauce.utils.check_and_install": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 12, "bases": 0, "doc": 13}, "mlsauce.utils.is_multitask_estimator": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "mlsauce.utils.get_histo_features": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 38}, "mlsauce.utils.safe_sparse_dot": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 90}, "mlsauce.utils.mean_errors": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 3}, "mlsauce.utils.winkler_score": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 37, "bases": 0, "doc": 3}, "mlsauce.utils.coverage": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 37, "bases": 0, "doc": 3}, "mlsauce.utils.convert_df_to_numeric": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 43}, "mlsauce.utils.dict_to_dataframe_series": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 3}, "mlsauce.utils.get_beta.get_beta": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 3}, "mlsauce.utils.get_beta.get_beta_ridge": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 3}, "mlsauce.utils.get_beta.get_best_beta": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 3}}, "length": 195, "save": true}, "index": {"qualname": {"root": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.KRLSRegressor.X_": {"tf": 1}, "mlsauce.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.X_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.alpha_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.quantile_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.icp_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.kde_": {"tf": 1}, "mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 29, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.AdaOpt": {"tf": 1}, "mlsauce.adaopt.AdaOpt": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {"mlsauce.utils.Progbar.add": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.alpha_": {"tf": 1}}, "df": 3}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}}, "df": 4}}}}, "g": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.predictioninterval.PredictionInterval.agg": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.LSBoostClassifier": {"tf": 1}, "mlsauce.booster.LSBoostClassifier": {"tf": 1}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.LSBoostRegressor": {"tf": 1}, "mlsauce.booster.LSBoostRegressor": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.LassoRegressor": {"tf": 1}, "mlsauce.lasso.LassoRegressor": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "z": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.LazyBoostingClassifier": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingClassifier": {"tf": 1}}, "df": 2}}}}}}}}}}, "m": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.LazyBoostingMTS": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingMTS": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.LazyBoostingRegressor": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingRegressor": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.predictioninterval.PredictionInterval.level": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.GenericBoostingClassifier": {"tf": 1}, "mlsauce.booster.GenericBoostingClassifier": {"tf": 1}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.GenericBoostingRegressor": {"tf": 1}, "mlsauce.booster.GenericBoostingRegressor": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.GenericFunctionalForecaster": {"tf": 1}, "mlsauce.fpca.GenericFunctionalForecaster": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}}}}}, "t": {"docs": {"mlsauce.get_config": {"tf": 1}, "mlsauce.utils.get_beta": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1}, "mlsauce.utils.get_beta.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 6}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.StumpClassifier": {"tf": 1}, "mlsauce.stump.StumpClassifier": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.set_config": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 20}, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval.seed": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}}, "df": 13}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1}}, "df": 3}, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.subsample": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}}, "df": 16}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.err_func": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.is_multitask_estimator": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 14}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.IsotonicRegressor.increasing": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.increasing": {"tf": 1}}, "df": 2}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.Progbar.interval": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"mlsauce.utils.is_float": {"tf": 1}, "mlsauce.utils.is_factor": {"tf": 1}, "mlsauce.utils.is_multitask_estimator": {"tf": 1}}, "df": 3, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.regr": {"tf": 1}, "mlsauce.IsotonicRegressor.increasing": {"tf": 1}, "mlsauce.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.regr": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.increasing": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}}, "df": 16}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.predictioninterval.PredictionInterval.icp_": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}}, "df": 5}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"tf": 1}}, "df": 2, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor.regularization": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.regularization": {"tf": 1}}, "df": 2}}}}}}}}}}}, "r": {"docs": {"mlsauce.MultiTaskRegressor.regr": {"tf": 1}, "mlsauce.IsotonicRegressor.regr": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.regr": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.regr": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}}, "df": 4}}}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}}, "df": 6}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.base_model": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.err_func": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}}, "df": 9}}}}}}}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.predictioninterval.PredictionInterval.replications": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1}}, "df": 3}}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.RidgeRegressor": {"tf": 1}, "mlsauce.ridge.RidgeRegressor": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.KRLSRegressor.backend": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.backend": {"tf": 1}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.base_model": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.utils.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 4}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.KRLSRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}}, "df": 14}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.err_func": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.utils.flatten": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.is_float": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.is_factor": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor.predict": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}}, "df": 15, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.obj": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.method": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.level": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.type_pi": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.replications": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.kernel": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.agg": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.seed": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.alpha_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.quantile_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.icp_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.kde_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 21}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.__init__": {"tf": 1}, "mlsauce.utils.Progbar.target": {"tf": 1}, "mlsauce.utils.Progbar.width": {"tf": 1}, "mlsauce.utils.Progbar.verbose": {"tf": 1}, "mlsauce.utils.Progbar.interval": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}, "mlsauce.utils.Progbar.add": {"tf": 1}}, "df": 8}}}}}}, "i": {"docs": {"mlsauce.predictioninterval.PredictionInterval.type_pi": {"tf": 1}}, "df": 1}}, "k": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.backend": {"tf": 1}, "mlsauce.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.KRLSRegressor.regularization": {"tf": 1}, "mlsauce.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.KRLSRegressor.X_": {"tf": 1}, "mlsauce.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.KRLSRegressor.fit": {"tf": 1}, "mlsauce.KRLSRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.backend": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.regularization": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.X_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}}, "df": 24}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.kernel": {"tf": 1}}, "df": 3}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval.kde_": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "m": {"docs": {"mlsauce.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"tf": 1}}, "df": 2}}, "x": {"docs": {"mlsauce.KRLSRegressor.X_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.X_": {"tf": 1}}, "df": 2}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {"mlsauce.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"tf": 1}}, "df": 2}}, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.get_config": {"tf": 1}, "mlsauce.set_config": {"tf": 1}, "mlsauce.config_context": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.config_context": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.coverage": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1}}, "df": 3}}}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {"mlsauce.utils.is_multitask_estimator": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.MultiTaskRegressor.regr": {"tf": 1}, "mlsauce.MultiTaskRegressor.objs": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.regr": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.objs": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}}, "df": 14}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.base_model": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval.method": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.merge_two_dicts": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {"mlsauce.predictioninterval.PredictionInterval.obj": {"tf": 1}}, "df": 1, "s": {"docs": {"mlsauce.MultiTaskRegressor.objs": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.objs": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"tf": 1}}, "df": 2}}, "f": {"docs": {"mlsauce.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"tf": 1}}, "df": 2}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}}}}}}, "t": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 1, "s": {"docs": {"mlsauce.utils.merge_two_dicts": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 1}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval.quantile_": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval.type_pi": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"mlsauce.utils.merge_two_dicts": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.Progbar.target": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}, "mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 2}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mlsauce.utils.Progbar.width": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.winkler_score": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar.verbose": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 1}}}}}}}, "fullname": {"root": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.KRLSRegressor.X_": {"tf": 1}, "mlsauce.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.X_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.alpha_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.quantile_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.icp_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.kde_": {"tf": 1}, "mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 29, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce": {"tf": 1}, "mlsauce.AdaOpt": {"tf": 1}, "mlsauce.LSBoostClassifier": {"tf": 1}, "mlsauce.GenericBoostingClassifier": {"tf": 1}, "mlsauce.GenericBoostingRegressor": {"tf": 1}, "mlsauce.StumpClassifier": {"tf": 1}, "mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.backend": {"tf": 1}, "mlsauce.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.KRLSRegressor.regularization": {"tf": 1}, "mlsauce.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.KRLSRegressor.X_": {"tf": 1}, "mlsauce.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.KRLSRegressor.fit": {"tf": 1}, "mlsauce.KRLSRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.LassoRegressor": {"tf": 1}, "mlsauce.LSBoostRegressor": {"tf": 1}, "mlsauce.RidgeRegressor": {"tf": 1}, "mlsauce.LazyBoostingClassifier": {"tf": 1}, "mlsauce.LazyBoostingMTS": {"tf": 1}, "mlsauce.LazyBoostingRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.MultiTaskRegressor.regr": {"tf": 1}, "mlsauce.MultiTaskRegressor.objs": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.regr": {"tf": 1}, "mlsauce.IsotonicRegressor.increasing": {"tf": 1}, "mlsauce.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.GenericFunctionalForecaster": {"tf": 1}, "mlsauce.download": {"tf": 1}, "mlsauce.get_config": {"tf": 1}, "mlsauce.set_config": {"tf": 1}, "mlsauce.config_context": {"tf": 1}, "mlsauce.adaopt": {"tf": 1}, "mlsauce.adaopt.AdaOpt": {"tf": 1}, "mlsauce.booster": {"tf": 1}, "mlsauce.booster.LSBoostClassifier": {"tf": 1}, "mlsauce.booster.LSBoostRegressor": {"tf": 1}, "mlsauce.booster.GenericBoostingClassifier": {"tf": 1}, "mlsauce.booster.GenericBoostingRegressor": {"tf": 1}, "mlsauce.datasets": {"tf": 1}, "mlsauce.datasets.dowload": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}, "mlsauce.demo": {"tf": 1}, "mlsauce.elasticnet": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.fpca": {"tf": 1}, "mlsauce.fpca.GenericFunctionalForecaster": {"tf": 1}, "mlsauce.isotonicregressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.regr": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.increasing": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.backend": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.regularization": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.X_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.lasso": {"tf": 1}, "mlsauce.lasso.LassoRegressor": {"tf": 1}, "mlsauce.lazybooster": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingClassifier": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingRegressor": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingMTS": {"tf": 1}, "mlsauce.multitaskregressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.regr": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.objs": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.base_model": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.err_func": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.obj": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.method": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.level": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.type_pi": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.replications": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.kernel": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.agg": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.seed": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.alpha_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.quantile_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.icp_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.kde_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.ridge": {"tf": 1}, "mlsauce.ridge.RidgeRegressor": {"tf": 1}, "mlsauce.stump": {"tf": 1}, "mlsauce.stump.StumpClassifier": {"tf": 1}, "mlsauce.utils": {"tf": 1}, "mlsauce.utils.cluster": {"tf": 1}, "mlsauce.utils.subsample": {"tf": 1}, "mlsauce.utils.merge_two_dicts": {"tf": 1}, "mlsauce.utils.flatten": {"tf": 1}, "mlsauce.utils.is_float": {"tf": 1}, "mlsauce.utils.is_factor": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.__init__": {"tf": 1}, "mlsauce.utils.Progbar.target": {"tf": 1}, "mlsauce.utils.Progbar.width": {"tf": 1}, "mlsauce.utils.Progbar.verbose": {"tf": 1}, "mlsauce.utils.Progbar.interval": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}, "mlsauce.utils.Progbar.add": {"tf": 1}, "mlsauce.utils.get_beta": {"tf": 1}, "mlsauce.utils.check_and_install": {"tf": 1}, "mlsauce.utils.is_multitask_estimator": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}, "mlsauce.utils.mean_errors": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}, "mlsauce.utils.coverage": {"tf": 1}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1}, "mlsauce.utils.dict_to_dataframe_series": {"tf": 1}, "mlsauce.utils.get_beta.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 195}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {"mlsauce.utils.is_multitask_estimator": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.MultiTaskRegressor.regr": {"tf": 1}, "mlsauce.MultiTaskRegressor.objs": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.regr": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.objs": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}}, "df": 15}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.base_model": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval.method": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.merge_two_dicts": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.AdaOpt": {"tf": 1}, "mlsauce.adaopt": {"tf": 1}, "mlsauce.adaopt.AdaOpt": {"tf": 1.4142135623730951}}, "df": 3}}}}, "d": {"docs": {"mlsauce.utils.Progbar.add": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.alpha_": {"tf": 1}}, "df": 3}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}}, "df": 4}}}}, "g": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.predictioninterval.PredictionInterval.agg": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.LSBoostClassifier": {"tf": 1}, "mlsauce.booster.LSBoostClassifier": {"tf": 1}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.LSBoostRegressor": {"tf": 1}, "mlsauce.booster.LSBoostRegressor": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {"mlsauce.lasso": {"tf": 1}, "mlsauce.lasso.LassoRegressor": {"tf": 1}}, "df": 2, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.LassoRegressor": {"tf": 1}, "mlsauce.lasso.LassoRegressor": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "z": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.LazyBoostingClassifier": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingClassifier": {"tf": 1}}, "df": 2}}}}}}}}}}, "m": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.LazyBoostingMTS": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingMTS": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.LazyBoostingRegressor": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingRegressor": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.lazybooster": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingClassifier": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingRegressor": {"tf": 1}, "mlsauce.lazybooster.LazyBoostingMTS": {"tf": 1}}, "df": 4}}}}}}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.predictioninterval.PredictionInterval.level": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.GenericBoostingClassifier": {"tf": 1}, "mlsauce.booster.GenericBoostingClassifier": {"tf": 1}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.GenericBoostingRegressor": {"tf": 1}, "mlsauce.booster.GenericBoostingRegressor": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.GenericFunctionalForecaster": {"tf": 1}, "mlsauce.fpca.GenericFunctionalForecaster": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}}}}}, "t": {"docs": {"mlsauce.get_config": {"tf": 1}, "mlsauce.utils.get_beta": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1}, "mlsauce.utils.get_beta.get_beta": {"tf": 1.4142135623730951}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1.4142135623730951}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1.4142135623730951}}, "df": 6}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.stump": {"tf": 1}, "mlsauce.stump.StumpClassifier": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.StumpClassifier": {"tf": 1}, "mlsauce.stump.StumpClassifier": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.set_config": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 20}, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval.seed": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}}, "df": 13}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1}}, "df": 3}, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.subsample": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.elasticnet": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}}, "df": 9, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.alpha": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}}, "df": 16}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.err_func": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.is_multitask_estimator": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 14}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.IsotonicRegressor.increasing": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.increasing": {"tf": 1}}, "df": 2}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.Progbar.interval": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"mlsauce.utils.is_float": {"tf": 1}, "mlsauce.utils.is_factor": {"tf": 1}, "mlsauce.utils.is_multitask_estimator": {"tf": 1}}, "df": 3, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.regr": {"tf": 1}, "mlsauce.IsotonicRegressor.increasing": {"tf": 1}, "mlsauce.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.regr": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.increasing": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}}, "df": 17}}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.predictioninterval.PredictionInterval.icp_": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}}, "df": 5}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.ElasticNetRegressor.reg_lambda": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"tf": 1}}, "df": 2, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor.regularization": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.regularization": {"tf": 1}}, "df": 2}}}}}}}}}}}, "r": {"docs": {"mlsauce.MultiTaskRegressor.regr": {"tf": 1}, "mlsauce.IsotonicRegressor.regr": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.regr": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.regr": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}}, "df": 4}}}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}}, "df": 6}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.base_model": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.err_func": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}}, "df": 9}}}}}}}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.predictioninterval.PredictionInterval.replications": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1}}, "df": 3}}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ridge": {"tf": 1}, "mlsauce.ridge.RidgeRegressor": {"tf": 1}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}}, "df": 3, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.RidgeRegressor": {"tf": 1}, "mlsauce.ridge.RidgeRegressor": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.KRLSRegressor.backend": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.backend": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.backend": {"tf": 1}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.base_model": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.booster": {"tf": 1}, "mlsauce.booster.LSBoostClassifier": {"tf": 1}, "mlsauce.booster.LSBoostRegressor": {"tf": 1}, "mlsauce.booster.GenericBoostingClassifier": {"tf": 1}, "mlsauce.booster.GenericBoostingRegressor": {"tf": 1}}, "df": 5}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.utils.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta": {"tf": 1.4142135623730951}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1.4142135623730951}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1.4142135623730951}}, "df": 4}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.KRLSRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}}, "df": 14}}, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.fpca": {"tf": 1}, "mlsauce.fpca.GenericFunctionalForecaster": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.err_func": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.utils.flatten": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.is_float": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.is_factor": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor.predict": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}}, "df": 15, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.predictioninterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.obj": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.method": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.level": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.type_pi": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.replications": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.kernel": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.agg": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.seed": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.alpha_": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.quantile_": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.icp_": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.kde_": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 22}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.__init__": {"tf": 1}, "mlsauce.utils.Progbar.target": {"tf": 1}, "mlsauce.utils.Progbar.width": {"tf": 1}, "mlsauce.utils.Progbar.verbose": {"tf": 1}, "mlsauce.utils.Progbar.interval": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}, "mlsauce.utils.Progbar.add": {"tf": 1}}, "df": 8}}}}}}, "i": {"docs": {"mlsauce.predictioninterval.PredictionInterval.type_pi": {"tf": 1}}, "df": 1}}, "k": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.backend": {"tf": 1}, "mlsauce.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.KRLSRegressor.regularization": {"tf": 1}, "mlsauce.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.KRLSRegressor.X_": {"tf": 1}, "mlsauce.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.KRLSRegressor.fit": {"tf": 1}, "mlsauce.KRLSRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.backend": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.regularization": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.X_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}}, "df": 24}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.kernel": {"tf": 1}}, "df": 3, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.kernelridge": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.backend": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.kernel": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.regularization": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.X_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}}, "df": 13}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval.kde_": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "m": {"docs": {"mlsauce.KRLSRegressor.ym_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"tf": 1}}, "df": 2}}, "x": {"docs": {"mlsauce.KRLSRegressor.X_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.X_": {"tf": 1}}, "df": 2}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {"mlsauce.KRLSRegressor.coef_": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"tf": 1}}, "df": 2}}, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.get_config": {"tf": 1}, "mlsauce.set_config": {"tf": 1}, "mlsauce.config_context": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.config_context": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.coverage": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1}}, "df": 3}}}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {"mlsauce.predictioninterval.PredictionInterval.obj": {"tf": 1}}, "df": 1, "s": {"docs": {"mlsauce.MultiTaskRegressor.objs": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.objs": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"tf": 1}}, "df": 2}}, "f": {"docs": {"mlsauce.IsotonicRegressor.out_of_bounds": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"tf": 1}}, "df": 2}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.datasets.dowload": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.datasets": {"tf": 1}, "mlsauce.datasets.dowload": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 3}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {"mlsauce.demo": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 1, "s": {"docs": {"mlsauce.utils.merge_two_dicts": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.base_model": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.err_func": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}}, "df": 31}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval.quantile_": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval.type_pi": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"mlsauce.utils.merge_two_dicts": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.Progbar.target": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}, "mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 2}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils": {"tf": 1}, "mlsauce.utils.cluster": {"tf": 1}, "mlsauce.utils.subsample": {"tf": 1}, "mlsauce.utils.merge_two_dicts": {"tf": 1}, "mlsauce.utils.flatten": {"tf": 1}, "mlsauce.utils.is_float": {"tf": 1}, "mlsauce.utils.is_factor": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.__init__": {"tf": 1}, "mlsauce.utils.Progbar.target": {"tf": 1}, "mlsauce.utils.Progbar.width": {"tf": 1}, "mlsauce.utils.Progbar.verbose": {"tf": 1}, "mlsauce.utils.Progbar.interval": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}, "mlsauce.utils.Progbar.add": {"tf": 1}, "mlsauce.utils.get_beta": {"tf": 1}, "mlsauce.utils.check_and_install": {"tf": 1}, "mlsauce.utils.is_multitask_estimator": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}, "mlsauce.utils.mean_errors": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}, "mlsauce.utils.coverage": {"tf": 1}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1}, "mlsauce.utils.dict_to_dataframe_series": {"tf": 1}, "mlsauce.utils.get_beta.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 28}}}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mlsauce.utils.Progbar.width": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.winkler_score": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar.verbose": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 1}}}}}}}, "annotation": {"root": {"docs": {}, "df": 0}}, "default_value": {"root": {"docs": {}, "df": 0}}, "signature": {"root": {"0": {"5": {"docs": {"mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 1}, "6": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}}, "df": 1}, "docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.utils.subsample": {"tf": 1}, "mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 6}, "1": {"2": {"3": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.utils.cluster": {"tf": 1}, "mlsauce.utils.subsample": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 5, "e": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}}, "df": 1}}, "3": {"0": {"docs": {"mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 1}, "9": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.download": {"tf": 2.449489742783178}, "mlsauce.datasets.dowload.download": {"tf": 2.449489742783178}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 2.449489742783178}, "mlsauce.utils.cluster": {"tf": 2}, "mlsauce.utils.get_beta": {"tf": 1.4142135623730951}, "mlsauce.utils.safe_sparse_dot": {"tf": 1.4142135623730951}, "mlsauce.utils.mean_errors": {"tf": 1.4142135623730951}, "mlsauce.utils.get_beta.get_beta": {"tf": 1.4142135623730951}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1.4142135623730951}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1.4142135623730951}}, "df": 16}, "docs": {}, "df": 0}, "5": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}}, "df": 2}, "8": {"docs": {"mlsauce.utils.subsample": {"tf": 1}}, "df": 1}, "9": {"5": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}, "mlsauce.utils.coverage": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 5.477225575051661}, "mlsauce.ElasticNetRegressor.fit": {"tf": 4.898979485566356}, "mlsauce.ElasticNetRegressor.predict": {"tf": 4.47213595499958}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.KRLSRegressor.__init__": {"tf": 5.477225575051661}, "mlsauce.KRLSRegressor.fit": {"tf": 4.242640687119285}, "mlsauce.KRLSRegressor.predict": {"tf": 3.7416573867739413}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.MultiTaskRegressor.__init__": {"tf": 2.8284271247461903}, "mlsauce.MultiTaskRegressor.fit": {"tf": 4.242640687119285}, "mlsauce.MultiTaskRegressor.predict": {"tf": 3.7416573867739413}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.IsotonicRegressor.__init__": {"tf": 5.0990195135927845}, "mlsauce.IsotonicRegressor.fit": {"tf": 4.898979485566356}, "mlsauce.IsotonicRegressor.predict": {"tf": 4.47213595499958}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.download": {"tf": 6.782329983125268}, "mlsauce.datasets.dowload.download": {"tf": 6.782329983125268}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 5.477225575051661}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 4.898979485566356}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 4.47213595499958}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 5.0990195135927845}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 4.898979485566356}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 4.47213595499958}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 5.477225575051661}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 4.242640687119285}, "mlsauce.kernelridge.KRLSRegressor.predict": {"tf": 3.7416573867739413}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"tf": 2.8284271247461903}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 4.242640687119285}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 3.7416573867739413}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 4.242640687119285}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 4.242640687119285}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 4.242640687119285}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 4.242640687119285}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 4}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 7.280109889280518}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 5.0990195135927845}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 4}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 4.242640687119285}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 4.69041575982343}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 4}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 4.69041575982343}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 3.1622776601683795}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 8.831760866327848}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 4.242640687119285}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 4.69041575982343}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 3.1622776601683795}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.utils.cluster": {"tf": 9.327379053088816}, "mlsauce.utils.subsample": {"tf": 5.0990195135927845}, "mlsauce.utils.merge_two_dicts": {"tf": 3.7416573867739413}, "mlsauce.utils.flatten": {"tf": 3.1622776601683795}, "mlsauce.utils.is_float": {"tf": 3.1622776601683795}, "mlsauce.utils.is_factor": {"tf": 3.1622776601683795}, "mlsauce.utils.Progbar.__init__": {"tf": 6.324555320336759}, "mlsauce.utils.Progbar.update": {"tf": 4.69041575982343}, "mlsauce.utils.Progbar.add": {"tf": 4.69041575982343}, "mlsauce.utils.get_beta": {"tf": 4.898979485566356}, "mlsauce.utils.check_and_install": {"tf": 3.1622776601683795}, "mlsauce.utils.is_multitask_estimator": {"tf": 3.1622776601683795}, "mlsauce.utils.get_histo_features": {"tf": 4.242640687119285}, "mlsauce.utils.safe_sparse_dot": {"tf": 5.656854249492381}, "mlsauce.utils.mean_errors": {"tf": 5.656854249492381}, "mlsauce.utils.winkler_score": {"tf": 5.477225575051661}, "mlsauce.utils.coverage": {"tf": 5.477225575051661}, "mlsauce.utils.convert_df_to_numeric": {"tf": 3.1622776601683795}, "mlsauce.utils.dict_to_dataframe_series": {"tf": 3.7416573867739413}, "mlsauce.utils.get_beta.get_beta": {"tf": 4.898979485566356}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 5.291502622129181}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 5.291502622129181}}, "df": 82, "r": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}}, "df": 2, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}, "r": {"docs": {"mlsauce.MultiTaskRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"tf": 1}}, "df": 4}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {"mlsauce.utils.subsample": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {"mlsauce.utils.flatten": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "m": {"docs": {"mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}}, "df": 1, "b": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}}, "df": 2, "s": {"docs": {"mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}, "mlsauce.utils.coverage": {"tf": 1}}, "df": 3}}}}}, "a": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}}, "df": 2}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}, "mlsauce.utils.coverage": {"tf": 1}}, "df": 3}}}}}}, "b": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.utils.get_beta": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}, "mlsauce.utils.get_beta.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 9}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {"mlsauce.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.utils.get_beta": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}, "mlsauce.utils.get_beta.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 9}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor.fit": {"tf": 1}, "mlsauce.KRLSRegressor.predict": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}, "mlsauce.utils.Progbar.add": {"tf": 1}}, "df": 28}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.utils.cluster": {"tf": 1}, "mlsauce.utils.subsample": {"tf": 1}}, "df": 3}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}, "mlsauce.utils.coverage": {"tf": 1}, "mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 4}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}}, "df": 4}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.subsample": {"tf": 1}}, "df": 1}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}}, "df": 1}}}}}}}, "x": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor.fit": {"tf": 1}, "mlsauce.KRLSRegressor.predict": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.cluster": {"tf": 1}, "mlsauce.utils.merge_two_dicts": {"tf": 1}, "mlsauce.utils.is_float": {"tf": 1}, "mlsauce.utils.get_beta": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1}, "mlsauce.utils.get_beta.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 30}, "y": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.KRLSRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.utils.subsample": {"tf": 1}, "mlsauce.utils.merge_two_dicts": {"tf": 1}, "mlsauce.utils.is_factor": {"tf": 1}, "mlsauce.utils.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta": {"tf": 1}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1}}, "df": 20}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}}, "df": 10}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}}, "df": 3}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}}}}}}}}, "n": {"docs": {"mlsauce.utils.cluster": {"tf": 1}, "mlsauce.utils.Progbar.add": {"tf": 1}}, "df": 2, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1.4142135623730951}, "mlsauce.utils.cluster": {"tf": 2}, "mlsauce.utils.Progbar.__init__": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}, "mlsauce.utils.Progbar.add": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 14}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}}, "df": 2}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 2}, "m": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1, "s": {"docs": {"mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}}, "df": 5}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.utils.cluster": {"tf": 1}}, "df": 3}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.utils.cluster": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {"mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 2}, "b": {"docs": {}, "df": 0, "j": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}, "mlsauce.utils.coverage": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}}, "df": 2}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}, "mlsauce.utils.coverage": {"tf": 1}}, "df": 3}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1.4142135623730951}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.utils.cluster": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1}, "mlsauce.utils.mean_errors": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.utils.dict_to_dataframe_series": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 1}}}, "f": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.download": {"tf": 1}, "mlsauce.datasets.dowload.download": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}, "mlsauce.utils.mean_errors": {"tf": 1}, "mlsauce.utils.winkler_score": {"tf": 1}, "mlsauce.utils.coverage": {"tf": 1}}, "df": 5}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1}}, "df": 2, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.mean_errors": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.cluster": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.is_multitask_estimator": {"tf": 1}}, "df": 1}}}}}}}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1}}, "df": 1}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar.__init__": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 1, "s": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1}, "mlsauce.utils.Progbar.add": {"tf": 1}}, "df": 2}}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}}, "df": 9}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}}, "df": 11, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 9}}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorAdapter": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 10}}}}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 6}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 6}}}}}}}}}}}}, "c": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}}}, "doc": {"root": {"0": {"1": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}}, "df": 2}, "2": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}}, "df": 2}, "3": {"6": {"2": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2.8284271247461903}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 2.8284271247461903}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 12}, "1": {"0": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}, "1": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}, "4": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}, "5": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}, "6": {"0": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 19}, "docs": {}, "df": 0}, "docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor": {"tf": 2}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 31}, "2": {"0": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}, "7": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}, "9": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}, "docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 2.6457513110645907}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2.6457513110645907}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2.6457513110645907}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2.6457513110645907}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 29}, "3": {"1": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}, "6": {"2": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}, "docs": {}, "df": 0}, "9": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}}, "df": 4}, "docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 2.449489742783178}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2.449489742783178}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2.449489742783178}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2.449489742783178}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 24, "d": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}}, "df": 2}}, "4": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}, "5": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 2}, "6": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 1}, "8": {"6": {"1": {"7": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 19}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}, "9": {"5": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}, "9": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.7320508075688772}}, "df": 2}, "docs": {}, "df": 0}, "docs": {"mlsauce": {"tf": 1.7320508075688772}, "mlsauce.AdaOpt": {"tf": 1.7320508075688772}, "mlsauce.LSBoostClassifier": {"tf": 1.7320508075688772}, "mlsauce.GenericBoostingClassifier": {"tf": 1.7320508075688772}, "mlsauce.GenericBoostingRegressor": {"tf": 1.7320508075688772}, "mlsauce.StumpClassifier": {"tf": 1.7320508075688772}, "mlsauce.ElasticNetRegressor": {"tf": 3.1622776601683795}, "mlsauce.ElasticNetRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.ElasticNetRegressor.reg_lambda": {"tf": 1.7320508075688772}, "mlsauce.ElasticNetRegressor.alpha": {"tf": 1.7320508075688772}, "mlsauce.ElasticNetRegressor.backend": {"tf": 1.7320508075688772}, "mlsauce.ElasticNetRegressor.fit": {"tf": 4.123105625617661}, "mlsauce.ElasticNetRegressor.predict": {"tf": 4.123105625617661}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 9}, "mlsauce.KRLSRegressor": {"tf": 21.61018278497431}, "mlsauce.KRLSRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.backend": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.kernel": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.regularization": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.ym_": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.scaler_": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.X_": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.coef_": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 9}, "mlsauce.LassoRegressor": {"tf": 1.7320508075688772}, "mlsauce.LSBoostRegressor": {"tf": 1.7320508075688772}, "mlsauce.RidgeRegressor": {"tf": 1.7320508075688772}, "mlsauce.LazyBoostingClassifier": {"tf": 1.7320508075688772}, "mlsauce.LazyBoostingMTS": {"tf": 1.7320508075688772}, "mlsauce.LazyBoostingRegressor": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor": {"tf": 3.1622776601683795}, "mlsauce.MultiTaskRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor.regr": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor.objs": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor.fit": {"tf": 2.449489742783178}, "mlsauce.MultiTaskRegressor.predict": {"tf": 3.1622776601683795}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 9}, "mlsauce.IsotonicRegressor": {"tf": 3.7416573867739413}, "mlsauce.IsotonicRegressor.__init__": {"tf": 3.3166247903554}, "mlsauce.IsotonicRegressor.regr": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.increasing": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.out_of_bounds": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.fit": {"tf": 3.7416573867739413}, "mlsauce.IsotonicRegressor.predict": {"tf": 3.7416573867739413}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 9}, "mlsauce.GenericFunctionalForecaster": {"tf": 1.7320508075688772}, "mlsauce.download": {"tf": 1.7320508075688772}, "mlsauce.get_config": {"tf": 1.7320508075688772}, "mlsauce.set_config": {"tf": 1.7320508075688772}, "mlsauce.config_context": {"tf": 1.7320508075688772}, "mlsauce.adaopt": {"tf": 1.7320508075688772}, "mlsauce.adaopt.AdaOpt": {"tf": 1.7320508075688772}, "mlsauce.booster": {"tf": 1.7320508075688772}, "mlsauce.booster.LSBoostClassifier": {"tf": 1.7320508075688772}, "mlsauce.booster.LSBoostRegressor": {"tf": 1.7320508075688772}, "mlsauce.booster.GenericBoostingClassifier": {"tf": 1.7320508075688772}, "mlsauce.booster.GenericBoostingRegressor": {"tf": 1.7320508075688772}, "mlsauce.datasets": {"tf": 1.7320508075688772}, "mlsauce.datasets.dowload": {"tf": 1.7320508075688772}, "mlsauce.datasets.dowload.download": {"tf": 1.7320508075688772}, "mlsauce.demo": {"tf": 1.7320508075688772}, "mlsauce.elasticnet": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 3.1622776601683795}, "mlsauce.elasticnet.ElasticNetRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.reg_lambda": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.alpha": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.backend": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 4.123105625617661}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 4.123105625617661}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 9}, "mlsauce.fpca": {"tf": 1.7320508075688772}, "mlsauce.fpca.GenericFunctionalForecaster": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 3.7416573867739413}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 3.3166247903554}, "mlsauce.isotonicregressor.IsotonicRegressor.regr": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.increasing": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.out_of_bounds": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 3.7416573867739413}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 3.7416573867739413}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 9}, "mlsauce.kernelridge": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 21.61018278497431}, "mlsauce.kernelridge.KRLSRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.backend": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.kernel": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.regularization": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.ym_": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.scaler_": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.X_": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.coef_": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 9}, "mlsauce.lasso": {"tf": 1.7320508075688772}, "mlsauce.lasso.LassoRegressor": {"tf": 1.7320508075688772}, "mlsauce.lazybooster": {"tf": 1.7320508075688772}, "mlsauce.lazybooster.LazyBoostingClassifier": {"tf": 1.7320508075688772}, "mlsauce.lazybooster.LazyBoostingRegressor": {"tf": 1.7320508075688772}, "mlsauce.lazybooster.LazyBoostingMTS": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 3.1622776601683795}, "mlsauce.multitaskregressor.MultiTaskRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor.regr": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor.objs": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 2.449489742783178}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 3.1622776601683795}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 9}, "mlsauce.nonconformist": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 3.3166247903554}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 4.358898943540674}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 4.358898943540674}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 3}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 4.358898943540674}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 4.358898943540674}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 21.61018278497431}, "mlsauce.nonconformist.RegressorAdapter.__init__": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 9}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 9}, "mlsauce.nonconformist.RegressorNc": {"tf": 5.916079783099616}, "mlsauce.nonconformist.RegressorNc.__init__": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 5.0990195135927845}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 9}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 9}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 9}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 21.61018278497431}, "mlsauce.nonconformist.RegressorNormalizer.__init__": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.base_model": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.normalizer_model": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.err_func": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.fit": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.score": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 9}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 9}, "mlsauce.nonconformist.IcpRegressor": {"tf": 22.360679774997898}, "mlsauce.nonconformist.IcpRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 4.795831523312719}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 9}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 9}, "mlsauce.predictioninterval": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 3.3166247903554}, "mlsauce.predictioninterval.PredictionInterval.__init__": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.obj": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.method": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.level": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.type_pi": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.replications": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.kernel": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.agg": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.seed": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.alpha_": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.quantile_": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.icp_": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.scaled_calibrated_residuals_": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.calibrated_residuals_scaler_": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.kde_": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 3.605551275463989}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 3.1622776601683795}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 9}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 9}, "mlsauce.ridge": {"tf": 1.7320508075688772}, "mlsauce.ridge.RidgeRegressor": {"tf": 1.7320508075688772}, "mlsauce.stump": {"tf": 1.7320508075688772}, "mlsauce.stump.StumpClassifier": {"tf": 1.7320508075688772}, "mlsauce.utils": {"tf": 1.7320508075688772}, "mlsauce.utils.cluster": {"tf": 1.7320508075688772}, "mlsauce.utils.subsample": {"tf": 1.7320508075688772}, "mlsauce.utils.merge_two_dicts": {"tf": 1.7320508075688772}, "mlsauce.utils.flatten": {"tf": 1.7320508075688772}, "mlsauce.utils.is_float": {"tf": 1.7320508075688772}, "mlsauce.utils.is_factor": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar": {"tf": 3.1622776601683795}, "mlsauce.utils.Progbar.__init__": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar.target": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar.width": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar.verbose": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar.interval": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar.update": {"tf": 3.4641016151377544}, "mlsauce.utils.Progbar.add": {"tf": 1.7320508075688772}, "mlsauce.utils.get_beta": {"tf": 1.7320508075688772}, "mlsauce.utils.check_and_install": {"tf": 1.7320508075688772}, "mlsauce.utils.is_multitask_estimator": {"tf": 1.7320508075688772}, "mlsauce.utils.get_histo_features": {"tf": 3}, "mlsauce.utils.safe_sparse_dot": {"tf": 5.0990195135927845}, "mlsauce.utils.mean_errors": {"tf": 1.7320508075688772}, "mlsauce.utils.winkler_score": {"tf": 1.7320508075688772}, "mlsauce.utils.coverage": {"tf": 1.7320508075688772}, "mlsauce.utils.convert_df_to_numeric": {"tf": 3.1622776601683795}, "mlsauce.utils.dict_to_dataframe_series": {"tf": 1.7320508075688772}, "mlsauce.utils.get_beta.get_beta": {"tf": 1.7320508075688772}, "mlsauce.utils.get_beta.get_beta_ridge": {"tf": 1.7320508075688772}, "mlsauce.utils.get_beta.get_best_beta": {"tf": 1.7320508075688772}}, "df": 195, "e": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 21, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.KRLSRegressor": {"tf": 2.449489742783178}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2.449489742783178}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2.449489742783178}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2.449489742783178}}, "df": 8, "s": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}}, "df": 2}}}}}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 2}}, "df": 6}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}}, "df": 1, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 6}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2.23606797749979}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}}, "df": 8}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 2}}}}}}}}}}, "a": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.MultiTaskRegressor": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 2.23606797749979}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 2.23606797749979}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 2.23606797749979}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 2.23606797749979}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.check_and_install": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 2}}, "df": 31, "t": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}}, "df": 6, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 9}}}}}}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}}}, "l": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1.4142135623730951}}, "df": 8, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 2}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 3, "d": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 2}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2.449489742783178}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 2.23606797749979}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1.7320508075688772}}, "df": 42}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 17}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 6}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor": {"tf": 2}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1.4142135623730951}, "mlsauce.utils.safe_sparse_dot": {"tf": 2}}, "df": 27}}}, "e": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 24}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}}, "df": 8}}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 31, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}}, "df": 3}}}, "y": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}}, "df": 4}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}}, "df": 1}}}}}}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 1, "d": {"docs": {"mlsauce.utils.Progbar": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}}, "r": {"docs": {"mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}}, "df": 6, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}}, "df": 9, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 13, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 5, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 19}, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 20}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.7320508075688772}}, "df": 19, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}}}, "f": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 20}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}}, "df": 2}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 2}}}}}}, "l": {"1": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}, "2": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1.4142135623730951}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 14}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 23}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}}, "df": 9, "s": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}, "o": {"docs": {}, "df": 0, "w": {"docs": {"mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 1}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 8}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2.449489742783178}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 2.23606797749979}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar.update": {"tf": 1.4142135623730951}, "mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 44}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.7320508075688772}}, "df": 32, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 7}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1.7320508075688772}, "mlsauce.utils.get_histo_features": {"tf": 1.4142135623730951}}, "df": 14}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}}, "df": 1, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 2}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 2}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 2}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 2}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 2}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 2}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 2}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 2}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 2}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 2}, "mlsauce.nonconformist.RegressorNc": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 2}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 2}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 2}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 2}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 2}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 2}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 2}}, "df": 26}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 2.23606797749979}}, "df": 5}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1.7320508075688772}}, "df": 6}}}}}, "p": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.7320508075688772}}, "df": 2, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"mlsauce.KRLSRegressor": {"tf": 2.6457513110645907}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2.6457513110645907}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2.6457513110645907}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2.6457513110645907}}, "df": 4, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}}, "df": 7, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 2}, "mlsauce.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 2}, "mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 2}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 2}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 2}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 2}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 2}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 2}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 2}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 2}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 2}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 2}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 2}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 2}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 2}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 2}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 2}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 47}}}}}, "s": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}}, "df": 8}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}}, "df": 2, "s": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}}, "df": 3}}, "s": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 16, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 2}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1.4142135623730951}}, "df": 8, "s": {"docs": {"mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1.4142135623730951}}, "df": 9}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}}, "df": 4}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}}, "df": 2}}, "s": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}}, "df": 2, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.Progbar": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 2}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}}}}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 19}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}}}}, "i": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 2}, "d": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1.4142135623730951}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1.4142135623730951}}, "df": 2}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "k": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 4}}}, "s": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 2}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 30, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 4}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19, "d": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 19}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.check_and_install": {"tf": 1}}, "df": 20}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 8}, "l": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 2.6457513110645907}}, "df": 1, "c": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 4}}}, "e": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "b": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1.7320508075688772}}, "df": 1, "e": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar.update": {"tf": 1.4142135623730951}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 42, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 5}}}}, "a": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}}, "df": 1}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 13, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "r": {"docs": {"mlsauce.utils.Progbar": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 2}}, "y": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 24}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 23, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 5}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 3}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1.4142135623730951}}, "df": 2}}, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {"mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 2}}, "df": 3, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}}, "df": 2}}}}}}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.7320508075688772}}, "df": 4}}}}, "{": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "q": {"docs": {"mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}}, "df": 1}}}}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1, "l": {"docs": {"mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 2.449489742783178}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 9}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.7320508075688772}}, "df": 23, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 20}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 1, "s": {"docs": {"mlsauce.utils.Progbar": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 2}}}}}}, "y": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 5}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}}}}}}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}}, "df": 3, "n": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 2}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 33, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}}, "df": 4, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1.7320508075688772}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 7, "s": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}}, "df": 3}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 2}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1.4142135623730951}}, "df": 7, "s": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 4}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.utils.check_and_install": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 2.23606797749979}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1.4142135623730951}, "mlsauce.utils.check_and_install": {"tf": 1}}, "df": 39, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 2}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 2}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 4, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 4}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}, "f": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}, "mlsauce.utils.check_and_install": {"tf": 1.4142135623730951}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 30}, "t": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.check_and_install": {"tf": 1}}, "df": 24, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 2.449489742783178}}, "df": 5}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}, "x": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 2.8284271247461903}}, "df": 1}}, "c": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 2.23606797749979}}, "df": 1, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "s": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 25, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 2, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 2}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 21}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 27}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 21, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 2}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.fit": {"tf": 2}, "mlsauce.IsotonicRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 2}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 2}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 2}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 2}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 2}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1.7320508075688772}}, "df": 16}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor": {"tf": 2.6457513110645907}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2.6457513110645907}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2.6457513110645907}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2.6457513110645907}}, "df": 8}}, "t": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 30, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}}}}}}}, "e": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 2, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "i": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2.6457513110645907}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 2.6457513110645907}}, "df": 5}}}}}}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 2.23606797749979}}, "df": 1}}, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 6}, "r": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 2.8284271247461903}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 5}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}}, "o": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1.4142135623730951}}, "df": 38, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1.7320508075688772}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.4142135623730951}}, "df": 7}}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 31}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.IsotonicRegressor": {"tf": 2.23606797749979}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.IsotonicRegressor.fit": {"tf": 2}, "mlsauce.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 2.23606797749979}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.7320508075688772}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 2}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2.6457513110645907}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 2.23606797749979}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 3.1622776601683795}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 3.1622776601683795}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 2}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 3.1622776601683795}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 3.1622776601683795}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1.4142135623730951}, "mlsauce.utils.get_histo_features": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 55, "i": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}, "n": {"docs": {"mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.7320508075688772}}, "df": 2}, "r": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 26}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 8}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 11}}}}, "s": {"docs": {}, "df": 0, "k": {"docs": {"mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}}, "df": 2}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2.23606797749979}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}}, "df": 5, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 1}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 1, "s": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 2.23606797749979}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 2.23606797749979}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2.6457513110645907}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.IcpRegressor": {"tf": 2.23606797749979}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 2.449489742783178}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 2.23606797749979}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 2.23606797749979}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 2}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 2.23606797749979}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 2.23606797749979}, "mlsauce.utils.Progbar": {"tf": 1.7320508075688772}, "mlsauce.utils.Progbar.update": {"tf": 1.7320508075688772}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 48}, "b": {"docs": {}, "df": 0, "j": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1.4142135623730951}}, "df": 9, "s": {"docs": {"mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {"mlsauce.MultiTaskRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}}, "df": 2}}}}}}}, "r": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1.4142135623730951}, "mlsauce.utils.safe_sparse_dot": {"tf": 1.7320508075688772}}, "df": 14, "g": {"docs": {}, "df": 0, "/": {"3": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}}}}}}}}}}}}}}, "docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}}}}}}}}}}}, "w": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}}, "df": 4, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.utils.safe_sparse_dot": {"tf": 2}}, "df": 7, "s": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 1, "s": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 2}}}}, "g": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 19, "p": {"docs": {}, "df": 0, "u": {"docs": {"mlsauce.ElasticNetRegressor": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "v": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}, "t": {"docs": {"mlsauce.KRLSRegressor": {"tf": 5.291502622129181}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 5.291502622129181}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 5.291502622129181}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 5.291502622129181}, "mlsauce.nonconformist.IcpRegressor": {"tf": 7.14142842854285}}, "df": 5}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1.7320508075688772}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 17, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1.4142135623730951}, "mlsauce.utils.convert_df_to_numeric": {"tf": 2.23606797749979}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 19}}}}}}}}, "f": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.7320508075688772}}, "df": 4, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 2}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}, "mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 30}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 4}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1.7320508075688772}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1.4142135623730951}}, "df": 6}}, "s": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.nonconformist": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1.4142135623730951}}, "df": 1}}, "f": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 1}}, "x": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor": {"tf": 2.8284271247461903}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2.8284271247461903}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2.8284271247461903}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2.8284271247461903}, "mlsauce.nonconformist.IcpRegressor": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1.4142135623730951}}, "df": 22}, "y": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor": {"tf": 2}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.7320508075688772}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.4142135623730951}}, "df": 20, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 2.23606797749979}, "mlsauce.ElasticNetRegressor.predict": {"tf": 2}, "mlsauce.IsotonicRegressor.fit": {"tf": 2.23606797749979}, "mlsauce.IsotonicRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 2.23606797749979}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 2}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 2.23606797749979}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 2}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 2}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 2}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 2.23606797749979}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 2}}, "df": 17, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 10}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}}, "df": 11}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.utils.convert_df_to_numeric": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar.update": {"tf": 1.4142135623730951}}, "df": 20, "s": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 5}}}, "n": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}}, "df": 4}}, "o": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4, "t": {"docs": {"mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}, "mlsauce.utils.check_and_install": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 23}}}, "n": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}}, "df": 1, "e": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval": {"tf": 1}, "mlsauce.utils.Progbar": {"tf": 1}}, "df": 8}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc": {"tf": 2}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 2}}, "df": 9}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.nonconformist.IcpRegressor": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}}, "df": 1}, "d": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "p": {"docs": {"mlsauce.KRLSRegressor": {"tf": 2}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 2}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 2}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 2}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}, "mlsauce.utils.get_histo_features": {"tf": 1.4142135623730951}}, "df": 6}, "c": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.AbsErrorErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply": {"tf": 1}, "mlsauce.nonconformist.QuantileRegErrFunc.apply_inverse": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 2.6457513110645907}}, "df": 5}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 8}}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar": {"tf": 1.7320508075688772}}, "df": 1}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1.4142135623730951}}, "df": 6, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.MultiTaskRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.fit": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 14}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1.7320508075688772}}, "df": 4}}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.fit": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 8}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 20}}}}, "n": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 21}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}, "mlsauce.utils.get_histo_features": {"tf": 1}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1.7320508075688772}}, "df": 5}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar": {"tf": 1.4142135623730951}, "mlsauce.utils.Progbar.update": {"tf": 1.4142135623730951}, "mlsauce.utils.safe_sparse_dot": {"tf": 1.4142135623730951}}, "df": 7}}, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"mlsauce.utils.Progbar": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.fit": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.fit": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 12}}}}}, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1.4142135623730951}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1.4142135623730951}}, "df": 19}, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.predictioninterval.PredictionInterval": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.IsotonicRegressor": {"tf": 1}, "mlsauce.IsotonicRegressor.__init__": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.__init__": {"tf": 1}}, "df": 4, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}, "d": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1.4142135623730951}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor": {"tf": 1.4142135623730951}}, "df": 6}, "r": {"docs": {"mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.predict": {"tf": 1}, "mlsauce.nonconformist.RegressorNc": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}, "mlsauce.utils.convert_df_to_numeric": {"tf": 1}}, "df": 5}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"mlsauce.nonconformist.RegressorNc": {"tf": 1.7320508075688772}, "mlsauce.nonconformist.RegressorNc.predict": {"tf": 1}}, "df": 2}}}}}}}}, "k": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"mlsauce.predictioninterval.PredictionInterval.predict": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.Progbar": {"tf": 1}}, "df": 1, "s": {"docs": {"mlsauce.utils.Progbar.update": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}, "w": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "w": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 19}}}}}}}}}, "m": {"docs": {}, "df": 0, "l": {"docs": {"mlsauce.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.KRLSRegressor": {"tf": 1}, "mlsauce.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.elasticnet.ElasticNetRegressor.set_score_request": {"tf": 1}, "mlsauce.isotonicregressor.IsotonicRegressor.set_score_request": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor": {"tf": 1}, "mlsauce.kernelridge.KRLSRegressor.set_score_request": {"tf": 1}, "mlsauce.multitaskregressor.MultiTaskRegressor.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorAdapter.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_predict_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNc.set_score_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.RegressorNormalizer.set_score_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_fit_request": {"tf": 1}, "mlsauce.nonconformist.IcpRegressor.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_predict_request": {"tf": 1}, "mlsauce.predictioninterval.PredictionInterval.set_score_request": {"tf": 1}}, "df": 23}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "y": {"docs": {"mlsauce.nonconformist.AbsErrorErrFunc": {"tf": 1}}, "df": 1}, "q": {"docs": {"mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.utils.safe_sparse_dot": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"mlsauce.utils.get_histo_features": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"mlsauce.nonconformist.QuantileRegErrFunc": {"tf": 1}}, "df": 1}}}}}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();