# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('dblm.dblm_root_group.command_name', 'dblm'), cls=CommandGroupWithAlias, help=cli_util.override('dblm.dblm_root_group.help', """A description of the Dblm API"""), short_help=cli_util.override('dblm.dblm_root_group.short_help', """Dblm API"""))
@cli_util.help_option_group
def dblm_root_group():
    pass


@click.command(cli_util.override('dblm.dblm_patch_management_group.command_name', 'dblm-patch-management'), cls=CommandGroupWithAlias, help="""Description of PatchManagement.""")
@cli_util.help_option_group
def dblm_patch_management_group():
    pass


@click.command(cli_util.override('dblm.vulnerability_scan_collection_group.command_name', 'vulnerability-scan-collection'), cls=CommandGroupWithAlias, help="""Results of a VulnerabilityScan search. Contains list of VulnerabilityScanSummary items.""")
@cli_util.help_option_group
def vulnerability_scan_collection_group():
    pass


@click.command(cli_util.override('dblm.dblm_vulnerability_group.command_name', 'dblm-vulnerability'), cls=CommandGroupWithAlias, help="""A Dblm Vulnerability is a description of a Dblm Vulnerability.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def dblm_vulnerability_group():
    pass


@click.command(cli_util.override('dblm.patch_databases_collection_group.command_name', 'patch-databases-collection'), cls=CommandGroupWithAlias, help="""Results of a patchDatabases search. Contains items for databases, images and patch compliance information.""")
@cli_util.help_option_group
def patch_databases_collection_group():
    pass


@click.command(cli_util.override('dblm.notification_collection_group.command_name', 'notification-collection'), cls=CommandGroupWithAlias, help="""Collection of notifications for new CVEs and CPUs.""")
@cli_util.help_option_group
def notification_collection_group():
    pass


@click.command(cli_util.override('dblm.work_request_error_group.command_name', 'work-request-error'), cls=CommandGroupWithAlias, help="""An error encountered while executing a work request.""")
@cli_util.help_option_group
def work_request_error_group():
    pass


@click.command(cli_util.override('dblm.work_request_log_entry_group.command_name', 'work-request-log-entry'), cls=CommandGroupWithAlias, help="""A log message from the execution of a work request.""")
@cli_util.help_option_group
def work_request_log_entry_group():
    pass


@click.command(cli_util.override('dblm.vulnerability_resource_collection_group.command_name', 'vulnerability-resource-collection'), cls=CommandGroupWithAlias, help="""Collection of assessed resources that may or may not have vulnerabilities""")
@cli_util.help_option_group
def vulnerability_resource_collection_group():
    pass


@click.command(cli_util.override('dblm.work_request_group.command_name', 'work-request'), cls=CommandGroupWithAlias, help="""A description of workrequest status""")
@cli_util.help_option_group
def work_request_group():
    pass


@click.command(cli_util.override('dblm.vulnerability_scan_group.command_name', 'vulnerability-scan'), cls=CommandGroupWithAlias, help="""A VulnerabilityScan is a description of a VulnerabilityScan.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def vulnerability_scan_group():
    pass


dblm_root_group.add_command(dblm_patch_management_group)
dblm_root_group.add_command(vulnerability_scan_collection_group)
dblm_root_group.add_command(dblm_vulnerability_group)
dblm_root_group.add_command(patch_databases_collection_group)
dblm_root_group.add_command(notification_collection_group)
dblm_root_group.add_command(work_request_error_group)
dblm_root_group.add_command(work_request_log_entry_group)
dblm_root_group.add_command(vulnerability_resource_collection_group)
dblm_root_group.add_command(work_request_group)
dblm_root_group.add_command(vulnerability_scan_group)


@vulnerability_scan_group.command(name=cli_util.override('dblm.create_vulnerability_scan.command_name', 'create'), help=u"""Creates a VulnerabilityScan. \n[Command Reference](createVulnerabilityScan)""")
@cli_util.option('--compartment-id', required=True, help=u"""Compartment Identifier""")
@cli_util.option('--vulnerability-scan-type', required=True, help=u"""Vulnerability Scan type is CVE, PATCH or IMAGE_PATCH""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'VulnerabilityScan'})
@cli_util.wrap_exceptions
def create_vulnerability_scan(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, vulnerability_scan_type):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['vulnerabilityScanType'] = vulnerability_scan_type

    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    result = client.create_vulnerability_scan(
        create_vulnerability_scan_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@dblm_patch_management_group.command(name=cli_util.override('dblm.get_patch_management.command_name', 'get-patch-management'), help=u"""Overview of Patch Management. \n[Command Reference](getPatchManagement)""")
@cli_util.option('--compartment-id', required=True, help=u"""The required ID of the compartment in which to list resources.""")
@cli_util.option('--database-release', help=u"""A filter to return only database that match the given release version.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED"]), help=u"""A filter to return only resources their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--time-started-greater-than-or-equal-to', type=custom_types.CLI_DATETIME, help=u"""A filter to return only resources whose timeStarted is greater than or equal to the given date-time.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-started-less-than', type=custom_types.CLI_DATETIME, help=u"""A filter to return only resources whose timeStarted is less than the given date-time.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'DblmPatchManagement'})
@cli_util.wrap_exceptions
def get_patch_management(ctx, from_json, compartment_id, database_release, lifecycle_state, time_started_greater_than_or_equal_to, time_started_less_than):

    kwargs = {}
    if database_release is not None:
        kwargs['database_release'] = database_release
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if time_started_greater_than_or_equal_to is not None:
        kwargs['time_started_greater_than_or_equal_to'] = time_started_greater_than_or_equal_to
    if time_started_less_than is not None:
        kwargs['time_started_less_than'] = time_started_less_than
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    result = client.get_patch_management(
        compartment_id=compartment_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@dblm_vulnerability_group.command(name=cli_util.override('dblm.get_vulnerability.command_name', 'get-vulnerability'), help=u"""Gets a Vulnerability \n[Command Reference](getVulnerability)""")
@cli_util.option('--compartment-id', required=True, help=u"""The required ID of the compartment in which to list resources.""")
@cli_util.option('--database-release', help=u"""A filter to return only database that match the given release version.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED"]), help=u"""A filter to return only resources their lifecycleState matches the given lifecycleState.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'DblmVulnerability'})
@cli_util.wrap_exceptions
def get_vulnerability(ctx, from_json, compartment_id, database_release, lifecycle_state):

    kwargs = {}
    if database_release is not None:
        kwargs['database_release'] = database_release
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    result = client.get_vulnerability(
        compartment_id=compartment_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@vulnerability_scan_group.command(name=cli_util.override('dblm.get_vulnerability_scan.command_name', 'get'), help=u"""Gets information about a VulnerabilityScan. \n[Command Reference](getVulnerabilityScan)""")
@cli_util.option('--vulnerability-scan-id', required=True, help=u"""The [OCID] of the VulnerabilityScan.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'VulnerabilityScan'})
@cli_util.wrap_exceptions
def get_vulnerability_scan(ctx, from_json, vulnerability_scan_id):

    if isinstance(vulnerability_scan_id, six.string_types) and len(vulnerability_scan_id.strip()) == 0:
        raise click.UsageError('Parameter --vulnerability-scan-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    result = client.get_vulnerability_scan(
        vulnerability_scan_id=vulnerability_scan_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('dblm.get_work_request.command_name', 'get'), help=u"""Gets details of the work request with the given ID. \n[Command Reference](getWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'WorkRequest'})
@cli_util.wrap_exceptions
def get_work_request(ctx, from_json, work_request_id):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    result = client.get_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@dblm_vulnerability_group.command(name=cli_util.override('dblm.list_aggregated_vulnerability_data.command_name', 'list-aggregated-vulnerability-data'), help=u"""Gets an AggregatedVulnerabilityData \n[Command Reference](listAggregatedVulnerabilityData)""")
@cli_util.option('--compartment-id', help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--time-created-greater-than', type=custom_types.CLI_DATETIME, help=u"""The created greater than.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-ended-less-than', type=custom_types.CLI_DATETIME, help=u"""The time ended less than.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--database-release', help=u"""A filter to return only database that match the given release version.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED"]), help=u"""A filter to return only resources their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'AggregatedVulnerabilityCollection'})
@cli_util.wrap_exceptions
def list_aggregated_vulnerability_data(ctx, from_json, all_pages, page_size, compartment_id, time_created_greater_than, time_ended_less_than, database_release, lifecycle_state, limit, page):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if time_created_greater_than is not None:
        kwargs['time_created_greater_than'] = time_created_greater_than
    if time_ended_less_than is not None:
        kwargs['time_ended_less_than'] = time_ended_less_than
    if database_release is not None:
        kwargs['database_release'] = database_release
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_aggregated_vulnerability_data,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_aggregated_vulnerability_data,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_aggregated_vulnerability_data(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@patch_databases_collection_group.command(name=cli_util.override('dblm.list_databases.command_name', 'list-databases'), help=u"""Gets the list of databases \n[Command Reference](listDatabases)""")
@cli_util.option('--compartment-id', help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED"]), help=u"""A filter to return only resources their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--database-release', help=u"""A filter to return only database that match the given release version.""")
@cli_util.option('--database-type', type=custom_types.CliCaseInsensitiveChoice(["SI", "RAC"]), help=u"""Filter by database type. Possible values Single Instance or RAC.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "name", "resourceType", "release", "subscribedImage", "patchCompliance"]), help=u"""The field to sort by.""")
@cli_util.option('--image-id', help=u"""Subscribed image""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--drifter-patch-id', type=click.INT, help=u"""A filter to return only database that have given patchId as additional patch (drifter from image version).""")
@cli_util.option('--image-compliance', type=custom_types.CliCaseInsensitiveChoice(["NOT_SUBSCRIBED", "NOT_COMPLIANT_WITH_IMAGES", "ALL_DATABASES"]), help=u"""Filter databases by image compliance status.""")
@cli_util.option('--severity-type', type=custom_types.CliCaseInsensitiveChoice(["CRITICAL", "HIGH", "MEDIUM", "LOW", "INFO", "NONE"]), multiple=True, help=u"""Filter by one or more severity types. Possible values are critical, high, medium, low, info and none.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'PatchDatabasesCollection'})
@cli_util.wrap_exceptions
def list_databases(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, database_release, database_type, limit, page, sort_order, sort_by, image_id, display_name, drifter_patch_id, image_compliance, severity_type):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if database_release is not None:
        kwargs['database_release'] = database_release
    if database_type is not None:
        kwargs['database_type'] = database_type
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if image_id is not None:
        kwargs['image_id'] = image_id
    if display_name is not None:
        kwargs['display_name'] = display_name
    if drifter_patch_id is not None:
        kwargs['drifter_patch_id'] = drifter_patch_id
    if image_compliance is not None:
        kwargs['image_compliance'] = image_compliance
    if severity_type is not None and len(severity_type) > 0:
        kwargs['severity_type'] = severity_type
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_databases,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_databases,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_databases(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@notification_collection_group.command(name=cli_util.override('dblm.list_notifications.command_name', 'list-notifications'), help=u"""List of notifications \n[Command Reference](listNotifications)""")
@cli_util.option('--compartment-id', required=True, help=u"""The required ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'NotificationCollection'})
@cli_util.wrap_exceptions
def list_notifications(ctx, from_json, all_pages, compartment_id, limit):

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    result = client.list_notifications(
        compartment_id=compartment_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@dblm_vulnerability_group.command(name=cli_util.override('dblm.list_vulnerabilities.command_name', 'list-vulnerabilities'), help=u"""Gets the vulnerabilities summary list \n[Command Reference](listVulnerabilities)""")
@cli_util.option('--compartment-id', help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["cveId", "vulnerableResources"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for vulnerableResources is descending. Default order for cveId is descending.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED"]), help=u"""A filter to return only resources their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--database-release', help=u"""A filter to return only database that match the given release version.""")
@cli_util.option('--resource-id', help=u"""A filter to return only resources that match the given resource id.""")
@cli_util.option('--severity-type', type=custom_types.CliCaseInsensitiveChoice(["CRITICAL", "HIGH", "MEDIUM", "LOW", "INFO"]), multiple=True, help=u"""Filter by one or more severity types. Possible values are critical, high, medium, low, info.""")
@cli_util.option('--search-by', help=u"""The search input for filter cve id and cve description.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'VulnerabilityCollection'})
@cli_util.wrap_exceptions
def list_vulnerabilities(ctx, from_json, all_pages, page_size, compartment_id, limit, page, display_name, sort_order, sort_by, lifecycle_state, database_release, resource_id, severity_type, search_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if display_name is not None:
        kwargs['display_name'] = display_name
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if database_release is not None:
        kwargs['database_release'] = database_release
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if severity_type is not None and len(severity_type) > 0:
        kwargs['severity_type'] = severity_type
    if search_by is not None:
        kwargs['search_by'] = search_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_vulnerabilities,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_vulnerabilities,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_vulnerabilities(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@vulnerability_resource_collection_group.command(name=cli_util.override('dblm.list_vulnerability_resources.command_name', 'list-vulnerability-resources'), help=u"""Lists the summary of vulnerable and clean resourcees \n[Command Reference](listVulnerabilityResources)""")
@cli_util.option('--compartment-id', required=True, help=u"""The required ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName", "vulnerabilityCount"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED"]), help=u"""A filter to return only resources their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--database-release', help=u"""A filter to return only database that match the given release version.""")
@cli_util.option('--cve-id', help=u"""The id of a CVE.""")
@cli_util.option('--severity-type', type=custom_types.CliCaseInsensitiveChoice(["CRITICAL", "HIGH", "MEDIUM", "LOW", "INFO", "NONE"]), multiple=True, help=u"""Filter by one or more severity types. Possible values are critical, high, medium, low, info and none.""")
@cli_util.option('--patch-recommendation', type=custom_types.CliCaseInsensitiveChoice(["upToDate", "patchAvailable"]), multiple=True, help=u"""Filter by one or more severity types. Possible values are upToDate, patchAvailable""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'VulnerabilityResourceCollection'})
@cli_util.wrap_exceptions
def list_vulnerability_resources(ctx, from_json, all_pages, page_size, compartment_id, limit, page, sort_order, sort_by, display_name, lifecycle_state, database_release, cve_id, severity_type, patch_recommendation):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if database_release is not None:
        kwargs['database_release'] = database_release
    if cve_id is not None:
        kwargs['cve_id'] = cve_id
    if severity_type is not None and len(severity_type) > 0:
        kwargs['severity_type'] = severity_type
    if patch_recommendation is not None and len(patch_recommendation) > 0:
        kwargs['patch_recommendation'] = patch_recommendation
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_vulnerability_resources,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_vulnerability_resources,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_vulnerability_resources(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@vulnerability_scan_collection_group.command(name=cli_util.override('dblm.list_vulnerability_scans.command_name', 'list-vulnerability-scans'), help=u"""Gets a list of VulnerabilityScans. \n[Command Reference](listVulnerabilityScans)""")
@cli_util.option('--vulnerability-scan-id', help=u"""The ID of the vulnerability scan.""")
@cli_util.option('--compartment-id', help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["id", "displayName", "timeCreated", "timeEnded"]), help=u"""The field to sort by. Only one sort order may be provided. Default order is descending.""")
@cli_util.option('--time-created-greater-than', type=custom_types.CLI_DATETIME, help=u"""The created greater than.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-ended-less-than', type=custom_types.CLI_DATETIME, help=u"""The time ended less than.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--vulnerability-scan-status', type=custom_types.CliCaseInsensitiveChoice(["COMPLETED", "ERROR", "RUNNING", "ABORTED"]), multiple=True, help=u"""Filter by one or more vulnerability scan status. Possible values are completed, running, completed with error, aborted.""")
@cli_util.option('--vulnerability-scan-type', type=custom_types.CliCaseInsensitiveChoice(["CVE", "PATCH", "IMAGE_PATCH"]), help=u"""The scan type to use is 'CVE', 'PATCH' or 'IMAGE_PATCH'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'VulnerabilityScanCollection'})
@cli_util.wrap_exceptions
def list_vulnerability_scans(ctx, from_json, all_pages, page_size, vulnerability_scan_id, compartment_id, display_name, limit, page, sort_order, sort_by, time_created_greater_than, time_ended_less_than, vulnerability_scan_status, vulnerability_scan_type):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if vulnerability_scan_id is not None:
        kwargs['vulnerability_scan_id'] = vulnerability_scan_id
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if time_created_greater_than is not None:
        kwargs['time_created_greater_than'] = time_created_greater_than
    if time_ended_less_than is not None:
        kwargs['time_ended_less_than'] = time_ended_less_than
    if vulnerability_scan_status is not None and len(vulnerability_scan_status) > 0:
        kwargs['vulnerability_scan_status'] = vulnerability_scan_status
    if vulnerability_scan_type is not None:
        kwargs['vulnerability_scan_type'] = vulnerability_scan_type
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_vulnerability_scans,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_vulnerability_scans,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_vulnerability_scans(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_error_group.command(name=cli_util.override('dblm.list_work_request_errors.command_name', 'list'), help=u"""Returns a (paginated) list of errors for the work request with the given ID. \n[Command Reference](listWorkRequestErrors)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timestamp"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timestamp is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'WorkRequestErrorCollection'})
@cli_util.wrap_exceptions
def list_work_request_errors(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_errors,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_errors,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_errors(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_log_entry_group.command(name=cli_util.override('dblm.list_work_request_logs.command_name', 'list-work-request-logs'), help=u"""Returns a (paginated) list of logs for the work request with the given ID. \n[Command Reference](listWorkRequestLogs)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timestamp"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timestamp is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'WorkRequestLogEntryCollection'})
@cli_util.wrap_exceptions
def list_work_request_logs(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_logs,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_logs,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_logs(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('dblm.list_work_requests.command_name', 'list'), help=u"""Lists the work requests in a compartment. \n[Command Reference](listWorkRequests)""")
@cli_util.option('--compartment-id', help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--work-request-id', help=u"""The ID of the asynchronous work request.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), help=u"""A filter to return only resources their lifecycleState matches the given OperationStatus.""")
@cli_util.option('--resource-id', help=u"""The ID of the resource affected by the work request.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeAccepted"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeAccepted is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'dblm', 'class': 'WorkRequestSummaryCollection'})
@cli_util.wrap_exceptions
def list_work_requests(ctx, from_json, all_pages, page_size, compartment_id, work_request_id, status, resource_id, page, limit, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if work_request_id is not None:
        kwargs['work_request_id'] = work_request_id
    if status is not None:
        kwargs['status'] = status
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('dblm', 'db_life_cycle_management', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_requests,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_requests,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_work_requests(
            **kwargs
        )
    cli_util.render_response(result, ctx)
