# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.wlms.src.oci_cli_wlms.generated import wlms_service_cli


@click.command(cli_util.override('weblogic_management_service.weblogic_management_service_root_group.command_name', 'weblogic-management-service'), cls=CommandGroupWithAlias, help=cli_util.override('weblogic_management_service.weblogic_management_service_root_group.help', """WebLogic Management Service is an OCI service that enables a unified view and management of WebLogic domains
in Oracle Cloud Infrastructure. Features include on-demand patching of WebLogic domains, rollback of the
last applied patch, discovery and management of WebLogic instances on a compute host."""), short_help=cli_util.override('weblogic_management_service.weblogic_management_service_root_group.short_help', """WebLogic Management Service API"""))
@cli_util.help_option_group
def weblogic_management_service_root_group():
    pass


@click.command(cli_util.override('weblogic_management_service.resource_inventory_group.command_name', 'resource-inventory'), cls=CommandGroupWithAlias, help="""The inventory of WebLogic domains and managed instances in the selected compartment.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def resource_inventory_group():
    pass


@click.command(cli_util.override('weblogic_management_service.agreement_group.command_name', 'agreement'), cls=CommandGroupWithAlias, help="""The terms of use agreement which must be accepted prior to accessing certain product features.""")
@cli_util.help_option_group
def agreement_group():
    pass


@click.command(cli_util.override('weblogic_management_service.managed_instance_group.command_name', 'managed-instance'), cls=CommandGroupWithAlias, help="""A managed instance has an agent with the WebLogic Management Service plugin running.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def managed_instance_group():
    pass


@click.command(cli_util.override('weblogic_management_service.wls_domain_group.command_name', 'wls-domain'), cls=CommandGroupWithAlias, help="""WLSDomain is representative of a WebLogic Domain running on one or more managed instances.

To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def wls_domain_group():
    pass


@click.command(cli_util.override('weblogic_management_service.required_policy_collection_group.command_name', 'required-policy-collection'), cls=CommandGroupWithAlias, help="""Result of list RequiredPolicies.""")
@cli_util.help_option_group
def required_policy_collection_group():
    pass


@click.command(cli_util.override('weblogic_management_service.work_request_group.command_name', 'work-request'), cls=CommandGroupWithAlias, help="""An asynchronous work request. Work requests help you monitor long-running operations. When you start a long-running operation, the service creates a work request. A work request is an activity log that lets you track each step in the operation's progress. Each work request has an OCID that lets you interact with it programmatically and use it for automation.""")
@cli_util.help_option_group
def work_request_group():
    pass


wlms_service_cli.wlms_service_group.add_command(weblogic_management_service_root_group)
weblogic_management_service_root_group.add_command(resource_inventory_group)
weblogic_management_service_root_group.add_command(agreement_group)
weblogic_management_service_root_group.add_command(managed_instance_group)
weblogic_management_service_root_group.add_command(wls_domain_group)
weblogic_management_service_root_group.add_command(required_policy_collection_group)
weblogic_management_service_root_group.add_command(work_request_group)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.change_wls_domain_compartment.command_name', 'change-compartment'), help=u"""Moves a WebLogic domain into a different compartment within the same tenancy. \n[Command Reference](changeWlsDomainCompartment)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the WebLogic domain should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_wls_domain_compartment(ctx, from_json, wls_domain_id, compartment_id, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.change_wls_domain_compartment(
        wls_domain_id=wls_domain_id,
        change_wls_domain_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.create_agreement_record.command_name', 'create-agreement-record'), help=u"""Creates a terms of use agreement record for a WebLogic domain. \n[Command Reference](createAgreementRecord)""")
@cli_util.option('--agreement-uuid', required=True, help=u"""The ID of the agreement to accept.""")
@cli_util.option('--agreement-signature', required=True, help=u"""The agreement signature.""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'AgreementRecord'})
@cli_util.wrap_exceptions
def create_agreement_record(ctx, from_json, agreement_uuid, agreement_signature, wls_domain_id, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['agreementUuid'] = agreement_uuid
    _details['agreementSignature'] = agreement_signature

    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.create_agreement_record(
        wls_domain_id=wls_domain_id,
        create_agreement_record_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.delete_wls_domain.command_name', 'delete'), help=u"""Delete the WebLogic domain. \n[Command Reference](deleteWlsDomain)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_wls_domain(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, wls_domain_id, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.delete_wls_domain(
        wls_domain_id=wls_domain_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_wls_domain') and callable(getattr(client, 'get_wls_domain')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_wls_domain(wls_domain_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@agreement_group.command(name=cli_util.override('weblogic_management_service.get_agreement.command_name', 'get'), help=u"""Returns the terms and conditions of use agreement. \n[Command Reference](getAgreement)""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'Agreement'})
@cli_util.wrap_exceptions
def get_agreement(ctx, from_json, ):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.get_agreement(
        **kwargs
    )
    cli_util.render_response(result, ctx)


@managed_instance_group.command(name=cli_util.override('weblogic_management_service.get_managed_instance.command_name', 'get'), help=u"""Gets information about the specified managed instance. \n[Command Reference](getManagedInstance)""")
@cli_util.option('--managed-instance-id', required=True, help=u"""The [OCID] of the instance.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'ManagedInstance'})
@cli_util.wrap_exceptions
def get_managed_instance(ctx, from_json, managed_instance_id):

    if isinstance(managed_instance_id, six.string_types) and len(managed_instance_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-instance-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.get_managed_instance(
        managed_instance_id=managed_instance_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@managed_instance_group.command(name=cli_util.override('weblogic_management_service.get_managed_instance_server.command_name', 'get-managed-instance-server'), help=u"""Gets information about the specified server in a managed instance. \n[Command Reference](getManagedInstanceServer)""")
@cli_util.option('--managed-instance-id', required=True, help=u"""The [OCID] of the instance.""")
@cli_util.option('--server-id', required=True, help=u"""The unique identifier of a server.

**Note:** Not an [OCID].""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'Server'})
@cli_util.wrap_exceptions
def get_managed_instance_server(ctx, from_json, managed_instance_id, server_id):

    if isinstance(managed_instance_id, six.string_types) and len(managed_instance_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-instance-id cannot be whitespace or empty string')

    if isinstance(server_id, six.string_types) and len(server_id.strip()) == 0:
        raise click.UsageError('Parameter --server-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.get_managed_instance_server(
        managed_instance_id=managed_instance_id,
        server_id=server_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.get_wls_domain.command_name', 'get'), help=u"""Gets a specific WebLogic domain. \n[Command Reference](getWlsDomain)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'WlsDomain'})
@cli_util.wrap_exceptions
def get_wls_domain(ctx, from_json, wls_domain_id):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.get_wls_domain(
        wls_domain_id=wls_domain_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.get_wls_domain_credential.command_name', 'get-wls-domain-credential'), help=u"""Gets WebLogic and Node Manager credentials of a specific WebLogic domain. \n[Command Reference](getWlsDomainCredential)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--credential-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["weblogicAdminUser", "nodemanagerUser"]), help=u"""The type of the credentials.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'WlsDomainCredential'})
@cli_util.wrap_exceptions
def get_wls_domain_credential(ctx, from_json, wls_domain_id, credential_type):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    if isinstance(credential_type, six.string_types) and len(credential_type.strip()) == 0:
        raise click.UsageError('Parameter --credential-type cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.get_wls_domain_credential(
        wls_domain_id=wls_domain_id,
        credential_type=credential_type,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.get_wls_domain_server.command_name', 'get-wls-domain-server'), help=u"""Gets information about the specified server in a WebLogic domain. \n[Command Reference](getWlsDomainServer)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--server-id', required=True, help=u"""The unique identifier of a server.

**Note:** Not an [OCID].""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'Server'})
@cli_util.wrap_exceptions
def get_wls_domain_server(ctx, from_json, wls_domain_id, server_id):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    if isinstance(server_id, six.string_types) and len(server_id.strip()) == 0:
        raise click.UsageError('Parameter --server-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.get_wls_domain_server(
        wls_domain_id=wls_domain_id,
        server_id=server_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.get_wls_domain_server_backup.command_name', 'get-wls-domain-server-backup'), help=u"""Get details of specific backup for the WebLogic Domain. \n[Command Reference](getWlsDomainServerBackup)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--server-id', required=True, help=u"""The unique identifier of a server.

**Note:** Not an [OCID].""")
@cli_util.option('--backup-id', required=True, help=u"""The unique identifier of the backup.

**Note:** Not an [OCID].""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'Backup'})
@cli_util.wrap_exceptions
def get_wls_domain_server_backup(ctx, from_json, wls_domain_id, server_id, backup_id):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    if isinstance(server_id, six.string_types) and len(server_id.strip()) == 0:
        raise click.UsageError('Parameter --server-id cannot be whitespace or empty string')

    if isinstance(backup_id, six.string_types) and len(backup_id.strip()) == 0:
        raise click.UsageError('Parameter --backup-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.get_wls_domain_server_backup(
        wls_domain_id=wls_domain_id,
        server_id=server_id,
        backup_id=backup_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.get_wls_domain_server_backup_content.command_name', 'get-wls-domain-server-backup-content'), help=u"""Get details of specific backup for the WebLogic Domain. \n[Command Reference](getWlsDomainServerBackupContent)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--server-id', required=True, help=u"""The unique identifier of a server.

**Note:** Not an [OCID].""")
@cli_util.option('--backup-id', required=True, help=u"""The unique identifier of the backup.

**Note:** Not an [OCID].""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'BackupContent'})
@cli_util.wrap_exceptions
def get_wls_domain_server_backup_content(ctx, from_json, wls_domain_id, server_id, backup_id):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    if isinstance(server_id, six.string_types) and len(server_id.strip()) == 0:
        raise click.UsageError('Parameter --server-id cannot be whitespace or empty string')

    if isinstance(backup_id, six.string_types) and len(backup_id.strip()) == 0:
        raise click.UsageError('Parameter --backup-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.get_wls_domain_server_backup_content(
        wls_domain_id=wls_domain_id,
        server_id=server_id,
        backup_id=backup_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('weblogic_management_service.get_work_request.command_name', 'get'), help=u"""Gets the details of a work request. \n[Command Reference](getWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The [OCID] of the asynchronous work request.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'WorkRequest'})
@cli_util.wrap_exceptions
def get_work_request(ctx, from_json, work_request_id):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.get_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.install_latest_patches_on_wls_domain.command_name', 'install-latest-patches'), help=u"""Install the latest patches on a WebLogic domain. \n[Command Reference](installLatestPatchesOnWlsDomain)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--is-force-servers-shutdown', type=click.BOOL, help=u"""When installing or uninstalling patches, forces shutdown of the servers if they have not shutdown after a period of time. The timeout can be configured in the WebLogic domain configuration.""")
@cli_util.option('--must-include-domains-sharing-middleware', type=click.BOOL, help=u"""When installing or uninstalling patches, allows the operation to proceed on all domains that share the same middleware. If not set to true, the installation or uninstallation will fail if there is any other domain using the same middleware.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def install_latest_patches_on_wls_domain(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, wls_domain_id, is_force_servers_shutdown, must_include_domains_sharing_middleware, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if is_force_servers_shutdown is not None:
        _details['isForceServersShutdown'] = is_force_servers_shutdown

    if must_include_domains_sharing_middleware is not None:
        _details['mustIncludeDomainsSharingMiddleware'] = must_include_domains_sharing_middleware

    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.install_latest_patches_on_wls_domain(
        wls_domain_id=wls_domain_id,
        install_latest_patches_on_wls_domain_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.list_agreement_records.command_name', 'list-agreement-records'), help=u"""List the terms of use agreement record for the WebLogic domain. \n[Command Reference](listAgreementRecords)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _timeCreated_ is **descending**. Default order for _displayName_ is **ascending**. If no value is specified, _timeCreated_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'AgreementRecordCollection'})
@cli_util.wrap_exceptions
def list_agreement_records(ctx, from_json, all_pages, page_size, wls_domain_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_agreement_records,
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_agreement_records,
            limit,
            page_size,
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    else:
        result = client.list_agreement_records(
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.list_applicable_patches.command_name', 'list-applicable-patches'), help=u"""Gets the latest patches that can be installed to the WebLogic domains. \n[Command Reference](listApplicablePatches)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["displayName"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _displayName_ is **ascending**. If no value is specified, _displayName_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'ApplicablePatchCollection'})
@cli_util.wrap_exceptions
def list_applicable_patches(ctx, from_json, all_pages, page_size, wls_domain_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_applicable_patches,
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_applicable_patches,
            limit,
            page_size,
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    else:
        result = client.list_applicable_patches(
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@managed_instance_group.command(name=cli_util.override('weblogic_management_service.list_managed_instance_scan_results.command_name', 'list-managed-instance-scan-results'), help=u"""Gets all the scan results for all WebLogic servers in the managed instance. \n[Command Reference](listManagedInstanceScanResults)""")
@cli_util.option('--managed-instance-id', required=True, help=u"""The [OCID] of the instance.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeOfServerCheck", "serverName"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _timeOfServerCheck_ is **descending**. Default order for _serverName_ is **ascending**. If no value is specified, _timeOfServerCheck_ is default.""")
@cli_util.option('--wls-domain-id', help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--server-name', help=u"""The name of the server.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'ScanResultCollection'})
@cli_util.wrap_exceptions
def list_managed_instance_scan_results(ctx, from_json, all_pages, page_size, managed_instance_id, limit, page, sort_order, sort_by, wls_domain_id, server_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(managed_instance_id, six.string_types) and len(managed_instance_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-instance-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if wls_domain_id is not None:
        kwargs['wls_domain_id'] = wls_domain_id
    if server_name is not None:
        kwargs['server_name'] = server_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_managed_instance_scan_results,
            managed_instance_id=managed_instance_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_managed_instance_scan_results,
            limit,
            page_size,
            managed_instance_id=managed_instance_id,
            **kwargs
        )
    else:
        result = client.list_managed_instance_scan_results(
            managed_instance_id=managed_instance_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@managed_instance_group.command(name=cli_util.override('weblogic_management_service.list_managed_instance_server_installed_patches.command_name', 'list-managed-instance-server-installed-patches'), help=u"""Gets a list of installed patches on a server in a managed instance. \n[Command Reference](listManagedInstanceServerInstalledPatches)""")
@cli_util.option('--managed-instance-id', required=True, help=u"""The [OCID] of the instance.""")
@cli_util.option('--server-id', required=True, help=u"""The unique identifier of a server.

**Note:** Not an [OCID].""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["displayName"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _displayName_ is **ascending**. If no value is specified, _displayName_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'InstalledPatchCollection'})
@cli_util.wrap_exceptions
def list_managed_instance_server_installed_patches(ctx, from_json, all_pages, page_size, managed_instance_id, server_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(managed_instance_id, six.string_types) and len(managed_instance_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-instance-id cannot be whitespace or empty string')

    if isinstance(server_id, six.string_types) and len(server_id.strip()) == 0:
        raise click.UsageError('Parameter --server-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_managed_instance_server_installed_patches,
            managed_instance_id=managed_instance_id,
            server_id=server_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_managed_instance_server_installed_patches,
            limit,
            page_size,
            managed_instance_id=managed_instance_id,
            server_id=server_id,
            **kwargs
        )
    else:
        result = client.list_managed_instance_server_installed_patches(
            managed_instance_id=managed_instance_id,
            server_id=server_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@managed_instance_group.command(name=cli_util.override('weblogic_management_service.list_managed_instance_servers.command_name', 'list-managed-instance-servers'), help=u"""Gets list of servers in a specific managed instance. \n[Command Reference](listManagedInstanceServers)""")
@cli_util.option('--managed-instance-id', required=True, help=u"""The [OCID] of the instance.""")
@cli_util.option('--name', help=u"""The name of the resource.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "name"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _timeCreated_ is **descending**. Default order for _name_ is **ascending**. If no value is specified, _timeCreated_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'ServerCollection'})
@cli_util.wrap_exceptions
def list_managed_instance_servers(ctx, from_json, all_pages, page_size, managed_instance_id, name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(managed_instance_id, six.string_types) and len(managed_instance_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-instance-id cannot be whitespace or empty string')

    kwargs = {}
    if name is not None:
        kwargs['name'] = name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_managed_instance_servers,
            managed_instance_id=managed_instance_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_managed_instance_servers,
            limit,
            page_size,
            managed_instance_id=managed_instance_id,
            **kwargs
        )
    else:
        result = client.list_managed_instance_servers(
            managed_instance_id=managed_instance_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@managed_instance_group.command(name=cli_util.override('weblogic_management_service.list_managed_instances.command_name', 'list'), help=u"""Lists managed instances that match the specified compartment or managed instance OCID. Filter the list against a variety of criteria including but not limited to its name, status and compartment. \n[Command Reference](listManagedInstances)""")
@cli_util.option('--compartment-id', help=u"""The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.""")
@cli_util.option('--display-name', help=u"""The display name.""")
@cli_util.option('--id', help=u"""The [OCID] of the instance.""")
@cli_util.option('--plugin-status', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), help=u"""The plugin status of the managed instance.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _timeCreated_ is **descending**. Default order for _displayName_ is **ascending**. If no value is specified, _timeCreated_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'ManagedInstanceCollection'})
@cli_util.wrap_exceptions
def list_managed_instances(ctx, from_json, all_pages, page_size, compartment_id, display_name, id, plugin_status, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if plugin_status is not None:
        kwargs['plugin_status'] = plugin_status
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_managed_instances,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_managed_instances,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_managed_instances(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@required_policy_collection_group.command(name=cli_util.override('weblogic_management_service.list_required_policies.command_name', 'list-required-policies'), help=u"""Gets all the required policies for the WebLogic Management Service. \n[Command Reference](listRequiredPolicies)""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'RequiredPolicyCollection'})
@cli_util.wrap_exceptions
def list_required_policies(ctx, from_json, all_pages, ):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.list_required_policies(
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.list_wls_domain_credentials.command_name', 'list-wls-domain-credentials'), help=u"""Gets domain credentials of a specific domain. \n[Command Reference](listWlsDomainCredentials)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'WlsDomainCredentialCollection'})
@cli_util.wrap_exceptions
def list_wls_domain_credentials(ctx, from_json, all_pages, wls_domain_id):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.list_wls_domain_credentials(
        wls_domain_id=wls_domain_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.list_wls_domain_scan_results.command_name', 'list-wls-domain-scan-results'), help=u"""Get all scan results for a server in a specific WebLogic domain. \n[Command Reference](listWlsDomainScanResults)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--server-name', help=u"""The name of the server.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeOfServerCheck", "serverName"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _timeOfServerCheck_ is **descending**. Default order for _serverName_ is **ascending**. If no value is specified, _timeOfServerCheck_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'ScanResultCollection'})
@cli_util.wrap_exceptions
def list_wls_domain_scan_results(ctx, from_json, all_pages, page_size, wls_domain_id, server_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if server_name is not None:
        kwargs['server_name'] = server_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_wls_domain_scan_results,
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_wls_domain_scan_results,
            limit,
            page_size,
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    else:
        result = client.list_wls_domain_scan_results(
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.list_wls_domain_server_backups.command_name', 'list-wls-domain-server-backups'), help=u"""Gets a list of backups for the server of a specific WebLogic Domain. \n[Command Reference](listWlsDomainServerBackups)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--server-id', required=True, help=u"""The unique identifier of a server.

**Note:** Not an [OCID].""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for timeCreated is **descending**. If no value is specified, timeCreated is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'BackupCollection'})
@cli_util.wrap_exceptions
def list_wls_domain_server_backups(ctx, from_json, all_pages, page_size, wls_domain_id, server_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    if isinstance(server_id, six.string_types) and len(server_id.strip()) == 0:
        raise click.UsageError('Parameter --server-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_wls_domain_server_backups,
            wls_domain_id=wls_domain_id,
            server_id=server_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_wls_domain_server_backups,
            limit,
            page_size,
            wls_domain_id=wls_domain_id,
            server_id=server_id,
            **kwargs
        )
    else:
        result = client.list_wls_domain_server_backups(
            wls_domain_id=wls_domain_id,
            server_id=server_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.list_wls_domain_server_installed_patches.command_name', 'list-wls-domain-server-installed-patches'), help=u"""Gets a list of installed patches on a server for a domain. \n[Command Reference](listWlsDomainServerInstalledPatches)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--server-id', required=True, help=u"""The unique identifier of a server.

**Note:** Not an [OCID].""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["displayName"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _displayName_ is **ascending**. If no value is specified, _displayName_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'InstalledPatchCollection'})
@cli_util.wrap_exceptions
def list_wls_domain_server_installed_patches(ctx, from_json, all_pages, page_size, wls_domain_id, server_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    if isinstance(server_id, six.string_types) and len(server_id.strip()) == 0:
        raise click.UsageError('Parameter --server-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_wls_domain_server_installed_patches,
            wls_domain_id=wls_domain_id,
            server_id=server_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_wls_domain_server_installed_patches,
            limit,
            page_size,
            wls_domain_id=wls_domain_id,
            server_id=server_id,
            **kwargs
        )
    else:
        result = client.list_wls_domain_server_installed_patches(
            wls_domain_id=wls_domain_id,
            server_id=server_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.list_wls_domain_servers.command_name', 'list-wls-domain-servers'), help=u"""Gets list of servers in a specific WebLogic domain. \n[Command Reference](listWlsDomainServers)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--name', help=u"""The name of the resource.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "name"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _timeCreated_ is **descending**. Default order for _name_ is **ascending**. If no value is specified, _timeCreated_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'ServerCollection'})
@cli_util.wrap_exceptions
def list_wls_domain_servers(ctx, from_json, all_pages, page_size, wls_domain_id, name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if name is not None:
        kwargs['name'] = name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_wls_domain_servers,
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_wls_domain_servers,
            limit,
            page_size,
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    else:
        result = client.list_wls_domain_servers(
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.list_wls_domains.command_name', 'list'), help=u"""Gets all WebLogic domains in a given compartment. \n[Command Reference](listWlsDomains)""")
@cli_util.option('--compartment-id', help=u"""The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING"]), help=u"""A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.""")
@cli_util.option('--display-name', help=u"""The display name.""")
@cli_util.option('--id', help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--weblogic-version', type=custom_types.CliCaseInsensitiveChoice(["v12.2.1.4", "v14.1.1.0", "v14.1.2.0"]), help=u"""A filter to return WebLogic domains based on the WebLogic version.""")
@cli_util.option('--middleware-type', type=custom_types.CliCaseInsensitiveChoice(["FMW", "WLS"]), help=u"""A filter to return WebLogic domains based on the type of middleware of the WebLogic domain.""")
@cli_util.option('--patch-readiness-status', type=custom_types.CliCaseInsensitiveChoice(["OK", "WARNING", "ERROR", "UNKNOWN"]), help=u"""A filter to return domains based on the patch readiness status.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _timeCreated_ is **descending**. Default order for _displayName_ is **ascending**. If no value is specified, _timeCreated_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'WlsDomainCollection'})
@cli_util.wrap_exceptions
def list_wls_domains(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, id, weblogic_version, middleware_type, patch_readiness_status, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if weblogic_version is not None:
        kwargs['weblogic_version'] = weblogic_version
    if middleware_type is not None:
        kwargs['middleware_type'] = middleware_type
    if patch_readiness_status is not None:
        kwargs['patch_readiness_status'] = patch_readiness_status
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_wls_domains,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_wls_domains,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_wls_domains(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.list_wls_domains_sharing_middlewares.command_name', 'list-wls-domains-sharing-middlewares'), help=u"""Gets a list of WebLogic domains that share middleware with a specific domain. \n[Command Reference](listWlsDomainsSharingMiddlewares)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field by which to sort the resource. Only one sort order may be provided. Default order for _timeCreated_ is **descending**. Default order for _displayName_ is **ascending**. If no value is specified, _timeCreated_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'WlsDomainCollection'})
@cli_util.wrap_exceptions
def list_wls_domains_sharing_middlewares(ctx, from_json, all_pages, page_size, wls_domain_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_wls_domains_sharing_middlewares,
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_wls_domains_sharing_middlewares,
            limit,
            page_size,
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    else:
        result = client.list_wls_domains_sharing_middlewares(
            wls_domain_id=wls_domain_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('weblogic_management_service.list_work_request_errors.command_name', 'list-work-request-errors'), help=u"""Lists the errors for a work request. \n[Command Reference](listWorkRequestErrors)""")
@cli_util.option('--work-request-id', required=True, help=u"""The [OCID] of the asynchronous work request.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timestamp"]), help=u"""The field to sort by. Default order for `timestamp` is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'WorkRequestErrorCollection'})
@cli_util.wrap_exceptions
def list_work_request_errors(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_errors,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_errors,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_errors(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('weblogic_management_service.list_work_request_logs.command_name', 'list-work-request-logs'), help=u"""Lists the logs for a work request. \n[Command Reference](listWorkRequestLogs)""")
@cli_util.option('--work-request-id', required=True, help=u"""The [OCID] of the asynchronous work request.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timestamp"]), help=u"""The field to sort by. Default order for `timestamp` is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'WorkRequestLogEntryCollection'})
@cli_util.wrap_exceptions
def list_work_request_logs(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_logs,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_logs,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_logs(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('weblogic_management_service.list_work_requests.command_name', 'list'), help=u"""Lists the work requests in a compartment. \n[Command Reference](listWorkRequests)""")
@cli_util.option('--compartment-id', help=u"""The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.""")
@cli_util.option('--work-request-id', help=u"""The [OCID] of the asynchronous work request.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), help=u"""A filter to return only the resources that match the given lifecycle state.""")
@cli_util.option('--resource-id', help=u"""The [OCID] of the resource affected by the work request.""")
@cli_util.option('--page', help=u"""The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order is either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeAccepted"]), help=u"""The field to sort by. Default order for `timeAccepted` is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'WorkRequestSummaryCollection'})
@cli_util.wrap_exceptions
def list_work_requests(ctx, from_json, all_pages, page_size, compartment_id, work_request_id, status, resource_id, page, limit, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if work_request_id is not None:
        kwargs['work_request_id'] = work_request_id
    if status is not None:
        kwargs['status'] = status
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_requests,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_requests,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_work_requests(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.restart_wls_domain.command_name', 'restart'), help=u"""Restarts all the servers in the WebLogic domains. Servers that are already stopped are ignored. \n[Command Reference](restartWlsDomain)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--is-force-servers-shutdown', type=click.BOOL, help=u"""Force shutdown of the servers if they have not shutdown after a period of time. The timeout can be configured in the WebLogic domain configuration.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def restart_wls_domain(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, wls_domain_id, is_force_servers_shutdown, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if is_force_servers_shutdown is not None:
        _details['isForceServersShutdown'] = is_force_servers_shutdown

    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.restart_wls_domain(
        wls_domain_id=wls_domain_id,
        restart_wls_domain_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.restore_wls_domain.command_name', 'restore'), help=u"""Restore a domain from backup. If the backup contains a MIDDLEWARE asset, then the middleware of the domain, including patches, will be restored. \n[Command Reference](restoreWlsDomain)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--is-force-servers-shutdown', type=click.BOOL, help=u"""If the restore operation required to stop the servers, this option indicates to force shutdown of the servers if they have not shutdown after a period of time. The timeout can be configured in the WebLogic domain configuration.""")
@cli_util.option('--must-include-domains-sharing-middleware', type=click.BOOL, help=u"""If the WebLogic Domain being restored shares middleware with other domains, and the restore operation will restore servers in the other domains, this option allows the operation to proceed on all domains that share the same middleware. If not set to true, the restore operation will fail if there is any other domain using the same middleware.""")
@cli_util.option('--servers-to-restore', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of servers to restore and the backups

This option is a JSON list with items of type ServerToRestore.  For documentation on ServerToRestore please see our API reference: https://docs.cloud.oracle.com/api/#/en/weblogicmanagementservice/20241101/datatypes/ServerToRestore.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'servers-to-restore': {'module': 'wlms', 'class': 'list[ServerToRestore]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'servers-to-restore': {'module': 'wlms', 'class': 'list[ServerToRestore]'}})
@cli_util.wrap_exceptions
def restore_wls_domain(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, wls_domain_id, is_force_servers_shutdown, must_include_domains_sharing_middleware, servers_to_restore, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if is_force_servers_shutdown is not None:
        _details['isForceServersShutdown'] = is_force_servers_shutdown

    if must_include_domains_sharing_middleware is not None:
        _details['mustIncludeDomainsSharingMiddleware'] = must_include_domains_sharing_middleware

    if servers_to_restore is not None:
        _details['serversToRestore'] = cli_util.parse_json_parameter("servers_to_restore", servers_to_restore)

    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.restore_wls_domain(
        wls_domain_id=wls_domain_id,
        restore_wls_domain_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@managed_instance_group.command(name=cli_util.override('weblogic_management_service.scan_managed_instance.command_name', 'scan'), help=u"""Scans a managed instance for WebLogic domains. \n[Command Reference](scanManagedInstance)""")
@cli_util.option('--managed-instance-id', required=True, help=u"""The [OCID] of the instance.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def scan_managed_instance(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, managed_instance_id, if_match):

    if isinstance(managed_instance_id, six.string_types) and len(managed_instance_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-instance-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.scan_managed_instance(
        managed_instance_id=managed_instance_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.scan_wls_domain.command_name', 'scan'), help=u"""Runs a series of checks in the WebLogic domain. \n[Command Reference](scanWlsDomain)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def scan_wls_domain(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, wls_domain_id, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.scan_wls_domain(
        wls_domain_id=wls_domain_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.set_restart_order.command_name', 'set-restart-order'), help=u"""Sets restart order of servers in specific WebLogic domain. \n[Command Reference](setRestartOrder)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--servers', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@json_skeleton_utils.get_cli_json_input_option({'servers': {'module': 'wlms', 'class': 'SetRestartOrderServerCollection'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'servers': {'module': 'wlms', 'class': 'SetRestartOrderServerCollection'}}, output_type={'module': 'wlms', 'class': 'ServerCollection'})
@cli_util.wrap_exceptions
def set_restart_order(ctx, from_json, wls_domain_id, servers, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['servers'] = cli_util.parse_json_parameter("servers", servers)

    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.set_restart_order(
        wls_domain_id=wls_domain_id,
        set_restart_order_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.start_wls_domain.command_name', 'start'), help=u"""Starts all the servers in the WebLogic domain. Servers that are already started are ignored. \n[Command Reference](startWlsDomain)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def start_wls_domain(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, wls_domain_id, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.start_wls_domain(
        wls_domain_id=wls_domain_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.stop_wls_domain.command_name', 'stop'), help=u"""Stops all the servers in the WebLogic domain. Servers that are already stopped are ignored. \n[Command Reference](stopWlsDomain)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--is-force-servers-shutdown', type=click.BOOL, help=u"""Force shutdown of the servers if they have not shutdown after a period of time. The timeout can be configured in the WebLogic domain configuration.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def stop_wls_domain(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, wls_domain_id, is_force_servers_shutdown, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if is_force_servers_shutdown is not None:
        _details['isForceServersShutdown'] = is_force_servers_shutdown

    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.stop_wls_domain(
        wls_domain_id=wls_domain_id,
        stop_wls_domain_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@resource_inventory_group.command(name=cli_util.override('weblogic_management_service.summarize_resource_inventory.command_name', 'summarize'), help=u"""Gets the data to be shown in the Overview page of the service in a given compartment. \n[Command Reference](summarizeResourceInventory)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'ResourceInventory'})
@cli_util.wrap_exceptions
def summarize_resource_inventory(ctx, from_json, compartment_id):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.summarize_resource_inventory(
        compartment_id=compartment_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@managed_instance_group.command(name=cli_util.override('weblogic_management_service.update_managed_instance.command_name', 'update'), help=u"""Updates the specified managed instance information, such as discovery interval and domain search path. \n[Command Reference](updateManagedInstance)""")
@cli_util.option('--managed-instance-id', required=True, help=u"""The [OCID] of the instance.""")
@cli_util.option('--configuration', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'configuration': {'module': 'wlms', 'class': 'UpdateManagedInstanceConfigurationDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'configuration': {'module': 'wlms', 'class': 'UpdateManagedInstanceConfigurationDetails'}}, output_type={'module': 'wlms', 'class': 'ManagedInstance'})
@cli_util.wrap_exceptions
def update_managed_instance(ctx, from_json, force, managed_instance_id, configuration, if_match):

    if isinstance(managed_instance_id, six.string_types) and len(managed_instance_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-instance-id cannot be whitespace or empty string')
    if not force:
        if configuration:
            if not click.confirm("WARNING: Updates to configuration will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if configuration is not None:
        _details['configuration'] = cli_util.parse_json_parameter("configuration", configuration)

    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.update_managed_instance(
        managed_instance_id=managed_instance_id,
        update_managed_instance_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.update_wls_domain.command_name', 'update'), help=u"""Updates a specific WebLogic domain. \n[Command Reference](updateWlsDomain)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--configuration', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'configuration': {'module': 'wlms', 'class': 'UpdateWlsDomainConfigurationDetails'}, 'defined-tags': {'module': 'wlms', 'class': 'dict(str, dict(str, object))'}, 'freeform-tags': {'module': 'wlms', 'class': 'dict(str, string)'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'configuration': {'module': 'wlms', 'class': 'UpdateWlsDomainConfigurationDetails'}, 'defined-tags': {'module': 'wlms', 'class': 'dict(str, dict(str, object))'}, 'freeform-tags': {'module': 'wlms', 'class': 'dict(str, string)'}}, output_type={'module': 'wlms', 'class': 'WlsDomain'})
@cli_util.wrap_exceptions
def update_wls_domain(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, wls_domain_id, configuration, defined_tags, freeform_tags, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')
    if not force:
        if configuration or defined_tags or freeform_tags:
            if not click.confirm("WARNING: Updates to configuration and defined-tags and freeform-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if configuration is not None:
        _details['configuration'] = cli_util.parse_json_parameter("configuration", configuration)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.update_wls_domain(
        wls_domain_id=wls_domain_id,
        update_wls_domain_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_wls_domain') and callable(getattr(client, 'get_wls_domain')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_wls_domain(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@wls_domain_group.command(name=cli_util.override('weblogic_management_service.update_wls_domain_credential.command_name', 'update-wls-domain-credential'), help=u"""Updates WebLogic domain credentials of specific WebLogic domain. \n[Command Reference](updateWlsDomainCredential)""")
@cli_util.option('--wls-domain-id', required=True, help=u"""The [OCID] of the WebLogic domain.""")
@cli_util.option('--credential-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["weblogicAdminUser", "nodemanagerUser"]), help=u"""The type of the credentials.""")
@cli_util.option('--strategy', help=u"""The strategy for passing new WebLogic credential.""")
@cli_util.option('--user-secret-id', help=u"""The OCID for WebLogic user secret.""")
@cli_util.option('--password-secret-id', help=u"""The OCID for WebLogic password secret.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'wlms', 'class': 'WlsDomainCredential'})
@cli_util.wrap_exceptions
def update_wls_domain_credential(ctx, from_json, wls_domain_id, credential_type, strategy, user_secret_id, password_secret_id, if_match):

    if isinstance(wls_domain_id, six.string_types) and len(wls_domain_id.strip()) == 0:
        raise click.UsageError('Parameter --wls-domain-id cannot be whitespace or empty string')

    if isinstance(credential_type, six.string_types) and len(credential_type.strip()) == 0:
        raise click.UsageError('Parameter --credential-type cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if strategy is not None:
        _details['strategy'] = strategy

    if user_secret_id is not None:
        _details['userSecretId'] = user_secret_id

    if password_secret_id is not None:
        _details['passwordSecretId'] = password_secret_id

    client = cli_util.build_client('wlms', 'weblogic_management_service', ctx)
    result = client.update_wls_domain_credential(
        wls_domain_id=wls_domain_id,
        credential_type=credential_type,
        update_wls_domain_credential_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)
