"""Extract registry information."""

from .collection_api import get_collection, get_context
from .metaresource_api import (
    get_registry,
    get_registry_description,
    get_registry_example,
    get_registry_homepage,
    get_registry_name,
    get_registry_provider_uri_format,
    get_registry_short_name,
    get_registry_uri,
)
from .parse_iri import (
    curie_from_iri,
    get_default_converter,
    normalize_curie,
    normalize_parsed_curie,
    normalize_prefix,
    parse_curie,
    parse_iri,
)
from .reference import (
    NormalizedNamableReference,
    NormalizedNamedReference,
    NormalizedReference,
    StandardNamableReference,
    StandardNamedReference,
    StandardReference,
)
from .resolve import (
    add_resource,
    count_mappings,
    get_appears_in,
    get_banana,
    get_biocontext_uri_format,
    get_bioportal_prefix,
    get_canonical_for,
    get_contact,
    get_contact_email,
    get_contact_github,
    get_contact_name,
    get_contact_orcid,
    get_converter,
    get_curie_pattern,
    get_default_format,
    get_depends_on,
    get_description,
    get_example,
    get_external,
    get_fairsharing_prefix,
    get_has_canonical,
    get_has_parts,
    get_homepage,
    get_identifiers_org_prefix,
    get_json_download,
    get_keywords,
    get_license,
    get_license_conflicts,
    get_logo,
    get_mailing_list,
    get_mappings,
    get_miriam_uri_format,
    get_miriam_uri_prefix,
    get_n2t_prefix,
    get_name,
    get_namespace_in_lui,
    get_obo_context_prefix_map,
    get_obo_download,
    get_obo_health_url,
    get_obofoundry_prefix,
    get_obofoundry_uri_format,
    get_obofoundry_uri_prefix,
    get_ols_prefix,
    get_ols_uri_format,
    get_ols_uri_prefix,
    get_owl_download,
    get_part_of,
    get_parts_collections,
    get_pattern,
    get_preferred_prefix,
    get_prefixcommons_uri_format,
    get_provided_by,
    get_provides_for,
    get_rdf_download,
    get_registry_invmap,
    get_registry_map,
    get_repository,
    get_repository_to_prefix,
    get_resource,
    get_synonyms,
    get_version,
    get_versions,
    get_wikidata_prefix,
    has_no_terms,
    is_deprecated,
    is_novel,
    is_obo_foundry,
    is_proprietary,
    read_contributors,
)
from .resolve_identifier import (
    get_bioportal_iri,
    get_bioregistry_iri,
    get_default_iri,
    get_identifiers_org_curie,
    get_identifiers_org_iri,
    get_iri,
    get_n2t_iri,
    get_obofoundry_iri,
    get_ols_iri,
    get_providers,
    get_providers_list,
    is_standardizable_curie,
    is_standardizable_identifier,
    is_valid_curie,
    is_valid_identifier,
    miriam_standardize_identifier,
    standardize_identifier,
)
from .resource_manager import Manager, manager
from .schema.struct import (
    Author,
    Collection,
    Context,
    Provider,
    Registry,
    Resource,
)
from .schema_utils import (
    is_mismatch,
    read_collections,
    read_contexts,
    read_mappings,
    read_metaregistry,
    read_mismatches,
    read_registry,
    registries,
    resources,
    write_contexts,
    write_registry,
)
from .uri_format import (
    get_pattern_map,
    get_prefix_map,
    get_uri_format,
    get_uri_prefix,
)
from .utils import curie_to_str

__all__ = [
    "Author",
    "Collection",
    "Context",
    "Manager",
    "NormalizedNamableReference",
    "NormalizedNamedReference",
    "NormalizedReference",
    "Provider",
    "Registry",
    "Resource",
    "StandardNamableReference",
    "StandardNamedReference",
    "StandardReference",
    "add_resource",
    "count_mappings",
    "curie_from_iri",
    "curie_to_str",
    "get_appears_in",
    "get_banana",
    "get_biocontext_uri_format",
    "get_bioportal_iri",
    "get_bioportal_prefix",
    "get_bioregistry_iri",
    "get_canonical_for",
    "get_collection",
    "get_contact",
    "get_contact_email",
    "get_contact_github",
    "get_contact_name",
    "get_contact_orcid",
    "get_context",
    "get_converter",
    "get_curie_pattern",
    "get_default_converter",
    "get_default_format",
    "get_default_iri",
    "get_depends_on",
    "get_description",
    "get_example",
    "get_external",
    "get_fairsharing_prefix",
    "get_has_canonical",
    "get_has_parts",
    "get_homepage",
    "get_identifiers_org_curie",
    "get_identifiers_org_iri",
    "get_identifiers_org_prefix",
    "get_iri",
    "get_json_download",
    "get_keywords",
    "get_license",
    "get_license_conflicts",
    "get_logo",
    "get_mailing_list",
    "get_mappings",
    "get_miriam_uri_format",
    "get_miriam_uri_prefix",
    "get_n2t_iri",
    "get_n2t_prefix",
    "get_name",
    "get_namespace_in_lui",
    "get_obo_context_prefix_map",
    "get_obo_download",
    "get_obo_health_url",
    "get_obofoundry_iri",
    "get_obofoundry_prefix",
    "get_obofoundry_uri_format",
    "get_obofoundry_uri_prefix",
    "get_ols_iri",
    "get_ols_prefix",
    "get_ols_uri_format",
    "get_ols_uri_prefix",
    "get_owl_download",
    "get_part_of",
    "get_parts_collections",
    "get_pattern",
    "get_pattern_map",
    "get_preferred_prefix",
    "get_prefix_map",
    "get_prefixcommons_uri_format",
    "get_provided_by",
    "get_providers",
    "get_providers_list",
    "get_provides_for",
    "get_rdf_download",
    "get_registry",
    "get_registry_description",
    "get_registry_example",
    "get_registry_homepage",
    "get_registry_invmap",
    "get_registry_map",
    "get_registry_name",
    "get_registry_provider_uri_format",
    "get_registry_short_name",
    "get_registry_uri",
    "get_repository",
    "get_repository_to_prefix",
    "get_resource",
    "get_synonyms",
    "get_uri_format",
    "get_uri_prefix",
    "get_version",
    "get_versions",
    "get_wikidata_prefix",
    "has_no_terms",
    "is_deprecated",
    "is_mismatch",
    "is_novel",
    "is_obo_foundry",
    "is_proprietary",
    "is_standardizable_curie",
    "is_standardizable_identifier",
    "is_valid_curie",
    "is_valid_identifier",
    "manager",
    "miriam_standardize_identifier",
    "normalize_curie",
    "normalize_parsed_curie",
    "normalize_prefix",
    "parse_curie",
    "parse_iri",
    "read_collections",
    "read_contexts",
    "read_contributors",
    "read_mappings",
    "read_metaregistry",
    "read_mismatches",
    "read_registry",
    "registries",
    "resources",
    "standardize_identifier",
    "write_contexts",
    "write_registry",
]
