# CubeParser MCP Server

A Model Context Protocol (MCP) server that provides access to CubeParser document extraction API. This server can be run directly using `uvx` with absolute paths for easy deployment and sharing.

## 🚀 Quick Start with uvx

### For End Users (Running the Server)

If someone has shared this project with you, you can run it directly using uvx with the absolute path:

```bash
# Replace with the actual absolute path provided to you
uvx --from "C:\path\to\cubeparser_mcp" cubeparser-mcp
```

**Example:**
```bash
uvx --from "C:\Users\Remy\sensedeal\code\projects\work\CITICS2025\zhangkai\cubeparser_mcp" cubeparser-mcp
```

### For Developers (Setting Up for Sharing)

1. **Clone and Setup**:
```bash
git clone <repository-url>
cd cubeparser_mcp
uv sync
```

2. **Run Setup Script**:
```bash
uv run python setup_uvx.py
```

This creates:
- `mcp_config.json` - MCP client configuration with absolute paths
- `.env.template` - Environment variables template
- `run_cubeparser_mcp.bat` - Quick run script for Windows

3. **Configure Environment**:
```bash
cp .env.template .env
# Edit .env with your CubeParser credentials
```

## 📋 Features

This MCP server provides three main tools:

1. **get_templates** - Retrieve available extraction templates from CubeParser
2. **create_task** - Upload files and create extraction tasks with specified templates
3. **download_results** - Get extraction results from completed tasks

## 🛠️ Installation Methods

### Method 1: Direct uvx Usage (Recommended for Sharing)

```bash
# Run from absolute path (replace with actual path)
uvx --from "/absolute/path/to/cubeparser_mcp" cubeparser-mcp

# Or on Windows
uvx --from "C:\absolute\path\to\cubeparser_mcp" cubeparser-mcp
```

### Method 2: Local Development

```bash
# Install dependencies
uv sync

# Run directly
uv run python main.py

# Or use the generated batch file
.\run_cubeparser_mcp.bat  # Windows
./run_cubeparser_mcp.sh   # Linux/Mac
```

## ⚙️ Configuration

### Environment Variables

Create a `.env` file with your CubeParser credentials:

```env
CUBEPARSER_USERNAME=your_username_here
CUBEPARSER_PASSWORD=your_password_here
CUBEPARSER_BASEURL=https://cubeparser.cn/
```

### MCP Client Configuration

Use the generated `mcp_config.json` file in your MCP client (e.g., Claude Desktop):

```json
{
  "mcpServers": {
    "cubeparser": {
      "command": "uvx",
      "args": [
        "--from",
        "C:\\absolute\\path\\to\\cubeparser_mcp",
        "cubeparser-mcp"
      ],
      "env": {
        "CUBEPARSER_USERNAME": "your_username",
        "CUBEPARSER_PASSWORD": "your_password",
        "CUBEPARSER_BASEURL": "https://cubeparser.cn/"
      }
    }
  }
}
```

## 🔧 Available Tools

### get_templates()

Retrieves a list of available extraction templates from CubeParser.

**Returns:** List of template objects with IDs, names, and descriptions.

### create_task(file_path: str, template_id: str)

Creates an extraction task by uploading a file and specifying a template.

**Parameters:**
- `file_path`: Absolute path to the file to be processed
- `template_id`: ID of the template to use for extraction

**Returns:** Task information including task ID and status.

### download_results(task_id: str)

Downloads extraction results for a completed task.

**Parameters:**
- `task_id`: ID of the extraction task

**Returns:** Extraction results and task status information.

## 🧪 Testing

### Test the Installation

```bash
# Test that the server starts correctly
uvx --from "C:\your\absolute\path\to\cubeparser_mcp" cubeparser-mcp

# Or use the batch file
.\run_cubeparser_mcp.bat
```

### Run Tests

```bash
uv run pytest
```

## 📁 Generated Files

After running `setup_uvx.py`, you'll have:

- **`mcp_config.json`** - Ready-to-use MCP client configuration
- **`.env.template`** - Template for environment variables
- **`run_cubeparser_mcp.bat`** - Windows batch script for easy testing
- **`run_cubeparser_mcp.sh`** - Linux/Mac shell script for easy testing

## 🚨 Troubleshooting

### Common Issues

1. **Server won't start**: Check that environment variables are set correctly
2. **uvx command not found**: Install uv first: `pip install uv`
3. **Permission errors**: Ensure the absolute path is accessible
4. **Network errors**: Verify CubeParser API credentials and network access

### Debug Mode

Run with verbose logging:

```bash
uvx --from "C:\your\path\to\cubeparser_mcp" cubeparser-mcp --verbose
```

## 📤 Sharing with Others

To share this MCP server with others:

1. **Provide the absolute path** to your project directory
2. **Share the uvx command**:
   ```bash
   uvx --from "C:\your\absolute\path\to\cubeparser_mcp" cubeparser-mcp
   ```
3. **Include environment setup instructions** (they need their own CubeParser credentials)

## 📄 License

MIT License - see LICENSE file for details.
