# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictInt, StrictStr, conint, conlist, constr, validator

from typing import Dict, Optional

from lusid.models.abor import Abor
from lusid.models.abor_properties import AborProperties
from lusid.models.abor_request import AborRequest
from lusid.models.close_period_diary_entry_request import ClosePeriodDiaryEntryRequest
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.diary_entry import DiaryEntry
from lusid.models.diary_entry_request import DiaryEntryRequest
from lusid.models.journal_entry_lines_query_parameters import JournalEntryLinesQueryParameters
from lusid.models.lock_period_diary_entry_request import LockPeriodDiaryEntryRequest
from lusid.models.model_property import ModelProperty
from lusid.models.operation import Operation
from lusid.models.paged_resource_list_of_abor import PagedResourceListOfAbor
from lusid.models.paged_resource_list_of_diary_entry import PagedResourceListOfDiaryEntry
from lusid.models.period_diary_entries_reopened_response import PeriodDiaryEntriesReopenedResponse
from lusid.models.re_open_period_diary_entry_request import ReOpenPeriodDiaryEntryRequest
from lusid.models.trial_balance_query_parameters import TrialBalanceQueryParameters
from lusid.models.versioned_resource_list_of_journal_entry_line import VersionedResourceListOfJournalEntryLine
from lusid.models.versioned_resource_list_of_trial_balance import VersionedResourceListOfTrialBalance

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class AborApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def add_diary_entry(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], diary_entry_request : Annotated[DiaryEntryRequest, Field(..., description="The diary entry to add.")], **kwargs) -> DiaryEntry:  # noqa: E501
        ...

    @overload
    def add_diary_entry(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], diary_entry_request : Annotated[DiaryEntryRequest, Field(..., description="The diary entry to add.")], async_req: Optional[bool]=True, **kwargs) -> DiaryEntry:  # noqa: E501
        ...

    @validate_arguments
    def add_diary_entry(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], diary_entry_request : Annotated[DiaryEntryRequest, Field(..., description="The diary entry to add.")], async_req: Optional[bool]=None, **kwargs) -> Union[DiaryEntry, Awaitable[DiaryEntry]]:  # noqa: E501
        """[EXPERIMENTAL] AddDiaryEntry: Add a diary entry to the specified Abor.  # noqa: E501

        Adds a new diary entry to the specified Abor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_diary_entry(scope, code, diary_entry_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. (required)
        :type code: str
        :param diary_entry_request: The diary entry to add. (required)
        :type diary_entry_request: DiaryEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DiaryEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the add_diary_entry_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.add_diary_entry_with_http_info(scope, code, diary_entry_request, **kwargs)  # noqa: E501

    @validate_arguments
    def add_diary_entry_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], diary_entry_request : Annotated[DiaryEntryRequest, Field(..., description="The diary entry to add.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] AddDiaryEntry: Add a diary entry to the specified Abor.  # noqa: E501

        Adds a new diary entry to the specified Abor  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_diary_entry_with_http_info(scope, code, diary_entry_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. (required)
        :type code: str
        :param diary_entry_request: The diary entry to add. (required)
        :type diary_entry_request: DiaryEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DiaryEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'diary_entry_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_diary_entry" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['diary_entry_request'] is not None:
            _body_params = _params['diary_entry_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "DiaryEntry",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}/accountingdiary', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def close_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], close_period_diary_entry_request : Annotated[ClosePeriodDiaryEntryRequest, Field(..., description="The request body, containing details to apply to the closing/locking period.")], **kwargs) -> DiaryEntry:  # noqa: E501
        ...

    @overload
    def close_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], close_period_diary_entry_request : Annotated[ClosePeriodDiaryEntryRequest, Field(..., description="The request body, containing details to apply to the closing/locking period.")], async_req: Optional[bool]=True, **kwargs) -> DiaryEntry:  # noqa: E501
        ...

    @validate_arguments
    def close_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], close_period_diary_entry_request : Annotated[ClosePeriodDiaryEntryRequest, Field(..., description="The request body, containing details to apply to the closing/locking period.")], async_req: Optional[bool]=None, **kwargs) -> Union[DiaryEntry, Awaitable[DiaryEntry]]:  # noqa: E501
        """[EXPERIMENTAL] ClosePeriod: Closes or locks the current period for the given Abor.  # noqa: E501

        Closes or Locks the current open period for the given Abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.close_period(scope, code, close_period_diary_entry_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. (required)
        :type code: str
        :param close_period_diary_entry_request: The request body, containing details to apply to the closing/locking period. (required)
        :type close_period_diary_entry_request: ClosePeriodDiaryEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DiaryEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the close_period_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.close_period_with_http_info(scope, code, close_period_diary_entry_request, **kwargs)  # noqa: E501

    @validate_arguments
    def close_period_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], close_period_diary_entry_request : Annotated[ClosePeriodDiaryEntryRequest, Field(..., description="The request body, containing details to apply to the closing/locking period.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ClosePeriod: Closes or locks the current period for the given Abor.  # noqa: E501

        Closes or Locks the current open period for the given Abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.close_period_with_http_info(scope, code, close_period_diary_entry_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. (required)
        :type code: str
        :param close_period_diary_entry_request: The request body, containing details to apply to the closing/locking period. (required)
        :type close_period_diary_entry_request: ClosePeriodDiaryEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DiaryEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'close_period_diary_entry_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method close_period" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['close_period_diary_entry_request'] is not None:
            _body_params = _params['close_period_diary_entry_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "DiaryEntry",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}/accountingdiary/$closeperiod', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], abor_request : Annotated[AborRequest, Field(..., description="The definition of the Abor.")], **kwargs) -> Abor:  # noqa: E501
        ...

    @overload
    def create_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], abor_request : Annotated[AborRequest, Field(..., description="The definition of the Abor.")], async_req: Optional[bool]=True, **kwargs) -> Abor:  # noqa: E501
        ...

    @validate_arguments
    def create_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], abor_request : Annotated[AborRequest, Field(..., description="The definition of the Abor.")], async_req: Optional[bool]=None, **kwargs) -> Union[Abor, Awaitable[Abor]]:  # noqa: E501
        """[EXPERIMENTAL] CreateAbor: Create an Abor.  # noqa: E501

        Create the given Abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_abor(scope, abor_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param abor_request: The definition of the Abor. (required)
        :type abor_request: AborRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Abor
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_abor_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_abor_with_http_info(scope, abor_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_abor_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], abor_request : Annotated[AborRequest, Field(..., description="The definition of the Abor.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateAbor: Create an Abor.  # noqa: E501

        Create the given Abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_abor_with_http_info(scope, abor_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param abor_request: The definition of the Abor. (required)
        :type abor_request: AborRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Abor, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'abor_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_abor" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['abor_request'] is not None:
            _body_params = _params['abor_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Abor",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to be deleted. Together with the scope this uniquely identifies the Abor.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to be deleted. Together with the scope this uniquely identifies the Abor.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to be deleted. Together with the scope this uniquely identifies the Abor.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteAbor: Delete an Abor.  # noqa: E501

        Delete the given Abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_abor(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor to be deleted. (required)
        :type scope: str
        :param code: The code of the Abor to be deleted. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_abor_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_abor_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_abor_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to be deleted. Together with the scope this uniquely identifies the Abor.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteAbor: Delete an Abor.  # noqa: E501

        Delete the given Abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_abor_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor to be deleted. (required)
        :type scope: str
        :param code: The code of the Abor to be deleted. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_abor" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Abor properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Abor definition. Defaults to returning the latest version of the Abor definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Abor' domain to decorate onto the Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> Abor:  # noqa: E501
        ...

    @overload
    def get_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Abor properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Abor definition. Defaults to returning the latest version of the Abor definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Abor' domain to decorate onto the Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=True, **kwargs) -> Abor:  # noqa: E501
        ...

    @validate_arguments
    def get_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Abor properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Abor definition. Defaults to returning the latest version of the Abor definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Abor' domain to decorate onto the Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Abor, Awaitable[Abor]]:  # noqa: E501
        """[EXPERIMENTAL] GetAbor: Get Abor.  # noqa: E501

        Retrieve the definition of a particular Abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_abor(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Abor properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Abor definition. Defaults to returning the latest version of the Abor definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Abor' domain to decorate onto the Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Abor
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_abor_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_abor_with_http_info(scope, code, effective_at, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_abor_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Abor properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Abor definition. Defaults to returning the latest version of the Abor definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Abor' domain to decorate onto the Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetAbor: Get Abor.  # noqa: E501

        Retrieve the definition of a particular Abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_abor_with_http_info(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Abor properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Abor definition. Defaults to returning the latest version of the Abor definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Abor' domain to decorate onto the Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Abor, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_abor" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Abor",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_abor_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to list the properties for. Together with the scope this uniquely identifies the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Abor's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Abor's properties. Defaults to return the latest version of each property if not specified.")] = None, **kwargs) -> AborProperties:  # noqa: E501
        ...

    @overload
    def get_abor_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to list the properties for. Together with the scope this uniquely identifies the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Abor's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Abor's properties. Defaults to return the latest version of each property if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> AborProperties:  # noqa: E501
        ...

    @validate_arguments
    def get_abor_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to list the properties for. Together with the scope this uniquely identifies the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Abor's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Abor's properties. Defaults to return the latest version of each property if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[AborProperties, Awaitable[AborProperties]]:  # noqa: E501
        """[EXPERIMENTAL] GetAborProperties: Get Abor properties  # noqa: E501

        Get all the properties of a single abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_abor_properties(scope, code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor to list the properties for. (required)
        :type scope: str
        :param code: The code of the Abor to list the properties for. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the Abor's properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Abor's properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AborProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_abor_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_abor_properties_with_http_info(scope, code, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_abor_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to list the properties for. Together with the scope this uniquely identifies the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Abor's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Abor's properties. Defaults to return the latest version of each property if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetAborProperties: Get Abor properties  # noqa: E501

        Get all the properties of a single abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_abor_properties_with_http_info(scope, code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor to list the properties for. (required)
        :type scope: str
        :param code: The code of the Abor to list the properties for. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the Abor's properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Abor's properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AborProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_abor_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AborProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}/properties', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_journal_entry_lines(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope is creating the unique identifier for the given Abor.")], journal_entry_lines_query_parameters : Annotated[JournalEntryLinesQueryParameters, Field(..., description="The query parameters used in running the generation of the Journal Entry lines.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="\"Expression to filter the result set.\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Journal Entry lines from a previous call to GetJournalEntryLines.")] = None, **kwargs) -> VersionedResourceListOfJournalEntryLine:  # noqa: E501
        ...

    @overload
    def get_journal_entry_lines(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope is creating the unique identifier for the given Abor.")], journal_entry_lines_query_parameters : Annotated[JournalEntryLinesQueryParameters, Field(..., description="The query parameters used in running the generation of the Journal Entry lines.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="\"Expression to filter the result set.\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Journal Entry lines from a previous call to GetJournalEntryLines.")] = None, async_req: Optional[bool]=True, **kwargs) -> VersionedResourceListOfJournalEntryLine:  # noqa: E501
        ...

    @validate_arguments
    def get_journal_entry_lines(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope is creating the unique identifier for the given Abor.")], journal_entry_lines_query_parameters : Annotated[JournalEntryLinesQueryParameters, Field(..., description="The query parameters used in running the generation of the Journal Entry lines.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="\"Expression to filter the result set.\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Journal Entry lines from a previous call to GetJournalEntryLines.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[VersionedResourceListOfJournalEntryLine, Awaitable[VersionedResourceListOfJournalEntryLine]]:  # noqa: E501
        """[EXPERIMENTAL] GetJournalEntryLines: Get the Journal Entry lines for the given Abor.  # noqa: E501

        Gets the Journal Entry lines for the given Abor              The Journal Entry lines have been generated from transactions and translated via posting rules  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_journal_entry_lines(scope, code, journal_entry_lines_query_parameters, as_at, filter, limit, page, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. Together with the scope is creating the unique identifier for the given Abor. (required)
        :type code: str
        :param journal_entry_lines_query_parameters: The query parameters used in running the generation of the Journal Entry lines. (required)
        :type journal_entry_lines_query_parameters: JournalEntryLinesQueryParameters
        :param as_at: The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.
        :type as_at: datetime
        :param filter: \"Expression to filter the result set.\"
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing Journal Entry lines from a previous call to GetJournalEntryLines.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VersionedResourceListOfJournalEntryLine
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_journal_entry_lines_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_journal_entry_lines_with_http_info(scope, code, journal_entry_lines_query_parameters, as_at, filter, limit, page, **kwargs)  # noqa: E501

    @validate_arguments
    def get_journal_entry_lines_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope is creating the unique identifier for the given Abor.")], journal_entry_lines_query_parameters : Annotated[JournalEntryLinesQueryParameters, Field(..., description="The query parameters used in running the generation of the Journal Entry lines.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="\"Expression to filter the result set.\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Journal Entry lines from a previous call to GetJournalEntryLines.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetJournalEntryLines: Get the Journal Entry lines for the given Abor.  # noqa: E501

        Gets the Journal Entry lines for the given Abor              The Journal Entry lines have been generated from transactions and translated via posting rules  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_journal_entry_lines_with_http_info(scope, code, journal_entry_lines_query_parameters, as_at, filter, limit, page, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. Together with the scope is creating the unique identifier for the given Abor. (required)
        :type code: str
        :param journal_entry_lines_query_parameters: The query parameters used in running the generation of the Journal Entry lines. (required)
        :type journal_entry_lines_query_parameters: JournalEntryLinesQueryParameters
        :param as_at: The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.
        :type as_at: datetime
        :param filter: \"Expression to filter the result set.\"
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing Journal Entry lines from a previous call to GetJournalEntryLines.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VersionedResourceListOfJournalEntryLine, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'journal_entry_lines_query_parameters',
            'as_at',
            'filter',
            'limit',
            'page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journal_entry_lines" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['journal_entry_lines_query_parameters'] is not None:
            _body_params = _params['journal_entry_lines_query_parameters']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "VersionedResourceListOfJournalEntryLine",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}/journalentrylines/$query', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_trial_balance(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], trial_balance_query_parameters : Annotated[TrialBalanceQueryParameters, Field(..., description="The query parameters used in running the generation of the Trial Balance.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Trial Balance.             Defaults to returning the latest version if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.             For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.             Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial Balances.             This token is returned from the previous call.             If a pagination token is provided, the filter, effectiveAt and asAt fields             must not have changed since the original request.")] = None, **kwargs) -> VersionedResourceListOfTrialBalance:  # noqa: E501
        ...

    @overload
    def get_trial_balance(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], trial_balance_query_parameters : Annotated[TrialBalanceQueryParameters, Field(..., description="The query parameters used in running the generation of the Trial Balance.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Trial Balance.             Defaults to returning the latest version if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.             For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.             Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial Balances.             This token is returned from the previous call.             If a pagination token is provided, the filter, effectiveAt and asAt fields             must not have changed since the original request.")] = None, async_req: Optional[bool]=True, **kwargs) -> VersionedResourceListOfTrialBalance:  # noqa: E501
        ...

    @validate_arguments
    def get_trial_balance(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], trial_balance_query_parameters : Annotated[TrialBalanceQueryParameters, Field(..., description="The query parameters used in running the generation of the Trial Balance.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Trial Balance.             Defaults to returning the latest version if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.             For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.             Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial Balances.             This token is returned from the previous call.             If a pagination token is provided, the filter, effectiveAt and asAt fields             must not have changed since the original request.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[VersionedResourceListOfTrialBalance, Awaitable[VersionedResourceListOfTrialBalance]]:  # noqa: E501
        """[EXPERIMENTAL] GetTrialBalance: Get the Trial Balance for the given Abor.  # noqa: E501

        Gets the Trial Balance for the given Abor.  The Trial Balance has been generated from transactions, translated via Posting Rules and aggregated based on a General Ledger Profile (where specified).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_trial_balance(scope, code, trial_balance_query_parameters, as_at, filter, limit, page, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param trial_balance_query_parameters: The query parameters used in running the generation of the Trial Balance. (required)
        :type trial_balance_query_parameters: TrialBalanceQueryParameters
        :param as_at: The asAt datetime at which to retrieve the Trial Balance.             Defaults to returning the latest version if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the results by.             For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this many.             Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing Trial Balances.             This token is returned from the previous call.             If a pagination token is provided, the filter, effectiveAt and asAt fields             must not have changed since the original request.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VersionedResourceListOfTrialBalance
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_trial_balance_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_trial_balance_with_http_info(scope, code, trial_balance_query_parameters, as_at, filter, limit, page, **kwargs)  # noqa: E501

    @validate_arguments
    def get_trial_balance_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], trial_balance_query_parameters : Annotated[TrialBalanceQueryParameters, Field(..., description="The query parameters used in running the generation of the Trial Balance.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Trial Balance.             Defaults to returning the latest version if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.             For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many.             Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial Balances.             This token is returned from the previous call.             If a pagination token is provided, the filter, effectiveAt and asAt fields             must not have changed since the original request.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetTrialBalance: Get the Trial Balance for the given Abor.  # noqa: E501

        Gets the Trial Balance for the given Abor.  The Trial Balance has been generated from transactions, translated via Posting Rules and aggregated based on a General Ledger Profile (where specified).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_trial_balance_with_http_info(scope, code, trial_balance_query_parameters, as_at, filter, limit, page, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param trial_balance_query_parameters: The query parameters used in running the generation of the Trial Balance. (required)
        :type trial_balance_query_parameters: TrialBalanceQueryParameters
        :param as_at: The asAt datetime at which to retrieve the Trial Balance.             Defaults to returning the latest version if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the results by.             For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this many.             Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing Trial Balances.             This token is returned from the previous call.             If a pagination token is provided, the filter, effectiveAt and asAt fields             must not have changed since the original request.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VersionedResourceListOfTrialBalance, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'trial_balance_query_parameters',
            'as_at',
            'filter',
            'limit',
            'page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trial_balance" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['trial_balance_query_parameters'] is not None:
            _body_params = _params['trial_balance_query_parameters']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "VersionedResourceListOfTrialBalance",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}/trialbalance/$query', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_abors(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Abor. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Abor. Defaults to returning the latest version of each Abor if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Abor; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Abor type, specify \"id.Code eq 'Abor1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Abor' domain to decorate onto each Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'.")] = None, **kwargs) -> PagedResourceListOfAbor:  # noqa: E501
        ...

    @overload
    def list_abors(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Abor. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Abor. Defaults to returning the latest version of each Abor if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Abor; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Abor type, specify \"id.Code eq 'Abor1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Abor' domain to decorate onto each Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfAbor:  # noqa: E501
        ...

    @validate_arguments
    def list_abors(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Abor. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Abor. Defaults to returning the latest version of each Abor if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Abor; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Abor type, specify \"id.Code eq 'Abor1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Abor' domain to decorate onto each Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfAbor, Awaitable[PagedResourceListOfAbor]]:  # noqa: E501
        """[EXPERIMENTAL] ListAbors: List Abors.  # noqa: E501

        List all the Abors matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_abors(effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the Abor. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Abor. Defaults to returning the latest version of each Abor if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Abor; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Abor type, specify \"id.Code eq 'Abor1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'Abor' domain to decorate onto each Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfAbor
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_abors_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_abors_with_http_info(effective_at, as_at, page, limit, filter, sort_by, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_abors_with_http_info(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Abor. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Abor. Defaults to returning the latest version of each Abor if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Abor; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Abor type, specify \"id.Code eq 'Abor1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Abor' domain to decorate onto each Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListAbors: List Abors.  # noqa: E501

        List all the Abors matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_abors_with_http_info(effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the Abor. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Abor. Defaults to returning the latest version of each Abor if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Abor; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Abor type, specify \"id.Code eq 'Abor1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'Abor' domain to decorate onto each Abor.             These must take the format {domain}/{scope}/{code}, for example 'Abor/Manager/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfAbor, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_abors" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfAbor",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_diary_entries(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Diary Entries. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the DiaryEntry. Defaults to returning the latest version of each DiaryEntry if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing diary entries; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the DiaryEntry type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'DiaryEntry' domain to decorate onto each DiaryEntry.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/Report/Id'.")] = None, **kwargs) -> PagedResourceListOfDiaryEntry:  # noqa: E501
        ...

    @overload
    def list_diary_entries(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Diary Entries. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the DiaryEntry. Defaults to returning the latest version of each DiaryEntry if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing diary entries; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the DiaryEntry type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'DiaryEntry' domain to decorate onto each DiaryEntry.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/Report/Id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfDiaryEntry:  # noqa: E501
        ...

    @validate_arguments
    def list_diary_entries(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Diary Entries. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the DiaryEntry. Defaults to returning the latest version of each DiaryEntry if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing diary entries; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the DiaryEntry type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'DiaryEntry' domain to decorate onto each DiaryEntry.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/Report/Id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfDiaryEntry, Awaitable[PagedResourceListOfDiaryEntry]]:  # noqa: E501
        """[EXPERIMENTAL] ListDiaryEntries: List diary entries.  # noqa: E501

        List all the diary entries matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_diary_entries(scope, code, effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the Diary Entries. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the DiaryEntry. Defaults to returning the latest version of each DiaryEntry if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing diary entries; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the DiaryEntry type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'DiaryEntry' domain to decorate onto each DiaryEntry.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/Report/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfDiaryEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_diary_entries_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_diary_entries_with_http_info(scope, code, effective_at, as_at, page, limit, filter, sort_by, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_diary_entries_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Diary Entries. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the DiaryEntry. Defaults to returning the latest version of each DiaryEntry if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing diary entries; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the DiaryEntry type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'DiaryEntry' domain to decorate onto each DiaryEntry.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/Report/Id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListDiaryEntries: List diary entries.  # noqa: E501

        List all the diary entries matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_diary_entries_with_http_info(scope, code, effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the Diary Entries. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the DiaryEntry. Defaults to returning the latest version of each DiaryEntry if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing diary entries; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the DiaryEntry type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'DiaryEntry' domain to decorate onto each DiaryEntry.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/Report/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfDiaryEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_diary_entries" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfDiaryEntry",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}/accountingdiary', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def lock_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], lock_period_diary_entry_request : Annotated[Optional[LockPeriodDiaryEntryRequest], Field(description="The request body, detailing lock details")] = None, **kwargs) -> DiaryEntry:  # noqa: E501
        ...

    @overload
    def lock_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], lock_period_diary_entry_request : Annotated[Optional[LockPeriodDiaryEntryRequest], Field(description="The request body, detailing lock details")] = None, async_req: Optional[bool]=True, **kwargs) -> DiaryEntry:  # noqa: E501
        ...

    @validate_arguments
    def lock_period(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], lock_period_diary_entry_request : Annotated[Optional[LockPeriodDiaryEntryRequest], Field(description="The request body, detailing lock details")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DiaryEntry, Awaitable[DiaryEntry]]:  # noqa: E501
        """[EXPERIMENTAL] LockPeriod: Locks the last Closed or given Closed Period.  # noqa: E501

        Locks the specified or last locked period for the given Abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.lock_period(scope, code, lock_period_diary_entry_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. (required)
        :type code: str
        :param lock_period_diary_entry_request: The request body, detailing lock details
        :type lock_period_diary_entry_request: LockPeriodDiaryEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DiaryEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the lock_period_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.lock_period_with_http_info(scope, code, lock_period_diary_entry_request, **kwargs)  # noqa: E501

    @validate_arguments
    def lock_period_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor.")], lock_period_diary_entry_request : Annotated[Optional[LockPeriodDiaryEntryRequest], Field(description="The request body, detailing lock details")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] LockPeriod: Locks the last Closed or given Closed Period.  # noqa: E501

        Locks the specified or last locked period for the given Abor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.lock_period_with_http_info(scope, code, lock_period_diary_entry_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. (required)
        :type code: str
        :param lock_period_diary_entry_request: The request body, detailing lock details
        :type lock_period_diary_entry_request: LockPeriodDiaryEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DiaryEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'lock_period_diary_entry_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method lock_period" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['lock_period_diary_entry_request'] is not None:
            _body_params = _params['lock_period_diary_entry_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DiaryEntry",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}/accountingdiary/$lockperiod', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def patch_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the             scope this uniquely identifies the Abor.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> Abor:  # noqa: E501
        ...

    @overload
    def patch_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the             scope this uniquely identifies the Abor.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=True, **kwargs) -> Abor:  # noqa: E501
        ...

    @validate_arguments
    def patch_abor(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the             scope this uniquely identifies the Abor.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=None, **kwargs) -> Union[Abor, Awaitable[Abor]]:  # noqa: E501
        """[EXPERIMENTAL] PatchAbor: Patch Abor.  # noqa: E501

        Create or update certain fields for a particular Abor.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: PortfolioIds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_abor(scope, code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. Together with the             scope this uniquely identifies the Abor. (required)
        :type code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Abor
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the patch_abor_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.patch_abor_with_http_info(scope, code, operation, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_abor_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the             scope this uniquely identifies the Abor.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PatchAbor: Patch Abor.  # noqa: E501

        Create or update certain fields for a particular Abor.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: PortfolioIds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_abor_with_http_info(scope, code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. Together with the             scope this uniquely identifies the Abor. (required)
        :type code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Abor, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'operation'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_abor" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['operation'] is not None:
            _body_params = _params['operation']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Abor",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def re_open_periods(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], re_open_period_diary_entry_request : Annotated[Optional[ReOpenPeriodDiaryEntryRequest], Field(description="The request body, containing details about the period to be re-opened.")] = None, **kwargs) -> PeriodDiaryEntriesReopenedResponse:  # noqa: E501
        ...

    @overload
    def re_open_periods(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], re_open_period_diary_entry_request : Annotated[Optional[ReOpenPeriodDiaryEntryRequest], Field(description="The request body, containing details about the period to be re-opened.")] = None, async_req: Optional[bool]=True, **kwargs) -> PeriodDiaryEntriesReopenedResponse:  # noqa: E501
        ...

    @validate_arguments
    def re_open_periods(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], re_open_period_diary_entry_request : Annotated[Optional[ReOpenPeriodDiaryEntryRequest], Field(description="The request body, containing details about the period to be re-opened.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PeriodDiaryEntriesReopenedResponse, Awaitable[PeriodDiaryEntriesReopenedResponse]]:  # noqa: E501
        """[EXPERIMENTAL] ReOpenPeriods: Reopen periods from a seed Diary Entry Code or when not specified, the last Closed Period for the given Abor.  # noqa: E501

        Reopens one or more periods.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.re_open_periods(scope, code, re_open_period_diary_entry_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param re_open_period_diary_entry_request: The request body, containing details about the period to be re-opened.
        :type re_open_period_diary_entry_request: ReOpenPeriodDiaryEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PeriodDiaryEntriesReopenedResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the re_open_periods_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.re_open_periods_with_http_info(scope, code, re_open_period_diary_entry_request, **kwargs)  # noqa: E501

    @validate_arguments
    def re_open_periods_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor. Together with the scope this uniquely identifies the Abor.")], re_open_period_diary_entry_request : Annotated[Optional[ReOpenPeriodDiaryEntryRequest], Field(description="The request body, containing details about the period to be re-opened.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ReOpenPeriods: Reopen periods from a seed Diary Entry Code or when not specified, the last Closed Period for the given Abor.  # noqa: E501

        Reopens one or more periods.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.re_open_periods_with_http_info(scope, code, re_open_period_diary_entry_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor. (required)
        :type scope: str
        :param code: The code of the Abor. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param re_open_period_diary_entry_request: The request body, containing details about the period to be re-opened.
        :type re_open_period_diary_entry_request: ReOpenPeriodDiaryEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PeriodDiaryEntriesReopenedResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            're_open_period_diary_entry_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method re_open_periods" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['re_open_period_diary_entry_request'] is not None:
            _body_params = _params['re_open_period_diary_entry_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PeriodDiaryEntriesReopenedResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}/accountingdiary/$reopenperiods', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_abor_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to update or insert the properties onto. Together with the scope this uniquely identifies the Abor.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Abor. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Abor/Manager/Id\".")] = None, **kwargs) -> AborProperties:  # noqa: E501
        ...

    @overload
    def upsert_abor_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to update or insert the properties onto. Together with the scope this uniquely identifies the Abor.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Abor. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Abor/Manager/Id\".")] = None, async_req: Optional[bool]=True, **kwargs) -> AborProperties:  # noqa: E501
        ...

    @validate_arguments
    def upsert_abor_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to update or insert the properties onto. Together with the scope this uniquely identifies the Abor.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Abor. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Abor/Manager/Id\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[AborProperties, Awaitable[AborProperties]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertAborProperties: Upsert Abor properties  # noqa: E501

        Update or insert one or more properties onto a single Abor. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'Abor'.              Upserting a property that exists for an Abor, with a null value, will delete the instance of the property for that group.              Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_abor_properties(scope, code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the Abor to update or insert the properties onto. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param request_body: The properties to be updated or inserted onto the Abor. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Abor/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AborProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_abor_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_abor_properties_with_http_info(scope, code, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_abor_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Abor to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Abor to update or insert the properties onto. Together with the scope this uniquely identifies the Abor.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Abor. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Abor/Manager/Id\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertAborProperties: Upsert Abor properties  # noqa: E501

        Update or insert one or more properties onto a single Abor. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'Abor'.              Upserting a property that exists for an Abor, with a null value, will delete the instance of the property for that group.              Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_abor_properties_with_http_info(scope, code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Abor to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the Abor to update or insert the properties onto. Together with the scope this uniquely identifies the Abor. (required)
        :type code: str
        :param request_body: The properties to be updated or inserted onto the Abor. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Abor/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AborProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_abor_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AborProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/abor/{scope}/{code}/properties/$upsert', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
