# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, constr, validator

from typing import Optional

from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.resource_list_of_returns_entity import ResourceListOfReturnsEntity
from lusid.models.returns_entity import ReturnsEntity

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class AggregatedReturnsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def delete_returns_entity(self, scope : Annotated[StrictStr, Field(..., description="Returns entity scope.")], code : Annotated[StrictStr, Field(..., description="Returns entity code.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_returns_entity(self, scope : Annotated[StrictStr, Field(..., description="Returns entity scope.")], code : Annotated[StrictStr, Field(..., description="Returns entity code.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_returns_entity(self, scope : Annotated[StrictStr, Field(..., description="Returns entity scope.")], code : Annotated[StrictStr, Field(..., description="Returns entity code.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteReturnsEntity: Delete returns entity.  # noqa: E501

        Delete returns entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_returns_entity(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Returns entity scope. (required)
        :type scope: str
        :param code: Returns entity code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_returns_entity_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_returns_entity_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_returns_entity_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Returns entity scope.")], code : Annotated[StrictStr, Field(..., description="Returns entity code.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteReturnsEntity: Delete returns entity.  # noqa: E501

        Delete returns entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_returns_entity_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Returns entity scope. (required)
        :type scope: str
        :param code: Returns entity code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_returns_entity" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/returns/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_returns_entity(self, scope : Annotated[StrictStr, Field(..., description="Returns entity scope.")], code : Annotated[StrictStr, Field(..., description="Returns entity code.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the returns entity. Defaults to return             the latest version of the definition if not specified.")] = None, **kwargs) -> ReturnsEntity:  # noqa: E501
        ...

    @overload
    def get_returns_entity(self, scope : Annotated[StrictStr, Field(..., description="Returns entity scope.")], code : Annotated[StrictStr, Field(..., description="Returns entity code.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the returns entity. Defaults to return             the latest version of the definition if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> ReturnsEntity:  # noqa: E501
        ...

    @validate_arguments
    def get_returns_entity(self, scope : Annotated[StrictStr, Field(..., description="Returns entity scope.")], code : Annotated[StrictStr, Field(..., description="Returns entity code.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the returns entity. Defaults to return             the latest version of the definition if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ReturnsEntity, Awaitable[ReturnsEntity]]:  # noqa: E501
        """[EXPERIMENTAL] GetReturnsEntity: Get returns entity.  # noqa: E501

        Get returns entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_returns_entity(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: Returns entity scope. (required)
        :type scope: str
        :param code: Returns entity code. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the returns entity. Defaults to return             the latest version of the definition if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ReturnsEntity
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_returns_entity_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_returns_entity_with_http_info(scope, code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_returns_entity_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Returns entity scope.")], code : Annotated[StrictStr, Field(..., description="Returns entity code.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the returns entity. Defaults to return             the latest version of the definition if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetReturnsEntity: Get returns entity.  # noqa: E501

        Get returns entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_returns_entity_with_http_info(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: Returns entity scope. (required)
        :type scope: str
        :param code: Returns entity code. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the returns entity. Defaults to return             the latest version of the definition if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ReturnsEntity, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_returns_entity" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ReturnsEntity",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/returns/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_returns_entities(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the relation definitions. Defaults to return             the latest version of each definition if not specified.")] = None, **kwargs) -> ResourceListOfReturnsEntity:  # noqa: E501
        ...

    @overload
    def list_returns_entities(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the relation definitions. Defaults to return             the latest version of each definition if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfReturnsEntity:  # noqa: E501
        ...

    @validate_arguments
    def list_returns_entities(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the relation definitions. Defaults to return             the latest version of each definition if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfReturnsEntity, Awaitable[ResourceListOfReturnsEntity]]:  # noqa: E501
        """[EXPERIMENTAL] ListReturnsEntities: List returns entities.  # noqa: E501

        List returns entities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_returns_entities(as_at, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the relation definitions. Defaults to return             the latest version of each definition if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfReturnsEntity
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_returns_entities_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_returns_entities_with_http_info(as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def list_returns_entities_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the relation definitions. Defaults to return             the latest version of each definition if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListReturnsEntities: List returns entities.  # noqa: E501

        List returns entities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_returns_entities_with_http_info(as_at, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the relation definitions. Defaults to return             the latest version of each definition if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfReturnsEntity, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_returns_entities" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfReturnsEntity",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/returns', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_returns_entity(self, returns_entity : Annotated[ReturnsEntity, Field(..., description="Definition of the returns entity.")], **kwargs) -> ReturnsEntity:  # noqa: E501
        ...

    @overload
    def upsert_returns_entity(self, returns_entity : Annotated[ReturnsEntity, Field(..., description="Definition of the returns entity.")], async_req: Optional[bool]=True, **kwargs) -> ReturnsEntity:  # noqa: E501
        ...

    @validate_arguments
    def upsert_returns_entity(self, returns_entity : Annotated[ReturnsEntity, Field(..., description="Definition of the returns entity.")], async_req: Optional[bool]=None, **kwargs) -> Union[ReturnsEntity, Awaitable[ReturnsEntity]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertReturnsEntity: Upsert returns entity.  # noqa: E501

        Upsert returns entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_returns_entity(returns_entity, async_req=True)
        >>> result = thread.get()

        :param returns_entity: Definition of the returns entity. (required)
        :type returns_entity: ReturnsEntity
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ReturnsEntity
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_returns_entity_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_returns_entity_with_http_info(returns_entity, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_returns_entity_with_http_info(self, returns_entity : Annotated[ReturnsEntity, Field(..., description="Definition of the returns entity.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertReturnsEntity: Upsert returns entity.  # noqa: E501

        Upsert returns entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_returns_entity_with_http_info(returns_entity, async_req=True)
        >>> result = thread.get()

        :param returns_entity: Definition of the returns entity. (required)
        :type returns_entity: ReturnsEntity
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ReturnsEntity, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'returns_entity'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_returns_entity" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['returns_entity'] is not None:
            _body_params = _params['returns_entity']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "ReturnsEntity",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/returns', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
