# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Dict, List, Optional

from lusid.models.add_business_days_to_date_request import AddBusinessDaysToDateRequest
from lusid.models.add_business_days_to_date_response import AddBusinessDaysToDateResponse
from lusid.models.batch_upsert_dates_for_calendar_response import BatchUpsertDatesForCalendarResponse
from lusid.models.calendar import Calendar
from lusid.models.calendar_date import CalendarDate
from lusid.models.create_calendar_request import CreateCalendarRequest
from lusid.models.create_date_request import CreateDateRequest
from lusid.models.is_business_day_response import IsBusinessDayResponse
from lusid.models.paged_resource_list_of_calendar import PagedResourceListOfCalendar
from lusid.models.resource_list_of_calendar_date import ResourceListOfCalendarDate
from lusid.models.update_calendar_request import UpdateCalendarRequest
from lusid.models.valuation_schedule import ValuationSchedule

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class CalendarsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def add_business_days_to_date(self, scope : Annotated[StrictStr, Field(..., description="Scope within which to search for the calendars")], add_business_days_to_date_request : Annotated[AddBusinessDaysToDateRequest, Field(..., description="Request Details: start date, number of days to add (which can be negative, but not zero), calendar codes and optionally an AsAt date for searching the calendar store")], **kwargs) -> AddBusinessDaysToDateResponse:  # noqa: E501
        ...

    @overload
    def add_business_days_to_date(self, scope : Annotated[StrictStr, Field(..., description="Scope within which to search for the calendars")], add_business_days_to_date_request : Annotated[AddBusinessDaysToDateRequest, Field(..., description="Request Details: start date, number of days to add (which can be negative, but not zero), calendar codes and optionally an AsAt date for searching the calendar store")], async_req: Optional[bool]=True, **kwargs) -> AddBusinessDaysToDateResponse:  # noqa: E501
        ...

    @validate_arguments
    def add_business_days_to_date(self, scope : Annotated[StrictStr, Field(..., description="Scope within which to search for the calendars")], add_business_days_to_date_request : Annotated[AddBusinessDaysToDateRequest, Field(..., description="Request Details: start date, number of days to add (which can be negative, but not zero), calendar codes and optionally an AsAt date for searching the calendar store")], async_req: Optional[bool]=None, **kwargs) -> Union[AddBusinessDaysToDateResponse, Awaitable[AddBusinessDaysToDateResponse]]:  # noqa: E501
        """[EARLY ACCESS] AddBusinessDaysToDate: Adds the requested number of Business Days to the provided date.  # noqa: E501

        A Business day is defined as a point in time that:     * Does not represent a day in the calendar's weekend     * Does not represent a day in the calendar's list of holidays (e.g. Christmas Day in the UK)               All dates specified must be UTC and the upper bound of a calendar is not inclusive               e.g. From: 2020-12-24-00-00-00:      Adding 3 business days returns 2020-12-30, assuming Saturday and Sunday are weekends, and the 25th and 28th are holidays.      Adding -2 business days returns 2020-12-22 under the same assumptions.              If the provided number of days to add is zero, returns a failure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_business_days_to_date(scope, add_business_days_to_date_request, async_req=True)
        >>> result = thread.get()

        :param scope: Scope within which to search for the calendars (required)
        :type scope: str
        :param add_business_days_to_date_request: Request Details: start date, number of days to add (which can be negative, but not zero), calendar codes and optionally an AsAt date for searching the calendar store (required)
        :type add_business_days_to_date_request: AddBusinessDaysToDateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddBusinessDaysToDateResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the add_business_days_to_date_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.add_business_days_to_date_with_http_info(scope, add_business_days_to_date_request, **kwargs)  # noqa: E501

    @validate_arguments
    def add_business_days_to_date_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope within which to search for the calendars")], add_business_days_to_date_request : Annotated[AddBusinessDaysToDateRequest, Field(..., description="Request Details: start date, number of days to add (which can be negative, but not zero), calendar codes and optionally an AsAt date for searching the calendar store")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] AddBusinessDaysToDate: Adds the requested number of Business Days to the provided date.  # noqa: E501

        A Business day is defined as a point in time that:     * Does not represent a day in the calendar's weekend     * Does not represent a day in the calendar's list of holidays (e.g. Christmas Day in the UK)               All dates specified must be UTC and the upper bound of a calendar is not inclusive               e.g. From: 2020-12-24-00-00-00:      Adding 3 business days returns 2020-12-30, assuming Saturday and Sunday are weekends, and the 25th and 28th are holidays.      Adding -2 business days returns 2020-12-22 under the same assumptions.              If the provided number of days to add is zero, returns a failure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_business_days_to_date_with_http_info(scope, add_business_days_to_date_request, async_req=True)
        >>> result = thread.get()

        :param scope: Scope within which to search for the calendars (required)
        :type scope: str
        :param add_business_days_to_date_request: Request Details: start date, number of days to add (which can be negative, but not zero), calendar codes and optionally an AsAt date for searching the calendar store (required)
        :type add_business_days_to_date_request: AddBusinessDaysToDateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddBusinessDaysToDateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'add_business_days_to_date_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_business_days_to_date" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['add_business_days_to_date_request'] is not None:
            _body_params = _params['add_business_days_to_date_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AddBusinessDaysToDateResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/businessday/{scope}/add', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def add_date_to_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], create_date_request : Annotated[CreateDateRequest, Field(..., description="Add date to calendar request")], **kwargs) -> CalendarDate:  # noqa: E501
        ...

    @overload
    def add_date_to_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], create_date_request : Annotated[CreateDateRequest, Field(..., description="Add date to calendar request")], async_req: Optional[bool]=True, **kwargs) -> CalendarDate:  # noqa: E501
        ...

    @validate_arguments
    def add_date_to_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], create_date_request : Annotated[CreateDateRequest, Field(..., description="Add date to calendar request")], async_req: Optional[bool]=None, **kwargs) -> Union[CalendarDate, Awaitable[CalendarDate]]:  # noqa: E501
        """AddDateToCalendar: Add a date to a calendar  # noqa: E501

        Add an event to the calendar. These Events can be a maximum of 24 hours and must be specified in UTC. A local date will be calculated by the system and applied to the calendar before processing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_date_to_calendar(scope, code, create_date_request, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param create_date_request: Add date to calendar request (required)
        :type create_date_request: CreateDateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalendarDate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the add_date_to_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.add_date_to_calendar_with_http_info(scope, code, create_date_request, **kwargs)  # noqa: E501

    @validate_arguments
    def add_date_to_calendar_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], create_date_request : Annotated[CreateDateRequest, Field(..., description="Add date to calendar request")], **kwargs) -> ApiResponse:  # noqa: E501
        """AddDateToCalendar: Add a date to a calendar  # noqa: E501

        Add an event to the calendar. These Events can be a maximum of 24 hours and must be specified in UTC. A local date will be calculated by the system and applied to the calendar before processing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_date_to_calendar_with_http_info(scope, code, create_date_request, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param create_date_request: Add date to calendar request (required)
        :type create_date_request: CreateDateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CalendarDate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'create_date_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_date_to_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_date_request'] is not None:
            _body_params = _params['create_date_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CalendarDate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic/{scope}/{code}/dates', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def batch_upsert_dates_for_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")], request_body : Annotated[Dict[str, CreateDateRequest], Field(..., description="Create Date Requests of dates to upsert")], **kwargs) -> BatchUpsertDatesForCalendarResponse:  # noqa: E501
        ...

    @overload
    def batch_upsert_dates_for_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")], request_body : Annotated[Dict[str, CreateDateRequest], Field(..., description="Create Date Requests of dates to upsert")], async_req: Optional[bool]=True, **kwargs) -> BatchUpsertDatesForCalendarResponse:  # noqa: E501
        ...

    @validate_arguments
    def batch_upsert_dates_for_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")], request_body : Annotated[Dict[str, CreateDateRequest], Field(..., description="Create Date Requests of dates to upsert")], async_req: Optional[bool]=None, **kwargs) -> Union[BatchUpsertDatesForCalendarResponse, Awaitable[BatchUpsertDatesForCalendarResponse]]:  # noqa: E501
        """BatchUpsertDatesForCalendar: Batch upsert dates to a calendar  # noqa: E501

        Create or update events in the calendar. These Events can be a maximum of 24 hours and must be specified in UTC. A local date will be calculated by the system and applied to the calendar before processing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_upsert_dates_for_calendar(scope, code, success_mode, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial. (required)
        :type success_mode: str
        :param request_body: Create Date Requests of dates to upsert (required)
        :type request_body: Dict[str, CreateDateRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BatchUpsertDatesForCalendarResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the batch_upsert_dates_for_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.batch_upsert_dates_for_calendar_with_http_info(scope, code, success_mode, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def batch_upsert_dates_for_calendar_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], success_mode : Annotated[StrictStr, Field(..., description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")], request_body : Annotated[Dict[str, CreateDateRequest], Field(..., description="Create Date Requests of dates to upsert")], **kwargs) -> ApiResponse:  # noqa: E501
        """BatchUpsertDatesForCalendar: Batch upsert dates to a calendar  # noqa: E501

        Create or update events in the calendar. These Events can be a maximum of 24 hours and must be specified in UTC. A local date will be calculated by the system and applied to the calendar before processing.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_upsert_dates_for_calendar_with_http_info(scope, code, success_mode, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial. (required)
        :type success_mode: str
        :param request_body: Create Date Requests of dates to upsert (required)
        :type request_body: Dict[str, CreateDateRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BatchUpsertDatesForCalendarResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'success_mode',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_upsert_dates_for_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('success_mode') is not None:  # noqa: E501
            _query_params.append(('successMode', _params['success_mode']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "BatchUpsertDatesForCalendarResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic/{scope}/{code}/dates/$batchUpsert', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_calendar(self, create_calendar_request : Annotated[CreateCalendarRequest, Field(..., description="A request to create the calendar")], **kwargs) -> Calendar:  # noqa: E501
        ...

    @overload
    def create_calendar(self, create_calendar_request : Annotated[CreateCalendarRequest, Field(..., description="A request to create the calendar")], async_req: Optional[bool]=True, **kwargs) -> Calendar:  # noqa: E501
        ...

    @validate_arguments
    def create_calendar(self, create_calendar_request : Annotated[CreateCalendarRequest, Field(..., description="A request to create the calendar")], async_req: Optional[bool]=None, **kwargs) -> Union[Calendar, Awaitable[Calendar]]:  # noqa: E501
        """[EARLY ACCESS] CreateCalendar: Create a calendar in its generic form  # noqa: E501

        Create a calendar in a generic form which can be used to store date events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_calendar(create_calendar_request, async_req=True)
        >>> result = thread.get()

        :param create_calendar_request: A request to create the calendar (required)
        :type create_calendar_request: CreateCalendarRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Calendar
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_calendar_with_http_info(create_calendar_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_calendar_with_http_info(self, create_calendar_request : Annotated[CreateCalendarRequest, Field(..., description="A request to create the calendar")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CreateCalendar: Create a calendar in its generic form  # noqa: E501

        Create a calendar in a generic form which can be used to store date events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_calendar_with_http_info(create_calendar_request, async_req=True)
        >>> result = thread.get()

        :param create_calendar_request: A request to create the calendar (required)
        :type create_calendar_request: CreateCalendarRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Calendar, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_calendar_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_calendar_request'] is not None:
            _body_params = _params['create_calendar_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Calendar",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], **kwargs) -> Calendar:  # noqa: E501
        ...

    @overload
    def delete_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], async_req: Optional[bool]=True, **kwargs) -> Calendar:  # noqa: E501
        ...

    @validate_arguments
    def delete_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], async_req: Optional[bool]=None, **kwargs) -> Union[Calendar, Awaitable[Calendar]]:  # noqa: E501
        """[EARLY ACCESS] DeleteCalendar: Delete a calendar  # noqa: E501

        Delete a calendar and all of its respective dates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_calendar(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Calendar
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_calendar_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_calendar_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeleteCalendar: Delete a calendar  # noqa: E501

        Delete a calendar and all of its respective dates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_calendar_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Calendar, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Calendar",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_date_from_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], date_id : Annotated[StrictStr, Field(..., description="Identifier of the date to be removed")], **kwargs) -> CalendarDate:  # noqa: E501
        ...

    @overload
    def delete_date_from_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], date_id : Annotated[StrictStr, Field(..., description="Identifier of the date to be removed")], async_req: Optional[bool]=True, **kwargs) -> CalendarDate:  # noqa: E501
        ...

    @validate_arguments
    def delete_date_from_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], date_id : Annotated[StrictStr, Field(..., description="Identifier of the date to be removed")], async_req: Optional[bool]=None, **kwargs) -> Union[CalendarDate, Awaitable[CalendarDate]]:  # noqa: E501
        """DeleteDateFromCalendar: Remove a date from a calendar  # noqa: E501

        Remove a date from a calendar.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_date_from_calendar(scope, code, date_id, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param date_id: Identifier of the date to be removed (required)
        :type date_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalendarDate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_date_from_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_date_from_calendar_with_http_info(scope, code, date_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_date_from_calendar_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], date_id : Annotated[StrictStr, Field(..., description="Identifier of the date to be removed")], **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteDateFromCalendar: Remove a date from a calendar  # noqa: E501

        Remove a date from a calendar.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_date_from_calendar_with_http_info(scope, code, date_id, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param date_id: Identifier of the date to be removed (required)
        :type date_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CalendarDate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'date_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_date_from_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['date_id']:
            _path_params['dateId'] = _params['date_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CalendarDate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic/{scope}/{code}/dates/{dateId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_dates_from_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], request_body : Annotated[conlist(StrictStr), Field(..., description="Identifiers of the dates to be removed")], **kwargs) -> Dict[str, CalendarDate]:  # noqa: E501
        ...

    @overload
    def delete_dates_from_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], request_body : Annotated[conlist(StrictStr), Field(..., description="Identifiers of the dates to be removed")], async_req: Optional[bool]=True, **kwargs) -> Dict[str, CalendarDate]:  # noqa: E501
        ...

    @validate_arguments
    def delete_dates_from_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], request_body : Annotated[conlist(StrictStr), Field(..., description="Identifiers of the dates to be removed")], async_req: Optional[bool]=None, **kwargs) -> Union[Dict[str, CalendarDate], Awaitable[Dict[str, CalendarDate]]]:  # noqa: E501
        """DeleteDatesFromCalendar: Delete dates from a calendar  # noqa: E501

        Delete dates from a calendar.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_dates_from_calendar(scope, code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param request_body: Identifiers of the dates to be removed (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, CalendarDate]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_dates_from_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_dates_from_calendar_with_http_info(scope, code, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_dates_from_calendar_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], request_body : Annotated[conlist(StrictStr), Field(..., description="Identifiers of the dates to be removed")], **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteDatesFromCalendar: Delete dates from a calendar  # noqa: E501

        Delete dates from a calendar.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_dates_from_calendar_with_http_info(scope, code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param request_body: Identifiers of the dates to be removed (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, CalendarDate], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dates_from_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, CalendarDate]",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic/{scope}/{code}/dates/$delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def generate_schedule(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendars to use")], valuation_schedule : Annotated[ValuationSchedule, Field(..., description="The ValuationSchedule to generate schedule dates from")], as_at : Annotated[Optional[datetime], Field(description="Optional AsAt for searching the calendar store. Defaults to Latest.")] = None, **kwargs) -> List[datetime]:  # noqa: E501
        ...

    @overload
    def generate_schedule(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendars to use")], valuation_schedule : Annotated[ValuationSchedule, Field(..., description="The ValuationSchedule to generate schedule dates from")], as_at : Annotated[Optional[datetime], Field(description="Optional AsAt for searching the calendar store. Defaults to Latest.")] = None, async_req: Optional[bool]=True, **kwargs) -> List[datetime]:  # noqa: E501
        ...

    @validate_arguments
    def generate_schedule(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendars to use")], valuation_schedule : Annotated[ValuationSchedule, Field(..., description="The ValuationSchedule to generate schedule dates from")], as_at : Annotated[Optional[datetime], Field(description="Optional AsAt for searching the calendar store. Defaults to Latest.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[List[datetime], Awaitable[List[datetime]]]:  # noqa: E501
        """[EARLY ACCESS] GenerateSchedule: Generate an ordered schedule of dates.  # noqa: E501

        Returns an ordered array of dates. The dates will only fall on business days as defined by the scope and calendar codes in the valuation schedule.              Valuations are made at a frequency defined by the valuation schedule's tenor, e.g. every day (\"1D\"), every other week (\"2W\") etc. These dates will be adjusted onto business days as defined by the schedule's rollConvention.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_schedule(scope, valuation_schedule, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendars to use (required)
        :type scope: str
        :param valuation_schedule: The ValuationSchedule to generate schedule dates from (required)
        :type valuation_schedule: ValuationSchedule
        :param as_at: Optional AsAt for searching the calendar store. Defaults to Latest.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[datetime]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the generate_schedule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.generate_schedule_with_http_info(scope, valuation_schedule, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def generate_schedule_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendars to use")], valuation_schedule : Annotated[ValuationSchedule, Field(..., description="The ValuationSchedule to generate schedule dates from")], as_at : Annotated[Optional[datetime], Field(description="Optional AsAt for searching the calendar store. Defaults to Latest.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GenerateSchedule: Generate an ordered schedule of dates.  # noqa: E501

        Returns an ordered array of dates. The dates will only fall on business days as defined by the scope and calendar codes in the valuation schedule.              Valuations are made at a frequency defined by the valuation schedule's tenor, e.g. every day (\"1D\"), every other week (\"2W\") etc. These dates will be adjusted onto business days as defined by the schedule's rollConvention.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_schedule_with_http_info(scope, valuation_schedule, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendars to use (required)
        :type scope: str
        :param valuation_schedule: The ValuationSchedule to generate schedule dates from (required)
        :type valuation_schedule: ValuationSchedule
        :param as_at: Optional AsAt for searching the calendar store. Defaults to Latest.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[datetime], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'valuation_schedule',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_schedule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['valuation_schedule'] is not None:
            _body_params = _params['valuation_schedule']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "List[datetime]",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/schedule/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar identifier")], code : Annotated[StrictStr, Field(..., description="Code of the calendar identifier")], property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendar")] = None, **kwargs) -> Calendar:  # noqa: E501
        ...

    @overload
    def get_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar identifier")], code : Annotated[StrictStr, Field(..., description="Code of the calendar identifier")], property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendar")] = None, async_req: Optional[bool]=True, **kwargs) -> Calendar:  # noqa: E501
        ...

    @validate_arguments
    def get_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar identifier")], code : Annotated[StrictStr, Field(..., description="Code of the calendar identifier")], property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendar")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Calendar, Awaitable[Calendar]]:  # noqa: E501
        """GetCalendar: Get a calendar in its generic form  # noqa: E501

        Retrieve a generic calendar by a specific ID at a point in AsAt time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_calendar(scope, code, property_keys, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar identifier (required)
        :type scope: str
        :param code: Code of the calendar identifier (required)
        :type code: str
        :param property_keys: A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".
        :type property_keys: List[str]
        :param as_at: The AsAt datetime at which to retrieve the calendar
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Calendar
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_calendar_with_http_info(scope, code, property_keys, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_calendar_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar identifier")], code : Annotated[StrictStr, Field(..., description="Code of the calendar identifier")], property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendar")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetCalendar: Get a calendar in its generic form  # noqa: E501

        Retrieve a generic calendar by a specific ID at a point in AsAt time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_calendar_with_http_info(scope, code, property_keys, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar identifier (required)
        :type scope: str
        :param code: Code of the calendar identifier (required)
        :type code: str
        :param property_keys: A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".
        :type property_keys: List[str]
        :param as_at: The AsAt datetime at which to retrieve the calendar
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Calendar, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'property_keys',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Calendar",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_dates(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], from_effective_at : Annotated[Optional[StrictStr], Field( description="Where the effective window of dates should begin from")] = None, to_effective_at : Annotated[Optional[StrictStr], Field( description="Where the effective window of dates should end")] = None, as_at : Annotated[Optional[datetime], Field(description="AsAt the dates should be retrieved at")] = None, id_filter : Annotated[Optional[conlist(StrictStr)], Field(description="An additional filter that will filter dates based on their identifer")] = None, **kwargs) -> ResourceListOfCalendarDate:  # noqa: E501
        ...

    @overload
    def get_dates(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], from_effective_at : Annotated[Optional[StrictStr], Field( description="Where the effective window of dates should begin from")] = None, to_effective_at : Annotated[Optional[StrictStr], Field( description="Where the effective window of dates should end")] = None, as_at : Annotated[Optional[datetime], Field(description="AsAt the dates should be retrieved at")] = None, id_filter : Annotated[Optional[conlist(StrictStr)], Field(description="An additional filter that will filter dates based on their identifer")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfCalendarDate:  # noqa: E501
        ...

    @validate_arguments
    def get_dates(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], from_effective_at : Annotated[Optional[StrictStr], Field( description="Where the effective window of dates should begin from")] = None, to_effective_at : Annotated[Optional[StrictStr], Field( description="Where the effective window of dates should end")] = None, as_at : Annotated[Optional[datetime], Field(description="AsAt the dates should be retrieved at")] = None, id_filter : Annotated[Optional[conlist(StrictStr)], Field(description="An additional filter that will filter dates based on their identifer")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfCalendarDate, Awaitable[ResourceListOfCalendarDate]]:  # noqa: E501
        """[EARLY ACCESS] GetDates: Get dates for a specific calendar  # noqa: E501

        Get dates from a specific calendar within a specific window of effective time, at a point in AsAt time. Providing an id filter can further refine the results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_dates(scope, code, from_effective_at, to_effective_at, as_at, id_filter, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param from_effective_at: Where the effective window of dates should begin from
        :type from_effective_at: str
        :param to_effective_at: Where the effective window of dates should end
        :type to_effective_at: str
        :param as_at: AsAt the dates should be retrieved at
        :type as_at: datetime
        :param id_filter: An additional filter that will filter dates based on their identifer
        :type id_filter: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfCalendarDate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_dates_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_dates_with_http_info(scope, code, from_effective_at, to_effective_at, as_at, id_filter, **kwargs)  # noqa: E501

    @validate_arguments
    def get_dates_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], from_effective_at : Annotated[Optional[StrictStr], Field( description="Where the effective window of dates should begin from")] = None, to_effective_at : Annotated[Optional[StrictStr], Field( description="Where the effective window of dates should end")] = None, as_at : Annotated[Optional[datetime], Field(description="AsAt the dates should be retrieved at")] = None, id_filter : Annotated[Optional[conlist(StrictStr)], Field(description="An additional filter that will filter dates based on their identifer")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetDates: Get dates for a specific calendar  # noqa: E501

        Get dates from a specific calendar within a specific window of effective time, at a point in AsAt time. Providing an id filter can further refine the results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_dates_with_http_info(scope, code, from_effective_at, to_effective_at, as_at, id_filter, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param from_effective_at: Where the effective window of dates should begin from
        :type from_effective_at: str
        :param to_effective_at: Where the effective window of dates should end
        :type to_effective_at: str
        :param as_at: AsAt the dates should be retrieved at
        :type as_at: datetime
        :param id_filter: An additional filter that will filter dates based on their identifer
        :type id_filter: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfCalendarDate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'from_effective_at',
            'to_effective_at',
            'as_at',
            'id_filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dates" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('from_effective_at') is not None:  # noqa: E501
            _query_params.append(('fromEffectiveAt', _params['from_effective_at']))

        if _params.get('to_effective_at') is not None:  # noqa: E501
            _query_params.append(('toEffectiveAt', _params['to_effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('id_filter') is not None:  # noqa: E501
            _query_params.append(('idFilter', _params['id_filter']))
            _collection_formats['idFilter'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfCalendarDate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic/{scope}/{code}/dates', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def is_business_date_time(self, date_time : Annotated[datetime, Field(..., description="DateTime to check - This DateTime must be UTC")], scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], as_at : Annotated[Optional[datetime], Field(description="AsAt for the request")] = None, **kwargs) -> IsBusinessDayResponse:  # noqa: E501
        ...

    @overload
    def is_business_date_time(self, date_time : Annotated[datetime, Field(..., description="DateTime to check - This DateTime must be UTC")], scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], as_at : Annotated[Optional[datetime], Field(description="AsAt for the request")] = None, async_req: Optional[bool]=True, **kwargs) -> IsBusinessDayResponse:  # noqa: E501
        ...

    @validate_arguments
    def is_business_date_time(self, date_time : Annotated[datetime, Field(..., description="DateTime to check - This DateTime must be UTC")], scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], as_at : Annotated[Optional[datetime], Field(description="AsAt for the request")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[IsBusinessDayResponse, Awaitable[IsBusinessDayResponse]]:  # noqa: E501
        """[EARLY ACCESS] IsBusinessDateTime: Check whether a DateTime is a \"Business DateTime\"  # noqa: E501

        A Business DateTime is defined as a point in time that:     * Does not represent a day that overlaps with the calendars WeekendMask     * If the calendar is a \"Holiday Calendar\" Does not overlap with any dates in the calendar     * If the calendar is a \"TradingHours Calendar\" Does overlap with a date in the calendar              All dates specified must be UTC and the upper bound of a calendar is not inclusive  e.g. From: 2020-12-25-00-00-00       To: 2020-12-26-00-00-00 IsBusinessDay(2020-12-26-00-00-00) == false  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.is_business_date_time(date_time, scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param date_time: DateTime to check - This DateTime must be UTC (required)
        :type date_time: datetime
        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param as_at: AsAt for the request
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IsBusinessDayResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the is_business_date_time_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.is_business_date_time_with_http_info(date_time, scope, code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def is_business_date_time_with_http_info(self, date_time : Annotated[datetime, Field(..., description="DateTime to check - This DateTime must be UTC")], scope : Annotated[StrictStr, Field(..., description="Scope of the calendar")], code : Annotated[StrictStr, Field(..., description="Code of the calendar")], as_at : Annotated[Optional[datetime], Field(description="AsAt for the request")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] IsBusinessDateTime: Check whether a DateTime is a \"Business DateTime\"  # noqa: E501

        A Business DateTime is defined as a point in time that:     * Does not represent a day that overlaps with the calendars WeekendMask     * If the calendar is a \"Holiday Calendar\" Does not overlap with any dates in the calendar     * If the calendar is a \"TradingHours Calendar\" Does overlap with a date in the calendar              All dates specified must be UTC and the upper bound of a calendar is not inclusive  e.g. From: 2020-12-25-00-00-00       To: 2020-12-26-00-00-00 IsBusinessDay(2020-12-26-00-00-00) == false  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.is_business_date_time_with_http_info(date_time, scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param date_time: DateTime to check - This DateTime must be UTC (required)
        :type date_time: datetime
        :param scope: Scope of the calendar (required)
        :type scope: str
        :param code: Code of the calendar (required)
        :type code: str
        :param as_at: AsAt for the request
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IsBusinessDayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'date_time',
            'scope',
            'code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method is_business_date_time" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('date_time') is not None:  # noqa: E501
            if isinstance(_params['date_time'], datetime):
                _query_params.append(('dateTime', _params['date_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('dateTime', _params['date_time']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "IsBusinessDayResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/businessday/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_calendars(self, as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendars")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> PagedResourceListOfCalendar:  # noqa: E501
        ...

    @overload
    def list_calendars(self, as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendars")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfCalendar:  # noqa: E501
        ...

    @validate_arguments
    def list_calendars(self, as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendars")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfCalendar, Awaitable[PagedResourceListOfCalendar]]:  # noqa: E501
        """[EARLY ACCESS] ListCalendars: List Calendars  # noqa: E501

        List calendars at a point in AsAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_calendars(as_at, page, limit, property_keys, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: The AsAt datetime at which to retrieve the calendars
        :type as_at: datetime
        :param page: The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param property_keys: A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".
        :type property_keys: List[str]
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfCalendar
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_calendars_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_calendars_with_http_info(as_at, page, limit, property_keys, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_calendars_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendars")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListCalendars: List Calendars  # noqa: E501

        List calendars at a point in AsAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_calendars_with_http_info(as_at, page, limit, property_keys, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: The AsAt datetime at which to retrieve the calendars
        :type as_at: datetime
        :param page: The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param property_keys: A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".
        :type property_keys: List[str]
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfCalendar, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'limit',
            'property_keys',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_calendars" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfCalendar",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_calendars_in_scope(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendars")], as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendars")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> PagedResourceListOfCalendar:  # noqa: E501
        ...

    @overload
    def list_calendars_in_scope(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendars")], as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendars")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfCalendar:  # noqa: E501
        ...

    @validate_arguments
    def list_calendars_in_scope(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendars")], as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendars")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfCalendar, Awaitable[PagedResourceListOfCalendar]]:  # noqa: E501
        """ListCalendarsInScope: List all calenders in a specified scope  # noqa: E501

        List calendars in a Scope at a point in AsAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_calendars_in_scope(scope, as_at, page, limit, property_keys, filter, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendars (required)
        :type scope: str
        :param as_at: The AsAt datetime at which to retrieve the calendars
        :type as_at: datetime
        :param page: The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param property_keys: A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".
        :type property_keys: List[str]
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfCalendar
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_calendars_in_scope_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_calendars_in_scope_with_http_info(scope, as_at, page, limit, property_keys, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_calendars_in_scope_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the calendars")], as_at : Annotated[Optional[datetime], Field(description="The AsAt datetime at which to retrieve the calendars")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListCalendarsInScope: List all calenders in a specified scope  # noqa: E501

        List calendars in a Scope at a point in AsAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_calendars_in_scope_with_http_info(scope, as_at, page, limit, property_keys, filter, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the calendars (required)
        :type scope: str
        :param as_at: The AsAt datetime at which to retrieve the calendars
        :type as_at: datetime
        :param page: The pagination token to use to continue listing calendars from a previous call to list calendars.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields             must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param property_keys: A list of property keys from the \"Calendar\" domain to decorate onto the calendar,              These take the format {domain}/{scope}/{code} e.g. \"Calendar/System/Name\".
        :type property_keys: List[str]
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfCalendar, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'as_at',
            'page',
            'limit',
            'property_keys',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_calendars_in_scope" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfCalendar",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic/{scope}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the request")], code : Annotated[StrictStr, Field(..., description="Code of the request")], update_calendar_request : Annotated[UpdateCalendarRequest, Field(..., description="The new state of the calendar")], **kwargs) -> Calendar:  # noqa: E501
        ...

    @overload
    def update_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the request")], code : Annotated[StrictStr, Field(..., description="Code of the request")], update_calendar_request : Annotated[UpdateCalendarRequest, Field(..., description="The new state of the calendar")], async_req: Optional[bool]=True, **kwargs) -> Calendar:  # noqa: E501
        ...

    @validate_arguments
    def update_calendar(self, scope : Annotated[StrictStr, Field(..., description="Scope of the request")], code : Annotated[StrictStr, Field(..., description="Code of the request")], update_calendar_request : Annotated[UpdateCalendarRequest, Field(..., description="The new state of the calendar")], async_req: Optional[bool]=None, **kwargs) -> Union[Calendar, Awaitable[Calendar]]:  # noqa: E501
        """[EARLY ACCESS] UpdateCalendar: Update a calendar  # noqa: E501

        Update the calendars WeekendMask, SourceProvider or Properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_calendar(scope, code, update_calendar_request, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the request (required)
        :type scope: str
        :param code: Code of the request (required)
        :type code: str
        :param update_calendar_request: The new state of the calendar (required)
        :type update_calendar_request: UpdateCalendarRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Calendar
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_calendar_with_http_info(scope, code, update_calendar_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_calendar_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the request")], code : Annotated[StrictStr, Field(..., description="Code of the request")], update_calendar_request : Annotated[UpdateCalendarRequest, Field(..., description="The new state of the calendar")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateCalendar: Update a calendar  # noqa: E501

        Update the calendars WeekendMask, SourceProvider or Properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_calendar_with_http_info(scope, code, update_calendar_request, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the request (required)
        :type scope: str
        :param code: Code of the request (required)
        :type code: str
        :param update_calendar_request: The new state of the calendar (required)
        :type update_calendar_request: UpdateCalendarRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Calendar, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_calendar_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_calendar_request'] is not None:
            _body_params = _params['update_calendar_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Calendar",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/calendars/generic/{scope}/{code}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
