# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Dict, Optional

from lusid.models.account import Account
from lusid.models.account_properties import AccountProperties
from lusid.models.accounts_upsert_response import AccountsUpsertResponse
from lusid.models.chart_of_accounts import ChartOfAccounts
from lusid.models.chart_of_accounts_properties import ChartOfAccountsProperties
from lusid.models.chart_of_accounts_request import ChartOfAccountsRequest
from lusid.models.cleardown_module_details import CleardownModuleDetails
from lusid.models.cleardown_module_request import CleardownModuleRequest
from lusid.models.cleardown_module_response import CleardownModuleResponse
from lusid.models.cleardown_module_rule import CleardownModuleRule
from lusid.models.cleardown_module_rules_updated_response import CleardownModuleRulesUpdatedResponse
from lusid.models.delete_accounts_response import DeleteAccountsResponse
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.general_ledger_profile_mapping import GeneralLedgerProfileMapping
from lusid.models.general_ledger_profile_request import GeneralLedgerProfileRequest
from lusid.models.general_ledger_profile_response import GeneralLedgerProfileResponse
from lusid.models.model_property import ModelProperty
from lusid.models.operation import Operation
from lusid.models.paged_resource_list_of_account import PagedResourceListOfAccount
from lusid.models.paged_resource_list_of_chart_of_accounts import PagedResourceListOfChartOfAccounts
from lusid.models.paged_resource_list_of_cleardown_module_response import PagedResourceListOfCleardownModuleResponse
from lusid.models.paged_resource_list_of_cleardown_module_rule import PagedResourceListOfCleardownModuleRule
from lusid.models.paged_resource_list_of_general_ledger_profile_response import PagedResourceListOfGeneralLedgerProfileResponse
from lusid.models.paged_resource_list_of_posting_module_response import PagedResourceListOfPostingModuleResponse
from lusid.models.paged_resource_list_of_posting_module_rule import PagedResourceListOfPostingModuleRule
from lusid.models.posting_module_details import PostingModuleDetails
from lusid.models.posting_module_request import PostingModuleRequest
from lusid.models.posting_module_response import PostingModuleResponse
from lusid.models.posting_module_rule import PostingModuleRule
from lusid.models.posting_module_rules_updated_response import PostingModuleRulesUpdatedResponse

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class ChartOfAccountsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], chart_of_accounts_request : Annotated[ChartOfAccountsRequest, Field(..., description="The definition of the Chart of Accounts.")], **kwargs) -> ChartOfAccounts:  # noqa: E501
        ...

    @overload
    def create_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], chart_of_accounts_request : Annotated[ChartOfAccountsRequest, Field(..., description="The definition of the Chart of Accounts.")], async_req: Optional[bool]=True, **kwargs) -> ChartOfAccounts:  # noqa: E501
        ...

    @validate_arguments
    def create_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], chart_of_accounts_request : Annotated[ChartOfAccountsRequest, Field(..., description="The definition of the Chart of Accounts.")], async_req: Optional[bool]=None, **kwargs) -> Union[ChartOfAccounts, Awaitable[ChartOfAccounts]]:  # noqa: E501
        """[EXPERIMENTAL] CreateChartOfAccounts: Create a Chart of Accounts  # noqa: E501

        Create the given Chart of Accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_chart_of_accounts(scope, chart_of_accounts_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param chart_of_accounts_request: The definition of the Chart of Accounts. (required)
        :type chart_of_accounts_request: ChartOfAccountsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ChartOfAccounts
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_chart_of_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_chart_of_accounts_with_http_info(scope, chart_of_accounts_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_chart_of_accounts_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], chart_of_accounts_request : Annotated[ChartOfAccountsRequest, Field(..., description="The definition of the Chart of Accounts.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateChartOfAccounts: Create a Chart of Accounts  # noqa: E501

        Create the given Chart of Accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_chart_of_accounts_with_http_info(scope, chart_of_accounts_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param chart_of_accounts_request: The definition of the Chart of Accounts. (required)
        :type chart_of_accounts_request: ChartOfAccountsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ChartOfAccounts, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'chart_of_accounts_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_chart_of_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['chart_of_accounts_request'] is not None:
            _body_params = _params['chart_of_accounts_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "ChartOfAccounts",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_request : Annotated[CleardownModuleRequest, Field(..., description="The definition of the Cleardown Module.")], **kwargs) -> CleardownModuleResponse:  # noqa: E501
        ...

    @overload
    def create_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_request : Annotated[CleardownModuleRequest, Field(..., description="The definition of the Cleardown Module.")], async_req: Optional[bool]=True, **kwargs) -> CleardownModuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def create_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_request : Annotated[CleardownModuleRequest, Field(..., description="The definition of the Cleardown Module.")], async_req: Optional[bool]=None, **kwargs) -> Union[CleardownModuleResponse, Awaitable[CleardownModuleResponse]]:  # noqa: E501
        """[EXPERIMENTAL] CreateCleardownModule: Create a Cleardown Module  # noqa: E501

        Create the given Cleardown Module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cleardown_module(scope, code, cleardown_module_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_request: The definition of the Cleardown Module. (required)
        :type cleardown_module_request: CleardownModuleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CleardownModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_cleardown_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_cleardown_module_with_http_info(scope, code, cleardown_module_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_cleardown_module_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_request : Annotated[CleardownModuleRequest, Field(..., description="The definition of the Cleardown Module.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateCleardownModule: Create a Cleardown Module  # noqa: E501

        Create the given Cleardown Module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cleardown_module_with_http_info(scope, code, cleardown_module_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_request: The definition of the Cleardown Module. (required)
        :type cleardown_module_request: CleardownModuleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CleardownModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'cleardown_module_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cleardown_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['cleardown_module_request'] is not None:
            _body_params = _params['cleardown_module_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "CleardownModuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/cleardownmodules', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_general_ledger_profile(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts.")], general_ledger_profile_request : Annotated[GeneralLedgerProfileRequest, Field(..., description="The definition of the General Ledger Profile.")], **kwargs) -> GeneralLedgerProfileResponse:  # noqa: E501
        ...

    @overload
    def create_general_ledger_profile(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts.")], general_ledger_profile_request : Annotated[GeneralLedgerProfileRequest, Field(..., description="The definition of the General Ledger Profile.")], async_req: Optional[bool]=True, **kwargs) -> GeneralLedgerProfileResponse:  # noqa: E501
        ...

    @validate_arguments
    def create_general_ledger_profile(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts.")], general_ledger_profile_request : Annotated[GeneralLedgerProfileRequest, Field(..., description="The definition of the General Ledger Profile.")], async_req: Optional[bool]=None, **kwargs) -> Union[GeneralLedgerProfileResponse, Awaitable[GeneralLedgerProfileResponse]]:  # noqa: E501
        """[EXPERIMENTAL] CreateGeneralLedgerProfile: Create a General Ledger Profile.  # noqa: E501

        Create the given General Ledger profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_general_ledger_profile(scope, code, general_ledger_profile_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. (required)
        :type code: str
        :param general_ledger_profile_request: The definition of the General Ledger Profile. (required)
        :type general_ledger_profile_request: GeneralLedgerProfileRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GeneralLedgerProfileResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_general_ledger_profile_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_general_ledger_profile_with_http_info(scope, code, general_ledger_profile_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_general_ledger_profile_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts.")], general_ledger_profile_request : Annotated[GeneralLedgerProfileRequest, Field(..., description="The definition of the General Ledger Profile.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateGeneralLedgerProfile: Create a General Ledger Profile.  # noqa: E501

        Create the given General Ledger profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_general_ledger_profile_with_http_info(scope, code, general_ledger_profile_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. (required)
        :type code: str
        :param general_ledger_profile_request: The definition of the General Ledger Profile. (required)
        :type general_ledger_profile_request: GeneralLedgerProfileRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GeneralLedgerProfileResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'general_ledger_profile_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_general_ledger_profile" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['general_ledger_profile_request'] is not None:
            _body_params = _params['general_ledger_profile_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "GeneralLedgerProfileResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/generalledgerprofile', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_request : Annotated[PostingModuleRequest, Field(..., description="The definition of the Posting Module.")], **kwargs) -> PostingModuleResponse:  # noqa: E501
        ...

    @overload
    def create_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_request : Annotated[PostingModuleRequest, Field(..., description="The definition of the Posting Module.")], async_req: Optional[bool]=True, **kwargs) -> PostingModuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def create_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_request : Annotated[PostingModuleRequest, Field(..., description="The definition of the Posting Module.")], async_req: Optional[bool]=None, **kwargs) -> Union[PostingModuleResponse, Awaitable[PostingModuleResponse]]:  # noqa: E501
        """[EXPERIMENTAL] CreatePostingModule: Create a Posting Module  # noqa: E501

        Create the given Posting Module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_posting_module(scope, code, posting_module_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_request: The definition of the Posting Module. (required)
        :type posting_module_request: PostingModuleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostingModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_posting_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_posting_module_with_http_info(scope, code, posting_module_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_posting_module_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_request : Annotated[PostingModuleRequest, Field(..., description="The definition of the Posting Module.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreatePostingModule: Create a Posting Module  # noqa: E501

        Create the given Posting Module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_posting_module_with_http_info(scope, code, posting_module_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_request: The definition of the Posting Module. (required)
        :type posting_module_request: PostingModuleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostingModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'posting_module_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_posting_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['posting_module_request'] is not None:
            _body_params = _params['posting_module_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "PostingModuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/postingmodules', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], request_body : Annotated[conlist(StrictStr), Field(..., description="The codes of the accounts to delete.")], delete_mode : Annotated[Optional[StrictStr], Field( description="The delete mode to use (defaults to 'Soft').")] = None, **kwargs) -> DeleteAccountsResponse:  # noqa: E501
        ...

    @overload
    def delete_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], request_body : Annotated[conlist(StrictStr), Field(..., description="The codes of the accounts to delete.")], delete_mode : Annotated[Optional[StrictStr], Field( description="The delete mode to use (defaults to 'Soft').")] = None, async_req: Optional[bool]=True, **kwargs) -> DeleteAccountsResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], request_body : Annotated[conlist(StrictStr), Field(..., description="The codes of the accounts to delete.")], delete_mode : Annotated[Optional[StrictStr], Field( description="The delete mode to use (defaults to 'Soft').")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeleteAccountsResponse, Awaitable[DeleteAccountsResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteAccounts: Soft or hard delete multiple accounts  # noqa: E501

        Delete one or more account from the Chart of Accounts. Soft deletion marks the account as inactive While the Hard deletion is deleting the account.  The maximum number of accounts that this method can delete per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_accounts(scope, code, request_body, delete_mode, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts. (required)
        :type code: str
        :param request_body: The codes of the accounts to delete. (required)
        :type request_body: List[str]
        :param delete_mode: The delete mode to use (defaults to 'Soft').
        :type delete_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeleteAccountsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_accounts_with_http_info(scope, code, request_body, delete_mode, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_accounts_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], request_body : Annotated[conlist(StrictStr), Field(..., description="The codes of the accounts to delete.")], delete_mode : Annotated[Optional[StrictStr], Field( description="The delete mode to use (defaults to 'Soft').")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteAccounts: Soft or hard delete multiple accounts  # noqa: E501

        Delete one or more account from the Chart of Accounts. Soft deletion marks the account as inactive While the Hard deletion is deleting the account.  The maximum number of accounts that this method can delete per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_accounts_with_http_info(scope, code, request_body, delete_mode, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts. (required)
        :type code: str
        :param request_body: The codes of the accounts to delete. (required)
        :type request_body: List[str]
        :param delete_mode: The delete mode to use (defaults to 'Soft').
        :type delete_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeleteAccountsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'request_body',
            'delete_mode'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('delete_mode') is not None:  # noqa: E501
            _query_params.append(('deleteMode', _params['delete_mode']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeleteAccountsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/accounts/$delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to be deleted. Together with the scope this uniquely identifies the Chart of Accounts.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to be deleted. Together with the scope this uniquely identifies the Chart of Accounts.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to be deleted. Together with the scope this uniquely identifies the Chart of Accounts.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteChartOfAccounts: Delete a Chart of Accounts  # noqa: E501

        Delete the given Chart of Accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_chart_of_accounts(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts to be deleted. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts to be deleted. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_chart_of_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_chart_of_accounts_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_chart_of_accounts_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to be deleted. Together with the scope this uniquely identifies the Chart of Accounts.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteChartOfAccounts: Delete a Chart of Accounts  # noqa: E501

        Delete the given Chart of Accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_chart_of_accounts_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts to be deleted. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts to be deleted. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chart_of_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be deleted.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be deleted.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be deleted.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteCleardownModule: Delete a Cleardown Module.  # noqa: E501

        Delete the given Cleardown Module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_cleardown_module(scope, code, cleardown_module_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the Cleardown Module to be deleted. (required)
        :type cleardown_module_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_cleardown_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_cleardown_module_with_http_info(scope, code, cleardown_module_code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_cleardown_module_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be deleted.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteCleardownModule: Delete a Cleardown Module.  # noqa: E501

        Delete the given Cleardown Module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_cleardown_module_with_http_info(scope, code, cleardown_module_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the Cleardown Module to be deleted. (required)
        :type cleardown_module_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'cleardown_module_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cleardown_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['cleardown_module_code']:
            _path_params['cleardownModuleCode'] = _params['cleardown_module_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/cleardownmodules/{cleardownModuleCode}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_general_ledger_profile(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts for the General Ledger Profile.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts for the General Ledger Profile.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The Code of the General Ledger Profile.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_general_ledger_profile(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts for the General Ledger Profile.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts for the General Ledger Profile.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The Code of the General Ledger Profile.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_general_ledger_profile(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts for the General Ledger Profile.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts for the General Ledger Profile.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The Code of the General Ledger Profile.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteGeneralLedgerProfile: Delete a General Ledger Profile.  # noqa: E501

        Delete the given General Ledger Profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_general_ledger_profile(scope, code, general_ledger_profile_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts for the General Ledger Profile. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts for the General Ledger Profile. (required)
        :type code: str
        :param general_ledger_profile_code: The Code of the General Ledger Profile. (required)
        :type general_ledger_profile_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_general_ledger_profile_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_general_ledger_profile_with_http_info(scope, code, general_ledger_profile_code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_general_ledger_profile_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts for the General Ledger Profile.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts for the General Ledger Profile.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The Code of the General Ledger Profile.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteGeneralLedgerProfile: Delete a General Ledger Profile.  # noqa: E501

        Delete the given General Ledger Profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_general_ledger_profile_with_http_info(scope, code, general_ledger_profile_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts for the General Ledger Profile. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts for the General Ledger Profile. (required)
        :type code: str
        :param general_ledger_profile_code: The Code of the General Ledger Profile. (required)
        :type general_ledger_profile_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'general_ledger_profile_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_general_ledger_profile" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['general_ledger_profile_code']:
            _path_params['generalLedgerProfileCode'] = _params['general_ledger_profile_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/generalledgerprofile/{generalLedgerProfileCode}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be deleted.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be deleted.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be deleted.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeletePostingModule: Delete a Posting Module.  # noqa: E501

        Delete the given Posting Module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_posting_module(scope, code, posting_module_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the Posting Module to be deleted. (required)
        :type posting_module_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_posting_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_posting_module_with_http_info(scope, code, posting_module_code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_posting_module_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be deleted.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeletePostingModule: Delete a Posting Module.  # noqa: E501

        Delete the given Posting Module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_posting_module_with_http_info(scope, code, posting_module_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the Posting Module to be deleted. (required)
        :type posting_module_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'posting_module_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_posting_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['posting_module_code']:
            _path_params['postingModuleCode'] = _params['posting_module_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/postingmodules/{postingModuleCode}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_account(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The code of the Account.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Account properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Account definition. Defaults to returning the latest version of the Account definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Account' domain to decorate onto the Account.             These must take the format {domain}/{scope}/{code}, for example 'Account/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> Account:  # noqa: E501
        ...

    @overload
    def get_account(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The code of the Account.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Account properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Account definition. Defaults to returning the latest version of the Account definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Account' domain to decorate onto the Account.             These must take the format {domain}/{scope}/{code}, for example 'Account/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=True, **kwargs) -> Account:  # noqa: E501
        ...

    @validate_arguments
    def get_account(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The code of the Account.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Account properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Account definition. Defaults to returning the latest version of the Account definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Account' domain to decorate onto the Account.             These must take the format {domain}/{scope}/{code}, for example 'Account/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Account, Awaitable[Account]]:  # noqa: E501
        """[EXPERIMENTAL] GetAccount: Get Account  # noqa: E501

        Retrieve the definition of a particular Account which is part of a Chart of Accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account(scope, code, account_code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param account_code: The code of the Account. (required)
        :type account_code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Account properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Account definition. Defaults to returning the latest version of the Account definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Account' domain to decorate onto the Account.             These must take the format {domain}/{scope}/{code}, for example 'Account/Manager/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Account
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_account_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_account_with_http_info(scope, code, account_code, effective_at, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_account_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The code of the Account.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Account properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Account definition. Defaults to returning the latest version of the Account definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Account' domain to decorate onto the Account.             These must take the format {domain}/{scope}/{code}, for example 'Account/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetAccount: Get Account  # noqa: E501

        Retrieve the definition of a particular Account which is part of a Chart of Accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_with_http_info(scope, code, account_code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param account_code: The code of the Account. (required)
        :type account_code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Account properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Account definition. Defaults to returning the latest version of the Account definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Account' domain to decorate onto the Account.             These must take the format {domain}/{scope}/{code}, for example 'Account/Manager/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Account, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'account_code',
            'effective_at',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['account_code']:
            _path_params['accountCode'] = _params['account_code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Account",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/accounts/{accountCode}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_account_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The unique ID of the account to get properties for.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Account's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Account's properties. Defaults to return the latest version of each property if not specified.")] = None, **kwargs) -> AccountProperties:  # noqa: E501
        ...

    @overload
    def get_account_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The unique ID of the account to get properties for.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Account's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Account's properties. Defaults to return the latest version of each property if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> AccountProperties:  # noqa: E501
        ...

    @validate_arguments
    def get_account_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The unique ID of the account to get properties for.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Account's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Account's properties. Defaults to return the latest version of each property if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[AccountProperties, Awaitable[AccountProperties]]:  # noqa: E501
        """[EXPERIMENTAL] GetAccountProperties: Get Account properties  # noqa: E501

        Get all the properties of a single account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_properties(scope, code, account_code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param account_code: The unique ID of the account to get properties for. (required)
        :type account_code: str
        :param effective_at: The effective datetime or cut label at which to list the Account's properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Account's properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_account_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_account_properties_with_http_info(scope, code, account_code, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_account_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The unique ID of the account to get properties for.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Account's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Account's properties. Defaults to return the latest version of each property if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetAccountProperties: Get Account properties  # noqa: E501

        Get all the properties of a single account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_properties_with_http_info(scope, code, account_code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param account_code: The unique ID of the account to get properties for. (required)
        :type account_code: str
        :param effective_at: The effective datetime or cut label at which to list the Account's properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Account's properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'account_code',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['account_code']:
            _path_params['accountCode'] = _params['account_code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AccountProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/accounts/{accountCode}/properties', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Chart of Accounts properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Chart of Accounts definition. Defaults to returning the latest version of the Chart of Accounts definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ChartOfAccounts' domain to decorate onto the Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> ChartOfAccounts:  # noqa: E501
        ...

    @overload
    def get_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Chart of Accounts properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Chart of Accounts definition. Defaults to returning the latest version of the Chart of Accounts definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ChartOfAccounts' domain to decorate onto the Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=True, **kwargs) -> ChartOfAccounts:  # noqa: E501
        ...

    @validate_arguments
    def get_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Chart of Accounts properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Chart of Accounts definition. Defaults to returning the latest version of the Chart of Accounts definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ChartOfAccounts' domain to decorate onto the Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ChartOfAccounts, Awaitable[ChartOfAccounts]]:  # noqa: E501
        """[EXPERIMENTAL] GetChartOfAccounts: Get ChartOfAccounts  # noqa: E501

        Retrieve the definition of a particular Chart of Accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_chart_of_accounts(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Chart of Accounts properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Chart of Accounts definition. Defaults to returning the latest version of the Chart of Accounts definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'ChartOfAccounts' domain to decorate onto the Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ChartOfAccounts
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_chart_of_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_chart_of_accounts_with_http_info(scope, code, effective_at, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_chart_of_accounts_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Chart of Accounts properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Chart of Accounts definition. Defaults to returning the latest version of the Chart of Accounts definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ChartOfAccounts' domain to decorate onto the Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetChartOfAccounts: Get ChartOfAccounts  # noqa: E501

        Retrieve the definition of a particular Chart of Accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_chart_of_accounts_with_http_info(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Chart of Accounts properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Chart of Accounts definition. Defaults to returning the latest version of the Chart of Accounts definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'ChartOfAccounts' domain to decorate onto the Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ChartOfAccounts, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chart_of_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ChartOfAccounts",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_chart_of_accounts_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the chart of accounts to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the chart of accounts to list the properties for. Together with the scope this uniquely identifies the chart of accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the chart of accounts' properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the chart of accounts' properties. Defaults to return the latest version of each property if not specified.")] = None, **kwargs) -> ChartOfAccountsProperties:  # noqa: E501
        ...

    @overload
    def get_chart_of_accounts_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the chart of accounts to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the chart of accounts to list the properties for. Together with the scope this uniquely identifies the chart of accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the chart of accounts' properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the chart of accounts' properties. Defaults to return the latest version of each property if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> ChartOfAccountsProperties:  # noqa: E501
        ...

    @validate_arguments
    def get_chart_of_accounts_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the chart of accounts to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the chart of accounts to list the properties for. Together with the scope this uniquely identifies the chart of accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the chart of accounts' properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the chart of accounts' properties. Defaults to return the latest version of each property if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ChartOfAccountsProperties, Awaitable[ChartOfAccountsProperties]]:  # noqa: E501
        """[EXPERIMENTAL] GetChartOfAccountsProperties: Get chart of accounts properties  # noqa: E501

        Get all the properties of a single chart of accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_chart_of_accounts_properties(scope, code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the chart of accounts to list the properties for. (required)
        :type scope: str
        :param code: The code of the chart of accounts to list the properties for. Together with the scope this uniquely identifies the chart of accounts. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the chart of accounts' properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the chart of accounts' properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ChartOfAccountsProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_chart_of_accounts_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_chart_of_accounts_properties_with_http_info(scope, code, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_chart_of_accounts_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the chart of accounts to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the chart of accounts to list the properties for. Together with the scope this uniquely identifies the chart of accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the chart of accounts' properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the chart of accounts' properties. Defaults to return the latest version of each property if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetChartOfAccountsProperties: Get chart of accounts properties  # noqa: E501

        Get all the properties of a single chart of accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_chart_of_accounts_properties_with_http_info(scope, code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the chart of accounts to list the properties for. (required)
        :type scope: str
        :param code: The code of the chart of accounts to list the properties for. Together with the scope this uniquely identifies the chart of accounts. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the chart of accounts' properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the chart of accounts' properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ChartOfAccountsProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chart_of_accounts_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ChartOfAccountsProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/properties', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Cleardown Module. Defaults to return the latest version of the Cleardown Module if not specified.")] = None, **kwargs) -> CleardownModuleResponse:  # noqa: E501
        ...

    @overload
    def get_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Cleardown Module. Defaults to return the latest version of the Cleardown Module if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> CleardownModuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Cleardown Module. Defaults to return the latest version of the Cleardown Module if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[CleardownModuleResponse, Awaitable[CleardownModuleResponse]]:  # noqa: E501
        """[EXPERIMENTAL] GetCleardownModule: Get a Cleardown Module  # noqa: E501

        Retrieve the definition of a Cleardown Module complete with its rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cleardown_module(scope, code, cleardown_module_code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the Cleardown Module. (required)
        :type cleardown_module_code: str
        :param as_at: The asAt datetime at which to retrieve the Cleardown Module. Defaults to return the latest version of the Cleardown Module if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CleardownModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_cleardown_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_cleardown_module_with_http_info(scope, code, cleardown_module_code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_cleardown_module_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Cleardown Module. Defaults to return the latest version of the Cleardown Module if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetCleardownModule: Get a Cleardown Module  # noqa: E501

        Retrieve the definition of a Cleardown Module complete with its rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cleardown_module_with_http_info(scope, code, cleardown_module_code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the Cleardown Module. (required)
        :type cleardown_module_code: str
        :param as_at: The asAt datetime at which to retrieve the Cleardown Module. Defaults to return the latest version of the Cleardown Module if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CleardownModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'cleardown_module_code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cleardown_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['cleardown_module_code']:
            _path_params['cleardownModuleCode'] = _params['cleardown_module_code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CleardownModuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/cleardownmodules/{cleardownModuleCode}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_general_ledger_profile(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts for the General Ledger Profile.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts for the General Ledger Profile.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The General Ledger Profile Code of the General Ledger Profile.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the General Ledger Profile. Defaults to return the latest version of the General Ledger Profile if not specified.")] = None, **kwargs) -> GeneralLedgerProfileResponse:  # noqa: E501
        ...

    @overload
    def get_general_ledger_profile(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts for the General Ledger Profile.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts for the General Ledger Profile.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The General Ledger Profile Code of the General Ledger Profile.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the General Ledger Profile. Defaults to return the latest version of the General Ledger Profile if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> GeneralLedgerProfileResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_general_ledger_profile(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts for the General Ledger Profile.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts for the General Ledger Profile.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The General Ledger Profile Code of the General Ledger Profile.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the General Ledger Profile. Defaults to return the latest version of the General Ledger Profile if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[GeneralLedgerProfileResponse, Awaitable[GeneralLedgerProfileResponse]]:  # noqa: E501
        """[EXPERIMENTAL] GetGeneralLedgerProfile: Get a General Ledger Profile.  # noqa: E501

        Get the given General Ledger Profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_general_ledger_profile(scope, code, general_ledger_profile_code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts for the General Ledger Profile. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts for the General Ledger Profile. (required)
        :type code: str
        :param general_ledger_profile_code: The General Ledger Profile Code of the General Ledger Profile. (required)
        :type general_ledger_profile_code: str
        :param as_at: The asAt datetime at which to retrieve the General Ledger Profile. Defaults to return the latest version of the General Ledger Profile if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GeneralLedgerProfileResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_general_ledger_profile_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_general_ledger_profile_with_http_info(scope, code, general_ledger_profile_code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_general_ledger_profile_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts for the General Ledger Profile.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts for the General Ledger Profile.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The General Ledger Profile Code of the General Ledger Profile.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the General Ledger Profile. Defaults to return the latest version of the General Ledger Profile if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetGeneralLedgerProfile: Get a General Ledger Profile.  # noqa: E501

        Get the given General Ledger Profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_general_ledger_profile_with_http_info(scope, code, general_ledger_profile_code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts for the General Ledger Profile. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts for the General Ledger Profile. (required)
        :type code: str
        :param general_ledger_profile_code: The General Ledger Profile Code of the General Ledger Profile. (required)
        :type general_ledger_profile_code: str
        :param as_at: The asAt datetime at which to retrieve the General Ledger Profile. Defaults to return the latest version of the General Ledger Profile if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GeneralLedgerProfileResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'general_ledger_profile_code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_general_ledger_profile" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['general_ledger_profile_code']:
            _path_params['generalLedgerProfileCode'] = _params['general_ledger_profile_code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GeneralLedgerProfileResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/generalledgerprofile/{generalLedgerProfileCode}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Posting Module. Defaults to return the latest version of the Posting Module if not specified.")] = None, **kwargs) -> PostingModuleResponse:  # noqa: E501
        ...

    @overload
    def get_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Posting Module. Defaults to return the latest version of the Posting Module if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> PostingModuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Posting Module. Defaults to return the latest version of the Posting Module if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PostingModuleResponse, Awaitable[PostingModuleResponse]]:  # noqa: E501
        """[EXPERIMENTAL] GetPostingModule: Get a Posting Module  # noqa: E501

        Retrieve the definition of a Posting Module complete with its rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_posting_module(scope, code, posting_module_code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the Posting Module. (required)
        :type posting_module_code: str
        :param as_at: The asAt datetime at which to retrieve the Posting Module. Defaults to return the latest version of the Posting Module if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostingModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_posting_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_posting_module_with_http_info(scope, code, posting_module_code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_posting_module_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Posting Module. Defaults to return the latest version of the Posting Module if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetPostingModule: Get a Posting Module  # noqa: E501

        Retrieve the definition of a Posting Module complete with its rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_posting_module_with_http_info(scope, code, posting_module_code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the Posting Module. (required)
        :type posting_module_code: str
        :param as_at: The asAt datetime at which to retrieve the Posting Module. Defaults to return the latest version of the Posting Module if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostingModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'posting_module_code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_posting_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['posting_module_code']:
            _path_params['postingModuleCode'] = _params['posting_module_code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PostingModuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/postingmodules/{postingModuleCode}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties decorated on Accounts. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Accounts. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Account type, specify \"code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Account' domain to decorate onto the Account.             These must have the format {domain}/{scope}/{code}, for example 'Account/system/Name'.")] = None, **kwargs) -> PagedResourceListOfAccount:  # noqa: E501
        ...

    @overload
    def list_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties decorated on Accounts. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Accounts. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Account type, specify \"code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Account' domain to decorate onto the Account.             These must have the format {domain}/{scope}/{code}, for example 'Account/system/Name'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfAccount:  # noqa: E501
        ...

    @validate_arguments
    def list_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties decorated on Accounts. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Accounts. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Account type, specify \"code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Account' domain to decorate onto the Account.             These must have the format {domain}/{scope}/{code}, for example 'Account/system/Name'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfAccount, Awaitable[PagedResourceListOfAccount]]:  # noqa: E501
        """[EXPERIMENTAL] ListAccounts: List Accounts  # noqa: E501

        List the accounts in a Chart of Accounts  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_accounts(scope, code, effective_at, as_at, page, limit, filter, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties decorated on Accounts. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Accounts. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Account type, specify \"code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param property_keys: A list of property keys from the 'Account' domain to decorate onto the Account.             These must have the format {domain}/{scope}/{code}, for example 'Account/system/Name'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfAccount
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_accounts_with_http_info(scope, code, effective_at, as_at, page, limit, filter, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_accounts_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties decorated on Accounts. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Accounts. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Account type, specify \"code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Account' domain to decorate onto the Account.             These must have the format {domain}/{scope}/{code}, for example 'Account/system/Name'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListAccounts: List Accounts  # noqa: E501

        List the accounts in a Chart of Accounts  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_accounts_with_http_info(scope, code, effective_at, as_at, page, limit, filter, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties decorated on Accounts. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Accounts. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Account type, specify \"code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param property_keys: A list of property keys from the 'Account' domain to decorate onto the Account.             These must have the format {domain}/{scope}/{code}, for example 'Account/system/Name'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfAccount, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfAccount",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/accounts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_charts_of_accounts(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Chart Of Accounts. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the charts of accounts. Defaults to returning the latest version             of each Chart of Accounts if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Chart of Accounts type, specify \"id.Code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ChartOfAccounts' domain to decorate onto each Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'.")] = None, **kwargs) -> PagedResourceListOfChartOfAccounts:  # noqa: E501
        ...

    @overload
    def list_charts_of_accounts(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Chart Of Accounts. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the charts of accounts. Defaults to returning the latest version             of each Chart of Accounts if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Chart of Accounts type, specify \"id.Code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ChartOfAccounts' domain to decorate onto each Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfChartOfAccounts:  # noqa: E501
        ...

    @validate_arguments
    def list_charts_of_accounts(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Chart Of Accounts. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the charts of accounts. Defaults to returning the latest version             of each Chart of Accounts if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Chart of Accounts type, specify \"id.Code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ChartOfAccounts' domain to decorate onto each Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfChartOfAccounts, Awaitable[PagedResourceListOfChartOfAccounts]]:  # noqa: E501
        """[EXPERIMENTAL] ListChartsOfAccounts: List Charts of Accounts  # noqa: E501

        List all the Charts of Accounts matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_charts_of_accounts(effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the Chart Of Accounts. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the charts of accounts. Defaults to returning the latest version             of each Chart of Accounts if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Chart of Accounts type, specify \"id.Code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'ChartOfAccounts' domain to decorate onto each Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfChartOfAccounts
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_charts_of_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_charts_of_accounts_with_http_info(effective_at, as_at, page, limit, filter, sort_by, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_charts_of_accounts_with_http_info(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Chart Of Accounts. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the charts of accounts. Defaults to returning the latest version             of each Chart of Accounts if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Chart of Accounts type, specify \"id.Code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'ChartOfAccounts' domain to decorate onto each Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListChartsOfAccounts: List Charts of Accounts  # noqa: E501

        List all the Charts of Accounts matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_charts_of_accounts_with_http_info(effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the Chart Of Accounts. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the charts of accounts. Defaults to returning the latest version             of each Chart of Accounts if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing charts of accounts; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Chart of Accounts type, specify \"id.Code eq '001'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'ChartOfAccounts' domain to decorate onto each Chart of Accounts.             These must take the format {domain}/{scope}/{code}, for example 'ChartOfAccounts/Manager/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfChartOfAccounts, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_charts_of_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfChartOfAccounts",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_cleardown_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the cleardown module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing cleardown module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, **kwargs) -> PagedResourceListOfCleardownModuleRule:  # noqa: E501
        ...

    @overload
    def list_cleardown_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the cleardown module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing cleardown module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfCleardownModuleRule:  # noqa: E501
        ...

    @validate_arguments
    def list_cleardown_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the cleardown module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing cleardown module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfCleardownModuleRule, Awaitable[PagedResourceListOfCleardownModuleRule]]:  # noqa: E501
        """[EXPERIMENTAL] ListCleardownModuleRules: List Cleardown Module Rules  # noqa: E501

        List the Rules in a Cleardown Module  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cleardown_module_rules(scope, code, cleardown_module_code, as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the cleardown module. (required)
        :type cleardown_module_code: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing cleardown module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfCleardownModuleRule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_cleardown_module_rules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_cleardown_module_rules_with_http_info(scope, code, cleardown_module_code, as_at, page, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_cleardown_module_rules_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the cleardown module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing cleardown module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListCleardownModuleRules: List Cleardown Module Rules  # noqa: E501

        List the Rules in a Cleardown Module  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cleardown_module_rules_with_http_info(scope, code, cleardown_module_code, as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the cleardown module. (required)
        :type cleardown_module_code: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing cleardown module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfCleardownModuleRule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'cleardown_module_code',
            'as_at',
            'page',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cleardown_module_rules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['cleardown_module_code']:
            _path_params['cleardownModuleCode'] = _params['cleardown_module_code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfCleardownModuleRule",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/cleardownmodules/{cleardownModuleCode}/cleardownrules', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_cleardown_modules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Cleardown Module. Defaults to returning the latest version             of each Cleardown Module if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Cleardown Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Cleardown Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, **kwargs) -> PagedResourceListOfCleardownModuleResponse:  # noqa: E501
        ...

    @overload
    def list_cleardown_modules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Cleardown Module. Defaults to returning the latest version             of each Cleardown Module if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Cleardown Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Cleardown Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfCleardownModuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def list_cleardown_modules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Cleardown Module. Defaults to returning the latest version             of each Cleardown Module if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Cleardown Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Cleardown Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfCleardownModuleResponse, Awaitable[PagedResourceListOfCleardownModuleResponse]]:  # noqa: E501
        """[EXPERIMENTAL] ListCleardownModules: List Cleardown Modules  # noqa: E501

        List all the Cleardown Modules matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cleardown_modules(scope, code, as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param as_at: The asAt datetime at which to list the Cleardown Module. Defaults to returning the latest version             of each Cleardown Module if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Cleardown Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Cleardown Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfCleardownModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_cleardown_modules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_cleardown_modules_with_http_info(scope, code, as_at, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_cleardown_modules_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Cleardown Module. Defaults to returning the latest version             of each Cleardown Module if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Cleardown Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Cleardown Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListCleardownModules: List Cleardown Modules  # noqa: E501

        List all the Cleardown Modules matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cleardown_modules_with_http_info(scope, code, as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param as_at: The asAt datetime at which to list the Cleardown Module. Defaults to returning the latest version             of each Cleardown Module if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Cleardown Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Cleardown Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfCleardownModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cleardown_modules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfCleardownModuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/cleardownmodules', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_general_ledger_profiles(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the General Ledger Profiles. Defaults to returning the latest version of each General Ledger Profile if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing General Ledger Profiles; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the General Ledger profiles type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, **kwargs) -> PagedResourceListOfGeneralLedgerProfileResponse:  # noqa: E501
        ...

    @overload
    def list_general_ledger_profiles(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the General Ledger Profiles. Defaults to returning the latest version of each General Ledger Profile if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing General Ledger Profiles; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the General Ledger profiles type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfGeneralLedgerProfileResponse:  # noqa: E501
        ...

    @validate_arguments
    def list_general_ledger_profiles(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the General Ledger Profiles. Defaults to returning the latest version of each General Ledger Profile if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing General Ledger Profiles; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the General Ledger profiles type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfGeneralLedgerProfileResponse, Awaitable[PagedResourceListOfGeneralLedgerProfileResponse]]:  # noqa: E501
        """[EXPERIMENTAL] ListGeneralLedgerProfiles: List General Ledger Profiles.  # noqa: E501

        List all the General Ledger profiles matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_general_ledger_profiles(scope, code, as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts (required)
        :type scope: str
        :param code: The code of the Chart of Accounts (required)
        :type code: str
        :param as_at: The asAt datetime at which to list the General Ledger Profiles. Defaults to returning the latest version of each General Ledger Profile if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing General Ledger Profiles; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the General Ledger profiles type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfGeneralLedgerProfileResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_general_ledger_profiles_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_general_ledger_profiles_with_http_info(scope, code, as_at, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_general_ledger_profiles_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the General Ledger Profiles. Defaults to returning the latest version of each General Ledger Profile if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing General Ledger Profiles; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the General Ledger profiles type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListGeneralLedgerProfiles: List General Ledger Profiles.  # noqa: E501

        List all the General Ledger profiles matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_general_ledger_profiles_with_http_info(scope, code, as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts (required)
        :type scope: str
        :param code: The code of the Chart of Accounts (required)
        :type code: str
        :param as_at: The asAt datetime at which to list the General Ledger Profiles. Defaults to returning the latest version of each General Ledger Profile if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing General Ledger Profiles; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the General Ledger profiles type, specify \"type eq 'PeriodBoundary'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfGeneralLedgerProfileResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_general_ledger_profiles" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfGeneralLedgerProfileResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/generalledgerprofile', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_posting_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the posting module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing posting module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, **kwargs) -> PagedResourceListOfPostingModuleRule:  # noqa: E501
        ...

    @overload
    def list_posting_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the posting module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing posting module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfPostingModuleRule:  # noqa: E501
        ...

    @validate_arguments
    def list_posting_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the posting module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing posting module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfPostingModuleRule, Awaitable[PagedResourceListOfPostingModuleRule]]:  # noqa: E501
        """[EXPERIMENTAL] ListPostingModuleRules: List Posting Module Rules  # noqa: E501

        List the Rules in a Posting Module  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_posting_module_rules(scope, code, posting_module_code, as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the posting module. (required)
        :type posting_module_code: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing posting module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfPostingModuleRule
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_posting_module_rules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_posting_module_rules_with_http_info(scope, code, posting_module_code, as_at, page, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_posting_module_rules_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the posting module.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing posting module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListPostingModuleRules: List Posting Module Rules  # noqa: E501

        List the Rules in a Posting Module  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_posting_module_rules_with_http_info(scope, code, posting_module_code, as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the posting module. (required)
        :type posting_module_code: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing posting module rules; this             value is returned from the previous call. If a pagination token is provided, the filter             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the rule id, specify \"ruleId eq 'rule 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfPostingModuleRule, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'posting_module_code',
            'as_at',
            'page',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_posting_module_rules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['posting_module_code']:
            _path_params['postingModuleCode'] = _params['posting_module_code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfPostingModuleRule",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/postingmodules/{postingModuleCode}/postingrules', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_posting_modules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Posting Module. Defaults to returning the latest version             of each Posting Module if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Posting Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Posting Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, **kwargs) -> PagedResourceListOfPostingModuleResponse:  # noqa: E501
        ...

    @overload
    def list_posting_modules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Posting Module. Defaults to returning the latest version             of each Posting Module if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Posting Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Posting Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfPostingModuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def list_posting_modules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Posting Module. Defaults to returning the latest version             of each Posting Module if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Posting Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Posting Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfPostingModuleResponse, Awaitable[PagedResourceListOfPostingModuleResponse]]:  # noqa: E501
        """[EXPERIMENTAL] ListPostingModules: List Posting Modules  # noqa: E501

        List all the Posting Modules matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_posting_modules(scope, code, as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param as_at: The asAt datetime at which to list the Posting Module. Defaults to returning the latest version             of each Posting Module if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Posting Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Posting Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfPostingModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_posting_modules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_posting_modules_with_http_info(scope, code, as_at, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_posting_modules_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Posting Module. Defaults to returning the latest version             of each Posting Module if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Posting Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Posting Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListPostingModules: List Posting Modules  # noqa: E501

        List all the Posting Modules matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_posting_modules_with_http_info(scope, code, as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param as_at: The asAt datetime at which to list the Posting Module. Defaults to returning the latest version             of each Posting Module if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Posting Modules; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Posting Module status, specify \"status eq 'Active'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfPostingModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_posting_modules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfPostingModuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/postingmodules', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def patch_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> ChartOfAccounts:  # noqa: E501
        ...

    @overload
    def patch_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=True, **kwargs) -> ChartOfAccounts:  # noqa: E501
        ...

    @validate_arguments
    def patch_chart_of_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=None, **kwargs) -> Union[ChartOfAccounts, Awaitable[ChartOfAccounts]]:  # noqa: E501
        """[EXPERIMENTAL] PatchChartOfAccounts: Patch a Chart of Accounts.  # noqa: E501

        Update fields on a Chart of Accounts.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: DisplayName, Description.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_chart_of_accounts(scope, code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ChartOfAccounts
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the patch_chart_of_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.patch_chart_of_accounts_with_http_info(scope, code, operation, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_chart_of_accounts_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PatchChartOfAccounts: Patch a Chart of Accounts.  # noqa: E501

        Update fields on a Chart of Accounts.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: DisplayName, Description.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_chart_of_accounts_with_http_info(scope, code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ChartOfAccounts, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'operation'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_chart_of_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['operation'] is not None:
            _body_params = _params['operation']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ChartOfAccounts",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def patch_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> CleardownModuleResponse:  # noqa: E501
        ...

    @overload
    def patch_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=True, **kwargs) -> CleardownModuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def patch_cleardown_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=None, **kwargs) -> Union[CleardownModuleResponse, Awaitable[CleardownModuleResponse]]:  # noqa: E501
        """[EXPERIMENTAL] PatchCleardownModule: Patch a Cleardown Module  # noqa: E501

        Update fields on a Cleardown Module.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: DisplayName, Description, Rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_cleardown_module(scope, code, cleardown_module_code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the Cleardown Module to be updated. (required)
        :type cleardown_module_code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CleardownModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the patch_cleardown_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.patch_cleardown_module_with_http_info(scope, code, cleardown_module_code, operation, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_cleardown_module_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PatchCleardownModule: Patch a Cleardown Module  # noqa: E501

        Update fields on a Cleardown Module.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: DisplayName, Description, Rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_cleardown_module_with_http_info(scope, code, cleardown_module_code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the Cleardown Module to be updated. (required)
        :type cleardown_module_code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CleardownModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'cleardown_module_code',
            'operation'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_cleardown_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['cleardown_module_code']:
            _path_params['cleardownModuleCode'] = _params['cleardown_module_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['operation'] is not None:
            _body_params = _params['operation']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CleardownModuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/cleardownmodules/{cleardownModuleCode}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def patch_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> PostingModuleResponse:  # noqa: E501
        ...

    @overload
    def patch_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=True, **kwargs) -> PostingModuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def patch_posting_module(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=None, **kwargs) -> Union[PostingModuleResponse, Awaitable[PostingModuleResponse]]:  # noqa: E501
        """[EXPERIMENTAL] PatchPostingModule: Patch a Posting Module  # noqa: E501

        Update fields on a Posting Module.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: DisplayName, Description, Rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_posting_module(scope, code, posting_module_code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the Posting Module to be updated. (required)
        :type posting_module_code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostingModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the patch_posting_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.patch_posting_module_with_http_info(scope, code, posting_module_code, operation, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_posting_module_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PatchPostingModule: Patch a Posting Module  # noqa: E501

        Update fields on a Posting Module.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: DisplayName, Description, Rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_posting_module_with_http_info(scope, code, posting_module_code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the Posting Module to be updated. (required)
        :type posting_module_code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostingModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'posting_module_code',
            'operation'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_posting_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['posting_module_code']:
            _path_params['postingModuleCode'] = _params['posting_module_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['operation'] is not None:
            _body_params = _params['operation']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PostingModuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/postingmodules/{postingModuleCode}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_cleardown_module_details(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], cleardown_module_details : Annotated[CleardownModuleDetails, Field(..., description="The new details for the Cleardown Module.")], **kwargs) -> CleardownModuleResponse:  # noqa: E501
        ...

    @overload
    def set_cleardown_module_details(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], cleardown_module_details : Annotated[CleardownModuleDetails, Field(..., description="The new details for the Cleardown Module.")], async_req: Optional[bool]=True, **kwargs) -> CleardownModuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def set_cleardown_module_details(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], cleardown_module_details : Annotated[CleardownModuleDetails, Field(..., description="The new details for the Cleardown Module.")], async_req: Optional[bool]=None, **kwargs) -> Union[CleardownModuleResponse, Awaitable[CleardownModuleResponse]]:  # noqa: E501
        """[EXPERIMENTAL] SetCleardownModuleDetails: Set the details of a Cleardown Module  # noqa: E501

        Update the given Cleardown Module details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_cleardown_module_details(scope, code, cleardown_module_code, cleardown_module_details, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the Cleardown Module to be updated. (required)
        :type cleardown_module_code: str
        :param cleardown_module_details: The new details for the Cleardown Module. (required)
        :type cleardown_module_details: CleardownModuleDetails
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CleardownModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_cleardown_module_details_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_cleardown_module_details_with_http_info(scope, code, cleardown_module_code, cleardown_module_details, **kwargs)  # noqa: E501

    @validate_arguments
    def set_cleardown_module_details_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], cleardown_module_details : Annotated[CleardownModuleDetails, Field(..., description="The new details for the Cleardown Module.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SetCleardownModuleDetails: Set the details of a Cleardown Module  # noqa: E501

        Update the given Cleardown Module details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_cleardown_module_details_with_http_info(scope, code, cleardown_module_code, cleardown_module_details, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the Cleardown Module to be updated. (required)
        :type cleardown_module_code: str
        :param cleardown_module_details: The new details for the Cleardown Module. (required)
        :type cleardown_module_details: CleardownModuleDetails
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CleardownModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'cleardown_module_code',
            'cleardown_module_details'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_cleardown_module_details" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['cleardown_module_code']:
            _path_params['cleardownModuleCode'] = _params['cleardown_module_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['cleardown_module_details'] is not None:
            _body_params = _params['cleardown_module_details']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CleardownModuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/cleardownmodules/{cleardownModuleCode}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_cleardown_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], cleardown_module_rule : Annotated[conlist(CleardownModuleRule), Field(..., description="The new rule set for the Cleardown Module.")], **kwargs) -> CleardownModuleRulesUpdatedResponse:  # noqa: E501
        ...

    @overload
    def set_cleardown_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], cleardown_module_rule : Annotated[conlist(CleardownModuleRule), Field(..., description="The new rule set for the Cleardown Module.")], async_req: Optional[bool]=True, **kwargs) -> CleardownModuleRulesUpdatedResponse:  # noqa: E501
        ...

    @validate_arguments
    def set_cleardown_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], cleardown_module_rule : Annotated[conlist(CleardownModuleRule), Field(..., description="The new rule set for the Cleardown Module.")], async_req: Optional[bool]=None, **kwargs) -> Union[CleardownModuleRulesUpdatedResponse, Awaitable[CleardownModuleRulesUpdatedResponse]]:  # noqa: E501
        """[EXPERIMENTAL] SetCleardownModuleRules: Set the rules of a Cleardown Module  # noqa: E501

        Set the given Cleardown Modules rules, this will replace the existing set of rules for the cleardown module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_cleardown_module_rules(scope, code, cleardown_module_code, cleardown_module_rule, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the Cleardown Module to be updated. (required)
        :type cleardown_module_code: str
        :param cleardown_module_rule: The new rule set for the Cleardown Module. (required)
        :type cleardown_module_rule: List[CleardownModuleRule]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CleardownModuleRulesUpdatedResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_cleardown_module_rules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_cleardown_module_rules_with_http_info(scope, code, cleardown_module_code, cleardown_module_rule, **kwargs)  # noqa: E501

    @validate_arguments
    def set_cleardown_module_rules_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], cleardown_module_code : Annotated[StrictStr, Field(..., description="The code of the Cleardown Module to be updated.")], cleardown_module_rule : Annotated[conlist(CleardownModuleRule), Field(..., description="The new rule set for the Cleardown Module.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SetCleardownModuleRules: Set the rules of a Cleardown Module  # noqa: E501

        Set the given Cleardown Modules rules, this will replace the existing set of rules for the cleardown module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_cleardown_module_rules_with_http_info(scope, code, cleardown_module_code, cleardown_module_rule, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param cleardown_module_code: The code of the Cleardown Module to be updated. (required)
        :type cleardown_module_code: str
        :param cleardown_module_rule: The new rule set for the Cleardown Module. (required)
        :type cleardown_module_rule: List[CleardownModuleRule]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CleardownModuleRulesUpdatedResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'cleardown_module_code',
            'cleardown_module_rule'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_cleardown_module_rules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['cleardown_module_code']:
            _path_params['cleardownModuleCode'] = _params['cleardown_module_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['cleardown_module_rule'] is not None:
            _body_params = _params['cleardown_module_rule']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CleardownModuleRulesUpdatedResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/cleardownmodules/{cleardownModuleCode}/cleardownrules', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_general_ledger_profile_mappings(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The code of the General Ledger Profile")], general_ledger_profile_mapping : Annotated[conlist(GeneralLedgerProfileMapping), Field(..., description="The updated General Ledger Profile Mappings, the previous mappings will be wholly replaced with this data. Mappings will be evaluated in the order they are provided.")], **kwargs) -> GeneralLedgerProfileResponse:  # noqa: E501
        ...

    @overload
    def set_general_ledger_profile_mappings(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The code of the General Ledger Profile")], general_ledger_profile_mapping : Annotated[conlist(GeneralLedgerProfileMapping), Field(..., description="The updated General Ledger Profile Mappings, the previous mappings will be wholly replaced with this data. Mappings will be evaluated in the order they are provided.")], async_req: Optional[bool]=True, **kwargs) -> GeneralLedgerProfileResponse:  # noqa: E501
        ...

    @validate_arguments
    def set_general_ledger_profile_mappings(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The code of the General Ledger Profile")], general_ledger_profile_mapping : Annotated[conlist(GeneralLedgerProfileMapping), Field(..., description="The updated General Ledger Profile Mappings, the previous mappings will be wholly replaced with this data. Mappings will be evaluated in the order they are provided.")], async_req: Optional[bool]=None, **kwargs) -> Union[GeneralLedgerProfileResponse, Awaitable[GeneralLedgerProfileResponse]]:  # noqa: E501
        """[EXPERIMENTAL] SetGeneralLedgerProfileMappings: Sets the General Ledger Profile Mappings.  # noqa: E501

        Update the given General Ledger profile Mappings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_general_ledger_profile_mappings(scope, code, general_ledger_profile_code, general_ledger_profile_mapping, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. (required)
        :type code: str
        :param general_ledger_profile_code: The code of the General Ledger Profile (required)
        :type general_ledger_profile_code: str
        :param general_ledger_profile_mapping: The updated General Ledger Profile Mappings, the previous mappings will be wholly replaced with this data. Mappings will be evaluated in the order they are provided. (required)
        :type general_ledger_profile_mapping: List[GeneralLedgerProfileMapping]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GeneralLedgerProfileResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_general_ledger_profile_mappings_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_general_ledger_profile_mappings_with_http_info(scope, code, general_ledger_profile_code, general_ledger_profile_mapping, **kwargs)  # noqa: E501

    @validate_arguments
    def set_general_ledger_profile_mappings_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts.")], general_ledger_profile_code : Annotated[StrictStr, Field(..., description="The code of the General Ledger Profile")], general_ledger_profile_mapping : Annotated[conlist(GeneralLedgerProfileMapping), Field(..., description="The updated General Ledger Profile Mappings, the previous mappings will be wholly replaced with this data. Mappings will be evaluated in the order they are provided.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SetGeneralLedgerProfileMappings: Sets the General Ledger Profile Mappings.  # noqa: E501

        Update the given General Ledger profile Mappings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_general_ledger_profile_mappings_with_http_info(scope, code, general_ledger_profile_code, general_ledger_profile_mapping, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. (required)
        :type code: str
        :param general_ledger_profile_code: The code of the General Ledger Profile (required)
        :type general_ledger_profile_code: str
        :param general_ledger_profile_mapping: The updated General Ledger Profile Mappings, the previous mappings will be wholly replaced with this data. Mappings will be evaluated in the order they are provided. (required)
        :type general_ledger_profile_mapping: List[GeneralLedgerProfileMapping]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GeneralLedgerProfileResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'general_ledger_profile_code',
            'general_ledger_profile_mapping'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_general_ledger_profile_mappings" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['general_ledger_profile_code']:
            _path_params['generalLedgerProfileCode'] = _params['general_ledger_profile_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['general_ledger_profile_mapping'] is not None:
            _body_params = _params['general_ledger_profile_mapping']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GeneralLedgerProfileResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/generalledgerprofile/{generalLedgerProfileCode}/mappings', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_posting_module_details(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], posting_module_details : Annotated[PostingModuleDetails, Field(..., description="The new details for the Posting Module.")], **kwargs) -> PostingModuleResponse:  # noqa: E501
        ...

    @overload
    def set_posting_module_details(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], posting_module_details : Annotated[PostingModuleDetails, Field(..., description="The new details for the Posting Module.")], async_req: Optional[bool]=True, **kwargs) -> PostingModuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def set_posting_module_details(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], posting_module_details : Annotated[PostingModuleDetails, Field(..., description="The new details for the Posting Module.")], async_req: Optional[bool]=None, **kwargs) -> Union[PostingModuleResponse, Awaitable[PostingModuleResponse]]:  # noqa: E501
        """[EXPERIMENTAL] SetPostingModuleDetails: Set the details of a Posting Module  # noqa: E501

        Update the given Posting Module details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_posting_module_details(scope, code, posting_module_code, posting_module_details, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the Posting Module to be updated. (required)
        :type posting_module_code: str
        :param posting_module_details: The new details for the Posting Module. (required)
        :type posting_module_details: PostingModuleDetails
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostingModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_posting_module_details_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_posting_module_details_with_http_info(scope, code, posting_module_code, posting_module_details, **kwargs)  # noqa: E501

    @validate_arguments
    def set_posting_module_details_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], posting_module_details : Annotated[PostingModuleDetails, Field(..., description="The new details for the Posting Module.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SetPostingModuleDetails: Set the details of a Posting Module  # noqa: E501

        Update the given Posting Module details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_posting_module_details_with_http_info(scope, code, posting_module_code, posting_module_details, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the Posting Module to be updated. (required)
        :type posting_module_code: str
        :param posting_module_details: The new details for the Posting Module. (required)
        :type posting_module_details: PostingModuleDetails
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostingModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'posting_module_code',
            'posting_module_details'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_posting_module_details" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['posting_module_code']:
            _path_params['postingModuleCode'] = _params['posting_module_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['posting_module_details'] is not None:
            _body_params = _params['posting_module_details']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PostingModuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/postingmodules/{postingModuleCode}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_posting_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], posting_module_rule : Annotated[conlist(PostingModuleRule), Field(..., description="The new rule set for the Posting Module.")], **kwargs) -> PostingModuleRulesUpdatedResponse:  # noqa: E501
        ...

    @overload
    def set_posting_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], posting_module_rule : Annotated[conlist(PostingModuleRule), Field(..., description="The new rule set for the Posting Module.")], async_req: Optional[bool]=True, **kwargs) -> PostingModuleRulesUpdatedResponse:  # noqa: E501
        ...

    @validate_arguments
    def set_posting_module_rules(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], posting_module_rule : Annotated[conlist(PostingModuleRule), Field(..., description="The new rule set for the Posting Module.")], async_req: Optional[bool]=None, **kwargs) -> Union[PostingModuleRulesUpdatedResponse, Awaitable[PostingModuleRulesUpdatedResponse]]:  # noqa: E501
        """[EXPERIMENTAL] SetPostingModuleRules: Set the rules of a Posting Module  # noqa: E501

        Set the given Posting Modules rules, this will replace the existing set of rules for the posting module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_posting_module_rules(scope, code, posting_module_code, posting_module_rule, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the Posting Module to be updated. (required)
        :type posting_module_code: str
        :param posting_module_rule: The new rule set for the Posting Module. (required)
        :type posting_module_rule: List[PostingModuleRule]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostingModuleRulesUpdatedResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_posting_module_rules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_posting_module_rules_with_http_info(scope, code, posting_module_code, posting_module_rule, **kwargs)  # noqa: E501

    @validate_arguments
    def set_posting_module_rules_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts.")], posting_module_code : Annotated[StrictStr, Field(..., description="The code of the Posting Module to be updated.")], posting_module_rule : Annotated[conlist(PostingModuleRule), Field(..., description="The new rule set for the Posting Module.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SetPostingModuleRules: Set the rules of a Posting Module  # noqa: E501

        Set the given Posting Modules rules, this will replace the existing set of rules for the posting module.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_posting_module_rules_with_http_info(scope, code, posting_module_code, posting_module_rule, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param posting_module_code: The code of the Posting Module to be updated. (required)
        :type posting_module_code: str
        :param posting_module_rule: The new rule set for the Posting Module. (required)
        :type posting_module_rule: List[PostingModuleRule]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostingModuleRulesUpdatedResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'posting_module_code',
            'posting_module_rule'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_posting_module_rules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['posting_module_code']:
            _path_params['postingModuleCode'] = _params['posting_module_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['posting_module_rule'] is not None:
            _body_params = _params['posting_module_rule']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PostingModuleRulesUpdatedResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/postingmodules/{postingModuleCode}/postingrules', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_account_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The unique ID of the account to create or update properties for.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Account/Manager/Id\".")] = None, **kwargs) -> AccountProperties:  # noqa: E501
        ...

    @overload
    def upsert_account_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The unique ID of the account to create or update properties for.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Account/Manager/Id\".")] = None, async_req: Optional[bool]=True, **kwargs) -> AccountProperties:  # noqa: E501
        ...

    @validate_arguments
    def upsert_account_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The unique ID of the account to create or update properties for.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Account/Manager/Id\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[AccountProperties, Awaitable[AccountProperties]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertAccountProperties: Upsert account properties  # noqa: E501

        Update or insert one or more properties onto a single account. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'Account'.              Upserting a property that exists for an account, with a null value, will delete the instance of the property for that group.              Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_account_properties(scope, code, account_code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param account_code: The unique ID of the account to create or update properties for. (required)
        :type account_code: str
        :param request_body: The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Account/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_account_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_account_properties_with_http_info(scope, code, account_code, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_account_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], account_code : Annotated[StrictStr, Field(..., description="The unique ID of the account to create or update properties for.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Account/Manager/Id\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertAccountProperties: Upsert account properties  # noqa: E501

        Update or insert one or more properties onto a single account. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'Account'.              Upserting a property that exists for an account, with a null value, will delete the instance of the property for that group.              Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_account_properties_with_http_info(scope, code, account_code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param account_code: The unique ID of the account to create or update properties for. (required)
        :type account_code: str
        :param request_body: The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Account/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'account_code',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_account_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['account_code']:
            _path_params['accountCode'] = _params['account_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AccountProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/accounts/{accountCode}/properties/$upsert', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], account : Annotated[conlist(Account), Field(..., description="A list of accounts to be created or updated.")], **kwargs) -> AccountsUpsertResponse:  # noqa: E501
        ...

    @overload
    def upsert_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], account : Annotated[conlist(Account), Field(..., description="A list of accounts to be created or updated.")], async_req: Optional[bool]=True, **kwargs) -> AccountsUpsertResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_accounts(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], account : Annotated[conlist(Account), Field(..., description="A list of accounts to be created or updated.")], async_req: Optional[bool]=None, **kwargs) -> Union[AccountsUpsertResponse, Awaitable[AccountsUpsertResponse]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertAccounts: Upsert Accounts  # noqa: E501

        Create or update accounts in the Chart of Accounts. An account will be updated if it already exists and created if it does not.  The maximum number of accounts that this method can upsert per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_accounts(scope, code, account, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts. (required)
        :type code: str
        :param account: A list of accounts to be created or updated. (required)
        :type account: List[Account]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountsUpsertResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_accounts_with_http_info(scope, code, account, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_accounts_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts.")], account : Annotated[conlist(Account), Field(..., description="A list of accounts to be created or updated.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertAccounts: Upsert Accounts  # noqa: E501

        Create or update accounts in the Chart of Accounts. An account will be updated if it already exists and created if it does not.  The maximum number of accounts that this method can upsert per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_accounts_with_http_info(scope, code, account, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts. Together with the scope this uniquely identifies             the Chart of Accounts. (required)
        :type code: str
        :param account: A list of accounts to be created or updated. (required)
        :type account: List[Account]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountsUpsertResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'account'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['account'] is not None:
            _body_params = _params['account']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AccountsUpsertResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/accounts', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_chart_of_accounts_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"ChartOfAccounts/Manager/Id\".")] = None, **kwargs) -> ChartOfAccountsProperties:  # noqa: E501
        ...

    @overload
    def upsert_chart_of_accounts_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"ChartOfAccounts/Manager/Id\".")] = None, async_req: Optional[bool]=True, **kwargs) -> ChartOfAccountsProperties:  # noqa: E501
        ...

    @validate_arguments
    def upsert_chart_of_accounts_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"ChartOfAccounts/Manager/Id\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ChartOfAccountsProperties, Awaitable[ChartOfAccountsProperties]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertChartOfAccountsProperties: Upsert Chart of Accounts properties  # noqa: E501

        Update or insert one or more properties onto a single Chart of Accounts. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'ChartOfAccounts'.              Upserting a property that exists for a Chart of Accounts, with a null value, will delete the instance of the property for that group.              Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_chart_of_accounts_properties(scope, code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param request_body: The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"ChartOfAccounts/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ChartOfAccountsProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_chart_of_accounts_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_chart_of_accounts_properties_with_http_info(scope, code, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_chart_of_accounts_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Chart of Accounts to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"ChartOfAccounts/Manager/Id\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertChartOfAccountsProperties: Upsert Chart of Accounts properties  # noqa: E501

        Update or insert one or more properties onto a single Chart of Accounts. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'ChartOfAccounts'.              Upserting a property that exists for a Chart of Accounts, with a null value, will delete the instance of the property for that group.              Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_chart_of_accounts_properties_with_http_info(scope, code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Chart of Accounts to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the Chart of Accounts to update or insert the properties onto. Together with the scope this uniquely identifies the Chart of Accounts. (required)
        :type code: str
        :param request_body: The properties to be updated or inserted onto the chart of account. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"ChartOfAccounts/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ChartOfAccountsProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_chart_of_accounts_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ChartOfAccountsProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/chartofaccounts/{scope}/{code}/properties/$upsert', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
