# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.check_definition import CheckDefinition
from lusid.models.create_check_definition_request import CreateCheckDefinitionRequest
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.paged_resource_list_of_check_definition import PagedResourceListOfCheckDefinition
from lusid.models.update_check_definition_request import UpdateCheckDefinitionRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class CheckDefinitionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_check_definition(self, create_check_definition_request : Annotated[Optional[CreateCheckDefinitionRequest], Field(description="The request containing the details of the Check Definition")] = None, **kwargs) -> CheckDefinition:  # noqa: E501
        ...

    @overload
    def create_check_definition(self, create_check_definition_request : Annotated[Optional[CreateCheckDefinitionRequest], Field(description="The request containing the details of the Check Definition")] = None, async_req: Optional[bool]=True, **kwargs) -> CheckDefinition:  # noqa: E501
        ...

    @validate_arguments
    def create_check_definition(self, create_check_definition_request : Annotated[Optional[CreateCheckDefinitionRequest], Field(description="The request containing the details of the Check Definition")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[CheckDefinition, Awaitable[CheckDefinition]]:  # noqa: E501
        """[EXPERIMENTAL] CreateCheckDefinition: Create a Check Definition  # noqa: E501

        Creates a Check Definition. Returns the created Check Definition at the current effectiveAt. Note that Check Definitions are mono-temporal, however they can have Time-Variant Properties. Upserted Properties will be returned at the latest AsAt and EffectiveAt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_check_definition(create_check_definition_request, async_req=True)
        >>> result = thread.get()

        :param create_check_definition_request: The request containing the details of the Check Definition
        :type create_check_definition_request: CreateCheckDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CheckDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_check_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_check_definition_with_http_info(create_check_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_check_definition_with_http_info(self, create_check_definition_request : Annotated[Optional[CreateCheckDefinitionRequest], Field(description="The request containing the details of the Check Definition")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateCheckDefinition: Create a Check Definition  # noqa: E501

        Creates a Check Definition. Returns the created Check Definition at the current effectiveAt. Note that Check Definitions are mono-temporal, however they can have Time-Variant Properties. Upserted Properties will be returned at the latest AsAt and EffectiveAt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_check_definition_with_http_info(create_check_definition_request, async_req=True)
        >>> result = thread.get()

        :param create_check_definition_request: The request containing the details of the Check Definition
        :type create_check_definition_request: CreateCheckDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CheckDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_check_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_check_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_check_definition_request'] is not None:
            _body_params = _params['create_check_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "CheckDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/dataquality/checkdefinitions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_check_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the domain and scope this uniquely             identifies the Check Definition.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_check_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the domain and scope this uniquely             identifies the Check Definition.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_check_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the domain and scope this uniquely             identifies the Check Definition.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteCheckDefinition: Deletes a particular Check Definition  # noqa: E501

        The deletion will take effect from the Check Definition deletion datetime. i.e. will no longer exist at any asAt datetime after the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_check_definition(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Check Definition. (required)
        :type scope: str
        :param code: The code of the specified Check Definition. Together with the domain and scope this uniquely             identifies the Check Definition. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_check_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_check_definition_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_check_definition_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the domain and scope this uniquely             identifies the Check Definition.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteCheckDefinition: Deletes a particular Check Definition  # noqa: E501

        The deletion will take effect from the Check Definition deletion datetime. i.e. will no longer exist at any asAt datetime after the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_check_definition_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Check Definition. (required)
        :type scope: str
        :param code: The code of the specified Check Definition. Together with the domain and scope this uniquely             identifies the Check Definition. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_check_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/dataquality/checkdefinitions/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_check_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the scope this uniquely             identifies the Check Definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Check Definition definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the check definition properties.             Defaults to the current LUSID system datetime if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'CheckDefinition' domain to decorate onto             the Check Definition.             These must have the format {domain}/{scope}/{code}, for example 'CheckDefinition/system/Name'.")] = None, **kwargs) -> CheckDefinition:  # noqa: E501
        ...

    @overload
    def get_check_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the scope this uniquely             identifies the Check Definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Check Definition definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the check definition properties.             Defaults to the current LUSID system datetime if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'CheckDefinition' domain to decorate onto             the Check Definition.             These must have the format {domain}/{scope}/{code}, for example 'CheckDefinition/system/Name'.")] = None, async_req: Optional[bool]=True, **kwargs) -> CheckDefinition:  # noqa: E501
        ...

    @validate_arguments
    def get_check_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the scope this uniquely             identifies the Check Definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Check Definition definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the check definition properties.             Defaults to the current LUSID system datetime if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'CheckDefinition' domain to decorate onto             the Check Definition.             These must have the format {domain}/{scope}/{code}, for example 'CheckDefinition/system/Name'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[CheckDefinition, Awaitable[CheckDefinition]]:  # noqa: E501
        """[EXPERIMENTAL] GetCheckDefinition: Get a single Check Definition by scope and code.  # noqa: E501

        Retrieves one Check Definition by scope and code. Check Definitions are mono-temporal. The EffectiveAt is only applied to Time-Variant Properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_check_definition(scope, code, as_at, effective_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Check Definition. (required)
        :type scope: str
        :param code: The code of the specified Check Definition. Together with the scope this uniquely             identifies the Check Definition. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the Check Definition definition. Defaults to return             the latest version of the definition if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to retrieve the check definition properties.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param property_keys: A list of property keys from the 'CheckDefinition' domain to decorate onto             the Check Definition.             These must have the format {domain}/{scope}/{code}, for example 'CheckDefinition/system/Name'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CheckDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_check_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_check_definition_with_http_info(scope, code, as_at, effective_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_check_definition_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the scope this uniquely             identifies the Check Definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Check Definition definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the check definition properties.             Defaults to the current LUSID system datetime if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'CheckDefinition' domain to decorate onto             the Check Definition.             These must have the format {domain}/{scope}/{code}, for example 'CheckDefinition/system/Name'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetCheckDefinition: Get a single Check Definition by scope and code.  # noqa: E501

        Retrieves one Check Definition by scope and code. Check Definitions are mono-temporal. The EffectiveAt is only applied to Time-Variant Properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_check_definition_with_http_info(scope, code, as_at, effective_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Check Definition. (required)
        :type scope: str
        :param code: The code of the specified Check Definition. Together with the scope this uniquely             identifies the Check Definition. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the Check Definition definition. Defaults to return             the latest version of the definition if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to retrieve the check definition properties.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param property_keys: A list of property keys from the 'CheckDefinition' domain to decorate onto             the Check Definition.             These must have the format {domain}/{scope}/{code}, for example 'CheckDefinition/system/Name'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CheckDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at',
            'effective_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_check_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CheckDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/dataquality/checkdefinitions/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_check_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Check Definitions. Defaults to returning the latest version of each Check Definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Check Definitions.             Note that Check Definitions are monotemporal, the effectiveAt is for Timevariant Properties on the Check Definition only.             Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Check Definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the displayName, specify \"displayName eq 'MyCheckDefinition'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'CheckDefinition' domain to decorate onto each Check Definition.             These must take the format {domain}/{scope}/{code}, for example 'CheckDefinition/Account/id'.")] = None, **kwargs) -> PagedResourceListOfCheckDefinition:  # noqa: E501
        ...

    @overload
    def list_check_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Check Definitions. Defaults to returning the latest version of each Check Definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Check Definitions.             Note that Check Definitions are monotemporal, the effectiveAt is for Timevariant Properties on the Check Definition only.             Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Check Definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the displayName, specify \"displayName eq 'MyCheckDefinition'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'CheckDefinition' domain to decorate onto each Check Definition.             These must take the format {domain}/{scope}/{code}, for example 'CheckDefinition/Account/id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfCheckDefinition:  # noqa: E501
        ...

    @validate_arguments
    def list_check_definitions(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Check Definitions. Defaults to returning the latest version of each Check Definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Check Definitions.             Note that Check Definitions are monotemporal, the effectiveAt is for Timevariant Properties on the Check Definition only.             Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Check Definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the displayName, specify \"displayName eq 'MyCheckDefinition'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'CheckDefinition' domain to decorate onto each Check Definition.             These must take the format {domain}/{scope}/{code}, for example 'CheckDefinition/Account/id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfCheckDefinition, Awaitable[PagedResourceListOfCheckDefinition]]:  # noqa: E501
        """[EXPERIMENTAL] ListCheckDefinitions: List Check Definitions  # noqa: E501

        List all the Check Definitions matching a particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_check_definitions(as_at, effective_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the Check Definitions. Defaults to returning the latest version of each Check Definition if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to list the Check Definitions.             Note that Check Definitions are monotemporal, the effectiveAt is for Timevariant Properties on the Check Definition only.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param page: The pagination token to use to continue listing Check Definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the displayName, specify \"displayName eq 'MyCheckDefinition'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'CheckDefinition' domain to decorate onto each Check Definition.             These must take the format {domain}/{scope}/{code}, for example 'CheckDefinition/Account/id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfCheckDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_check_definitions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_check_definitions_with_http_info(as_at, effective_at, page, limit, filter, sort_by, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_check_definitions_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Check Definitions. Defaults to returning the latest version of each Check Definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Check Definitions.             Note that Check Definitions are monotemporal, the effectiveAt is for Timevariant Properties on the Check Definition only.             Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Check Definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the displayName, specify \"displayName eq 'MyCheckDefinition'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'CheckDefinition' domain to decorate onto each Check Definition.             These must take the format {domain}/{scope}/{code}, for example 'CheckDefinition/Account/id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListCheckDefinitions: List Check Definitions  # noqa: E501

        List all the Check Definitions matching a particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_check_definitions_with_http_info(as_at, effective_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list the Check Definitions. Defaults to returning the latest version of each Check Definition if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to list the Check Definitions.             Note that Check Definitions are monotemporal, the effectiveAt is for Timevariant Properties on the Check Definition only.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param page: The pagination token to use to continue listing Check Definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the displayName, specify \"displayName eq 'MyCheckDefinition'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'CheckDefinition' domain to decorate onto each Check Definition.             These must take the format {domain}/{scope}/{code}, for example 'CheckDefinition/Account/id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfCheckDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'effective_at',
            'page',
            'limit',
            'filter',
            'sort_by',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_check_definitions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfCheckDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/dataquality/checkdefinitions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_check_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the domain and scope this uniquely identifies the Check Definition.")], update_check_definition_request : Annotated[Optional[UpdateCheckDefinitionRequest], Field(description="The request containing the updated details of the Check Definition")] = None, **kwargs) -> CheckDefinition:  # noqa: E501
        ...

    @overload
    def update_check_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the domain and scope this uniquely identifies the Check Definition.")], update_check_definition_request : Annotated[Optional[UpdateCheckDefinitionRequest], Field(description="The request containing the updated details of the Check Definition")] = None, async_req: Optional[bool]=True, **kwargs) -> CheckDefinition:  # noqa: E501
        ...

    @validate_arguments
    def update_check_definition(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the domain and scope this uniquely identifies the Check Definition.")], update_check_definition_request : Annotated[Optional[UpdateCheckDefinitionRequest], Field(description="The request containing the updated details of the Check Definition")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[CheckDefinition, Awaitable[CheckDefinition]]:  # noqa: E501
        """[EXPERIMENTAL] UpdateCheckDefinition: Update Check Definition defined by scope and code  # noqa: E501

        Overwrites an existing Check Definition Update request has the same required fields as Create apart from the id. Returns the updated Check Definition at the current effectiveAt. Note that Check Definitions are mono-temporal, however they can have Time-Variant Properties. Updated Properties will be returned at the latest AsAt and EffectiveAt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_check_definition(scope, code, update_check_definition_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Check Definition. (required)
        :type scope: str
        :param code: The code of the specified Check Definition. Together with the domain and scope this uniquely identifies the Check Definition. (required)
        :type code: str
        :param update_check_definition_request: The request containing the updated details of the Check Definition
        :type update_check_definition_request: UpdateCheckDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CheckDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_check_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_check_definition_with_http_info(scope, code, update_check_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_check_definition_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the specified Check Definition.")], code : Annotated[StrictStr, Field(..., description="The code of the specified Check Definition. Together with the domain and scope this uniquely identifies the Check Definition.")], update_check_definition_request : Annotated[Optional[UpdateCheckDefinitionRequest], Field(description="The request containing the updated details of the Check Definition")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpdateCheckDefinition: Update Check Definition defined by scope and code  # noqa: E501

        Overwrites an existing Check Definition Update request has the same required fields as Create apart from the id. Returns the updated Check Definition at the current effectiveAt. Note that Check Definitions are mono-temporal, however they can have Time-Variant Properties. Updated Properties will be returned at the latest AsAt and EffectiveAt  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_check_definition_with_http_info(scope, code, update_check_definition_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the specified Check Definition. (required)
        :type scope: str
        :param code: The code of the specified Check Definition. Together with the domain and scope this uniquely identifies the Check Definition. (required)
        :type code: str
        :param update_check_definition_request: The request containing the updated details of the Check Definition
        :type update_check_definition_request: UpdateCheckDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CheckDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_check_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_check_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_check_definition_request'] is not None:
            _body_params = _params['update_check_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CheckDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/dataquality/checkdefinitions/{scope}/{code}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
