# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.custom_entity_entity import CustomEntityEntity
from lusid.models.data_type_entity import DataTypeEntity
from lusid.models.instrument_entity import InstrumentEntity
from lusid.models.portfolio_entity import PortfolioEntity
from lusid.models.property_definition_entity import PropertyDefinitionEntity
from lusid.models.resource_list_of_change import ResourceListOfChange
from lusid.models.resource_list_of_change_interval import ResourceListOfChangeInterval

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class EntitiesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def get_custom_entity_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the Custom Entity.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Custom Entity. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Custom Entity. Defaults to returning the latest version of the Custom Entity if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, **kwargs) -> CustomEntityEntity:  # noqa: E501
        ...

    @overload
    def get_custom_entity_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the Custom Entity.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Custom Entity. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Custom Entity. Defaults to returning the latest version of the Custom Entity if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, async_req: Optional[bool]=True, **kwargs) -> CustomEntityEntity:  # noqa: E501
        ...

    @validate_arguments
    def get_custom_entity_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the Custom Entity.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Custom Entity. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Custom Entity. Defaults to returning the latest version of the Custom Entity if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[CustomEntityEntity, Awaitable[CustomEntityEntity]]:  # noqa: E501
        """GetCustomEntityByEntityUniqueId: Get a Custom Entity instance by its EntityUniqueId  # noqa: E501

        Retrieve a particular Custom Entity instance. If the Custom Entity is deleted, this will return the state of the Custom Entity immediately prior to deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_custom_entity_by_entity_unique_id(entity_unique_id, effective_at, as_at, previews, async_req=True)
        >>> result = thread.get()

        :param entity_unique_id: The universally unique identifier of the Custom Entity. (required)
        :type entity_unique_id: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Custom Entity. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Custom Entity. Defaults to returning the latest version of the Custom Entity if not specified.
        :type as_at: datetime
        :param previews: The ids of the staged modifications to be previewed in the response.
        :type previews: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomEntityEntity
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_custom_entity_by_entity_unique_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_custom_entity_by_entity_unique_id_with_http_info(entity_unique_id, effective_at, as_at, previews, **kwargs)  # noqa: E501

    @validate_arguments
    def get_custom_entity_by_entity_unique_id_with_http_info(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the Custom Entity.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Custom Entity. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Custom Entity. Defaults to returning the latest version of the Custom Entity if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetCustomEntityByEntityUniqueId: Get a Custom Entity instance by its EntityUniqueId  # noqa: E501

        Retrieve a particular Custom Entity instance. If the Custom Entity is deleted, this will return the state of the Custom Entity immediately prior to deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_custom_entity_by_entity_unique_id_with_http_info(entity_unique_id, effective_at, as_at, previews, async_req=True)
        >>> result = thread.get()

        :param entity_unique_id: The universally unique identifier of the Custom Entity. (required)
        :type entity_unique_id: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Custom Entity. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Custom Entity. Defaults to returning the latest version of the Custom Entity if not specified.
        :type as_at: datetime
        :param previews: The ids of the staged modifications to be previewed in the response.
        :type previews: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomEntityEntity, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_unique_id',
            'effective_at',
            'as_at',
            'previews'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_entity_by_entity_unique_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_unique_id']:
            _path_params['entityUniqueId'] = _params['entity_unique_id']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('previews') is not None:  # noqa: E501
            _query_params.append(('previews', _params['previews']))
            _collection_formats['previews'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "CustomEntityEntity",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/entities/customentities/{entityUniqueId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_data_type_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the DataType definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the DataType definition. Defaults to returning the latest version of the DataType definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, **kwargs) -> DataTypeEntity:  # noqa: E501
        ...

    @overload
    def get_data_type_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the DataType definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the DataType definition. Defaults to returning the latest version of the DataType definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, async_req: Optional[bool]=True, **kwargs) -> DataTypeEntity:  # noqa: E501
        ...

    @validate_arguments
    def get_data_type_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the DataType definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the DataType definition. Defaults to returning the latest version of the DataType definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DataTypeEntity, Awaitable[DataTypeEntity]]:  # noqa: E501
        """GetDataTypeByEntityUniqueId: Get DataType by EntityUniqueId  # noqa: E501

        Retrieve the definition of a particular DataType. If the DataType is deleted, this will return the state of the DataType immediately prior to deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_type_by_entity_unique_id(entity_unique_id, as_at, previews, async_req=True)
        >>> result = thread.get()

        :param entity_unique_id: The universally unique identifier of the DataType definition. (required)
        :type entity_unique_id: str
        :param as_at: The asAt datetime at which to retrieve the DataType definition. Defaults to returning the latest version of the DataType definition if not specified.
        :type as_at: datetime
        :param previews: The ids of the staged modifications to be previewed in the response.
        :type previews: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DataTypeEntity
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_data_type_by_entity_unique_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_data_type_by_entity_unique_id_with_http_info(entity_unique_id, as_at, previews, **kwargs)  # noqa: E501

    @validate_arguments
    def get_data_type_by_entity_unique_id_with_http_info(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the DataType definition.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the DataType definition. Defaults to returning the latest version of the DataType definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetDataTypeByEntityUniqueId: Get DataType by EntityUniqueId  # noqa: E501

        Retrieve the definition of a particular DataType. If the DataType is deleted, this will return the state of the DataType immediately prior to deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_type_by_entity_unique_id_with_http_info(entity_unique_id, as_at, previews, async_req=True)
        >>> result = thread.get()

        :param entity_unique_id: The universally unique identifier of the DataType definition. (required)
        :type entity_unique_id: str
        :param as_at: The asAt datetime at which to retrieve the DataType definition. Defaults to returning the latest version of the DataType definition if not specified.
        :type as_at: datetime
        :param previews: The ids of the staged modifications to be previewed in the response.
        :type previews: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DataTypeEntity, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_unique_id',
            'as_at',
            'previews'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_type_by_entity_unique_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_unique_id']:
            _path_params['entityUniqueId'] = _params['entity_unique_id']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('previews') is not None:  # noqa: E501
            _query_params.append(('previews', _params['previews']))
            _collection_formats['previews'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DataTypeEntity",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/entities/datatypes/{entityUniqueId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_entity_history(self, entity_type : Annotated[StrictStr, Field(..., description="The type of the entity to list the change history for.")], entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the entity.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list change history information. Defaults to return the change history at the latest datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing change history information from a previous call to list change             history information. This value is returned from the previous call. If a pagination token is provided the filter, sortBy             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names suffixed by \" ASC\" or \" DESC\"")] = None, **kwargs) -> ResourceListOfChangeInterval:  # noqa: E501
        ...

    @overload
    def get_entity_history(self, entity_type : Annotated[StrictStr, Field(..., description="The type of the entity to list the change history for.")], entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the entity.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list change history information. Defaults to return the change history at the latest datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing change history information from a previous call to list change             history information. This value is returned from the previous call. If a pagination token is provided the filter, sortBy             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names suffixed by \" ASC\" or \" DESC\"")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfChangeInterval:  # noqa: E501
        ...

    @validate_arguments
    def get_entity_history(self, entity_type : Annotated[StrictStr, Field(..., description="The type of the entity to list the change history for.")], entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the entity.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list change history information. Defaults to return the change history at the latest datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing change history information from a previous call to list change             history information. This value is returned from the previous call. If a pagination token is provided the filter, sortBy             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names suffixed by \" ASC\" or \" DESC\"")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfChangeInterval, Awaitable[ResourceListOfChangeInterval]]:  # noqa: E501
        """GetEntityHistory: List an entity's history information  # noqa: E501

        Retrieve a page of an entity's change history up to a particular point in AsAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_history(entity_type, entity_unique_id, as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the entity to list the change history for. (required)
        :type entity_type: str
        :param entity_unique_id: The universally unique identifier of the entity. (required)
        :type entity_unique_id: str
        :param as_at: The asAt datetime at which to list change history information. Defaults to return the change history at the latest datetime if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing change history information from a previous call to list change             history information. This value is returned from the previous call. If a pagination token is provided the filter, sortBy             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the result set.             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: A list of field names suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfChangeInterval
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_entity_history_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_entity_history_with_http_info(entity_type, entity_unique_id, as_at, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def get_entity_history_with_http_info(self, entity_type : Annotated[StrictStr, Field(..., description="The type of the entity to list the change history for.")], entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the entity.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list change history information. Defaults to return the change history at the latest datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing change history information from a previous call to list change             history information. This value is returned from the previous call. If a pagination token is provided the filter, sortBy             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names suffixed by \" ASC\" or \" DESC\"")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetEntityHistory: List an entity's history information  # noqa: E501

        Retrieve a page of an entity's change history up to a particular point in AsAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_history_with_http_info(entity_type, entity_unique_id, as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the entity to list the change history for. (required)
        :type entity_type: str
        :param entity_unique_id: The universally unique identifier of the entity. (required)
        :type entity_unique_id: str
        :param as_at: The asAt datetime at which to list change history information. Defaults to return the change history at the latest datetime if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing change history information from a previous call to list change             history information. This value is returned from the previous call. If a pagination token is provided the filter, sortBy             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the result set.             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: A list of field names suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfChangeInterval, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_type',
            'entity_unique_id',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entity_history" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_type']:
            _path_params['entityType'] = _params['entity_type']

        if _params['entity_unique_id']:
            _path_params['entityUniqueId'] = _params['entity_unique_id']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfChangeInterval",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/entities/{entityType}/{entityUniqueId}/history', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_instrument_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the instrument definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Instrument definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument definition. Defaults to returning the latest version of the instrument definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, **kwargs) -> InstrumentEntity:  # noqa: E501
        ...

    @overload
    def get_instrument_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the instrument definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Instrument definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument definition. Defaults to returning the latest version of the instrument definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, async_req: Optional[bool]=True, **kwargs) -> InstrumentEntity:  # noqa: E501
        ...

    @validate_arguments
    def get_instrument_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the instrument definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Instrument definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument definition. Defaults to returning the latest version of the instrument definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[InstrumentEntity, Awaitable[InstrumentEntity]]:  # noqa: E501
        """GetInstrumentByEntityUniqueId: Get instrument by EntityUniqueId  # noqa: E501

        Retrieve the definition of a particular instrument. If the instrument is deleted, this will return the state of the instrument immediately prior to deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_by_entity_unique_id(entity_unique_id, effective_at, as_at, previews, async_req=True)
        >>> result = thread.get()

        :param entity_unique_id: The universally unique identifier of the instrument definition. (required)
        :type entity_unique_id: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Instrument definition. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument definition. Defaults to returning the latest version of the instrument definition if not specified.
        :type as_at: datetime
        :param previews: The ids of the staged modifications to be previewed in the response.
        :type previews: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstrumentEntity
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_instrument_by_entity_unique_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_instrument_by_entity_unique_id_with_http_info(entity_unique_id, effective_at, as_at, previews, **kwargs)  # noqa: E501

    @validate_arguments
    def get_instrument_by_entity_unique_id_with_http_info(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the instrument definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Instrument definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument definition. Defaults to returning the latest version of the instrument definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetInstrumentByEntityUniqueId: Get instrument by EntityUniqueId  # noqa: E501

        Retrieve the definition of a particular instrument. If the instrument is deleted, this will return the state of the instrument immediately prior to deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_by_entity_unique_id_with_http_info(entity_unique_id, effective_at, as_at, previews, async_req=True)
        >>> result = thread.get()

        :param entity_unique_id: The universally unique identifier of the instrument definition. (required)
        :type entity_unique_id: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Instrument definition. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument definition. Defaults to returning the latest version of the instrument definition if not specified.
        :type as_at: datetime
        :param previews: The ids of the staged modifications to be previewed in the response.
        :type previews: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstrumentEntity, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_unique_id',
            'effective_at',
            'as_at',
            'previews'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_by_entity_unique_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_unique_id']:
            _path_params['entityUniqueId'] = _params['entity_unique_id']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('previews') is not None:  # noqa: E501
            _query_params.append(('previews', _params['previews']))
            _collection_formats['previews'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "InstrumentEntity",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/entities/instruments/{entityUniqueId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_portfolio_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the portfolio definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the portfolio definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the portfolio definition. Defaults to returning the latest version of the portfolio definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, **kwargs) -> PortfolioEntity:  # noqa: E501
        ...

    @overload
    def get_portfolio_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the portfolio definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the portfolio definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the portfolio definition. Defaults to returning the latest version of the portfolio definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, async_req: Optional[bool]=True, **kwargs) -> PortfolioEntity:  # noqa: E501
        ...

    @validate_arguments
    def get_portfolio_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the portfolio definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the portfolio definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the portfolio definition. Defaults to returning the latest version of the portfolio definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PortfolioEntity, Awaitable[PortfolioEntity]]:  # noqa: E501
        """GetPortfolioByEntityUniqueId: Get portfolio by EntityUniqueId  # noqa: E501

        Retrieve the definition of a particular portfolio. If the portfolio is deleted, this will return the state of the portfolio immediately prior to deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_portfolio_by_entity_unique_id(entity_unique_id, effective_at, as_at, previews, async_req=True)
        >>> result = thread.get()

        :param entity_unique_id: The universally unique identifier of the portfolio definition. (required)
        :type entity_unique_id: str
        :param effective_at: The effective datetime or cut label at which to retrieve the portfolio definition. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the portfolio definition. Defaults to returning the latest version of the portfolio definition if not specified.
        :type as_at: datetime
        :param previews: The ids of the staged modifications to be previewed in the response.
        :type previews: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PortfolioEntity
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_portfolio_by_entity_unique_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_portfolio_by_entity_unique_id_with_http_info(entity_unique_id, effective_at, as_at, previews, **kwargs)  # noqa: E501

    @validate_arguments
    def get_portfolio_by_entity_unique_id_with_http_info(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the portfolio definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the portfolio definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the portfolio definition. Defaults to returning the latest version of the portfolio definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetPortfolioByEntityUniqueId: Get portfolio by EntityUniqueId  # noqa: E501

        Retrieve the definition of a particular portfolio. If the portfolio is deleted, this will return the state of the portfolio immediately prior to deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_portfolio_by_entity_unique_id_with_http_info(entity_unique_id, effective_at, as_at, previews, async_req=True)
        >>> result = thread.get()

        :param entity_unique_id: The universally unique identifier of the portfolio definition. (required)
        :type entity_unique_id: str
        :param effective_at: The effective datetime or cut label at which to retrieve the portfolio definition. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the portfolio definition. Defaults to returning the latest version of the portfolio definition if not specified.
        :type as_at: datetime
        :param previews: The ids of the staged modifications to be previewed in the response.
        :type previews: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PortfolioEntity, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_unique_id',
            'effective_at',
            'as_at',
            'previews'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_by_entity_unique_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_unique_id']:
            _path_params['entityUniqueId'] = _params['entity_unique_id']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('previews') is not None:  # noqa: E501
            _query_params.append(('previews', _params['previews']))
            _collection_formats['previews'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PortfolioEntity",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/entities/portfolios/{entityUniqueId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_portfolio_changes(self, scope : Annotated[StrictStr, Field(..., description="The scope")], effective_at : Annotated[StrictStr, Field(..., description="The effective date of the origin.")], as_at : Annotated[Optional[datetime], Field(description="The as-at date of the origin.")] = None, **kwargs) -> ResourceListOfChange:  # noqa: E501
        ...

    @overload
    def get_portfolio_changes(self, scope : Annotated[StrictStr, Field(..., description="The scope")], effective_at : Annotated[StrictStr, Field(..., description="The effective date of the origin.")], as_at : Annotated[Optional[datetime], Field(description="The as-at date of the origin.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfChange:  # noqa: E501
        ...

    @validate_arguments
    def get_portfolio_changes(self, scope : Annotated[StrictStr, Field(..., description="The scope")], effective_at : Annotated[StrictStr, Field(..., description="The effective date of the origin.")], as_at : Annotated[Optional[datetime], Field(description="The as-at date of the origin.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfChange, Awaitable[ResourceListOfChange]]:  # noqa: E501
        """GetPortfolioChanges: Get the next change to each portfolio in a scope.  # noqa: E501

        Gets the time of the next (earliest effective at) modification (correction and/or amendment) to each portfolio in a scope relative to a point in bitemporal time. Includes changes from parent portfolios in different scopes. Excludes changes from subscriptions (e.g corporate actions).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_portfolio_changes(scope, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope (required)
        :type scope: str
        :param effective_at: The effective date of the origin. (required)
        :type effective_at: str
        :param as_at: The as-at date of the origin.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfChange
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_portfolio_changes_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_portfolio_changes_with_http_info(scope, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_portfolio_changes_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope")], effective_at : Annotated[StrictStr, Field(..., description="The effective date of the origin.")], as_at : Annotated[Optional[datetime], Field(description="The as-at date of the origin.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetPortfolioChanges: Get the next change to each portfolio in a scope.  # noqa: E501

        Gets the time of the next (earliest effective at) modification (correction and/or amendment) to each portfolio in a scope relative to a point in bitemporal time. Includes changes from parent portfolios in different scopes. Excludes changes from subscriptions (e.g corporate actions).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_portfolio_changes_with_http_info(scope, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope (required)
        :type scope: str
        :param effective_at: The effective date of the origin. (required)
        :type effective_at: str
        :param as_at: The as-at date of the origin.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfChange, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_changes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '400': "LusidValidationProblemDetails",
            '200': "ResourceListOfChange",
        }

        return self.api_client.call_api(
            '/api/entities/changes/portfolios', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_property_definition_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the property definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime at which to retrieve the property definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definition. Defaults to returning the latest version of the property definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, **kwargs) -> PropertyDefinitionEntity:  # noqa: E501
        ...

    @overload
    def get_property_definition_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the property definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime at which to retrieve the property definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definition. Defaults to returning the latest version of the property definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, async_req: Optional[bool]=True, **kwargs) -> PropertyDefinitionEntity:  # noqa: E501
        ...

    @validate_arguments
    def get_property_definition_by_entity_unique_id(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the property definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime at which to retrieve the property definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definition. Defaults to returning the latest version of the property definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PropertyDefinitionEntity, Awaitable[PropertyDefinitionEntity]]:  # noqa: E501
        """GetPropertyDefinitionByEntityUniqueId: Get property definition by EntityUniqueId  # noqa: E501

        Retrieve a particular property definition. If the property definition is deleted, this will return the state of the property definition immediately prior to deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_property_definition_by_entity_unique_id(entity_unique_id, effective_at, as_at, previews, async_req=True)
        >>> result = thread.get()

        :param entity_unique_id: The universally unique identifier of the property definition. (required)
        :type entity_unique_id: str
        :param effective_at: The effective datetime at which to retrieve the property definition. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the property definition. Defaults to returning the latest version of the property definition if not specified.
        :type as_at: datetime
        :param previews: The ids of the staged modifications to be previewed in the response.
        :type previews: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PropertyDefinitionEntity
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_property_definition_by_entity_unique_id_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_property_definition_by_entity_unique_id_with_http_info(entity_unique_id, effective_at, as_at, previews, **kwargs)  # noqa: E501

    @validate_arguments
    def get_property_definition_by_entity_unique_id_with_http_info(self, entity_unique_id : Annotated[StrictStr, Field(..., description="The universally unique identifier of the property definition.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime at which to retrieve the property definition. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definition. Defaults to returning the latest version of the property definition if not specified.")] = None, previews : Annotated[Optional[conlist(StrictStr)], Field(description="The ids of the staged modifications to be previewed in the response.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetPropertyDefinitionByEntityUniqueId: Get property definition by EntityUniqueId  # noqa: E501

        Retrieve a particular property definition. If the property definition is deleted, this will return the state of the property definition immediately prior to deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_property_definition_by_entity_unique_id_with_http_info(entity_unique_id, effective_at, as_at, previews, async_req=True)
        >>> result = thread.get()

        :param entity_unique_id: The universally unique identifier of the property definition. (required)
        :type entity_unique_id: str
        :param effective_at: The effective datetime at which to retrieve the property definition. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the property definition. Defaults to returning the latest version of the property definition if not specified.
        :type as_at: datetime
        :param previews: The ids of the staged modifications to be previewed in the response.
        :type previews: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PropertyDefinitionEntity, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'entity_unique_id',
            'effective_at',
            'as_at',
            'previews'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_property_definition_by_entity_unique_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['entity_unique_id']:
            _path_params['entityUniqueId'] = _params['entity_unique_id']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('previews') is not None:  # noqa: E501
            _query_params.append(('previews', _params['previews']))
            _collection_formats['previews'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PropertyDefinitionEntity",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/entities/propertydefinitions/{entityUniqueId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
