# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Dict, Optional

from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.fund_configuration import FundConfiguration
from lusid.models.fund_configuration_properties import FundConfigurationProperties
from lusid.models.fund_configuration_request import FundConfigurationRequest
from lusid.models.model_property import ModelProperty
from lusid.models.operation import Operation
from lusid.models.paged_resource_list_of_fund_configuration import PagedResourceListOfFundConfiguration

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class FundConfigurationApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], fund_configuration_request : Annotated[FundConfigurationRequest, Field(..., description="The definition of the FundConfiguration.")], **kwargs) -> FundConfiguration:  # noqa: E501
        ...

    @overload
    def create_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], fund_configuration_request : Annotated[FundConfigurationRequest, Field(..., description="The definition of the FundConfiguration.")], async_req: Optional[bool]=True, **kwargs) -> FundConfiguration:  # noqa: E501
        ...

    @validate_arguments
    def create_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], fund_configuration_request : Annotated[FundConfigurationRequest, Field(..., description="The definition of the FundConfiguration.")], async_req: Optional[bool]=None, **kwargs) -> Union[FundConfiguration, Awaitable[FundConfiguration]]:  # noqa: E501
        """[EXPERIMENTAL] CreateFundConfiguration: Create a FundConfiguration.  # noqa: E501

        Create the given FundConfiguration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_fund_configuration(scope, fund_configuration_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the FundConfiguration. (required)
        :type scope: str
        :param fund_configuration_request: The definition of the FundConfiguration. (required)
        :type fund_configuration_request: FundConfigurationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FundConfiguration
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_fund_configuration_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_fund_configuration_with_http_info(scope, fund_configuration_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_fund_configuration_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], fund_configuration_request : Annotated[FundConfigurationRequest, Field(..., description="The definition of the FundConfiguration.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateFundConfiguration: Create a FundConfiguration.  # noqa: E501

        Create the given FundConfiguration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_fund_configuration_with_http_info(scope, fund_configuration_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the FundConfiguration. (required)
        :type scope: str
        :param fund_configuration_request: The definition of the FundConfiguration. (required)
        :type fund_configuration_request: FundConfigurationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FundConfiguration, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'fund_configuration_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_fund_configuration" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['fund_configuration_request'] is not None:
            _body_params = _params['fund_configuration_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "FundConfiguration",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/fundconfigurations/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration to be deleted.              Together with the scope this uniquely identifies the FundConfiguration.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration to be deleted.              Together with the scope this uniquely identifies the FundConfiguration.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration to be deleted.              Together with the scope this uniquely identifies the FundConfiguration.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteFundConfiguration: Delete a FundConfiguration.  # noqa: E501

        Delete the given FundConfiguration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_fund_configuration(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the FundConfiguration to be deleted. (required)
        :type scope: str
        :param code: The code of the FundConfiguration to be deleted.              Together with the scope this uniquely identifies the FundConfiguration. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_fund_configuration_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_fund_configuration_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_fund_configuration_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration to be deleted.              Together with the scope this uniquely identifies the FundConfiguration.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteFundConfiguration: Delete a FundConfiguration.  # noqa: E501

        Delete the given FundConfiguration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_fund_configuration_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the FundConfiguration to be deleted. (required)
        :type scope: str
        :param code: The code of the FundConfiguration to be deleted.              Together with the scope this uniquely identifies the FundConfiguration. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_fund_configuration" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/fundconfigurations/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration. Together with the scope this uniquely identifies the FundConfiguration.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the FundConfiguration properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the FundConfiguration definition. Defaults to returning the latest version of the FundConfiguration definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'FundConfiguration' domain to decorate onto the FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> FundConfiguration:  # noqa: E501
        ...

    @overload
    def get_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration. Together with the scope this uniquely identifies the FundConfiguration.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the FundConfiguration properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the FundConfiguration definition. Defaults to returning the latest version of the FundConfiguration definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'FundConfiguration' domain to decorate onto the FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=True, **kwargs) -> FundConfiguration:  # noqa: E501
        ...

    @validate_arguments
    def get_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration. Together with the scope this uniquely identifies the FundConfiguration.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the FundConfiguration properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the FundConfiguration definition. Defaults to returning the latest version of the FundConfiguration definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'FundConfiguration' domain to decorate onto the FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[FundConfiguration, Awaitable[FundConfiguration]]:  # noqa: E501
        """[EXPERIMENTAL] GetFundConfiguration: Get FundConfiguration.  # noqa: E501

        Retrieve the definition of a particular FundConfiguration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fund_configuration(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the FundConfiguration. (required)
        :type scope: str
        :param code: The code of the FundConfiguration. Together with the scope this uniquely identifies the FundConfiguration. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the FundConfiguration properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the FundConfiguration definition. Defaults to returning the latest version of the FundConfiguration definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'FundConfiguration' domain to decorate onto the FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FundConfiguration
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_fund_configuration_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_fund_configuration_with_http_info(scope, code, effective_at, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_fund_configuration_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration. Together with the scope this uniquely identifies the FundConfiguration.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the FundConfiguration properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the FundConfiguration definition. Defaults to returning the latest version of the FundConfiguration definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'FundConfiguration' domain to decorate onto the FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetFundConfiguration: Get FundConfiguration.  # noqa: E501

        Retrieve the definition of a particular FundConfiguration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fund_configuration_with_http_info(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the FundConfiguration. (required)
        :type scope: str
        :param code: The code of the FundConfiguration. Together with the scope this uniquely identifies the FundConfiguration. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the FundConfiguration properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the FundConfiguration definition. Defaults to returning the latest version of the FundConfiguration definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'FundConfiguration' domain to decorate onto the FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FundConfiguration, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fund_configuration" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "FundConfiguration",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/fundconfigurations/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_fund_configurations(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the FundConfiguration.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the FundConfiguration. Defaults to returning the latest version of each FundConfiguration if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing FundConfiguration; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the FundConfiguration type, specify \"id.Code eq 'FundConfiguration1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'FundConfiguration' domain to decorate onto each FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'.")] = None, **kwargs) -> PagedResourceListOfFundConfiguration:  # noqa: E501
        ...

    @overload
    def list_fund_configurations(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the FundConfiguration.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the FundConfiguration. Defaults to returning the latest version of each FundConfiguration if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing FundConfiguration; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the FundConfiguration type, specify \"id.Code eq 'FundConfiguration1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'FundConfiguration' domain to decorate onto each FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfFundConfiguration:  # noqa: E501
        ...

    @validate_arguments
    def list_fund_configurations(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the FundConfiguration.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the FundConfiguration. Defaults to returning the latest version of each FundConfiguration if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing FundConfiguration; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the FundConfiguration type, specify \"id.Code eq 'FundConfiguration1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'FundConfiguration' domain to decorate onto each FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfFundConfiguration, Awaitable[PagedResourceListOfFundConfiguration]]:  # noqa: E501
        """[EXPERIMENTAL] ListFundConfigurations: List FundConfiguration.  # noqa: E501

        List all the FundConfiguration matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_fund_configurations(effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the FundConfiguration.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the FundConfiguration. Defaults to returning the latest version of each FundConfiguration if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing FundConfiguration; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the FundConfiguration type, specify \"id.Code eq 'FundConfiguration1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'FundConfiguration' domain to decorate onto each FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfFundConfiguration
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_fund_configurations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_fund_configurations_with_http_info(effective_at, as_at, page, limit, filter, sort_by, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_fund_configurations_with_http_info(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the FundConfiguration.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the FundConfiguration. Defaults to returning the latest version of each FundConfiguration if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing FundConfiguration; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the FundConfiguration type, specify \"id.Code eq 'FundConfiguration1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'FundConfiguration' domain to decorate onto each FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListFundConfigurations: List FundConfiguration.  # noqa: E501

        List all the FundConfiguration matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_fund_configurations_with_http_info(effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the FundConfiguration.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the FundConfiguration. Defaults to returning the latest version of each FundConfiguration if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing FundConfiguration; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the FundConfiguration type, specify \"id.Code eq 'FundConfiguration1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'FundConfiguration' domain to decorate onto each FundConfiguration.             These must take the format {domain}/{scope}/{code}, for example 'FundConfiguration/Manager/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfFundConfiguration, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_fund_configurations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfFundConfiguration",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/fundconfigurations', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def patch_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration. Together with the             scope this uniquely identifies the FundConfiguration.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> FundConfiguration:  # noqa: E501
        ...

    @overload
    def patch_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration. Together with the             scope this uniquely identifies the FundConfiguration.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=True, **kwargs) -> FundConfiguration:  # noqa: E501
        ...

    @validate_arguments
    def patch_fund_configuration(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration. Together with the             scope this uniquely identifies the FundConfiguration.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=None, **kwargs) -> Union[FundConfiguration, Awaitable[FundConfiguration]]:  # noqa: E501
        """[EXPERIMENTAL] PatchFundConfiguration: Patch Fund Configuration.  # noqa: E501

        Create or update certain fields for a particular FundConfiguration.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: DisplayName, Description, DealingFilters, PnlFilters, BackOutFilters, ExternalFeeFilters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_fund_configuration(scope, code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the FundConfiguration. (required)
        :type scope: str
        :param code: The code of the FundConfiguration. Together with the             scope this uniquely identifies the FundConfiguration. (required)
        :type code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FundConfiguration
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the patch_fund_configuration_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.patch_fund_configuration_with_http_info(scope, code, operation, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_fund_configuration_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration. Together with the             scope this uniquely identifies the FundConfiguration.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PatchFundConfiguration: Patch Fund Configuration.  # noqa: E501

        Create or update certain fields for a particular FundConfiguration.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: DisplayName, Description, DealingFilters, PnlFilters, BackOutFilters, ExternalFeeFilters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_fund_configuration_with_http_info(scope, code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the FundConfiguration. (required)
        :type scope: str
        :param code: The code of the FundConfiguration. Together with the             scope this uniquely identifies the FundConfiguration. (required)
        :type code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FundConfiguration, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'operation'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_fund_configuration" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['operation'] is not None:
            _body_params = _params['operation']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "FundConfiguration",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/fundconfigurations/{scope}/{code}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_fund_configuration_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration to update or insert the properties onto. Together with the scope this uniquely identifies the FundConfiguration.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fund Configuration. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"FundConfiguration/Manager/Id\".")] = None, **kwargs) -> FundConfigurationProperties:  # noqa: E501
        ...

    @overload
    def upsert_fund_configuration_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration to update or insert the properties onto. Together with the scope this uniquely identifies the FundConfiguration.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fund Configuration. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"FundConfiguration/Manager/Id\".")] = None, async_req: Optional[bool]=True, **kwargs) -> FundConfigurationProperties:  # noqa: E501
        ...

    @validate_arguments
    def upsert_fund_configuration_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration to update or insert the properties onto. Together with the scope this uniquely identifies the FundConfiguration.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fund Configuration. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"FundConfiguration/Manager/Id\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[FundConfigurationProperties, Awaitable[FundConfigurationProperties]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertFundConfigurationProperties: Upsert FundConfiguration properties  # noqa: E501

        Update or insert one or more properties onto a single FundConfiguration. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'FundConfiguration'.              Upserting a property that exists for an FundConfiguration, with a null value, will delete the instance of the property for that group.              Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_fund_configuration_properties(scope, code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the FundConfiguration to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the FundConfiguration to update or insert the properties onto. Together with the scope this uniquely identifies the FundConfiguration. (required)
        :type code: str
        :param request_body: The properties to be updated or inserted onto the Fund Configuration. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"FundConfiguration/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FundConfigurationProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_fund_configuration_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_fund_configuration_properties_with_http_info(scope, code, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_fund_configuration_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the FundConfiguration to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the FundConfiguration to update or insert the properties onto. Together with the scope this uniquely identifies the FundConfiguration.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fund Configuration. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"FundConfiguration/Manager/Id\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertFundConfigurationProperties: Upsert FundConfiguration properties  # noqa: E501

        Update or insert one or more properties onto a single FundConfiguration. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'FundConfiguration'.              Upserting a property that exists for an FundConfiguration, with a null value, will delete the instance of the property for that group.              Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_fund_configuration_properties_with_http_info(scope, code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the FundConfiguration to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the FundConfiguration to update or insert the properties onto. Together with the scope this uniquely identifies the FundConfiguration. (required)
        :type code: str
        :param request_body: The properties to be updated or inserted onto the Fund Configuration. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"FundConfiguration/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FundConfigurationProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_fund_configuration_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "FundConfigurationProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/fundconfigurations/{scope}/{code}/properties/$upsert', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
