# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictBool, StrictInt, StrictStr, conint, conlist, constr, validator

from typing import Dict, Optional

from lusid.models.accept_estimate_valuation_point_response import AcceptEstimateValuationPointResponse
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.diary_entry import DiaryEntry
from lusid.models.fee import Fee
from lusid.models.fee_properties import FeeProperties
from lusid.models.fee_request import FeeRequest
from lusid.models.fund import Fund
from lusid.models.fund_calendar_entry import FundCalendarEntry
from lusid.models.fund_definition_request import FundDefinitionRequest
from lusid.models.fund_properties import FundProperties
from lusid.models.fund_request import FundRequest
from lusid.models.fund_valuation_request import FundValuationRequest
from lusid.models.list_aggregation_response import ListAggregationResponse
from lusid.models.model_property import ModelProperty
from lusid.models.operation import Operation
from lusid.models.paged_resource_list_of_fee import PagedResourceListOfFee
from lusid.models.paged_resource_list_of_fund import PagedResourceListOfFund
from lusid.models.paged_resource_list_of_fund_calendar_entry import PagedResourceListOfFundCalendarEntry
from lusid.models.paged_resource_list_of_valuation_point_overview import PagedResourceListOfValuationPointOverview
from lusid.models.set_share_class_instruments_request import SetShareClassInstrumentsRequest
from lusid.models.single_valuation_point_query_parameters import SingleValuationPointQueryParameters
from lusid.models.upsert_fund_bookmark_request import UpsertFundBookmarkRequest
from lusid.models.upsert_valuation_point_request import UpsertValuationPointRequest
from lusid.models.valuation_point_data_query_parameters import ValuationPointDataQueryParameters
from lusid.models.valuation_point_data_request import ValuationPointDataRequest
from lusid.models.valuation_point_data_response import ValuationPointDataResponse
from lusid.models.valuation_point_resource_list_of_accounted_transaction import ValuationPointResourceListOfAccountedTransaction
from lusid.models.valuation_point_resource_list_of_fund_journal_entry_line import ValuationPointResourceListOfFundJournalEntryLine
from lusid.models.valuation_point_resource_list_of_pnl_journal_entry_line import ValuationPointResourceListOfPnlJournalEntryLine
from lusid.models.valuation_point_resource_list_of_trial_balance import ValuationPointResourceListOfTrialBalance
from lusid.models.versioned_resource_list_of_portfolio_holding import VersionedResourceListOfPortfolioHolding

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class FundsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def accept_estimate_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_request : Annotated[ValuationPointDataRequest, Field(..., description="The valuationPointDataRequest which contains the Diary Entry code for the Estimate Valuation Point to move to Candidate or Final state.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided Accepts the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Accepted.")] = None, **kwargs) -> AcceptEstimateValuationPointResponse:  # noqa: E501
        ...

    @overload
    def accept_estimate_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_request : Annotated[ValuationPointDataRequest, Field(..., description="The valuationPointDataRequest which contains the Diary Entry code for the Estimate Valuation Point to move to Candidate or Final state.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided Accepts the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Accepted.")] = None, async_req: Optional[bool]=True, **kwargs) -> AcceptEstimateValuationPointResponse:  # noqa: E501
        ...

    @validate_arguments
    def accept_estimate_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_request : Annotated[ValuationPointDataRequest, Field(..., description="The valuationPointDataRequest which contains the Diary Entry code for the Estimate Valuation Point to move to Candidate or Final state.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided Accepts the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Accepted.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[AcceptEstimateValuationPointResponse, Awaitable[AcceptEstimateValuationPointResponse]]:  # noqa: E501
        """[EXPERIMENTAL] AcceptEstimateValuationPoint: Accepts an Estimate Valuation Point.  # noqa: E501

        Accepts the specified estimate Valuation Point. Should the Valuation Point differ since the Valuation Point was last run, both Valuation Points will be returned and status will be marked as 'Candidate', otherwise it will be marked as 'Final'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.accept_estimate_valuation_point(scope, code, valuation_point_data_request, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param valuation_point_data_request: The valuationPointDataRequest which contains the Diary Entry code for the Estimate Valuation Point to move to Candidate or Final state. (required)
        :type valuation_point_data_request: ValuationPointDataRequest
        :param nav_type_code: When provided Accepts the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Accepted.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AcceptEstimateValuationPointResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the accept_estimate_valuation_point_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.accept_estimate_valuation_point_with_http_info(scope, code, valuation_point_data_request, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def accept_estimate_valuation_point_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_request : Annotated[ValuationPointDataRequest, Field(..., description="The valuationPointDataRequest which contains the Diary Entry code for the Estimate Valuation Point to move to Candidate or Final state.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided Accepts the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Accepted.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] AcceptEstimateValuationPoint: Accepts an Estimate Valuation Point.  # noqa: E501

        Accepts the specified estimate Valuation Point. Should the Valuation Point differ since the Valuation Point was last run, both Valuation Points will be returned and status will be marked as 'Candidate', otherwise it will be marked as 'Final'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.accept_estimate_valuation_point_with_http_info(scope, code, valuation_point_data_request, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param valuation_point_data_request: The valuationPointDataRequest which contains the Diary Entry code for the Estimate Valuation Point to move to Candidate or Final state. (required)
        :type valuation_point_data_request: ValuationPointDataRequest
        :param nav_type_code: When provided Accepts the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Accepted.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AcceptEstimateValuationPointResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'valuation_point_data_request',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method accept_estimate_valuation_point" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['valuation_point_data_request'] is not None:
            _body_params = _params['valuation_point_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AcceptEstimateValuationPointResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/valuationpoints/$acceptestimate', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_request : Annotated[FeeRequest, Field(..., description="The Fee to create.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, **kwargs) -> Fee:  # noqa: E501
        ...

    @overload
    def create_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_request : Annotated[FeeRequest, Field(..., description="The Fee to create.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, async_req: Optional[bool]=True, **kwargs) -> Fee:  # noqa: E501
        ...

    @validate_arguments
    def create_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_request : Annotated[FeeRequest, Field(..., description="The Fee to create.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Fee, Awaitable[Fee]]:  # noqa: E501
        """[EXPERIMENTAL] CreateFee: Create a Fee.  # noqa: E501

        Create the given Fee.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_fee(scope, code, fee_request, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_request: The Fee to create. (required)
        :type fee_request: FeeRequest
        :param nav_type_code: When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Fee
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_fee_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_fee_with_http_info(scope, code, fee_request, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def create_fee_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_request : Annotated[FeeRequest, Field(..., description="The Fee to create.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateFee: Create a Fee.  # noqa: E501

        Create the given Fee.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_fee_with_http_info(scope, code, fee_request, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_request: The Fee to create. (required)
        :type fee_request: FeeRequest
        :param nav_type_code: When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Fee, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'fee_request',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_fee" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['fee_request'] is not None:
            _body_params = _params['fee_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Fee",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/fees', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], fund_request : Annotated[FundRequest, Field(..., description="The definition of the Fund.")], **kwargs) -> Fund:  # noqa: E501
        ...

    @overload
    def create_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], fund_request : Annotated[FundRequest, Field(..., description="The definition of the Fund.")], async_req: Optional[bool]=True, **kwargs) -> Fund:  # noqa: E501
        ...

    @validate_arguments
    def create_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], fund_request : Annotated[FundRequest, Field(..., description="The definition of the Fund.")], async_req: Optional[bool]=None, **kwargs) -> Union[Fund, Awaitable[Fund]]:  # noqa: E501
        """[EXPERIMENTAL] CreateFund: Create a Fund.  # noqa: E501

        Create the given Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_fund(scope, fund_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param fund_request: The definition of the Fund. (required)
        :type fund_request: FundRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Fund
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_fund_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_fund_with_http_info(scope, fund_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_fund_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], fund_request : Annotated[FundRequest, Field(..., description="The definition of the Fund.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateFund: Create a Fund.  # noqa: E501

        Create the given Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_fund_with_http_info(scope, fund_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param fund_request: The definition of the Fund. (required)
        :type fund_request: FundRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Fund, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'fund_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_fund" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['fund_request'] is not None:
            _body_params = _params['fund_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Fund",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_fund_v2(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], fund_definition_request : Annotated[FundDefinitionRequest, Field(..., description="The definition of the Fund.")], **kwargs) -> Fund:  # noqa: E501
        ...

    @overload
    def create_fund_v2(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], fund_definition_request : Annotated[FundDefinitionRequest, Field(..., description="The definition of the Fund.")], async_req: Optional[bool]=True, **kwargs) -> Fund:  # noqa: E501
        ...

    @validate_arguments
    def create_fund_v2(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], fund_definition_request : Annotated[FundDefinitionRequest, Field(..., description="The definition of the Fund.")], async_req: Optional[bool]=None, **kwargs) -> Union[Fund, Awaitable[Fund]]:  # noqa: E501
        """[EXPERIMENTAL] CreateFundV2: Create a Fund V2 (Preview).  # noqa: E501

        Create the given V2 Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_fund_v2(scope, fund_definition_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param fund_definition_request: The definition of the Fund. (required)
        :type fund_definition_request: FundDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Fund
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_fund_v2_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_fund_v2_with_http_info(scope, fund_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_fund_v2_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], fund_definition_request : Annotated[FundDefinitionRequest, Field(..., description="The definition of the Fund.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateFundV2: Create a Fund V2 (Preview).  # noqa: E501

        Create the given V2 Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_fund_v2_with_http_info(scope, fund_definition_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param fund_definition_request: The definition of the Fund. (required)
        :type fund_definition_request: FundDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Fund, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'fund_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_fund_v2" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['fund_definition_request'] is not None:
            _body_params = _params['fund_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Fund",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/v2/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_bookmark(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund for the Bookmark to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund containing the Bookmark to be deleted. Together with the scope this uniquely identifies the Fund.")], bookmark_code : Annotated[StrictStr, Field(..., description="The bookmark code for the bookmark to be deleted")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Deletes the Bookmark against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.")] = None, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_bookmark(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund for the Bookmark to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund containing the Bookmark to be deleted. Together with the scope this uniquely identifies the Fund.")], bookmark_code : Annotated[StrictStr, Field(..., description="The bookmark code for the bookmark to be deleted")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Deletes the Bookmark against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.")] = None, async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_bookmark(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund for the Bookmark to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund containing the Bookmark to be deleted. Together with the scope this uniquely identifies the Fund.")], bookmark_code : Annotated[StrictStr, Field(..., description="The bookmark code for the bookmark to be deleted")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Deletes the Bookmark against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteBookmark: Delete a Bookmark.  # noqa: E501

        Deletes the given Bookmark.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_bookmark(scope, code, bookmark_code, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund for the Bookmark to be deleted. (required)
        :type scope: str
        :param code: The code of the Fund containing the Bookmark to be deleted. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param bookmark_code: The bookmark code for the bookmark to be deleted (required)
        :type bookmark_code: str
        :param nav_type_code: When provided, Deletes the Bookmark against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_bookmark_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_bookmark_with_http_info(scope, code, bookmark_code, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_bookmark_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund for the Bookmark to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund containing the Bookmark to be deleted. Together with the scope this uniquely identifies the Fund.")], bookmark_code : Annotated[StrictStr, Field(..., description="The bookmark code for the bookmark to be deleted")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Deletes the Bookmark against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteBookmark: Delete a Bookmark.  # noqa: E501

        Deletes the given Bookmark.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_bookmark_with_http_info(scope, code, bookmark_code, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund for the Bookmark to be deleted. (required)
        :type scope: str
        :param code: The code of the Fund containing the Bookmark to be deleted. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param bookmark_code: The bookmark code for the bookmark to be deleted (required)
        :type bookmark_code: str
        :param nav_type_code: When provided, Deletes the Bookmark against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'bookmark_code',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bookmark" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['bookmark_code']:
            _path_params['bookmarkCode'] = _params['bookmark_code']


        # process the query parameters
        _query_params = []
        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/bookmarks/{bookmarkCode}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to be deleted.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to be deleted.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to be deleted.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteFee: Delete a Fee.  # noqa: E501

        Delete the given Fee.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_fee(scope, code, fee_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_code: The code of the Fee to be deleted. (required)
        :type fee_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_fee_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_fee_with_http_info(scope, code, fee_code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_fee_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to be deleted.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteFee: Delete a Fee.  # noqa: E501

        Delete the given Fee.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_fee_with_http_info(scope, code, fee_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_code: The code of the Fee to be deleted. (required)
        :type fee_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'fee_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_fee" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['fee_code']:
            _path_params['feeCode'] = _params['fee_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/fees/{feeCode}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to be deleted. Together with the scope this uniquely identifies the Fund.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to be deleted. Together with the scope this uniquely identifies the Fund.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to be deleted. Together with the scope this uniquely identifies the Fund.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteFund: Delete a Fund.  # noqa: E501

        Delete the given Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_fund(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund to be deleted. (required)
        :type scope: str
        :param code: The code of the Fund to be deleted. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_fund_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_fund_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_fund_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to be deleted. Together with the scope this uniquely identifies the Fund.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteFund: Delete a Fund.  # noqa: E501

        Delete the given Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_fund_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund to be deleted. (required)
        :type scope: str
        :param code: The code of the Fund to be deleted. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_fund" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund for the valuation point to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund containing the Valuation Point to be deleted. Together with the scope this uniquely identifies the Fund.")], diary_entry_code : Annotated[StrictStr, Field(..., description="The diary entry code for the valuation Point to be deleted.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Deletes the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.")] = None, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund for the valuation point to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund containing the Valuation Point to be deleted. Together with the scope this uniquely identifies the Fund.")], diary_entry_code : Annotated[StrictStr, Field(..., description="The diary entry code for the valuation Point to be deleted.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Deletes the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.")] = None, async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund for the valuation point to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund containing the Valuation Point to be deleted. Together with the scope this uniquely identifies the Fund.")], diary_entry_code : Annotated[StrictStr, Field(..., description="The diary entry code for the valuation Point to be deleted.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Deletes the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteValuationPoint: Delete a Valuation Point.  # noqa: E501

        Deletes the given Valuation Point.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_valuation_point(scope, code, diary_entry_code, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund for the valuation point to be deleted. (required)
        :type scope: str
        :param code: The code of the Fund containing the Valuation Point to be deleted. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param diary_entry_code: The diary entry code for the valuation Point to be deleted. (required)
        :type diary_entry_code: str
        :param nav_type_code: When provided, Deletes the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_valuation_point_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_valuation_point_with_http_info(scope, code, diary_entry_code, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_valuation_point_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund for the valuation point to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund containing the Valuation Point to be deleted. Together with the scope this uniquely identifies the Fund.")], diary_entry_code : Annotated[StrictStr, Field(..., description="The diary entry code for the valuation Point to be deleted.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Deletes the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteValuationPoint: Delete a Valuation Point.  # noqa: E501

        Deletes the given Valuation Point.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_valuation_point_with_http_info(scope, code, diary_entry_code, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund for the valuation point to be deleted. (required)
        :type scope: str
        :param code: The code of the Fund containing the Valuation Point to be deleted. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param diary_entry_code: The diary entry code for the valuation Point to be deleted. (required)
        :type diary_entry_code: str
        :param nav_type_code: When provided, Deletes the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be Deleted.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'diary_entry_code',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_valuation_point" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['diary_entry_code']:
            _path_params['diaryEntryCode'] = _params['diary_entry_code']


        # process the query parameters
        _query_params = []
        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/valuationpoints/{diaryEntryCode}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def finalise_candidate_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_request : Annotated[ValuationPointDataRequest, Field(..., description="The valuationPointDataRequest which contains the diary entry code to mark as final.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided Finalises the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Finalised.")] = None, **kwargs) -> ValuationPointDataResponse:  # noqa: E501
        ...

    @overload
    def finalise_candidate_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_request : Annotated[ValuationPointDataRequest, Field(..., description="The valuationPointDataRequest which contains the diary entry code to mark as final.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided Finalises the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Finalised.")] = None, async_req: Optional[bool]=True, **kwargs) -> ValuationPointDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def finalise_candidate_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_request : Annotated[ValuationPointDataRequest, Field(..., description="The valuationPointDataRequest which contains the diary entry code to mark as final.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided Finalises the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Finalised.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ValuationPointDataResponse, Awaitable[ValuationPointDataResponse]]:  # noqa: E501
        """[EXPERIMENTAL] FinaliseCandidateValuationPoint: Finalise Candidate.  # noqa: E501

        Moves a 'Candidate' status Valuation Point to status 'Final'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.finalise_candidate_valuation_point(scope, code, valuation_point_data_request, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param valuation_point_data_request: The valuationPointDataRequest which contains the diary entry code to mark as final. (required)
        :type valuation_point_data_request: ValuationPointDataRequest
        :param nav_type_code: When provided Finalises the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Finalised.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ValuationPointDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the finalise_candidate_valuation_point_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.finalise_candidate_valuation_point_with_http_info(scope, code, valuation_point_data_request, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def finalise_candidate_valuation_point_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_request : Annotated[ValuationPointDataRequest, Field(..., description="The valuationPointDataRequest which contains the diary entry code to mark as final.")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided Finalises the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Finalised.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] FinaliseCandidateValuationPoint: Finalise Candidate.  # noqa: E501

        Moves a 'Candidate' status Valuation Point to status 'Final'.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.finalise_candidate_valuation_point_with_http_info(scope, code, valuation_point_data_request, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param valuation_point_data_request: The valuationPointDataRequest which contains the diary entry code to mark as final. (required)
        :type valuation_point_data_request: ValuationPointDataRequest
        :param nav_type_code: When provided Finalises the Valuation Point of the specified NAV Type. When not provided the Primary NAV Type will be Finalised.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ValuationPointDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'valuation_point_data_request',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method finalise_candidate_valuation_point" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['valuation_point_data_request'] is not None:
            _body_params = _params['valuation_point_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ValuationPointDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/valuationpoints/$finalisecandidate', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Fee properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fee. Defaults to returning the latest version of the Fee if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fee' domain to decorate onto the Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> Fee:  # noqa: E501
        ...

    @overload
    def get_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Fee properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fee. Defaults to returning the latest version of the Fee if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fee' domain to decorate onto the Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=True, **kwargs) -> Fee:  # noqa: E501
        ...

    @validate_arguments
    def get_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Fee properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fee. Defaults to returning the latest version of the Fee if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fee' domain to decorate onto the Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Fee, Awaitable[Fee]]:  # noqa: E501
        """[EXPERIMENTAL] GetFee: Get a Fee for a specified Fund.  # noqa: E501

        Retrieve a fee for a specified Fund  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fee(scope, code, fee_code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_code: The code of the Fee. (required)
        :type fee_code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Fee properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Fee. Defaults to returning the latest version of the Fee if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Fee' domain to decorate onto the Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Fee
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_fee_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_fee_with_http_info(scope, code, fee_code, effective_at, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_fee_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Fee properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fee. Defaults to returning the latest version of the Fee if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fee' domain to decorate onto the Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetFee: Get a Fee for a specified Fund.  # noqa: E501

        Retrieve a fee for a specified Fund  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fee_with_http_info(scope, code, fee_code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_code: The code of the Fee. (required)
        :type fee_code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Fee properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Fee. Defaults to returning the latest version of the Fee if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Fee' domain to decorate onto the Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Fee, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'fee_code',
            'effective_at',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fee" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['fee_code']:
            _path_params['feeCode'] = _params['fee_code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Fee",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/fees/{feeCode}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_fee_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to get the properties for.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Fee's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fee's properties. Defaults to return the latest version of each property if not specified.")] = None, **kwargs) -> FeeProperties:  # noqa: E501
        ...

    @overload
    def get_fee_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to get the properties for.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Fee's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fee's properties. Defaults to return the latest version of each property if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> FeeProperties:  # noqa: E501
        ...

    @validate_arguments
    def get_fee_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to get the properties for.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Fee's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fee's properties. Defaults to return the latest version of each property if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[FeeProperties, Awaitable[FeeProperties]]:  # noqa: E501
        """[EXPERIMENTAL] GetFeeProperties: Get Fee properties  # noqa: E501

        Get all the properties of a single fee.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fee_properties(scope, code, fee_code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_code: The code of the Fee to get the properties for. (required)
        :type fee_code: str
        :param effective_at: The effective datetime or cut label at which to list the Fee's properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Fee's properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FeeProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_fee_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_fee_properties_with_http_info(scope, code, fee_code, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_fee_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to get the properties for.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Fee's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fee's properties. Defaults to return the latest version of each property if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetFeeProperties: Get Fee properties  # noqa: E501

        Get all the properties of a single fee.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fee_properties_with_http_info(scope, code, fee_code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_code: The code of the Fee to get the properties for. (required)
        :type fee_code: str
        :param effective_at: The effective datetime or cut label at which to list the Fee's properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Fee's properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FeeProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'fee_code',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fee_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['fee_code']:
            _path_params['feeCode'] = _params['fee_code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "FeeProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/fees/{feeCode}/properties', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Fund properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fund' domain to decorate onto the Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> Fund:  # noqa: E501
        ...

    @overload
    def get_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Fund properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fund' domain to decorate onto the Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=True, **kwargs) -> Fund:  # noqa: E501
        ...

    @validate_arguments
    def get_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Fund properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fund' domain to decorate onto the Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Fund, Awaitable[Fund]]:  # noqa: E501
        """[EXPERIMENTAL] GetFund: Get a Fund.  # noqa: E501

        Retrieve the definition of a particular Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fund(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Fund properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Fund' domain to decorate onto the Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Fund
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_fund_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_fund_with_http_info(scope, code, effective_at, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_fund_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the Fund properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fund' domain to decorate onto the Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetFund: Get a Fund.  # noqa: E501

        Retrieve the definition of a particular Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fund_with_http_info(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the Fund properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Fund' domain to decorate onto the Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Fund, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fund" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Fund",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_fund_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to list the properties for. Together with the scope this uniquely identifies the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Fund's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fund's properties. Defaults to return the latest version of each property if not specified.")] = None, **kwargs) -> FundProperties:  # noqa: E501
        ...

    @overload
    def get_fund_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to list the properties for. Together with the scope this uniquely identifies the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Fund's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fund's properties. Defaults to return the latest version of each property if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> FundProperties:  # noqa: E501
        ...

    @validate_arguments
    def get_fund_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to list the properties for. Together with the scope this uniquely identifies the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Fund's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fund's properties. Defaults to return the latest version of each property if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[FundProperties, Awaitable[FundProperties]]:  # noqa: E501
        """[EXPERIMENTAL] GetFundProperties: Get Fund properties  # noqa: E501

        Get all the properties of a single fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fund_properties(scope, code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund to list the properties for. (required)
        :type scope: str
        :param code: The code of the Fund to list the properties for. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the Fund's properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Fund's properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FundProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_fund_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_fund_properties_with_http_info(scope, code, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_fund_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to list the properties for.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to list the properties for. Together with the scope this uniquely identifies the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the Fund's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fund's properties. Defaults to return the latest version of each property if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetFundProperties: Get Fund properties  # noqa: E501

        Get all the properties of a single fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fund_properties_with_http_info(scope, code, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund to list the properties for. (required)
        :type scope: str
        :param code: The code of the Fund to list the properties for. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the Fund's properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Fund's properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FundProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fund_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "FundProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/properties', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_holdings_for_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], single_valuation_point_query_parameters : Annotated[SingleValuationPointQueryParameters, Field(..., description="The query parameters used for diary entry or effective date of Holdings")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the holdings of transaction portfolios in the Fund. Defaults             to return the latest version of the holdings if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Instrument\", \"Holding\" or \"Portfolio\" domain to decorate onto             the holdings. These take the format {domain}/{scope}/{code} e.g. \"Instrument/system/Name\" or \"Holding/system/Cost\".")] = None, by_taxlots : Annotated[Optional[StrictBool], Field(description="Whether to expand the holdings to return the underlying tax-lots. Defaults to False.")] = None, include_settlement_events_after_days : Annotated[Optional[StrictInt], Field(description="Number of days ahead to bring back settlements from, in relation to the specified effectiveAt")] = None, **kwargs) -> VersionedResourceListOfPortfolioHolding:  # noqa: E501
        ...

    @overload
    def get_holdings_for_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], single_valuation_point_query_parameters : Annotated[SingleValuationPointQueryParameters, Field(..., description="The query parameters used for diary entry or effective date of Holdings")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the holdings of transaction portfolios in the Fund. Defaults             to return the latest version of the holdings if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Instrument\", \"Holding\" or \"Portfolio\" domain to decorate onto             the holdings. These take the format {domain}/{scope}/{code} e.g. \"Instrument/system/Name\" or \"Holding/system/Cost\".")] = None, by_taxlots : Annotated[Optional[StrictBool], Field(description="Whether to expand the holdings to return the underlying tax-lots. Defaults to False.")] = None, include_settlement_events_after_days : Annotated[Optional[StrictInt], Field(description="Number of days ahead to bring back settlements from, in relation to the specified effectiveAt")] = None, async_req: Optional[bool]=True, **kwargs) -> VersionedResourceListOfPortfolioHolding:  # noqa: E501
        ...

    @validate_arguments
    def get_holdings_for_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], single_valuation_point_query_parameters : Annotated[SingleValuationPointQueryParameters, Field(..., description="The query parameters used for diary entry or effective date of Holdings")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the holdings of transaction portfolios in the Fund. Defaults             to return the latest version of the holdings if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Instrument\", \"Holding\" or \"Portfolio\" domain to decorate onto             the holdings. These take the format {domain}/{scope}/{code} e.g. \"Instrument/system/Name\" or \"Holding/system/Cost\".")] = None, by_taxlots : Annotated[Optional[StrictBool], Field(description="Whether to expand the holdings to return the underlying tax-lots. Defaults to False.")] = None, include_settlement_events_after_days : Annotated[Optional[StrictInt], Field(description="Number of days ahead to bring back settlements from, in relation to the specified effectiveAt")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[VersionedResourceListOfPortfolioHolding, Awaitable[VersionedResourceListOfPortfolioHolding]]:  # noqa: E501
        """[EXPERIMENTAL] GetHoldingsForFund: Get holdings for transaction portfolios in a Fund.  # noqa: E501

        Get the holdings of transaction portfolios in a specified Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_holdings_for_fund(scope, code, single_valuation_point_query_parameters, nav_type_code, as_at, filter, property_keys, by_taxlots, include_settlement_events_after_days, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param single_valuation_point_query_parameters: The query parameters used for diary entry or effective date of Holdings (required)
        :type single_valuation_point_query_parameters: SingleValuationPointQueryParameters
        :param nav_type_code: When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.
        :type nav_type_code: str
        :param as_at: The asAt datetime at which to retrieve the holdings of transaction portfolios in the Fund. Defaults             to return the latest version of the holdings if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param property_keys: A list of property keys from the \"Instrument\", \"Holding\" or \"Portfolio\" domain to decorate onto             the holdings. These take the format {domain}/{scope}/{code} e.g. \"Instrument/system/Name\" or \"Holding/system/Cost\".
        :type property_keys: List[str]
        :param by_taxlots: Whether to expand the holdings to return the underlying tax-lots. Defaults to False.
        :type by_taxlots: bool
        :param include_settlement_events_after_days: Number of days ahead to bring back settlements from, in relation to the specified effectiveAt
        :type include_settlement_events_after_days: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VersionedResourceListOfPortfolioHolding
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_holdings_for_fund_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_holdings_for_fund_with_http_info(scope, code, single_valuation_point_query_parameters, nav_type_code, as_at, filter, property_keys, by_taxlots, include_settlement_events_after_days, **kwargs)  # noqa: E501

    @validate_arguments
    def get_holdings_for_fund_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], single_valuation_point_query_parameters : Annotated[SingleValuationPointQueryParameters, Field(..., description="The query parameters used for diary entry or effective date of Holdings")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the holdings of transaction portfolios in the Fund. Defaults             to return the latest version of the holdings if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Instrument\", \"Holding\" or \"Portfolio\" domain to decorate onto             the holdings. These take the format {domain}/{scope}/{code} e.g. \"Instrument/system/Name\" or \"Holding/system/Cost\".")] = None, by_taxlots : Annotated[Optional[StrictBool], Field(description="Whether to expand the holdings to return the underlying tax-lots. Defaults to False.")] = None, include_settlement_events_after_days : Annotated[Optional[StrictInt], Field(description="Number of days ahead to bring back settlements from, in relation to the specified effectiveAt")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetHoldingsForFund: Get holdings for transaction portfolios in a Fund.  # noqa: E501

        Get the holdings of transaction portfolios in a specified Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_holdings_for_fund_with_http_info(scope, code, single_valuation_point_query_parameters, nav_type_code, as_at, filter, property_keys, by_taxlots, include_settlement_events_after_days, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param single_valuation_point_query_parameters: The query parameters used for diary entry or effective date of Holdings (required)
        :type single_valuation_point_query_parameters: SingleValuationPointQueryParameters
        :param nav_type_code: When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.
        :type nav_type_code: str
        :param as_at: The asAt datetime at which to retrieve the holdings of transaction portfolios in the Fund. Defaults             to return the latest version of the holdings if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param property_keys: A list of property keys from the \"Instrument\", \"Holding\" or \"Portfolio\" domain to decorate onto             the holdings. These take the format {domain}/{scope}/{code} e.g. \"Instrument/system/Name\" or \"Holding/system/Cost\".
        :type property_keys: List[str]
        :param by_taxlots: Whether to expand the holdings to return the underlying tax-lots. Defaults to False.
        :type by_taxlots: bool
        :param include_settlement_events_after_days: Number of days ahead to bring back settlements from, in relation to the specified effectiveAt
        :type include_settlement_events_after_days: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VersionedResourceListOfPortfolioHolding, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'single_valuation_point_query_parameters',
            'nav_type_code',
            'as_at',
            'filter',
            'property_keys',
            'by_taxlots',
            'include_settlement_events_after_days'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_holdings_for_fund" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('by_taxlots') is not None:  # noqa: E501
            _query_params.append(('byTaxlots', _params['by_taxlots']))

        if _params.get('include_settlement_events_after_days') is not None:  # noqa: E501
            _query_params.append(('includeSettlementEventsAfterDays', _params['include_settlement_events_after_days']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['single_valuation_point_query_parameters'] is not None:
            _body_params = _params['single_valuation_point_query_parameters']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "VersionedResourceListOfPortfolioHolding",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/$holdings', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_valuation_for_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund")], code : Annotated[StrictStr, Field(..., description="The code of the Fund")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, fund_valuation_request : Annotated[Optional[FundValuationRequest], Field(description="The request specifying the dates (or DiaryEntry) on which to calculate a set of valuation metrics")] = None, **kwargs) -> ListAggregationResponse:  # noqa: E501
        ...

    @overload
    def get_valuation_for_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund")], code : Annotated[StrictStr, Field(..., description="The code of the Fund")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, fund_valuation_request : Annotated[Optional[FundValuationRequest], Field(description="The request specifying the dates (or DiaryEntry) on which to calculate a set of valuation metrics")] = None, async_req: Optional[bool]=True, **kwargs) -> ListAggregationResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_valuation_for_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund")], code : Annotated[StrictStr, Field(..., description="The code of the Fund")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, fund_valuation_request : Annotated[Optional[FundValuationRequest], Field(description="The request specifying the dates (or DiaryEntry) on which to calculate a set of valuation metrics")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ListAggregationResponse, Awaitable[ListAggregationResponse]]:  # noqa: E501
        """[EXPERIMENTAL] GetValuationForFund: Perform valuation for a Fund  # noqa: E501

        Perform valuation on a specified Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_for_fund(scope, code, nav_type_code, fund_valuation_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund (required)
        :type scope: str
        :param code: The code of the Fund (required)
        :type code: str
        :param nav_type_code: When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.
        :type nav_type_code: str
        :param fund_valuation_request: The request specifying the dates (or DiaryEntry) on which to calculate a set of valuation metrics
        :type fund_valuation_request: FundValuationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListAggregationResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_valuation_for_fund_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_valuation_for_fund_with_http_info(scope, code, nav_type_code, fund_valuation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def get_valuation_for_fund_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund")], code : Annotated[StrictStr, Field(..., description="The code of the Fund")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, fund_valuation_request : Annotated[Optional[FundValuationRequest], Field(description="The request specifying the dates (or DiaryEntry) on which to calculate a set of valuation metrics")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetValuationForFund: Perform valuation for a Fund  # noqa: E501

        Perform valuation on a specified Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_for_fund_with_http_info(scope, code, nav_type_code, fund_valuation_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund (required)
        :type scope: str
        :param code: The code of the Fund (required)
        :type code: str
        :param nav_type_code: When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.
        :type nav_type_code: str
        :param fund_valuation_request: The request specifying the dates (or DiaryEntry) on which to calculate a set of valuation metrics
        :type fund_valuation_request: FundValuationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListAggregationResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'nav_type_code',
            'fund_valuation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_valuation_for_fund" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['fund_valuation_request'] is not None:
            _body_params = _params['fund_valuation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ListAggregationResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/$valuation', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_valuation_point_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the Valuation Point data")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, **kwargs) -> ValuationPointDataResponse:  # noqa: E501
        ...

    @overload
    def get_valuation_point_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the Valuation Point data")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, async_req: Optional[bool]=True, **kwargs) -> ValuationPointDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_valuation_point_data(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the Valuation Point data")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ValuationPointDataResponse, Awaitable[ValuationPointDataResponse]]:  # noqa: E501
        """[EXPERIMENTAL] GetValuationPointData: Get Valuation Point Data for a Fund.  # noqa: E501

        Retrieves the Valuation Point data for a date or specified Diary Entry Id. The endpoint will internally extract all 'Assets' and 'Liabilities' from the related ABOR's Trial balance to produce a GAV. Start date will be assumed from the last 'official' DiaryEntry and EndDate will be as provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_point_data(scope, code, valuation_point_data_query_parameters, as_at, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param valuation_point_data_query_parameters: The arguments to use for querying the Valuation Point data (required)
        :type valuation_point_data_query_parameters: ValuationPointDataQueryParameters
        :param as_at: The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.
        :type as_at: datetime
        :param nav_type_code: When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ValuationPointDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_valuation_point_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_valuation_point_data_with_http_info(scope, code, valuation_point_data_query_parameters, as_at, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_valuation_point_data_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the Valuation Point data")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetValuationPointData: Get Valuation Point Data for a Fund.  # noqa: E501

        Retrieves the Valuation Point data for a date or specified Diary Entry Id. The endpoint will internally extract all 'Assets' and 'Liabilities' from the related ABOR's Trial balance to produce a GAV. Start date will be assumed from the last 'official' DiaryEntry and EndDate will be as provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_point_data_with_http_info(scope, code, valuation_point_data_query_parameters, as_at, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param valuation_point_data_query_parameters: The arguments to use for querying the Valuation Point data (required)
        :type valuation_point_data_query_parameters: ValuationPointDataQueryParameters
        :param as_at: The asAt datetime at which to retrieve the Fund definition. Defaults to returning the latest version of the Fund definition if not specified.
        :type as_at: datetime
        :param nav_type_code: When provided runs against the specified NAV Type, otherwise the Primary NAV Type will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ValuationPointDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'valuation_point_data_query_parameters',
            'as_at',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_valuation_point_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['valuation_point_data_query_parameters'] is not None:
            _body_params = _params['valuation_point_data_query_parameters']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ValuationPointDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/valuationpoints/$query', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_valuation_point_journal_entry_lines(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is creating the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the Journal Entry lines.")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Journal Entry lines from a previous call to GetValuationPointJournalEntryLines.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, **kwargs) -> ValuationPointResourceListOfFundJournalEntryLine:  # noqa: E501
        ...

    @overload
    def get_valuation_point_journal_entry_lines(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is creating the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the Journal Entry lines.")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Journal Entry lines from a previous call to GetValuationPointJournalEntryLines.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, async_req: Optional[bool]=True, **kwargs) -> ValuationPointResourceListOfFundJournalEntryLine:  # noqa: E501
        ...

    @validate_arguments
    def get_valuation_point_journal_entry_lines(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is creating the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the Journal Entry lines.")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Journal Entry lines from a previous call to GetValuationPointJournalEntryLines.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ValuationPointResourceListOfFundJournalEntryLine, Awaitable[ValuationPointResourceListOfFundJournalEntryLine]]:  # noqa: E501
        """[EXPERIMENTAL] GetValuationPointJournalEntryLines: Get the Journal Entry lines for the given Fund.  # noqa: E501

        Gets the Journal Entry lines for the given Valuation Point for a Fund              The Journal Entry lines have been generated from transactions, translated via posting rules and used in the valuation point  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_point_journal_entry_lines(scope, code, valuation_point_data_query_parameters, general_ledger_profile_code, as_at, filter, limit, page, property_keys, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope is creating the unique identifier for the given Fund. (required)
        :type code: str
        :param valuation_point_data_query_parameters: The arguments to use for querying the Journal Entry lines. (required)
        :type valuation_point_data_query_parameters: ValuationPointDataQueryParameters
        :param general_ledger_profile_code: The optional code of a general ledger profile used to decorate journal entry lines with levels.
        :type general_ledger_profile_code: str
        :param as_at: The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the result set.
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing Journal Entry lines from a previous call to GetValuationPointJournalEntryLines.
        :type page: str
        :param property_keys: A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.
        :type property_keys: List[str]
        :param nav_type_code: May be provided to view a specific NAV type. When not provided, Primary NAV will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ValuationPointResourceListOfFundJournalEntryLine
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_valuation_point_journal_entry_lines_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_valuation_point_journal_entry_lines_with_http_info(scope, code, valuation_point_data_query_parameters, general_ledger_profile_code, as_at, filter, limit, page, property_keys, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_valuation_point_journal_entry_lines_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is creating the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the Journal Entry lines.")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Journal Entry lines from a previous call to GetValuationPointJournalEntryLines.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetValuationPointJournalEntryLines: Get the Journal Entry lines for the given Fund.  # noqa: E501

        Gets the Journal Entry lines for the given Valuation Point for a Fund              The Journal Entry lines have been generated from transactions, translated via posting rules and used in the valuation point  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_point_journal_entry_lines_with_http_info(scope, code, valuation_point_data_query_parameters, general_ledger_profile_code, as_at, filter, limit, page, property_keys, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope is creating the unique identifier for the given Fund. (required)
        :type code: str
        :param valuation_point_data_query_parameters: The arguments to use for querying the Journal Entry lines. (required)
        :type valuation_point_data_query_parameters: ValuationPointDataQueryParameters
        :param general_ledger_profile_code: The optional code of a general ledger profile used to decorate journal entry lines with levels.
        :type general_ledger_profile_code: str
        :param as_at: The asAt datetime at which to retrieve Journal Entry lines. Defaults to returning the latest version              of each transaction if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the result set.
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing Journal Entry lines from a previous call to GetValuationPointJournalEntryLines.
        :type page: str
        :param property_keys: A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.
        :type property_keys: List[str]
        :param nav_type_code: May be provided to view a specific NAV type. When not provided, Primary NAV will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ValuationPointResourceListOfFundJournalEntryLine, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'valuation_point_data_query_parameters',
            'general_ledger_profile_code',
            'as_at',
            'filter',
            'limit',
            'page',
            'property_keys',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_valuation_point_journal_entry_lines" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('general_ledger_profile_code') is not None:  # noqa: E501
            _query_params.append(('generalLedgerProfileCode', _params['general_ledger_profile_code']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['valuation_point_data_query_parameters'] is not None:
            _body_params = _params['valuation_point_data_query_parameters']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ValuationPointResourceListOfFundJournalEntryLine",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/valuationpoints/journalentrylines/$query', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_valuation_point_pnl_summary(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The query parameters used in running the generation of the PnL summary")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve PnL summary. Defaults to returning the latest version             of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="\"Expression to filter the result set.\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial balance from a previous call to Trial balance.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, **kwargs) -> ValuationPointResourceListOfPnlJournalEntryLine:  # noqa: E501
        ...

    @overload
    def get_valuation_point_pnl_summary(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The query parameters used in running the generation of the PnL summary")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve PnL summary. Defaults to returning the latest version             of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="\"Expression to filter the result set.\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial balance from a previous call to Trial balance.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, async_req: Optional[bool]=True, **kwargs) -> ValuationPointResourceListOfPnlJournalEntryLine:  # noqa: E501
        ...

    @validate_arguments
    def get_valuation_point_pnl_summary(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The query parameters used in running the generation of the PnL summary")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve PnL summary. Defaults to returning the latest version             of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="\"Expression to filter the result set.\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial balance from a previous call to Trial balance.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ValuationPointResourceListOfPnlJournalEntryLine, Awaitable[ValuationPointResourceListOfPnlJournalEntryLine]]:  # noqa: E501
        """[EXPERIMENTAL] GetValuationPointPnlSummary: Get a PnL summary for the given Valuation Point in the Fund.  # noqa: E501

        Gets the PnL Summary lines from the journal entry lines produced when calculating the valuation point.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_point_pnl_summary(scope, code, valuation_point_data_query_parameters, general_ledger_profile_code, as_at, filter, limit, page, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope is the unique identifier for the given Fund. (required)
        :type code: str
        :param valuation_point_data_query_parameters: The query parameters used in running the generation of the PnL summary (required)
        :type valuation_point_data_query_parameters: ValuationPointDataQueryParameters
        :param general_ledger_profile_code: The optional code of a general ledger profile used to decorate journal entry lines with levels.
        :type general_ledger_profile_code: str
        :param as_at: The asAt datetime at which to retrieve PnL summary. Defaults to returning the latest version             of each transaction if not specified.
        :type as_at: datetime
        :param filter: \"Expression to filter the result set.\"
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing Trial balance from a previous call to Trial balance.
        :type page: str
        :param nav_type_code: May be provided to view a specific NAV type. When not provided, Primary NAV will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ValuationPointResourceListOfPnlJournalEntryLine
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_valuation_point_pnl_summary_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_valuation_point_pnl_summary_with_http_info(scope, code, valuation_point_data_query_parameters, general_ledger_profile_code, as_at, filter, limit, page, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_valuation_point_pnl_summary_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The query parameters used in running the generation of the PnL summary")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve PnL summary. Defaults to returning the latest version             of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="\"Expression to filter the result set.\"")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial balance from a previous call to Trial balance.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetValuationPointPnlSummary: Get a PnL summary for the given Valuation Point in the Fund.  # noqa: E501

        Gets the PnL Summary lines from the journal entry lines produced when calculating the valuation point.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_point_pnl_summary_with_http_info(scope, code, valuation_point_data_query_parameters, general_ledger_profile_code, as_at, filter, limit, page, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope is the unique identifier for the given Fund. (required)
        :type code: str
        :param valuation_point_data_query_parameters: The query parameters used in running the generation of the PnL summary (required)
        :type valuation_point_data_query_parameters: ValuationPointDataQueryParameters
        :param general_ledger_profile_code: The optional code of a general ledger profile used to decorate journal entry lines with levels.
        :type general_ledger_profile_code: str
        :param as_at: The asAt datetime at which to retrieve PnL summary. Defaults to returning the latest version             of each transaction if not specified.
        :type as_at: datetime
        :param filter: \"Expression to filter the result set.\"
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing Trial balance from a previous call to Trial balance.
        :type page: str
        :param nav_type_code: May be provided to view a specific NAV type. When not provided, Primary NAV will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ValuationPointResourceListOfPnlJournalEntryLine, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'valuation_point_data_query_parameters',
            'general_ledger_profile_code',
            'as_at',
            'filter',
            'limit',
            'page',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_valuation_point_pnl_summary" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('general_ledger_profile_code') is not None:  # noqa: E501
            _query_params.append(('generalLedgerProfileCode', _params['general_ledger_profile_code']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['valuation_point_data_query_parameters'] is not None:
            _body_params = _params['valuation_point_data_query_parameters']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ValuationPointResourceListOfPnlJournalEntryLine",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/valuationpoints/pnlsummary/$query', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_valuation_point_transactions(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is creating the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the transactions.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve transactions. Defaults to returning the latest version             of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing transactions from a previous call to GetValuationPointTransactions.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'             domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, **kwargs) -> ValuationPointResourceListOfAccountedTransaction:  # noqa: E501
        ...

    @overload
    def get_valuation_point_transactions(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is creating the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the transactions.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve transactions. Defaults to returning the latest version             of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing transactions from a previous call to GetValuationPointTransactions.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'             domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, async_req: Optional[bool]=True, **kwargs) -> ValuationPointResourceListOfAccountedTransaction:  # noqa: E501
        ...

    @validate_arguments
    def get_valuation_point_transactions(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is creating the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the transactions.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve transactions. Defaults to returning the latest version             of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing transactions from a previous call to GetValuationPointTransactions.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'             domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ValuationPointResourceListOfAccountedTransaction, Awaitable[ValuationPointResourceListOfAccountedTransaction]]:  # noqa: E501
        """[EXPERIMENTAL] GetValuationPointTransactions: Get the Transactions for the given Fund.  # noqa: E501

        Gets the Transactions for the given Valuation Point for a Fund  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_point_transactions(scope, code, valuation_point_data_query_parameters, as_at, filter, limit, page, property_keys, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope is creating the unique identifier for the given Fund. (required)
        :type code: str
        :param valuation_point_data_query_parameters: The arguments to use for querying the transactions. (required)
        :type valuation_point_data_query_parameters: ValuationPointDataQueryParameters
        :param as_at: The asAt datetime at which to retrieve transactions. Defaults to returning the latest version             of each transaction if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the result set.
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing transactions from a previous call to GetValuationPointTransactions.
        :type page: str
        :param property_keys: A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'             domain to decorate onto the journal entry lines.
        :type property_keys: List[str]
        :param nav_type_code: May be provided to view a specific NAV type. When not provided, Primary NAV will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ValuationPointResourceListOfAccountedTransaction
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_valuation_point_transactions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_valuation_point_transactions_with_http_info(scope, code, valuation_point_data_query_parameters, as_at, filter, limit, page, property_keys, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_valuation_point_transactions_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope is creating the unique identifier for the given Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The arguments to use for querying the transactions.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve transactions. Defaults to returning the latest version             of each transaction if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing transactions from a previous call to GetValuationPointTransactions.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'             domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetValuationPointTransactions: Get the Transactions for the given Fund.  # noqa: E501

        Gets the Transactions for the given Valuation Point for a Fund  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_point_transactions_with_http_info(scope, code, valuation_point_data_query_parameters, as_at, filter, limit, page, property_keys, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope is creating the unique identifier for the given Fund. (required)
        :type code: str
        :param valuation_point_data_query_parameters: The arguments to use for querying the transactions. (required)
        :type valuation_point_data_query_parameters: ValuationPointDataQueryParameters
        :param as_at: The asAt datetime at which to retrieve transactions. Defaults to returning the latest version             of each transaction if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the result set.
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this many. Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing transactions from a previous call to GetValuationPointTransactions.
        :type page: str
        :param property_keys: A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'             domain to decorate onto the journal entry lines.
        :type property_keys: List[str]
        :param nav_type_code: May be provided to view a specific NAV type. When not provided, Primary NAV will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ValuationPointResourceListOfAccountedTransaction, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'valuation_point_data_query_parameters',
            'as_at',
            'filter',
            'limit',
            'page',
            'property_keys',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_valuation_point_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['valuation_point_data_query_parameters'] is not None:
            _body_params = _params['valuation_point_data_query_parameters']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ValuationPointResourceListOfAccountedTransaction",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/valuationpoints/transactions/$query', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_valuation_point_trial_balance(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The query parameters used in running the generation of the Trial Balance.")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Trial Balance.              Defaults to returning the latest version if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.              For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this number.              Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial Balances.              This token is returned from the previous call.              If a pagination token is provided, the filter, effectiveAt and asAt fields              must not have changed since the original request.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, **kwargs) -> ValuationPointResourceListOfTrialBalance:  # noqa: E501
        ...

    @overload
    def get_valuation_point_trial_balance(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The query parameters used in running the generation of the Trial Balance.")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Trial Balance.              Defaults to returning the latest version if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.              For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this number.              Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial Balances.              This token is returned from the previous call.              If a pagination token is provided, the filter, effectiveAt and asAt fields              must not have changed since the original request.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, async_req: Optional[bool]=True, **kwargs) -> ValuationPointResourceListOfTrialBalance:  # noqa: E501
        ...

    @validate_arguments
    def get_valuation_point_trial_balance(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The query parameters used in running the generation of the Trial Balance.")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Trial Balance.              Defaults to returning the latest version if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.              For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this number.              Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial Balances.              This token is returned from the previous call.              If a pagination token is provided, the filter, effectiveAt and asAt fields              must not have changed since the original request.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ValuationPointResourceListOfTrialBalance, Awaitable[ValuationPointResourceListOfTrialBalance]]:  # noqa: E501
        """[EXPERIMENTAL] GetValuationPointTrialBalance: Get Trial Balance for the given Fund.  # noqa: E501

        Gets the Trial Balance for the given Valuation Point for a Fund.              The Trial Balance has been generated from transactions, translated via Posting Rules and aggregated based on a General Ledger Profile (where specified).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_point_trial_balance(scope, code, valuation_point_data_query_parameters, general_ledger_profile_code, as_at, filter, limit, page, property_keys, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param valuation_point_data_query_parameters: The query parameters used in running the generation of the Trial Balance. (required)
        :type valuation_point_data_query_parameters: ValuationPointDataQueryParameters
        :param general_ledger_profile_code: The optional code of a general ledger profile used to decorate journal entry lines with levels.
        :type general_ledger_profile_code: str
        :param as_at: The asAt datetime at which to retrieve the Trial Balance.              Defaults to returning the latest version if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the results by.              For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this number.              Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing Trial Balances.              This token is returned from the previous call.              If a pagination token is provided, the filter, effectiveAt and asAt fields              must not have changed since the original request.
        :type page: str
        :param property_keys: A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.
        :type property_keys: List[str]
        :param nav_type_code: May be provided to view a specific NAV type. When not provided, Primary NAV will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ValuationPointResourceListOfTrialBalance
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_valuation_point_trial_balance_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_valuation_point_trial_balance_with_http_info(scope, code, valuation_point_data_query_parameters, general_ledger_profile_code, as_at, filter, limit, page, property_keys, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_valuation_point_trial_balance_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], valuation_point_data_query_parameters : Annotated[ValuationPointDataQueryParameters, Field(..., description="The query parameters used in running the generation of the Trial Balance.")], general_ledger_profile_code : Annotated[Optional[StrictStr], Field( description="The optional code of a general ledger profile used to decorate journal entry lines with levels.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Trial Balance.              Defaults to returning the latest version if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.              For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this number.              Defaults to 100 if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Trial Balances.              This token is returned from the previous call.              If a pagination token is provided, the filter, effectiveAt and asAt fields              must not have changed since the original request.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetValuationPointTrialBalance: Get Trial Balance for the given Fund.  # noqa: E501

        Gets the Trial Balance for the given Valuation Point for a Fund.              The Trial Balance has been generated from transactions, translated via Posting Rules and aggregated based on a General Ledger Profile (where specified).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_valuation_point_trial_balance_with_http_info(scope, code, valuation_point_data_query_parameters, general_ledger_profile_code, as_at, filter, limit, page, property_keys, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param valuation_point_data_query_parameters: The query parameters used in running the generation of the Trial Balance. (required)
        :type valuation_point_data_query_parameters: ValuationPointDataQueryParameters
        :param general_ledger_profile_code: The optional code of a general ledger profile used to decorate journal entry lines with levels.
        :type general_ledger_profile_code: str
        :param as_at: The asAt datetime at which to retrieve the Trial Balance.              Defaults to returning the latest version if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the results by.              For more information about filtering results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param limit: When paginating, limit the number of returned results to this number.              Defaults to 100 if not specified.
        :type limit: int
        :param page: The pagination token to use to continue listing Trial Balances.              This token is returned from the previous call.              If a pagination token is provided, the filter, effectiveAt and asAt fields              must not have changed since the original request.
        :type page: str
        :param property_keys: A list of property keys from the 'Instrument', 'Transaction', 'Portfolio', 'Account', 'LegalEntity' or 'CustodianAccount'              domain to decorate onto the journal entry lines.
        :type property_keys: List[str]
        :param nav_type_code: May be provided to view a specific NAV type. When not provided, Primary NAV will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ValuationPointResourceListOfTrialBalance, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'valuation_point_data_query_parameters',
            'general_ledger_profile_code',
            'as_at',
            'filter',
            'limit',
            'page',
            'property_keys',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_valuation_point_trial_balance" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('general_ledger_profile_code') is not None:  # noqa: E501
            _query_params.append(('generalLedgerProfileCode', _params['general_ledger_profile_code']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['valuation_point_data_query_parameters'] is not None:
            _body_params = _params['valuation_point_data_query_parameters']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ValuationPointResourceListOfTrialBalance",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/valuationpoints/trialbalance/$query', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_fees(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Fees. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fees. Defaults to returning the latest version of each Fee if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing fees; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the treatment, specify \"treatment eq 'Monthly'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fee' domain to decorate onto each Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'.")] = None, **kwargs) -> PagedResourceListOfFee:  # noqa: E501
        ...

    @overload
    def list_fees(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Fees. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fees. Defaults to returning the latest version of each Fee if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing fees; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the treatment, specify \"treatment eq 'Monthly'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fee' domain to decorate onto each Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfFee:  # noqa: E501
        ...

    @validate_arguments
    def list_fees(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Fees. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fees. Defaults to returning the latest version of each Fee if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing fees; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the treatment, specify \"treatment eq 'Monthly'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fee' domain to decorate onto each Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfFee, Awaitable[PagedResourceListOfFee]]:  # noqa: E501
        """[EXPERIMENTAL] ListFees: List Fees for a specified Fund.  # noqa: E501

        List all the Fees matching a particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_fees(scope, code, effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the Fees. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Fees. Defaults to returning the latest version of each Fee if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing fees; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the treatment, specify \"treatment eq 'Monthly'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'Fee' domain to decorate onto each Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfFee
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_fees_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_fees_with_http_info(scope, code, effective_at, as_at, page, limit, filter, sort_by, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_fees_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Fees. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Fees. Defaults to returning the latest version of each Fee if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing fees; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the treatment, specify \"treatment eq 'Monthly'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fee' domain to decorate onto each Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListFees: List Fees for a specified Fund.  # noqa: E501

        List all the Fees matching a particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_fees_with_http_info(scope, code, effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the Fees. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Fees. Defaults to returning the latest version of each Fee if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing fees; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the treatment, specify \"treatment eq 'Monthly'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'Fee' domain to decorate onto each Fee.             These must take the format {domain}/{scope}/{code}, for example 'Fee/Account/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfFee, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_fees" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfFee",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/fees', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_fund_calendar(self, scope : Annotated[StrictStr, Field(..., description="The Scope for the Fund.")], code : Annotated[StrictStr, Field(..., description="The Code for the Fund.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Calendar. Defaults to returning the latest version of each Calendar Entry if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Valuation Points; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the DisplayName, specify \"displayName eq 'VP 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, **kwargs) -> PagedResourceListOfFundCalendarEntry:  # noqa: E501
        ...

    @overload
    def list_fund_calendar(self, scope : Annotated[StrictStr, Field(..., description="The Scope for the Fund.")], code : Annotated[StrictStr, Field(..., description="The Code for the Fund.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Calendar. Defaults to returning the latest version of each Calendar Entry if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Valuation Points; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the DisplayName, specify \"displayName eq 'VP 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfFundCalendarEntry:  # noqa: E501
        ...

    @validate_arguments
    def list_fund_calendar(self, scope : Annotated[StrictStr, Field(..., description="The Scope for the Fund.")], code : Annotated[StrictStr, Field(..., description="The Code for the Fund.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Calendar. Defaults to returning the latest version of each Calendar Entry if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Valuation Points; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the DisplayName, specify \"displayName eq 'VP 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfFundCalendarEntry, Awaitable[PagedResourceListOfFundCalendarEntry]]:  # noqa: E501
        """[EXPERIMENTAL] ListFundCalendar: List Fund Calendar.  # noqa: E501

        List all the Calendar Entries associated with the Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_fund_calendar(scope, code, as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param scope: The Scope for the Fund. (required)
        :type scope: str
        :param code: The Code for the Fund. (required)
        :type code: str
        :param as_at: The asAt datetime at which to list the Calendar. Defaults to returning the latest version of each Calendar Entry if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Valuation Points; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the DisplayName, specify \"displayName eq 'VP 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfFundCalendarEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_fund_calendar_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_fund_calendar_with_http_info(scope, code, as_at, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_fund_calendar_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The Scope for the Fund.")], code : Annotated[StrictStr, Field(..., description="The Code for the Fund.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Calendar. Defaults to returning the latest version of each Calendar Entry if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Valuation Points; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the DisplayName, specify \"displayName eq 'VP 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListFundCalendar: List Fund Calendar.  # noqa: E501

        List all the Calendar Entries associated with the Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_fund_calendar_with_http_info(scope, code, as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param scope: The Scope for the Fund. (required)
        :type scope: str
        :param code: The Code for the Fund. (required)
        :type code: str
        :param as_at: The asAt datetime at which to list the Calendar. Defaults to returning the latest version of each Calendar Entry if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Valuation Points; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the DisplayName, specify \"displayName eq 'VP 1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfFundCalendarEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_fund_calendar" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfFundCalendarEntry",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/calendar', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_funds(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Funds. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Funds. Defaults to returning the latest version of each Fund if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Funds; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Fund type, specify \"id.Code eq 'Fund1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fund' domain to decorate onto each Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'.")] = None, **kwargs) -> PagedResourceListOfFund:  # noqa: E501
        ...

    @overload
    def list_funds(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Funds. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Funds. Defaults to returning the latest version of each Fund if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Funds; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Fund type, specify \"id.Code eq 'Fund1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fund' domain to decorate onto each Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfFund:  # noqa: E501
        ...

    @validate_arguments
    def list_funds(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Funds. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Funds. Defaults to returning the latest version of each Fund if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Funds; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Fund type, specify \"id.Code eq 'Fund1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fund' domain to decorate onto each Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfFund, Awaitable[PagedResourceListOfFund]]:  # noqa: E501
        """[EXPERIMENTAL] ListFunds: List Funds.  # noqa: E501

        List all the Funds matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_funds(effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the Funds. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Funds. Defaults to returning the latest version of each Fund if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Funds; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Fund type, specify \"id.Code eq 'Fund1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'Fund' domain to decorate onto each Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfFund
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_funds_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_funds_with_http_info(effective_at, as_at, page, limit, filter, sort_by, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_funds_with_http_info(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the Funds. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the Funds. Defaults to returning the latest version of each Fund if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Funds; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the Fund type, specify \"id.Code eq 'Fund1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Fund' domain to decorate onto each Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListFunds: List Funds.  # noqa: E501

        List all the Funds matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_funds_with_http_info(effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the Funds. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the Funds. Defaults to returning the latest version of each Fund if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Funds; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the Fund type, specify \"id.Code eq 'Fund1'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'Fund' domain to decorate onto each Fund.             These must take the format {domain}/{scope}/{code}, for example 'Fund/Manager/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfFund, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_funds" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfFund",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_valuation_point_overview(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the ValuationPoints. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ValuationPoints. Defaults to returning the latest version of each ValuationPoint if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ValuationPoints; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.             For example, to filter on the NAV, specify \"NAV gt 300\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'DiaryEntry' domain to decorate onto each ValuationPoint.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/ValuationPoint/Id'.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, **kwargs) -> PagedResourceListOfValuationPointOverview:  # noqa: E501
        ...

    @overload
    def list_valuation_point_overview(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the ValuationPoints. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ValuationPoints. Defaults to returning the latest version of each ValuationPoint if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ValuationPoints; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.             For example, to filter on the NAV, specify \"NAV gt 300\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'DiaryEntry' domain to decorate onto each ValuationPoint.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/ValuationPoint/Id'.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfValuationPointOverview:  # noqa: E501
        ...

    @validate_arguments
    def list_valuation_point_overview(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the ValuationPoints. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ValuationPoints. Defaults to returning the latest version of each ValuationPoint if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ValuationPoints; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.             For example, to filter on the NAV, specify \"NAV gt 300\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'DiaryEntry' domain to decorate onto each ValuationPoint.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/ValuationPoint/Id'.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfValuationPointOverview, Awaitable[PagedResourceListOfValuationPointOverview]]:  # noqa: E501
        """[EXPERIMENTAL] ListValuationPointOverview: List Valuation Points Overview for a given Fund.  # noqa: E501

        List all the Valuation Points that match the given criteria for a given Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_valuation_point_overview(scope, code, effective_at, as_at, page, limit, filter, property_keys, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the ValuationPoints. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the ValuationPoints. Defaults to returning the latest version of each ValuationPoint if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing ValuationPoints; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results by.             For example, to filter on the NAV, specify \"NAV gt 300\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param property_keys: A list of property keys from the 'DiaryEntry' domain to decorate onto each ValuationPoint.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/ValuationPoint/Id'.
        :type property_keys: List[str]
        :param nav_type_code: May be provided to view a specific NAV type. When not provided, Primary NAV will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfValuationPointOverview
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_valuation_point_overview_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_valuation_point_overview_with_http_info(scope, code, effective_at, as_at, page, limit, filter, property_keys, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def list_valuation_point_overview_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the ValuationPoints. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the ValuationPoints. Defaults to returning the latest version of each ValuationPoint if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing ValuationPoints; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results by.             For example, to filter on the NAV, specify \"NAV gt 300\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'DiaryEntry' domain to decorate onto each ValuationPoint.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/ValuationPoint/Id'.")] = None, nav_type_code : Annotated[Optional[StrictStr], Field( description="May be provided to view a specific NAV type. When not provided, Primary NAV will be used.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListValuationPointOverview: List Valuation Points Overview for a given Fund.  # noqa: E501

        List all the Valuation Points that match the given criteria for a given Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_valuation_point_overview_with_http_info(scope, code, effective_at, as_at, page, limit, filter, property_keys, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the ValuationPoints. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the ValuationPoints. Defaults to returning the latest version of each ValuationPoint if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing ValuationPoints; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results by.             For example, to filter on the NAV, specify \"NAV gt 300\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param property_keys: A list of property keys from the 'DiaryEntry' domain to decorate onto each ValuationPoint.             These must take the format {domain}/{scope}/{code}, for example 'DiaryEntry/ValuationPoint/Id'.
        :type property_keys: List[str]
        :param nav_type_code: May be provided to view a specific NAV type. When not provided, Primary NAV will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfValuationPointOverview, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'property_keys',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_valuation_point_overview" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfValuationPointOverview",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/valuationPointOverview', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def patch_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> Fee:  # noqa: E501
        ...

    @overload
    def patch_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=True, **kwargs) -> Fee:  # noqa: E501
        ...

    @validate_arguments
    def patch_fee(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=None, **kwargs) -> Union[Fee, Awaitable[Fee]]:  # noqa: E501
        """[EXPERIMENTAL] PatchFee: Patch Fee.  # noqa: E501

        Create or update certain fields for a particular Fee.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: EndDate, ShareClasses.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_fee(scope, code, fee_code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_code: The code of the Fee. (required)
        :type fee_code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Fee
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the patch_fee_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.patch_fee_with_http_info(scope, code, fee_code, operation, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_fee_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PatchFee: Patch Fee.  # noqa: E501

        Create or update certain fields for a particular Fee.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: EndDate, ShareClasses.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_fee_with_http_info(scope, code, fee_code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_code: The code of the Fee. (required)
        :type fee_code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Fee, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'fee_code',
            'operation'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_fee" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['fee_code']:
            _path_params['feeCode'] = _params['fee_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['operation'] is not None:
            _body_params = _params['operation']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Fee",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/fees/{feeCode}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def patch_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> Fund:  # noqa: E501
        ...

    @overload
    def patch_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=True, **kwargs) -> Fund:  # noqa: E501
        ...

    @validate_arguments
    def patch_fund(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], async_req: Optional[bool]=None, **kwargs) -> Union[Fund, Awaitable[Fund]]:  # noqa: E501
        """[EXPERIMENTAL] PatchFund: Patch a Fund.  # noqa: E501

        Update fields on a Fund.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: DisplayName, Description, PortfolioIds, FundConfigurationId, ShareClassInstruments, Type, InceptionDate, DecimalPlaces, PrimaryNavType, AdditionalNavTypes, AborId, YearEndDate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_fund(scope, code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Fund
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the patch_fund_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.patch_fund_with_http_info(scope, code, operation, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_fund_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], operation : Annotated[conlist(Operation), Field(..., description="The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] PatchFund: Patch a Fund.  # noqa: E501

        Update fields on a Fund.  The behaviour is defined by the JSON Patch specification.    Currently supported fields are: DisplayName, Description, PortfolioIds, FundConfigurationId, ShareClassInstruments, Type, InceptionDate, DecimalPlaces, PrimaryNavType, AdditionalNavTypes, AborId, YearEndDate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_fund_with_http_info(scope, code, operation, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param operation: The json patch document. For more information see: https://datatracker.ietf.org/doc/html/rfc6902. (required)
        :type operation: List[Operation]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Fund, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'operation'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_fund" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['operation'] is not None:
            _body_params = _params['operation']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Fund",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def set_share_class_instruments(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], set_share_class_instruments_request : Annotated[SetShareClassInstrumentsRequest, Field(..., description="The scopes and instrument identifiers for the instruments to be set.")], **kwargs) -> Fund:  # noqa: E501
        ...

    @overload
    def set_share_class_instruments(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], set_share_class_instruments_request : Annotated[SetShareClassInstrumentsRequest, Field(..., description="The scopes and instrument identifiers for the instruments to be set.")], async_req: Optional[bool]=True, **kwargs) -> Fund:  # noqa: E501
        ...

    @validate_arguments
    def set_share_class_instruments(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], set_share_class_instruments_request : Annotated[SetShareClassInstrumentsRequest, Field(..., description="The scopes and instrument identifiers for the instruments to be set.")], async_req: Optional[bool]=None, **kwargs) -> Union[Fund, Awaitable[Fund]]:  # noqa: E501
        """[EXPERIMENTAL] SetShareClassInstruments: Set the ShareClass Instruments on a fund.  # noqa: E501

        Update the ShareClass Instruments on an existing fund with the set of instruments provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_share_class_instruments(scope, code, set_share_class_instruments_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. (required)
        :type code: str
        :param set_share_class_instruments_request: The scopes and instrument identifiers for the instruments to be set. (required)
        :type set_share_class_instruments_request: SetShareClassInstrumentsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Fund
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the set_share_class_instruments_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.set_share_class_instruments_with_http_info(scope, code, set_share_class_instruments_request, **kwargs)  # noqa: E501

    @validate_arguments
    def set_share_class_instruments_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund.")], set_share_class_instruments_request : Annotated[SetShareClassInstrumentsRequest, Field(..., description="The scopes and instrument identifiers for the instruments to be set.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] SetShareClassInstruments: Set the ShareClass Instruments on a fund.  # noqa: E501

        Update the ShareClass Instruments on an existing fund with the set of instruments provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_share_class_instruments_with_http_info(scope, code, set_share_class_instruments_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. (required)
        :type code: str
        :param set_share_class_instruments_request: The scopes and instrument identifiers for the instruments to be set. (required)
        :type set_share_class_instruments_request: SetShareClassInstrumentsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Fund, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'set_share_class_instruments_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_share_class_instruments" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['set_share_class_instruments_request'] is not None:
            _body_params = _params['set_share_class_instruments_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Fund",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/shareclasses', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_bookmark(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], upsert_fund_bookmark_request : Annotated[UpsertFundBookmarkRequest, Field(..., description="The bookmark definition to Upsert")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Upserts the Valuation Point against the specified NAV Type. When not provided, the Primary NAV Type will be used.")] = None, **kwargs) -> FundCalendarEntry:  # noqa: E501
        ...

    @overload
    def upsert_bookmark(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], upsert_fund_bookmark_request : Annotated[UpsertFundBookmarkRequest, Field(..., description="The bookmark definition to Upsert")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Upserts the Valuation Point against the specified NAV Type. When not provided, the Primary NAV Type will be used.")] = None, async_req: Optional[bool]=True, **kwargs) -> FundCalendarEntry:  # noqa: E501
        ...

    @validate_arguments
    def upsert_bookmark(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], upsert_fund_bookmark_request : Annotated[UpsertFundBookmarkRequest, Field(..., description="The bookmark definition to Upsert")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Upserts the Valuation Point against the specified NAV Type. When not provided, the Primary NAV Type will be used.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[FundCalendarEntry, Awaitable[FundCalendarEntry]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertBookmark: Upsert a bookmark.  # noqa: E501

        This method will update or upsert a Bookmark for the Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_bookmark(scope, code, upsert_fund_bookmark_request, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param upsert_fund_bookmark_request: The bookmark definition to Upsert (required)
        :type upsert_fund_bookmark_request: UpsertFundBookmarkRequest
        :param nav_type_code: When provided, Upserts the Valuation Point against the specified NAV Type. When not provided, the Primary NAV Type will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FundCalendarEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_bookmark_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_bookmark_with_http_info(scope, code, upsert_fund_bookmark_request, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_bookmark_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], upsert_fund_bookmark_request : Annotated[UpsertFundBookmarkRequest, Field(..., description="The bookmark definition to Upsert")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Upserts the Valuation Point against the specified NAV Type. When not provided, the Primary NAV Type will be used.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertBookmark: Upsert a bookmark.  # noqa: E501

        This method will update or upsert a Bookmark for the Fund.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_bookmark_with_http_info(scope, code, upsert_fund_bookmark_request, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param upsert_fund_bookmark_request: The bookmark definition to Upsert (required)
        :type upsert_fund_bookmark_request: UpsertFundBookmarkRequest
        :param nav_type_code: When provided, Upserts the Valuation Point against the specified NAV Type. When not provided, the Primary NAV Type will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FundCalendarEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'upsert_fund_bookmark_request',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_bookmark" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_fund_bookmark_request'] is not None:
            _body_params = _params['upsert_fund_bookmark_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "FundCalendarEntry",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/bookmarks', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_diary_entry_type_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], upsert_valuation_point_request : Annotated[UpsertValuationPointRequest, Field(..., description="The Valuation Point Estimate definition to Upsert")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Upserts the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be used.")] = None, **kwargs) -> DiaryEntry:  # noqa: E501
        ...

    @overload
    def upsert_diary_entry_type_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], upsert_valuation_point_request : Annotated[UpsertValuationPointRequest, Field(..., description="The Valuation Point Estimate definition to Upsert")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Upserts the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be used.")] = None, async_req: Optional[bool]=True, **kwargs) -> DiaryEntry:  # noqa: E501
        ...

    @validate_arguments
    def upsert_diary_entry_type_valuation_point(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], upsert_valuation_point_request : Annotated[UpsertValuationPointRequest, Field(..., description="The Valuation Point Estimate definition to Upsert")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Upserts the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be used.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DiaryEntry, Awaitable[DiaryEntry]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertDiaryEntryTypeValuationPoint: Upsert Valuation Point.  # noqa: E501

        Update or insert the estimate Valuation Point.              If the Valuation Point does not exist, this method will create it in estimate state.              If the Valuation Point already exists and is in estimate state, the Valuation Point will be updated with the newly specified information in this request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_diary_entry_type_valuation_point(scope, code, upsert_valuation_point_request, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param upsert_valuation_point_request: The Valuation Point Estimate definition to Upsert (required)
        :type upsert_valuation_point_request: UpsertValuationPointRequest
        :param nav_type_code: When provided, Upserts the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DiaryEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_diary_entry_type_valuation_point_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_diary_entry_type_valuation_point_with_http_info(scope, code, upsert_valuation_point_request, nav_type_code, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_diary_entry_type_valuation_point_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], upsert_valuation_point_request : Annotated[UpsertValuationPointRequest, Field(..., description="The Valuation Point Estimate definition to Upsert")], nav_type_code : Annotated[Optional[StrictStr], Field( description="When provided, Upserts the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be used.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertDiaryEntryTypeValuationPoint: Upsert Valuation Point.  # noqa: E501

        Update or insert the estimate Valuation Point.              If the Valuation Point does not exist, this method will create it in estimate state.              If the Valuation Point already exists and is in estimate state, the Valuation Point will be updated with the newly specified information in this request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_diary_entry_type_valuation_point_with_http_info(scope, code, upsert_valuation_point_request, nav_type_code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param upsert_valuation_point_request: The Valuation Point Estimate definition to Upsert (required)
        :type upsert_valuation_point_request: UpsertValuationPointRequest
        :param nav_type_code: When provided, Upserts the Valuation Point against the specified NAV Type. When not provided the Primary NAV Type will be used.
        :type nav_type_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DiaryEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'upsert_valuation_point_request',
            'nav_type_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_diary_entry_type_valuation_point" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('nav_type_code') is not None:  # noqa: E501
            _query_params.append(('navTypeCode', _params['nav_type_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_valuation_point_request'] is not None:
            _body_params = _params['upsert_valuation_point_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DiaryEntry",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/valuationpoints', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_fee_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to update or insert the properties onto.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fee. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fee/Manager/Id\".")] = None, **kwargs) -> FeeProperties:  # noqa: E501
        ...

    @overload
    def upsert_fee_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to update or insert the properties onto.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fee. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fee/Manager/Id\".")] = None, async_req: Optional[bool]=True, **kwargs) -> FeeProperties:  # noqa: E501
        ...

    @validate_arguments
    def upsert_fee_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to update or insert the properties onto.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fee. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fee/Manager/Id\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[FeeProperties, Awaitable[FeeProperties]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertFeeProperties: Upsert Fee properties.  # noqa: E501

        Update or insert one or more properties onto a single Fee. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'Fee'.              Upserting a property that exists for an Fee, with a null value, will delete the instance of the property for that group.     Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_fee_properties(scope, code, fee_code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_code: The code of the Fee to update or insert the properties onto. (required)
        :type fee_code: str
        :param request_body: The properties to be updated or inserted onto the Fee. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fee/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FeeProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_fee_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_fee_properties_with_http_info(scope, code, fee_code, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_fee_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund. Together with the scope this uniquely identifies the Fund.")], fee_code : Annotated[StrictStr, Field(..., description="The code of the Fee to update or insert the properties onto.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fee. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fee/Manager/Id\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertFeeProperties: Upsert Fee properties.  # noqa: E501

        Update or insert one or more properties onto a single Fee. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'Fee'.              Upserting a property that exists for an Fee, with a null value, will delete the instance of the property for that group.     Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_fee_properties_with_http_info(scope, code, fee_code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund. (required)
        :type scope: str
        :param code: The code of the Fund. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param fee_code: The code of the Fee to update or insert the properties onto. (required)
        :type fee_code: str
        :param request_body: The properties to be updated or inserted onto the Fee. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fee/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FeeProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'fee_code',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_fee_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['fee_code']:
            _path_params['feeCode'] = _params['fee_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "FeeProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/fees/{feeCode}/properties/$upsert', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_fund_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to update or insert the properties onto. Together with the scope this uniquely identifies the Fund.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fund. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fund/Manager/Id\".")] = None, **kwargs) -> FundProperties:  # noqa: E501
        ...

    @overload
    def upsert_fund_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to update or insert the properties onto. Together with the scope this uniquely identifies the Fund.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fund. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fund/Manager/Id\".")] = None, async_req: Optional[bool]=True, **kwargs) -> FundProperties:  # noqa: E501
        ...

    @validate_arguments
    def upsert_fund_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to update or insert the properties onto. Together with the scope this uniquely identifies the Fund.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fund. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fund/Manager/Id\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[FundProperties, Awaitable[FundProperties]]:  # noqa: E501
        """[EXPERIMENTAL] UpsertFundProperties: Upsert Fund properties.  # noqa: E501

        Update or insert one or more properties onto a single Fund. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'Fund'.              Upserting a property that exists for an Fund, with a null value, will delete the instance of the property for that group.              Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_fund_properties(scope, code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the Fund to update or insert the properties onto. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param request_body: The properties to be updated or inserted onto the Fund. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fund/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FundProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_fund_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_fund_properties_with_http_info(scope, code, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_fund_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Fund to update or insert the properties onto.")], code : Annotated[StrictStr, Field(..., description="The code of the Fund to update or insert the properties onto. Together with the scope this uniquely identifies the Fund.")], request_body : Annotated[Optional[Dict[str, ModelProperty]], Field(description="The properties to be updated or inserted onto the Fund. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fund/Manager/Id\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpsertFundProperties: Upsert Fund properties.  # noqa: E501

        Update or insert one or more properties onto a single Fund. A property will be updated if it already exists and inserted if it does not. All properties must be of the domain 'Fund'.              Upserting a property that exists for an Fund, with a null value, will delete the instance of the property for that group.              Properties have an <i>effectiveFrom</i> datetime for which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_fund_properties_with_http_info(scope, code, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Fund to update or insert the properties onto. (required)
        :type scope: str
        :param code: The code of the Fund to update or insert the properties onto. Together with the scope this uniquely identifies the Fund. (required)
        :type code: str
        :param request_body: The properties to be updated or inserted onto the Fund. Each property in              the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code} e.g. \"Fund/Manager/Id\".
        :type request_body: Dict[str, ModelProperty]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FundProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_fund_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "FundProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/funds/{scope}/{code}/properties/$upsert', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
