# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.create_identifier_definition_request import CreateIdentifierDefinitionRequest
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.identifier_definition import IdentifierDefinition
from lusid.models.paged_resource_list_of_identifier_definition import PagedResourceListOfIdentifierDefinition
from lusid.models.update_identifier_definition_request import UpdateIdentifierDefinitionRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class IdentifierDefinitionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_identifier_definition(self, create_identifier_definition_request : Annotated[Optional[CreateIdentifierDefinitionRequest], Field(description="The request defining the new definition")] = None, **kwargs) -> IdentifierDefinition:  # noqa: E501
        ...

    @overload
    def create_identifier_definition(self, create_identifier_definition_request : Annotated[Optional[CreateIdentifierDefinitionRequest], Field(description="The request defining the new definition")] = None, async_req: Optional[bool]=True, **kwargs) -> IdentifierDefinition:  # noqa: E501
        ...

    @validate_arguments
    def create_identifier_definition(self, create_identifier_definition_request : Annotated[Optional[CreateIdentifierDefinitionRequest], Field(description="The request defining the new definition")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[IdentifierDefinition, Awaitable[IdentifierDefinition]]:  # noqa: E501
        """[EXPERIMENTAL] CreateIdentifierDefinition: Create an Identifier Definition  # noqa: E501

        Define a new Identifier Definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_identifier_definition(create_identifier_definition_request, async_req=True)
        >>> result = thread.get()

        :param create_identifier_definition_request: The request defining the new definition
        :type create_identifier_definition_request: CreateIdentifierDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IdentifierDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_identifier_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_identifier_definition_with_http_info(create_identifier_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_identifier_definition_with_http_info(self, create_identifier_definition_request : Annotated[Optional[CreateIdentifierDefinitionRequest], Field(description="The request defining the new definition")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateIdentifierDefinition: Create an Identifier Definition  # noqa: E501

        Define a new Identifier Definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_identifier_definition_with_http_info(create_identifier_definition_request, async_req=True)
        >>> result = thread.get()

        :param create_identifier_definition_request: The request defining the new definition
        :type create_identifier_definition_request: CreateIdentifierDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IdentifierDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_identifier_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_identifier_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_identifier_definition_request'] is not None:
            _body_params = _params['create_identifier_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "IdentifierDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/identifierdefinitions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_identifier_definition(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_identifier_definition(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_identifier_definition(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteIdentifierDefinition: Delete a particular Identifier Definition  # noqa: E501

        The deletion will take effect from the Identifier Definition deletion datetime. i.e. will no longer exist at any asAt datetime after the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_identifier_definition(domain, identifier_scope, identifier_type, async_req=True)
        >>> result = thread.get()

        :param domain: The type of entity to which the identifier relates (required)
        :type domain: str
        :param identifier_scope: The scope that the identifier exists in (required)
        :type identifier_scope: str
        :param identifier_type: What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition (required)
        :type identifier_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_identifier_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_identifier_definition_with_http_info(domain, identifier_scope, identifier_type, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_identifier_definition_with_http_info(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteIdentifierDefinition: Delete a particular Identifier Definition  # noqa: E501

        The deletion will take effect from the Identifier Definition deletion datetime. i.e. will no longer exist at any asAt datetime after the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_identifier_definition_with_http_info(domain, identifier_scope, identifier_type, async_req=True)
        >>> result = thread.get()

        :param domain: The type of entity to which the identifier relates (required)
        :type domain: str
        :param identifier_scope: The scope that the identifier exists in (required)
        :type identifier_scope: str
        :param identifier_type: What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition (required)
        :type identifier_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'domain',
            'identifier_scope',
            'identifier_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_identifier_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['domain']:
            _path_params['domain'] = _params['domain']

        if _params['identifier_scope']:
            _path_params['identifierScope'] = _params['identifier_scope']

        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/identifierdefinitions/{domain}/{identifierScope}/{identifierType}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_identifier_definition(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates.")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Identifier Definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> IdentifierDefinition:  # noqa: E501
        ...

    @overload
    def get_identifier_definition(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates.")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Identifier Definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=True, **kwargs) -> IdentifierDefinition:  # noqa: E501
        ...

    @validate_arguments
    def get_identifier_definition(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates.")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Identifier Definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}. If no properties are specified, then no properties will be returned.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[IdentifierDefinition, Awaitable[IdentifierDefinition]]:  # noqa: E501
        """[EXPERIMENTAL] GetIdentifierDefinition: Get a single Identifier Definition  # noqa: E501

        Get a single Identifier Definition using domain, identifierScope, identifierType, and an optional asAt             - defaulting to latest if not specified  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_identifier_definition(domain, identifier_scope, identifier_type, as_at, effective_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param domain: The type of entity to which the identifier relates. (required)
        :type domain: str
        :param identifier_scope: The scope that the identifier exists in (required)
        :type identifier_scope: str
        :param identifier_type: What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition (required)
        :type identifier_type: str
        :param as_at: The asAt datetime at which to retrieve the Identifier Definition. Defaults to return             the latest version of the definition if not specified.
        :type as_at: datetime
        :param effective_at: The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.
        :type effective_at: str
        :param property_keys: A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IdentifierDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_identifier_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_identifier_definition_with_http_info(domain, identifier_scope, identifier_type, as_at, effective_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_identifier_definition_with_http_info(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates.")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Identifier Definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}. If no properties are specified, then no properties will be returned.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetIdentifierDefinition: Get a single Identifier Definition  # noqa: E501

        Get a single Identifier Definition using domain, identifierScope, identifierType, and an optional asAt             - defaulting to latest if not specified  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_identifier_definition_with_http_info(domain, identifier_scope, identifier_type, as_at, effective_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param domain: The type of entity to which the identifier relates. (required)
        :type domain: str
        :param identifier_scope: The scope that the identifier exists in (required)
        :type identifier_scope: str
        :param identifier_type: What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the identifier definition (required)
        :type identifier_type: str
        :param as_at: The asAt datetime at which to retrieve the Identifier Definition. Defaults to return             the latest version of the definition if not specified.
        :type as_at: datetime
        :param effective_at: The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.
        :type effective_at: str
        :param property_keys: A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}. If no properties are specified, then no properties will be returned.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IdentifierDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'domain',
            'identifier_scope',
            'identifier_type',
            'as_at',
            'effective_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_identifier_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['domain']:
            _path_params['domain'] = _params['domain']

        if _params['identifier_scope']:
            _path_params['identifierScope'] = _params['identifier_scope']

        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "IdentifierDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/identifierdefinitions/{domain}/{identifierScope}/{identifierType}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_identifier_definitions(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Identifier Definitions. Defaults to return the latest             version of the Identifier Definitions if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Identifier Definitions from a previous call to list             Identifier Definitions. This value is returned from the previous call. If a pagination token is provided the sortBy,             filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many per page.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}.")] = None, **kwargs) -> PagedResourceListOfIdentifierDefinition:  # noqa: E501
        ...

    @overload
    def list_identifier_definitions(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Identifier Definitions. Defaults to return the latest             version of the Identifier Definitions if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Identifier Definitions from a previous call to list             Identifier Definitions. This value is returned from the previous call. If a pagination token is provided the sortBy,             filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many per page.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfIdentifierDefinition:  # noqa: E501
        ...

    @validate_arguments
    def list_identifier_definitions(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Identifier Definitions. Defaults to return the latest             version of the Identifier Definitions if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Identifier Definitions from a previous call to list             Identifier Definitions. This value is returned from the previous call. If a pagination token is provided the sortBy,             filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many per page.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfIdentifierDefinition, Awaitable[PagedResourceListOfIdentifierDefinition]]:  # noqa: E501
        """[EXPERIMENTAL] ListIdentifierDefinitions: List Identifier Definitions  # noqa: E501

        Retrieves all Identifier Definitions that fit the filter, in a specific order if sortBy is provided Supports pagination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_identifier_definitions(effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Identifier Definitions. Defaults to return the latest             version of the Identifier Definitions if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Identifier Definitions from a previous call to list             Identifier Definitions. This value is returned from the previous call. If a pagination token is provided the sortBy,             filter, effectiveAt, and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many per page.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfIdentifierDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_identifier_definitions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_identifier_definitions_with_http_info(effective_at, as_at, page, limit, filter, sort_by, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_identifier_definitions_with_http_info(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the Identifier Definitions. Defaults to return the latest             version of the Identifier Definitions if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing Identifier Definitions from a previous call to list             Identifier Definitions. This value is returned from the previous call. If a pagination token is provided the sortBy,             filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many per page.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListIdentifierDefinitions: List Identifier Definitions  # noqa: E501

        Retrieves all Identifier Definitions that fit the filter, in a specific order if sortBy is provided Supports pagination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_identifier_definitions_with_http_info(effective_at, as_at, page, limit, filter, sort_by, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effectiveAt datetime at which to retrieve the Identifier Definitions.             Since Identifier Definitions exist for all effective time, this will only apply to properties (if requested)             on the Identifier Definition.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Identifier Definitions. Defaults to return the latest             version of the Identifier Definitions if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing Identifier Definitions from a previous call to list             Identifier Definitions. This value is returned from the previous call. If a pagination token is provided the sortBy,             filter, effectiveAt, and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many per page.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: A list of field names to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param property_keys: A list of property keys from the 'IdentifierDefinition' domain to decorate onto the Identifier Definition.             These must take the format {domain}/{scope}/{code}.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfIdentifierDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_identifier_definitions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfIdentifierDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/identifierdefinitions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_identifier_definition(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the Identifier Definition")], update_identifier_definition_request : Annotated[Optional[UpdateIdentifierDefinitionRequest], Field(description="The request containing the updated details of the Identifier Definition.")] = None, **kwargs) -> IdentifierDefinition:  # noqa: E501
        ...

    @overload
    def update_identifier_definition(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the Identifier Definition")], update_identifier_definition_request : Annotated[Optional[UpdateIdentifierDefinitionRequest], Field(description="The request containing the updated details of the Identifier Definition.")] = None, async_req: Optional[bool]=True, **kwargs) -> IdentifierDefinition:  # noqa: E501
        ...

    @validate_arguments
    def update_identifier_definition(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the Identifier Definition")], update_identifier_definition_request : Annotated[Optional[UpdateIdentifierDefinitionRequest], Field(description="The request containing the updated details of the Identifier Definition.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[IdentifierDefinition, Awaitable[IdentifierDefinition]]:  # noqa: E501
        """[EXPERIMENTAL] UpdateIdentifierDefinition: Update Identifier Definition defined by domain, identifierScope, and identifierType  # noqa: E501

        Overwrites an existing Identifier Definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_identifier_definition(domain, identifier_scope, identifier_type, update_identifier_definition_request, async_req=True)
        >>> result = thread.get()

        :param domain: The type of entity to which the identifier relates (required)
        :type domain: str
        :param identifier_scope: The scope that the identifier exists in (required)
        :type identifier_scope: str
        :param identifier_type: What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the Identifier Definition (required)
        :type identifier_type: str
        :param update_identifier_definition_request: The request containing the updated details of the Identifier Definition.
        :type update_identifier_definition_request: UpdateIdentifierDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IdentifierDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_identifier_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_identifier_definition_with_http_info(domain, identifier_scope, identifier_type, update_identifier_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_identifier_definition_with_http_info(self, domain : Annotated[StrictStr, Field(..., description="The type of entity to which the identifier relates")], identifier_scope : Annotated[StrictStr, Field(..., description="The scope that the identifier exists in")], identifier_type : Annotated[StrictStr, Field(..., description="What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the Identifier Definition")], update_identifier_definition_request : Annotated[Optional[UpdateIdentifierDefinitionRequest], Field(description="The request containing the updated details of the Identifier Definition.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpdateIdentifierDefinition: Update Identifier Definition defined by domain, identifierScope, and identifierType  # noqa: E501

        Overwrites an existing Identifier Definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_identifier_definition_with_http_info(domain, identifier_scope, identifier_type, update_identifier_definition_request, async_req=True)
        >>> result = thread.get()

        :param domain: The type of entity to which the identifier relates (required)
        :type domain: str
        :param identifier_scope: The scope that the identifier exists in (required)
        :type identifier_scope: str
        :param identifier_type: What the identifier represents. Together with \"domain\" and \"identifierScope\" this uniquely identifies the Identifier Definition (required)
        :type identifier_type: str
        :param update_identifier_definition_request: The request containing the updated details of the Identifier Definition.
        :type update_identifier_definition_request: UpdateIdentifierDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IdentifierDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'domain',
            'identifier_scope',
            'identifier_type',
            'update_identifier_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_identifier_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['domain']:
            _path_params['domain'] = _params['domain']

        if _params['identifier_scope']:
            _path_params['identifierScope'] = _params['identifier_scope']

        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_identifier_definition_request'] is not None:
            _body_params = _params['update_identifier_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "IdentifierDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/identifierdefinitions/{domain}/{identifierScope}/{identifierType}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
