# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Dict, List, Optional

from lusid.models.add_business_days_to_date_response import AddBusinessDaysToDateResponse
from lusid.models.batch_upsert_instrument_properties_response import BatchUpsertInstrumentPropertiesResponse
from lusid.models.delete_instrument_properties_response import DeleteInstrumentPropertiesResponse
from lusid.models.delete_instrument_response import DeleteInstrumentResponse
from lusid.models.delete_instruments_response import DeleteInstrumentsResponse
from lusid.models.get_instruments_response import GetInstrumentsResponse
from lusid.models.instrument import Instrument
from lusid.models.instrument_capabilities import InstrumentCapabilities
from lusid.models.instrument_definition import InstrumentDefinition
from lusid.models.instrument_models import InstrumentModels
from lusid.models.instrument_payment_diary import InstrumentPaymentDiary
from lusid.models.instrument_properties import InstrumentProperties
from lusid.models.lusid_instrument import LusidInstrument
from lusid.models.paged_resource_list_of_instrument import PagedResourceListOfInstrument
from lusid.models.resource_list_of_instrument_id_type_descriptor import ResourceListOfInstrumentIdTypeDescriptor
from lusid.models.resource_list_of_property import ResourceListOfProperty
from lusid.models.resource_list_of_property_interval import ResourceListOfPropertyInterval
from lusid.models.resource_list_of_relationship import ResourceListOfRelationship
from lusid.models.update_instrument_identifier_request import UpdateInstrumentIdentifierRequest
from lusid.models.upsert_instrument_properties_response import UpsertInstrumentPropertiesResponse
from lusid.models.upsert_instrument_property_request import UpsertInstrumentPropertyRequest
from lusid.models.upsert_instruments_response import UpsertInstrumentsResponse

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class InstrumentsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def batch_upsert_instrument_properties(self, request_body : Annotated[Dict[str, UpsertInstrumentPropertyRequest], Field(..., description="A list of instruments and associated instrument properties to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, identifier_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime used to resolve each instrument from the provided identifiers. Defaults to the current LUSID system datetime if not specified.")] = None, success_mode : Annotated[Optional[StrictStr], Field( description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> BatchUpsertInstrumentPropertiesResponse:  # noqa: E501
        ...

    @overload
    def batch_upsert_instrument_properties(self, request_body : Annotated[Dict[str, UpsertInstrumentPropertyRequest], Field(..., description="A list of instruments and associated instrument properties to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, identifier_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime used to resolve each instrument from the provided identifiers. Defaults to the current LUSID system datetime if not specified.")] = None, success_mode : Annotated[Optional[StrictStr], Field( description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=True, **kwargs) -> BatchUpsertInstrumentPropertiesResponse:  # noqa: E501
        ...

    @validate_arguments
    def batch_upsert_instrument_properties(self, request_body : Annotated[Dict[str, UpsertInstrumentPropertyRequest], Field(..., description="A list of instruments and associated instrument properties to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, identifier_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime used to resolve each instrument from the provided identifiers. Defaults to the current LUSID system datetime if not specified.")] = None, success_mode : Annotated[Optional[StrictStr], Field( description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[BatchUpsertInstrumentPropertiesResponse, Awaitable[BatchUpsertInstrumentPropertiesResponse]]:  # noqa: E501
        """BatchUpsertInstrumentProperties: Batch upsert instruments properties  # noqa: E501

        Create or update one or more properties for particular instruments.  Each instrument property is updated if it exists and created if it does not. For any failures, a reason is provided.  Properties have an <i>effectiveFrom</i> datetime from which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_upsert_instrument_properties(request_body, scope, identifier_effective_at, success_mode, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param request_body: A list of instruments and associated instrument properties to create or update. (required)
        :type request_body: Dict[str, UpsertInstrumentPropertyRequest]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param identifier_effective_at: The effective datetime used to resolve each instrument from the provided identifiers. Defaults to the current LUSID system datetime if not specified.
        :type identifier_effective_at: str
        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.
        :type success_mode: str
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BatchUpsertInstrumentPropertiesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the batch_upsert_instrument_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.batch_upsert_instrument_properties_with_http_info(request_body, scope, identifier_effective_at, success_mode, data_model_scope, data_model_code, **kwargs)  # noqa: E501

    @validate_arguments
    def batch_upsert_instrument_properties_with_http_info(self, request_body : Annotated[Dict[str, UpsertInstrumentPropertyRequest], Field(..., description="A list of instruments and associated instrument properties to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, identifier_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime used to resolve each instrument from the provided identifiers. Defaults to the current LUSID system datetime if not specified.")] = None, success_mode : Annotated[Optional[StrictStr], Field( description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """BatchUpsertInstrumentProperties: Batch upsert instruments properties  # noqa: E501

        Create or update one or more properties for particular instruments.  Each instrument property is updated if it exists and created if it does not. For any failures, a reason is provided.  Properties have an <i>effectiveFrom</i> datetime from which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.batch_upsert_instrument_properties_with_http_info(request_body, scope, identifier_effective_at, success_mode, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param request_body: A list of instruments and associated instrument properties to create or update. (required)
        :type request_body: Dict[str, UpsertInstrumentPropertyRequest]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param identifier_effective_at: The effective datetime used to resolve each instrument from the provided identifiers. Defaults to the current LUSID system datetime if not specified.
        :type identifier_effective_at: str
        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.
        :type success_mode: str
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BatchUpsertInstrumentPropertiesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'request_body',
            'scope',
            'identifier_effective_at',
            'success_mode',
            'data_model_scope',
            'data_model_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_upsert_instrument_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('identifier_effective_at') is not None:  # noqa: E501
            _query_params.append(('identifierEffectiveAt', _params['identifier_effective_at']))

        if _params.get('success_mode') is not None:  # noqa: E501
            _query_params.append(('successMode', _params['success_mode']))

        if _params.get('data_model_scope') is not None:  # noqa: E501
            _query_params.append(('dataModelScope', _params['data_model_scope']))

        if _params.get('data_model_code') is not None:  # noqa: E501
            _query_params.append(('dataModelCode', _params['data_model_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "BatchUpsertInstrumentPropertiesResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/$batchupsertproperties', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def calculate_settlement_date(self, identifier_type : Annotated[StrictStr, Field(..., description="An identifier type attached to the Instrument.")], identifier : Annotated[StrictStr, Field(..., description="The identifier value.")], transaction_date : Annotated[Optional[StrictStr], Field( description="The transaction date to calculate the settlement date from. This can be a UTC datetime offset or a cut label.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the related instrument and calendars for calculation. Defaults to             returning the latest version if not specified.")] = None, **kwargs) -> AddBusinessDaysToDateResponse:  # noqa: E501
        ...

    @overload
    def calculate_settlement_date(self, identifier_type : Annotated[StrictStr, Field(..., description="An identifier type attached to the Instrument.")], identifier : Annotated[StrictStr, Field(..., description="The identifier value.")], transaction_date : Annotated[Optional[StrictStr], Field( description="The transaction date to calculate the settlement date from. This can be a UTC datetime offset or a cut label.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the related instrument and calendars for calculation. Defaults to             returning the latest version if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> AddBusinessDaysToDateResponse:  # noqa: E501
        ...

    @validate_arguments
    def calculate_settlement_date(self, identifier_type : Annotated[StrictStr, Field(..., description="An identifier type attached to the Instrument.")], identifier : Annotated[StrictStr, Field(..., description="The identifier value.")], transaction_date : Annotated[Optional[StrictStr], Field( description="The transaction date to calculate the settlement date from. This can be a UTC datetime offset or a cut label.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the related instrument and calendars for calculation. Defaults to             returning the latest version if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[AddBusinessDaysToDateResponse, Awaitable[AddBusinessDaysToDateResponse]]:  # noqa: E501
        """CalculateSettlementDate: Get the settlement date for an instrument.  # noqa: E501

        Get the settlement date for a given trade date and instrument. The calculated settlement date will be in UTC. If a cut label transaction date is provided, the settlement date will be calculated relative to the absolute UTC datetime.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.calculate_settlement_date(identifier_type, identifier, transaction_date, scope, as_at, async_req=True)
        >>> result = thread.get()

        :param identifier_type: An identifier type attached to the Instrument. (required)
        :type identifier_type: str
        :param identifier: The identifier value. (required)
        :type identifier: str
        :param transaction_date: The transaction date to calculate the settlement date from. This can be a UTC datetime offset or a cut label.
        :type transaction_date: str
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param as_at: The asAt datetime at which to retrieve the related instrument and calendars for calculation. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddBusinessDaysToDateResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the calculate_settlement_date_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.calculate_settlement_date_with_http_info(identifier_type, identifier, transaction_date, scope, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def calculate_settlement_date_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="An identifier type attached to the Instrument.")], identifier : Annotated[StrictStr, Field(..., description="The identifier value.")], transaction_date : Annotated[Optional[StrictStr], Field( description="The transaction date to calculate the settlement date from. This can be a UTC datetime offset or a cut label.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the related instrument and calendars for calculation. Defaults to             returning the latest version if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """CalculateSettlementDate: Get the settlement date for an instrument.  # noqa: E501

        Get the settlement date for a given trade date and instrument. The calculated settlement date will be in UTC. If a cut label transaction date is provided, the settlement date will be calculated relative to the absolute UTC datetime.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.calculate_settlement_date_with_http_info(identifier_type, identifier, transaction_date, scope, as_at, async_req=True)
        >>> result = thread.get()

        :param identifier_type: An identifier type attached to the Instrument. (required)
        :type identifier_type: str
        :param identifier: The identifier value. (required)
        :type identifier: str
        :param transaction_date: The transaction date to calculate the settlement date from. This can be a UTC datetime offset or a cut label.
        :type transaction_date: str
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param as_at: The asAt datetime at which to retrieve the related instrument and calendars for calculation. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddBusinessDaysToDateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'identifier',
            'transaction_date',
            'scope',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calculate_settlement_date" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']

        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('transaction_date') is not None:  # noqa: E501
            _query_params.append(('transactionDate', _params['transaction_date']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AddBusinessDaysToDateResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/settlementdate', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_instrument(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> DeleteInstrumentResponse:  # noqa: E501
        ...

    @overload
    def delete_instrument(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> DeleteInstrumentResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_instrument(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeleteInstrumentResponse, Awaitable[DeleteInstrumentResponse]]:  # noqa: E501
        """DeleteInstrument: Soft delete a single instrument  # noqa: E501

        Soft delete a particular instrument, as identified by a particular instrument identifier.              Once deleted, an instrument is marked as inactive and can no longer be referenced when creating or updating transactions or holdings. You can still query existing transactions and holdings related to the deleted instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instrument(identifier_type, identifier, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeleteInstrumentResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_instrument_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_instrument_with_http_info(identifier_type, identifier, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_instrument_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteInstrument: Soft delete a single instrument  # noqa: E501

        Soft delete a particular instrument, as identified by a particular instrument identifier.              Once deleted, an instrument is marked as inactive and can no longer be referenced when creating or updating transactions or holdings. You can still query existing transactions and holdings related to the deleted instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instrument_with_http_info(identifier_type, identifier, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeleteInstrumentResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'identifier',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instrument" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']

        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeleteInstrumentResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_instrument_properties(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], request_body : Annotated[conlist(StrictStr), Field(..., description="A list of property keys from the 'Instruments' domain whose properties to delete.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is             before the time-variant property exists then a failure is returned. Do not specify this parameter if any of             the properties to delete are perpetual.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> DeleteInstrumentPropertiesResponse:  # noqa: E501
        ...

    @overload
    def delete_instrument_properties(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], request_body : Annotated[conlist(StrictStr), Field(..., description="A list of property keys from the 'Instruments' domain whose properties to delete.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is             before the time-variant property exists then a failure is returned. Do not specify this parameter if any of             the properties to delete are perpetual.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=True, **kwargs) -> DeleteInstrumentPropertiesResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_instrument_properties(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], request_body : Annotated[conlist(StrictStr), Field(..., description="A list of property keys from the 'Instruments' domain whose properties to delete.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is             before the time-variant property exists then a failure is returned. Do not specify this parameter if any of             the properties to delete are perpetual.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeleteInstrumentPropertiesResponse, Awaitable[DeleteInstrumentPropertiesResponse]]:  # noqa: E501
        """DeleteInstrumentProperties: Delete instrument properties  # noqa: E501

        Delete one or more properties from a particular instrument. If the properties are time-variant then an effective datetime from which to delete properties must be specified. If the properties are perpetual then it is invalid to specify an effective datetime for deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instrument_properties(identifier_type, identifier, request_body, effective_at, scope, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param request_body: A list of property keys from the 'Instruments' domain whose properties to delete. (required)
        :type request_body: List[str]
        :param effective_at: The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is             before the time-variant property exists then a failure is returned. Do not specify this parameter if any of             the properties to delete are perpetual.
        :type effective_at: str
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeleteInstrumentPropertiesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_instrument_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_instrument_properties_with_http_info(identifier_type, identifier, request_body, effective_at, scope, data_model_scope, data_model_code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_instrument_properties_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], request_body : Annotated[conlist(StrictStr), Field(..., description="A list of property keys from the 'Instruments' domain whose properties to delete.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is             before the time-variant property exists then a failure is returned. Do not specify this parameter if any of             the properties to delete are perpetual.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteInstrumentProperties: Delete instrument properties  # noqa: E501

        Delete one or more properties from a particular instrument. If the properties are time-variant then an effective datetime from which to delete properties must be specified. If the properties are perpetual then it is invalid to specify an effective datetime for deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instrument_properties_with_http_info(identifier_type, identifier, request_body, effective_at, scope, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param request_body: A list of property keys from the 'Instruments' domain whose properties to delete. (required)
        :type request_body: List[str]
        :param effective_at: The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is             before the time-variant property exists then a failure is returned. Do not specify this parameter if any of             the properties to delete are perpetual.
        :type effective_at: str
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeleteInstrumentPropertiesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'identifier',
            'request_body',
            'effective_at',
            'scope',
            'data_model_scope',
            'data_model_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instrument_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']

        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('data_model_scope') is not None:  # noqa: E501
            _query_params.append(('dataModelScope', _params['data_model_scope']))

        if _params.get('data_model_code') is not None:  # noqa: E501
            _query_params.append(('dataModelCode', _params['data_model_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeleteInstrumentPropertiesResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/properties/$delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_instruments(self, request_body : Annotated[conlist(StrictStr), Field(..., description="The list of lusidInstrumentId's to delete.")], delete_mode : Annotated[Optional[StrictStr], Field( description="The delete mode to use (defaults to 'Soft').")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instruments lie. When not supplied the scope is 'default'.")] = None, **kwargs) -> DeleteInstrumentsResponse:  # noqa: E501
        ...

    @overload
    def delete_instruments(self, request_body : Annotated[conlist(StrictStr), Field(..., description="The list of lusidInstrumentId's to delete.")], delete_mode : Annotated[Optional[StrictStr], Field( description="The delete mode to use (defaults to 'Soft').")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instruments lie. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> DeleteInstrumentsResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_instruments(self, request_body : Annotated[conlist(StrictStr), Field(..., description="The list of lusidInstrumentId's to delete.")], delete_mode : Annotated[Optional[StrictStr], Field( description="The delete mode to use (defaults to 'Soft').")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instruments lie. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeleteInstrumentsResponse, Awaitable[DeleteInstrumentsResponse]]:  # noqa: E501
        """DeleteInstruments: Soft or hard delete multiple instruments  # noqa: E501

        Deletes a number of instruments identified by LusidInstrumentId.              Soft deletion marks the instrument as inactive so it can no longer be referenced when creating or updating transactions or holdings. You can still query existing transactions and holdings related to the inactive instrument.              In addition to the above behaviour, hard deletion: (i) completely removes all external identifiers from the instrument; (ii) marks the instrument as 'Deleted'; (iii) prepends the instrument's name with 'DELETED '; (iv) prevents the instrument from being returned in list instruments queries.              Following hard deletion, an instrument may only be retrieved by making a direct get instrument request for the LusidInstrumentId. Instrument deletion cannot be undone. Please note that currency instruments cannot currently be deleted.  The maximum number of instruments that this method can delete per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instruments(request_body, delete_mode, scope, async_req=True)
        >>> result = thread.get()

        :param request_body: The list of lusidInstrumentId's to delete. (required)
        :type request_body: List[str]
        :param delete_mode: The delete mode to use (defaults to 'Soft').
        :type delete_mode: str
        :param scope: The scope in which the instruments lie. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeleteInstrumentsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_instruments_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_instruments_with_http_info(request_body, delete_mode, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_instruments_with_http_info(self, request_body : Annotated[conlist(StrictStr), Field(..., description="The list of lusidInstrumentId's to delete.")], delete_mode : Annotated[Optional[StrictStr], Field( description="The delete mode to use (defaults to 'Soft').")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instruments lie. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteInstruments: Soft or hard delete multiple instruments  # noqa: E501

        Deletes a number of instruments identified by LusidInstrumentId.              Soft deletion marks the instrument as inactive so it can no longer be referenced when creating or updating transactions or holdings. You can still query existing transactions and holdings related to the inactive instrument.              In addition to the above behaviour, hard deletion: (i) completely removes all external identifiers from the instrument; (ii) marks the instrument as 'Deleted'; (iii) prepends the instrument's name with 'DELETED '; (iv) prevents the instrument from being returned in list instruments queries.              Following hard deletion, an instrument may only be retrieved by making a direct get instrument request for the LusidInstrumentId. Instrument deletion cannot be undone. Please note that currency instruments cannot currently be deleted.  The maximum number of instruments that this method can delete per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_instruments_with_http_info(request_body, delete_mode, scope, async_req=True)
        >>> result = thread.get()

        :param request_body: The list of lusidInstrumentId's to delete. (required)
        :type request_body: List[str]
        :param delete_mode: The delete mode to use (defaults to 'Soft').
        :type delete_mode: str
        :param scope: The scope in which the instruments lie. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeleteInstrumentsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'request_body',
            'delete_mode',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instruments" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delete_mode') is not None:  # noqa: E501
            _query_params.append(('deleteMode', _params['delete_mode']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeleteInstrumentsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/$delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_all_possible_features(self, instrument_type : Annotated[StrictStr, Field(..., description="A lusid instrument type e.g. Bond, FxOption.")], **kwargs) -> Dict[str, List[str]]:  # noqa: E501
        ...

    @overload
    def get_all_possible_features(self, instrument_type : Annotated[StrictStr, Field(..., description="A lusid instrument type e.g. Bond, FxOption.")], async_req: Optional[bool]=True, **kwargs) -> Dict[str, List[str]]:  # noqa: E501
        ...

    @validate_arguments
    def get_all_possible_features(self, instrument_type : Annotated[StrictStr, Field(..., description="A lusid instrument type e.g. Bond, FxOption.")], async_req: Optional[bool]=None, **kwargs) -> Union[Dict[str, List[str]], Awaitable[Dict[str, List[str]]]]:  # noqa: E501
        """GetAllPossibleFeatures: Provides list of all possible features for instrument type.  # noqa: E501

        Provides all possible instrument features an instrument of a given type can provide.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_possible_features(instrument_type, async_req=True)
        >>> result = thread.get()

        :param instrument_type: A lusid instrument type e.g. Bond, FxOption. (required)
        :type instrument_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, List[str]]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_all_possible_features_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_all_possible_features_with_http_info(instrument_type, **kwargs)  # noqa: E501

    @validate_arguments
    def get_all_possible_features_with_http_info(self, instrument_type : Annotated[StrictStr, Field(..., description="A lusid instrument type e.g. Bond, FxOption.")], **kwargs) -> ApiResponse:  # noqa: E501
        """GetAllPossibleFeatures: Provides list of all possible features for instrument type.  # noqa: E501

        Provides all possible instrument features an instrument of a given type can provide.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_possible_features_with_http_info(instrument_type, async_req=True)
        >>> result = thread.get()

        :param instrument_type: A lusid instrument type e.g. Bond, FxOption. (required)
        :type instrument_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, List[str]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'instrument_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_possible_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['instrument_type']:
            _path_params['instrumentType'] = _params['instrument_type']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, List[str]]",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{instrumentType}/allfeatures', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_existing_instrument_capabilities(self, identifier : Annotated[StrictStr, Field(..., description="A lusid instrument id identifying the instrument.")], model : Annotated[Optional[StrictStr], Field( description="A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, instrument_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, recipe_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the recipe lies. When not supplied the scope is 'default'.")] = None, recipe_code : Annotated[Optional[StrictStr], Field( description="A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.")] = None, **kwargs) -> InstrumentCapabilities:  # noqa: E501
        ...

    @overload
    def get_existing_instrument_capabilities(self, identifier : Annotated[StrictStr, Field(..., description="A lusid instrument id identifying the instrument.")], model : Annotated[Optional[StrictStr], Field( description="A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, instrument_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, recipe_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the recipe lies. When not supplied the scope is 'default'.")] = None, recipe_code : Annotated[Optional[StrictStr], Field( description="A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.")] = None, async_req: Optional[bool]=True, **kwargs) -> InstrumentCapabilities:  # noqa: E501
        ...

    @validate_arguments
    def get_existing_instrument_capabilities(self, identifier : Annotated[StrictStr, Field(..., description="A lusid instrument id identifying the instrument.")], model : Annotated[Optional[StrictStr], Field( description="A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, instrument_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, recipe_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the recipe lies. When not supplied the scope is 'default'.")] = None, recipe_code : Annotated[Optional[StrictStr], Field( description="A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[InstrumentCapabilities, Awaitable[InstrumentCapabilities]]:  # noqa: E501
        """GetExistingInstrumentCapabilities: Retrieve capabilities of an existing instrument identified by LUID. These include instrument features, and if model is provided it also includes supported address keys and economic dependencies. Given an lusid instrument id provides instrument capabilities, outlining features, and, given the model, the capabilities also include supported addresses as well as economic dependencies.  # noqa: E501

        Returns instrument capabilities containing useful information about the instrument and the model. This includes - features corresponding to the instrument e.g. Optionality:American, Other:InflationLinked - supported addresses (if model provided) e.g. Valuation/Pv, Valuation/DirtyPriceKey, Valuation/Accrued - economic dependencies (if model provided) e.g. Cash:USD, Fx:GBP.USD, Rates:GBP.GBPOIS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_existing_instrument_capabilities(identifier, model, effective_at, as_at, instrument_scope, recipe_scope, recipe_code, async_req=True)
        >>> result = thread.get()

        :param identifier: A lusid instrument id identifying the instrument. (required)
        :type identifier: str
        :param model: A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.
        :type model: str
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param instrument_scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type instrument_scope: str
        :param recipe_scope: The scope in which the recipe lies. When not supplied the scope is 'default'.
        :type recipe_scope: str
        :param recipe_code: A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.
        :type recipe_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstrumentCapabilities
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_existing_instrument_capabilities_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_existing_instrument_capabilities_with_http_info(identifier, model, effective_at, as_at, instrument_scope, recipe_scope, recipe_code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_existing_instrument_capabilities_with_http_info(self, identifier : Annotated[StrictStr, Field(..., description="A lusid instrument id identifying the instrument.")], model : Annotated[Optional[StrictStr], Field( description="A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, instrument_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, recipe_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the recipe lies. When not supplied the scope is 'default'.")] = None, recipe_code : Annotated[Optional[StrictStr], Field( description="A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetExistingInstrumentCapabilities: Retrieve capabilities of an existing instrument identified by LUID. These include instrument features, and if model is provided it also includes supported address keys and economic dependencies. Given an lusid instrument id provides instrument capabilities, outlining features, and, given the model, the capabilities also include supported addresses as well as economic dependencies.  # noqa: E501

        Returns instrument capabilities containing useful information about the instrument and the model. This includes - features corresponding to the instrument e.g. Optionality:American, Other:InflationLinked - supported addresses (if model provided) e.g. Valuation/Pv, Valuation/DirtyPriceKey, Valuation/Accrued - economic dependencies (if model provided) e.g. Cash:USD, Fx:GBP.USD, Rates:GBP.GBPOIS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_existing_instrument_capabilities_with_http_info(identifier, model, effective_at, as_at, instrument_scope, recipe_scope, recipe_code, async_req=True)
        >>> result = thread.get()

        :param identifier: A lusid instrument id identifying the instrument. (required)
        :type identifier: str
        :param model: A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.
        :type model: str
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param instrument_scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type instrument_scope: str
        :param recipe_scope: The scope in which the recipe lies. When not supplied the scope is 'default'.
        :type recipe_scope: str
        :param recipe_code: A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.
        :type recipe_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstrumentCapabilities, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier',
            'model',
            'effective_at',
            'as_at',
            'instrument_scope',
            'recipe_scope',
            'recipe_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_existing_instrument_capabilities" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('model') is not None:  # noqa: E501
            _query_params.append(('model', _params['model']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('instrument_scope') is not None:  # noqa: E501
            _query_params.append(('instrumentScope', _params['instrument_scope']))

        if _params.get('recipe_scope') is not None:  # noqa: E501
            _query_params.append(('recipeScope', _params['recipe_scope']))

        if _params.get('recipe_code') is not None:  # noqa: E501
            _query_params.append(('recipeCode', _params['recipe_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "InstrumentCapabilities",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifier}/capabilities', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_existing_instrument_models(self, identifier : Annotated[StrictStr, Field(..., description="A lusid instrument id identifying the instrument.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, instrument_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, recipe_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the recipe lies. When not supplied the scope is 'default'.")] = None, recipe_code : Annotated[Optional[StrictStr], Field( description="A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.")] = None, **kwargs) -> InstrumentModels:  # noqa: E501
        ...

    @overload
    def get_existing_instrument_models(self, identifier : Annotated[StrictStr, Field(..., description="A lusid instrument id identifying the instrument.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, instrument_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, recipe_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the recipe lies. When not supplied the scope is 'default'.")] = None, recipe_code : Annotated[Optional[StrictStr], Field( description="A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.")] = None, async_req: Optional[bool]=True, **kwargs) -> InstrumentModels:  # noqa: E501
        ...

    @validate_arguments
    def get_existing_instrument_models(self, identifier : Annotated[StrictStr, Field(..., description="A lusid instrument id identifying the instrument.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, instrument_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, recipe_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the recipe lies. When not supplied the scope is 'default'.")] = None, recipe_code : Annotated[Optional[StrictStr], Field( description="A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[InstrumentModels, Awaitable[InstrumentModels]]:  # noqa: E501
        """GetExistingInstrumentModels: Retrieve supported pricing models for an existing instrument identified by LUID.  # noqa: E501

        Get the supported pricing models of a single instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_existing_instrument_models(identifier, effective_at, as_at, instrument_scope, recipe_scope, recipe_code, async_req=True)
        >>> result = thread.get()

        :param identifier: A lusid instrument id identifying the instrument. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param instrument_scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type instrument_scope: str
        :param recipe_scope: The scope in which the recipe lies. When not supplied the scope is 'default'.
        :type recipe_scope: str
        :param recipe_code: A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.
        :type recipe_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstrumentModels
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_existing_instrument_models_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_existing_instrument_models_with_http_info(identifier, effective_at, as_at, instrument_scope, recipe_scope, recipe_code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_existing_instrument_models_with_http_info(self, identifier : Annotated[StrictStr, Field(..., description="A lusid instrument id identifying the instrument.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, instrument_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, recipe_scope : Annotated[Optional[StrictStr], Field( description="The scope in which the recipe lies. When not supplied the scope is 'default'.")] = None, recipe_code : Annotated[Optional[StrictStr], Field( description="A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetExistingInstrumentModels: Retrieve supported pricing models for an existing instrument identified by LUID.  # noqa: E501

        Get the supported pricing models of a single instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_existing_instrument_models_with_http_info(identifier, effective_at, as_at, instrument_scope, recipe_scope, recipe_code, async_req=True)
        >>> result = thread.get()

        :param identifier: A lusid instrument id identifying the instrument. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param instrument_scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type instrument_scope: str
        :param recipe_scope: The scope in which the recipe lies. When not supplied the scope is 'default'.
        :type recipe_scope: str
        :param recipe_code: A unique identifier for an entity, used to obtain configuration recipe details. Default configuration recipe is used if not provided.
        :type recipe_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstrumentModels, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier',
            'effective_at',
            'as_at',
            'instrument_scope',
            'recipe_scope',
            'recipe_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_existing_instrument_models" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('instrument_scope') is not None:  # noqa: E501
            _query_params.append(('instrumentScope', _params['instrument_scope']))

        if _params.get('recipe_scope') is not None:  # noqa: E501
            _query_params.append(('recipeScope', _params['recipe_scope']))

        if _params.get('recipe_code') is not None:  # noqa: E501
            _query_params.append(('recipeCode', _params['recipe_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "InstrumentModels",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifier}/models', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_instrument(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to use, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto             the instrument, or from any domain that supports relationships to decorate onto related entities.             These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities             onto the instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, **kwargs) -> Instrument:  # noqa: E501
        ...

    @overload
    def get_instrument(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to use, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto             the instrument, or from any domain that supports relationships to decorate onto related entities.             These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities             onto the instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, async_req: Optional[bool]=True, **kwargs) -> Instrument:  # noqa: E501
        ...

    @validate_arguments
    def get_instrument(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to use, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto             the instrument, or from any domain that supports relationships to decorate onto related entities.             These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities             onto the instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Instrument, Awaitable[Instrument]]:  # noqa: E501
        """GetInstrument: Get instrument  # noqa: E501

        Retrieve the definition of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument(identifier_type, identifier, effective_at, as_at, property_keys, scope, relationship_definition_ids, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to use, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Instrument' domain to decorate onto             the instrument, or from any domain that supports relationships to decorate onto related entities.             These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type property_keys: List[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities             onto the instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Instrument
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_instrument_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_instrument_with_http_info(identifier_type, identifier, effective_at, as_at, property_keys, scope, relationship_definition_ids, **kwargs)  # noqa: E501

    @validate_arguments
    def get_instrument_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to use, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto             the instrument, or from any domain that supports relationships to decorate onto related entities.             These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities             onto the instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetInstrument: Get instrument  # noqa: E501

        Retrieve the definition of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_with_http_info(identifier_type, identifier, effective_at, as_at, property_keys, scope, relationship_definition_ids, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to use, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument. Defaults to             returning the latest version if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Instrument' domain to decorate onto             the instrument, or from any domain that supports relationships to decorate onto related entities.             These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type property_keys: List[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities             onto the instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Instrument, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'identifier',
            'effective_at',
            'as_at',
            'property_keys',
            'scope',
            'relationship_definition_ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']

        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('relationship_definition_ids') is not None:  # noqa: E501
            _query_params.append(('relationshipDefinitionIds', _params['relationship_definition_ids']))
            _collection_formats['relationshipDefinitionIds'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Instrument",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_instrument_identifier_types(self, **kwargs) -> ResourceListOfInstrumentIdTypeDescriptor:  # noqa: E501
        ...

    @overload
    def get_instrument_identifier_types(self, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfInstrumentIdTypeDescriptor:  # noqa: E501
        ...

    @validate_arguments
    def get_instrument_identifier_types(self, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfInstrumentIdTypeDescriptor, Awaitable[ResourceListOfInstrumentIdTypeDescriptor]]:  # noqa: E501
        """GetInstrumentIdentifierTypes: Get instrument identifier types  # noqa: E501

        Retrieve a list of all valid instrument identifier types and whether they are unique or not.              An instrument must have a value for at least one unique identifier type (it can have more than one unique type and value). In addition, a value is automatically generated for a LUSID Instrument ID (LUID) unique type by the system.              An instrument can have values for multiple non-unique identifier types (or it can have zero non-unique types and values).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_identifier_types(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfInstrumentIdTypeDescriptor
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_instrument_identifier_types_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_instrument_identifier_types_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_instrument_identifier_types_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """GetInstrumentIdentifierTypes: Get instrument identifier types  # noqa: E501

        Retrieve a list of all valid instrument identifier types and whether they are unique or not.              An instrument must have a value for at least one unique identifier type (it can have more than one unique type and value). In addition, a value is automatically generated for a LUSID Instrument ID (LUID) unique type by the system.              An instrument can have values for multiple non-unique identifier types (or it can have zero non-unique types and values).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_identifier_types_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfInstrumentIdTypeDescriptor, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_identifier_types" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfInstrumentIdTypeDescriptor",
        }

        return self.api_client.call_api(
            '/api/instruments/identifierTypes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_instrument_payment_diary(self, identifier_type : Annotated[StrictStr, Field(..., description="The identifier being supplied e.g. \"Figi\".")], identifier : Annotated[StrictStr, Field(..., description="The value of the identifier for the requested instrument.")], recipe_scope : Annotated[StrictStr, Field(..., description="The scope of the valuation recipe being used to generate the payment diary")], recipe_code : Annotated[StrictStr, Field(..., description="The code of the valuation recipe being used to generate the payment diary")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to return the latest version of each property if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> InstrumentPaymentDiary:  # noqa: E501
        ...

    @overload
    def get_instrument_payment_diary(self, identifier_type : Annotated[StrictStr, Field(..., description="The identifier being supplied e.g. \"Figi\".")], identifier : Annotated[StrictStr, Field(..., description="The value of the identifier for the requested instrument.")], recipe_scope : Annotated[StrictStr, Field(..., description="The scope of the valuation recipe being used to generate the payment diary")], recipe_code : Annotated[StrictStr, Field(..., description="The code of the valuation recipe being used to generate the payment diary")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to return the latest version of each property if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> InstrumentPaymentDiary:  # noqa: E501
        ...

    @validate_arguments
    def get_instrument_payment_diary(self, identifier_type : Annotated[StrictStr, Field(..., description="The identifier being supplied e.g. \"Figi\".")], identifier : Annotated[StrictStr, Field(..., description="The value of the identifier for the requested instrument.")], recipe_scope : Annotated[StrictStr, Field(..., description="The scope of the valuation recipe being used to generate the payment diary")], recipe_code : Annotated[StrictStr, Field(..., description="The code of the valuation recipe being used to generate the payment diary")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to return the latest version of each property if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[InstrumentPaymentDiary, Awaitable[InstrumentPaymentDiary]]:  # noqa: E501
        """GetInstrumentPaymentDiary: Get instrument payment diary  # noqa: E501

        Get the payment diary of a single instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_payment_diary(identifier_type, identifier, recipe_scope, recipe_code, effective_at, as_at, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The identifier being supplied e.g. \"Figi\". (required)
        :type identifier_type: str
        :param identifier: The value of the identifier for the requested instrument. (required)
        :type identifier: str
        :param recipe_scope: The scope of the valuation recipe being used to generate the payment diary (required)
        :type recipe_scope: str
        :param recipe_code: The code of the valuation recipe being used to generate the payment diary (required)
        :type recipe_code: str
        :param effective_at: The effective datetime or cut label at which to list the instrument's properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the instrument's properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstrumentPaymentDiary
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_instrument_payment_diary_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_instrument_payment_diary_with_http_info(identifier_type, identifier, recipe_scope, recipe_code, effective_at, as_at, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def get_instrument_payment_diary_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="The identifier being supplied e.g. \"Figi\".")], identifier : Annotated[StrictStr, Field(..., description="The value of the identifier for the requested instrument.")], recipe_scope : Annotated[StrictStr, Field(..., description="The scope of the valuation recipe being used to generate the payment diary")], recipe_code : Annotated[StrictStr, Field(..., description="The code of the valuation recipe being used to generate the payment diary")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to return the latest version of each property if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetInstrumentPaymentDiary: Get instrument payment diary  # noqa: E501

        Get the payment diary of a single instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_payment_diary_with_http_info(identifier_type, identifier, recipe_scope, recipe_code, effective_at, as_at, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The identifier being supplied e.g. \"Figi\". (required)
        :type identifier_type: str
        :param identifier: The value of the identifier for the requested instrument. (required)
        :type identifier: str
        :param recipe_scope: The scope of the valuation recipe being used to generate the payment diary (required)
        :type recipe_scope: str
        :param recipe_code: The code of the valuation recipe being used to generate the payment diary (required)
        :type recipe_code: str
        :param effective_at: The effective datetime or cut label at which to list the instrument's properties. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the instrument's properties. Defaults to return the latest version of each property if not specified.
        :type as_at: datetime
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstrumentPaymentDiary, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'identifier',
            'recipe_scope',
            'recipe_code',
            'effective_at',
            'as_at',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_payment_diary" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']

        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('recipe_scope') is not None:  # noqa: E501
            _query_params.append(('recipeScope', _params['recipe_scope']))

        if _params.get('recipe_code') is not None:  # noqa: E501
            _query_params.append(('recipeCode', _params['recipe_code']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "InstrumentPaymentDiary",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/paymentdiary', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_instrument_properties(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> InstrumentProperties:  # noqa: E501
        ...

    @overload
    def get_instrument_properties(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> InstrumentProperties:  # noqa: E501
        ...

    @validate_arguments
    def get_instrument_properties(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[InstrumentProperties, Awaitable[InstrumentProperties]]:  # noqa: E501
        """GetInstrumentProperties: Get instrument properties  # noqa: E501

        List all the properties of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_properties(identifier_type, identifier, effective_at, as_at, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.
        :type as_at: datetime
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstrumentProperties
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_instrument_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_instrument_properties_with_http_info(identifier_type, identifier, effective_at, as_at, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def get_instrument_properties_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetInstrumentProperties: Get instrument properties  # noqa: E501

        List all the properties of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_properties_with_http_info(identifier_type, identifier, effective_at, as_at, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.
        :type as_at: datetime
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstrumentProperties, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'identifier',
            'effective_at',
            'as_at',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']

        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "InstrumentProperties",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/properties', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_instrument_property_time_series(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], property_key : Annotated[StrictStr, Field(..., description="The property key of a property from the 'Instrument' domain whose history to retrieve.             This must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")], identifier_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime used to resolve the instrument from the identifier.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument's property history. Defaults to             returning the current datetime if not supplied.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For more information about filtering,             see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties; this value is returned from             the previous call. If a pagination token is provided, the <i>filter</i>, <i>effectiveAt</i> and             <i>asAt</i> fields must not have changed since the original request. For more information, see             https://support.lusid.com/knowledgebase/article/KA-01915.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> ResourceListOfPropertyInterval:  # noqa: E501
        ...

    @overload
    def get_instrument_property_time_series(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], property_key : Annotated[StrictStr, Field(..., description="The property key of a property from the 'Instrument' domain whose history to retrieve.             This must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")], identifier_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime used to resolve the instrument from the identifier.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument's property history. Defaults to             returning the current datetime if not supplied.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For more information about filtering,             see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties; this value is returned from             the previous call. If a pagination token is provided, the <i>filter</i>, <i>effectiveAt</i> and             <i>asAt</i> fields must not have changed since the original request. For more information, see             https://support.lusid.com/knowledgebase/article/KA-01915.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfPropertyInterval:  # noqa: E501
        ...

    @validate_arguments
    def get_instrument_property_time_series(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], property_key : Annotated[StrictStr, Field(..., description="The property key of a property from the 'Instrument' domain whose history to retrieve.             This must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")], identifier_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime used to resolve the instrument from the identifier.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument's property history. Defaults to             returning the current datetime if not supplied.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For more information about filtering,             see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties; this value is returned from             the previous call. If a pagination token is provided, the <i>filter</i>, <i>effectiveAt</i> and             <i>asAt</i> fields must not have changed since the original request. For more information, see             https://support.lusid.com/knowledgebase/article/KA-01915.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfPropertyInterval, Awaitable[ResourceListOfPropertyInterval]]:  # noqa: E501
        """GetInstrumentPropertyTimeSeries: Get instrument property time series  # noqa: E501

        Retrieve the complete time series (history) for a particular property of an instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_property_time_series(identifier_type, identifier, property_key, identifier_effective_at, as_at, filter, page, limit, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param property_key: The property key of a property from the 'Instrument' domain whose history to retrieve.             This must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'. (required)
        :type property_key: str
        :param identifier_effective_at: The effective datetime used to resolve the instrument from the identifier.             Defaults to the current LUSID system datetime if not specified.
        :type identifier_effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument's property history. Defaults to             returning the current datetime if not supplied.
        :type as_at: datetime
        :param filter: Expression to filter the results. For more information about filtering,             see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param page: The pagination token to use to continue listing properties; this value is returned from             the previous call. If a pagination token is provided, the <i>filter</i>, <i>effectiveAt</i> and             <i>asAt</i> fields must not have changed since the original request. For more information, see             https://support.lusid.com/knowledgebase/article/KA-01915.
        :type page: str
        :param limit: When paginating, limit the results to this number.
        :type limit: int
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfPropertyInterval
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_instrument_property_time_series_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_instrument_property_time_series_with_http_info(identifier_type, identifier, property_key, identifier_effective_at, as_at, filter, page, limit, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def get_instrument_property_time_series_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], property_key : Annotated[StrictStr, Field(..., description="The property key of a property from the 'Instrument' domain whose history to retrieve.             This must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")], identifier_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime used to resolve the instrument from the identifier.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument's property history. Defaults to             returning the current datetime if not supplied.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For more information about filtering,             see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties; this value is returned from             the previous call. If a pagination token is provided, the <i>filter</i>, <i>effectiveAt</i> and             <i>asAt</i> fields must not have changed since the original request. For more information, see             https://support.lusid.com/knowledgebase/article/KA-01915.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetInstrumentPropertyTimeSeries: Get instrument property time series  # noqa: E501

        Retrieve the complete time series (history) for a particular property of an instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_property_time_series_with_http_info(identifier_type, identifier, property_key, identifier_effective_at, as_at, filter, page, limit, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param property_key: The property key of a property from the 'Instrument' domain whose history to retrieve.             This must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'. (required)
        :type property_key: str
        :param identifier_effective_at: The effective datetime used to resolve the instrument from the identifier.             Defaults to the current LUSID system datetime if not specified.
        :type identifier_effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument's property history. Defaults to             returning the current datetime if not supplied.
        :type as_at: datetime
        :param filter: Expression to filter the results. For more information about filtering,             see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param page: The pagination token to use to continue listing properties; this value is returned from             the previous call. If a pagination token is provided, the <i>filter</i>, <i>effectiveAt</i> and             <i>asAt</i> fields must not have changed since the original request. For more information, see             https://support.lusid.com/knowledgebase/article/KA-01915.
        :type page: str
        :param limit: When paginating, limit the results to this number.
        :type limit: int
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfPropertyInterval, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'identifier',
            'property_key',
            'identifier_effective_at',
            'as_at',
            'filter',
            'page',
            'limit',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_property_time_series" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']

        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('property_key') is not None:  # noqa: E501
            _query_params.append(('propertyKey', _params['property_key']))

        if _params.get('identifier_effective_at') is not None:  # noqa: E501
            _query_params.append(('identifierEffectiveAt', _params['identifier_effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfPropertyInterval",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/properties/time-series', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_instrument_relationships(self, identifier_type : Annotated[StrictStr, Field(..., description="An identifier type attached to the Instrument.")], identifier : Annotated[StrictStr, Field(..., description="The identifier value.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter relationships. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[conlist(StrictStr)], Field(description="Identifier types (as property keys) used for referencing Persons or Legal Entities.             These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example             'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The entity scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> ResourceListOfRelationship:  # noqa: E501
        ...

    @overload
    def get_instrument_relationships(self, identifier_type : Annotated[StrictStr, Field(..., description="An identifier type attached to the Instrument.")], identifier : Annotated[StrictStr, Field(..., description="The identifier value.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter relationships. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[conlist(StrictStr)], Field(description="Identifier types (as property keys) used for referencing Persons or Legal Entities.             These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example             'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The entity scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfRelationship:  # noqa: E501
        ...

    @validate_arguments
    def get_instrument_relationships(self, identifier_type : Annotated[StrictStr, Field(..., description="An identifier type attached to the Instrument.")], identifier : Annotated[StrictStr, Field(..., description="The identifier value.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter relationships. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[conlist(StrictStr)], Field(description="Identifier types (as property keys) used for referencing Persons or Legal Entities.             These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example             'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The entity scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfRelationship, Awaitable[ResourceListOfRelationship]]:  # noqa: E501
        """GetInstrumentRelationships: Get Instrument relationships  # noqa: E501

        Get relationships for a particular Instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_relationships(identifier_type, identifier, effective_at, as_at, filter, identifier_types, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: An identifier type attached to the Instrument. (required)
        :type identifier_type: str
        :param identifier: The identifier value. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifier types (as property keys) used for referencing Persons or Legal Entities.             These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example             'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.
        :type identifier_types: List[str]
        :param scope: The entity scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfRelationship
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_instrument_relationships_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_instrument_relationships_with_http_info(identifier_type, identifier, effective_at, as_at, filter, identifier_types, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def get_instrument_relationships_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="An identifier type attached to the Instrument.")], identifier : Annotated[StrictStr, Field(..., description="The identifier value.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter relationships. Users should provide null or empty string for this field until further notice.")] = None, identifier_types : Annotated[Optional[conlist(StrictStr)], Field(description="Identifier types (as property keys) used for referencing Persons or Legal Entities.             These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example             'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The entity scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetInstrumentRelationships: Get Instrument relationships  # noqa: E501

        Get relationships for a particular Instrument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instrument_relationships_with_http_info(identifier_type, identifier, effective_at, as_at, filter, identifier_types, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: An identifier type attached to the Instrument. (required)
        :type identifier_type: str
        :param identifier: The identifier value. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifier types (as property keys) used for referencing Persons or Legal Entities.             These can be specified from the 'Person' or 'LegalEntity' domains and have the format {domain}/{scope}/{code}, for example             'Person/CompanyDetails/Role'. An Empty array may be used to return all related Entities.
        :type identifier_types: List[str]
        :param scope: The entity scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfRelationship, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'identifier',
            'effective_at',
            'as_at',
            'filter',
            'identifier_types',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrument_relationships" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']

        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('identifier_types') is not None:  # noqa: E501
            _query_params.append(('identifierTypes', _params['identifier_types']))
            _collection_formats['identifierTypes'] = 'multi'

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfRelationship",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/relationships', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_instruments(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to use, for example 'Figi'.")], request_body : Annotated[conlist(StrictStr), Field(..., description="A list of one or more <i>identifierType</i> values to use to identify instruments.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument definitions.              Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument definitions.              Defaults to returning the latest version of each instrument definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto              each instrument, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, **kwargs) -> GetInstrumentsResponse:  # noqa: E501
        ...

    @overload
    def get_instruments(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to use, for example 'Figi'.")], request_body : Annotated[conlist(StrictStr), Field(..., description="A list of one or more <i>identifierType</i> values to use to identify instruments.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument definitions.              Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument definitions.              Defaults to returning the latest version of each instrument definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto              each instrument, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, async_req: Optional[bool]=True, **kwargs) -> GetInstrumentsResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_instruments(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to use, for example 'Figi'.")], request_body : Annotated[conlist(StrictStr), Field(..., description="A list of one or more <i>identifierType</i> values to use to identify instruments.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument definitions.              Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument definitions.              Defaults to returning the latest version of each instrument definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto              each instrument, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[GetInstrumentsResponse, Awaitable[GetInstrumentsResponse]]:  # noqa: E501
        """GetInstruments: Get instruments  # noqa: E501

        Retrieve the definition of one or more instruments, as identified by a collection of unique identifiers.              Note that to retrieve all the instruments in the instrument master, use the List instruments endpoint instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instruments(identifier_type, request_body, effective_at, as_at, property_keys, scope, relationship_definition_ids, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to use, for example 'Figi'. (required)
        :type identifier_type: str
        :param request_body: A list of one or more <i>identifierType</i> values to use to identify instruments. (required)
        :type request_body: List[str]
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument definitions.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument definitions.              Defaults to returning the latest version of each instrument definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Instrument' domain to decorate onto              each instrument, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type property_keys: List[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetInstrumentsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_instruments_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_instruments_with_http_info(identifier_type, request_body, effective_at, as_at, property_keys, scope, relationship_definition_ids, **kwargs)  # noqa: E501

    @validate_arguments
    def get_instruments_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to use, for example 'Figi'.")], request_body : Annotated[conlist(StrictStr), Field(..., description="A list of one or more <i>identifierType</i> values to use to identify instruments.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the instrument definitions.              Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the instrument definitions.              Defaults to returning the latest version of each instrument definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto              each instrument, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetInstruments: Get instruments  # noqa: E501

        Retrieve the definition of one or more instruments, as identified by a collection of unique identifiers.              Note that to retrieve all the instruments in the instrument master, use the List instruments endpoint instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_instruments_with_http_info(identifier_type, request_body, effective_at, as_at, property_keys, scope, relationship_definition_ids, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to use, for example 'Figi'. (required)
        :type identifier_type: str
        :param request_body: A list of one or more <i>identifierType</i> values to use to identify instruments. (required)
        :type request_body: List[str]
        :param effective_at: The effective datetime or cut label at which to retrieve the instrument definitions.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the instrument definitions.              Defaults to returning the latest version of each instrument definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Instrument' domain to decorate onto              each instrument, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type property_keys: List[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetInstrumentsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'request_body',
            'effective_at',
            'as_at',
            'property_keys',
            'scope',
            'relationship_definition_ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instruments" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('identifier_type') is not None:  # noqa: E501
            _query_params.append(('identifierType', _params['identifier_type']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('relationship_definition_ids') is not None:  # noqa: E501
            _query_params.append(('relationshipDefinitionIds', _params['relationship_definition_ids']))
            _collection_formats['relationshipDefinitionIds'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GetInstrumentsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/$get', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_instrument_properties(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing commands; this value is returned from the previous call.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results per page to this number.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> ResourceListOfProperty:  # noqa: E501
        ...

    @overload
    def list_instrument_properties(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing commands; this value is returned from the previous call.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results per page to this number.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfProperty:  # noqa: E501
        ...

    @validate_arguments
    def list_instrument_properties(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing commands; this value is returned from the previous call.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results per page to this number.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfProperty, Awaitable[ResourceListOfProperty]]:  # noqa: E501
        """ListInstrumentProperties: Get instrument properties (with Pagination)  # noqa: E501

        List all the properties of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_instrument_properties(identifier_type, identifier, effective_at, as_at, page, limit, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing commands; this value is returned from the previous call.
        :type page: str
        :param limit: When paginating, limit the results per page to this number.
        :type limit: int
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfProperty
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_instrument_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_instrument_properties_with_http_info(identifier_type, identifier, effective_at, as_at, page, limit, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def list_instrument_properties_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing commands; this value is returned from the previous call.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results per page to this number.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListInstrumentProperties: Get instrument properties (with Pagination)  # noqa: E501

        List all the properties of a particular instrument, as identified by a particular unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_instrument_properties_with_http_info(identifier_type, identifier, effective_at, as_at, page, limit, scope, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param effective_at: The effective datetime or cut label at which to list the instrument's properties.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the instrument's properties. Defaults to returning             the latest version of each property if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing commands; this value is returned from the previous call.
        :type page: str
        :param limit: When paginating, limit the results per page to this number.
        :type limit: int
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfProperty, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'identifier',
            'effective_at',
            'as_at',
            'page',
            'limit',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_instrument_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']

        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfProperty",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}/properties/list', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_instruments(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list instruments. Defaults to returning the latest              version of each instrument if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list instruments.              Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing instruments; this value is returned from              the previous call. If a pagination token is provided, the <i>sortBy</i>, <i>filter</i>, <i>effectiveAt</i> and              <i>asAt</i> fields must not have changed since the original request.              For more information, see https://support.lusid.com/knowledgebase/article/KA-01915.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Defaults to filtering out inactive instruments              (that is, those that have been deleted). For more information about filtering results,              see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, instrument_property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto              instruments, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use.")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use.")] = None, membership_type : Annotated[Optional[StrictStr], Field( description="The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.")] = None, **kwargs) -> PagedResourceListOfInstrument:  # noqa: E501
        ...

    @overload
    def list_instruments(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list instruments. Defaults to returning the latest              version of each instrument if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list instruments.              Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing instruments; this value is returned from              the previous call. If a pagination token is provided, the <i>sortBy</i>, <i>filter</i>, <i>effectiveAt</i> and              <i>asAt</i> fields must not have changed since the original request.              For more information, see https://support.lusid.com/knowledgebase/article/KA-01915.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Defaults to filtering out inactive instruments              (that is, those that have been deleted). For more information about filtering results,              see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, instrument_property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto              instruments, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use.")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use.")] = None, membership_type : Annotated[Optional[StrictStr], Field( description="The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfInstrument:  # noqa: E501
        ...

    @validate_arguments
    def list_instruments(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list instruments. Defaults to returning the latest              version of each instrument if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list instruments.              Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing instruments; this value is returned from              the previous call. If a pagination token is provided, the <i>sortBy</i>, <i>filter</i>, <i>effectiveAt</i> and              <i>asAt</i> fields must not have changed since the original request.              For more information, see https://support.lusid.com/knowledgebase/article/KA-01915.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Defaults to filtering out inactive instruments              (that is, those that have been deleted). For more information about filtering results,              see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, instrument_property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto              instruments, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use.")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use.")] = None, membership_type : Annotated[Optional[StrictStr], Field( description="The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfInstrument, Awaitable[PagedResourceListOfInstrument]]:  # noqa: E501
        """ListInstruments: List instruments  # noqa: E501

        List all the instruments in the instrument master.              To retrieve a particular set of instruments instead, use the Get instruments endpoint.  The maximum number of instruments that this method can list per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_instruments(as_at, effective_at, page, sort_by, limit, filter, instrument_property_keys, scope, relationship_definition_ids, data_model_scope, data_model_code, membership_type, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list instruments. Defaults to returning the latest              version of each instrument if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to list instruments.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param page: The pagination token to use to continue listing instruments; this value is returned from              the previous call. If a pagination token is provided, the <i>sortBy</i>, <i>filter</i>, <i>effectiveAt</i> and              <i>asAt</i> fields must not have changed since the original request.              For more information, see https://support.lusid.com/knowledgebase/article/KA-01915.
        :type page: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: When paginating, limit the results to this number.
        :type limit: int
        :param filter: Expression to filter the result set. Defaults to filtering out inactive instruments              (that is, those that have been deleted). For more information about filtering results,              see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param instrument_property_keys: A list of property keys from the 'Instrument' domain to decorate onto              instruments, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type instrument_property_keys: List[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param data_model_scope: The optional scope of a Custom Data Model to use.
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use.
        :type data_model_code: str
        :param membership_type: The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.
        :type membership_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfInstrument
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_instruments_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_instruments_with_http_info(as_at, effective_at, page, sort_by, limit, filter, instrument_property_keys, scope, relationship_definition_ids, data_model_scope, data_model_code, membership_type, **kwargs)  # noqa: E501

    @validate_arguments
    def list_instruments_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list instruments. Defaults to returning the latest              version of each instrument if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list instruments.              Defaults to the current LUSID system datetime if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing instruments; this value is returned from              the previous call. If a pagination token is provided, the <i>sortBy</i>, <i>filter</i>, <i>effectiveAt</i> and              <i>asAt</i> fields must not have changed since the original request.              For more information, see https://support.lusid.com/knowledgebase/article/KA-01915.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Defaults to filtering out inactive instruments              (that is, those that have been deleted). For more information about filtering results,              see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, instrument_property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' domain to decorate onto              instruments, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, relationship_definition_ids : Annotated[Optional[conlist(StrictStr)], Field(description="A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use.")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use.")] = None, membership_type : Annotated[Optional[StrictStr], Field( description="The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListInstruments: List instruments  # noqa: E501

        List all the instruments in the instrument master.              To retrieve a particular set of instruments instead, use the Get instruments endpoint.  The maximum number of instruments that this method can list per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_instruments_with_http_info(as_at, effective_at, page, sort_by, limit, filter, instrument_property_keys, scope, relationship_definition_ids, data_model_scope, data_model_code, membership_type, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to list instruments. Defaults to returning the latest              version of each instrument if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to list instruments.              Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param page: The pagination token to use to continue listing instruments; this value is returned from              the previous call. If a pagination token is provided, the <i>sortBy</i>, <i>filter</i>, <i>effectiveAt</i> and              <i>asAt</i> fields must not have changed since the original request.              For more information, see https://support.lusid.com/knowledgebase/article/KA-01915.
        :type page: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: When paginating, limit the results to this number.
        :type limit: int
        :param filter: Expression to filter the result set. Defaults to filtering out inactive instruments              (that is, those that have been deleted). For more information about filtering results,              see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param instrument_property_keys: A list of property keys from the 'Instrument' domain to decorate onto              instruments, or from any domain that supports relationships to decorate onto related entities.              These must have the format {domain}/{scope}/{code}, for example 'Instrument/system/Name'.
        :type instrument_property_keys: List[str]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto each instrument in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: List[str]
        :param data_model_scope: The optional scope of a Custom Data Model to use.
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use.
        :type data_model_code: str
        :param membership_type: The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.
        :type membership_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfInstrument, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'effective_at',
            'page',
            'sort_by',
            'limit',
            'filter',
            'instrument_property_keys',
            'scope',
            'relationship_definition_ids',
            'data_model_scope',
            'data_model_code',
            'membership_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_instruments" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('instrument_property_keys') is not None:  # noqa: E501
            _query_params.append(('instrumentPropertyKeys', _params['instrument_property_keys']))
            _collection_formats['instrumentPropertyKeys'] = 'multi'

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('relationship_definition_ids') is not None:  # noqa: E501
            _query_params.append(('relationshipDefinitionIds', _params['relationship_definition_ids']))
            _collection_formats['relationshipDefinitionIds'] = 'multi'

        if _params.get('data_model_scope') is not None:  # noqa: E501
            _query_params.append(('dataModelScope', _params['data_model_scope']))

        if _params.get('data_model_code') is not None:  # noqa: E501
            _query_params.append(('dataModelCode', _params['data_model_code']))

        if _params.get('membership_type') is not None:  # noqa: E501
            _query_params.append(('membershipType', _params['membership_type']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfInstrument",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def query_instrument_capabilities(self, lusid_instrument : Annotated[LusidInstrument, Field(..., description="The definition of the instrument.")], model : Annotated[Optional[StrictStr], Field( description="A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.")] = None, **kwargs) -> InstrumentCapabilities:  # noqa: E501
        ...

    @overload
    def query_instrument_capabilities(self, lusid_instrument : Annotated[LusidInstrument, Field(..., description="The definition of the instrument.")], model : Annotated[Optional[StrictStr], Field( description="A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.")] = None, async_req: Optional[bool]=True, **kwargs) -> InstrumentCapabilities:  # noqa: E501
        ...

    @validate_arguments
    def query_instrument_capabilities(self, lusid_instrument : Annotated[LusidInstrument, Field(..., description="The definition of the instrument.")], model : Annotated[Optional[StrictStr], Field( description="A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[InstrumentCapabilities, Awaitable[InstrumentCapabilities]]:  # noqa: E501
        """QueryInstrumentCapabilities: Query capabilities of a particular instrument in advance of creating it. These include instrument features, and if model is provided it also includes supported address keys and economic dependencies.  # noqa: E501

        Returns instrument capabilities containing useful information about the instrument and the model. This includes - features corresponding to the instrument e.g. Optionality:American, Other:InflationLinked - supported addresses (if model provided) e.g. Valuation/Pv, Valuation/DirtyPriceKey, Valuation/Accrued - economic dependencies (if model provided) e.g. Cash:USD, Fx:GBP.USD, Rates:GBP.GBPOIS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_instrument_capabilities(lusid_instrument, model, async_req=True)
        >>> result = thread.get()

        :param lusid_instrument: The definition of the instrument. (required)
        :type lusid_instrument: LusidInstrument
        :param model: A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.
        :type model: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InstrumentCapabilities
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the query_instrument_capabilities_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.query_instrument_capabilities_with_http_info(lusid_instrument, model, **kwargs)  # noqa: E501

    @validate_arguments
    def query_instrument_capabilities_with_http_info(self, lusid_instrument : Annotated[LusidInstrument, Field(..., description="The definition of the instrument.")], model : Annotated[Optional[StrictStr], Field( description="A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """QueryInstrumentCapabilities: Query capabilities of a particular instrument in advance of creating it. These include instrument features, and if model is provided it also includes supported address keys and economic dependencies.  # noqa: E501

        Returns instrument capabilities containing useful information about the instrument and the model. This includes - features corresponding to the instrument e.g. Optionality:American, Other:InflationLinked - supported addresses (if model provided) e.g. Valuation/Pv, Valuation/DirtyPriceKey, Valuation/Accrued - economic dependencies (if model provided) e.g. Cash:USD, Fx:GBP.USD, Rates:GBP.GBPOIS  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_instrument_capabilities_with_http_info(lusid_instrument, model, async_req=True)
        >>> result = thread.get()

        :param lusid_instrument: The definition of the instrument. (required)
        :type lusid_instrument: LusidInstrument
        :param model: A pricing model for the instrument. Defaults to Unknown if not specified. If not specified the SupportedAddresses and EconomicDependencies are not provided.
        :type model: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstrumentCapabilities, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lusid_instrument',
            'model'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_instrument_capabilities" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('model') is not None:  # noqa: E501
            _query_params.append(('model', _params['model']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['lusid_instrument'] is not None:
            _body_params = _params['lusid_instrument']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "InstrumentCapabilities",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/capabilities', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_instrument_identifier(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], update_instrument_identifier_request : Annotated[UpdateInstrumentIdentifierRequest, Field(..., description="The identifier to update or delete. This need not be the same value as the              'identifier' parameter used to retrieve the instrument.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> Instrument:  # noqa: E501
        ...

    @overload
    def update_instrument_identifier(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], update_instrument_identifier_request : Annotated[UpdateInstrumentIdentifierRequest, Field(..., description="The identifier to update or delete. This need not be the same value as the              'identifier' parameter used to retrieve the instrument.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=True, **kwargs) -> Instrument:  # noqa: E501
        ...

    @validate_arguments
    def update_instrument_identifier(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], update_instrument_identifier_request : Annotated[UpdateInstrumentIdentifierRequest, Field(..., description="The identifier to update or delete. This need not be the same value as the              'identifier' parameter used to retrieve the instrument.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Instrument, Awaitable[Instrument]]:  # noqa: E501
        """UpdateInstrumentIdentifier: Update instrument identifier  # noqa: E501

        Create, update or delete a particular instrument identifier for an instrument.              To delete the identifier, leave the value unspecified in the request. If not being deleted, the identifier is updated if it exists and created if it does not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_instrument_identifier(identifier_type, identifier, update_instrument_identifier_request, scope, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param update_instrument_identifier_request: The identifier to update or delete. This need not be the same value as the              'identifier' parameter used to retrieve the instrument. (required)
        :type update_instrument_identifier_request: UpdateInstrumentIdentifierRequest
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Instrument
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_instrument_identifier_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_instrument_identifier_with_http_info(identifier_type, identifier, update_instrument_identifier_request, scope, data_model_scope, data_model_code, **kwargs)  # noqa: E501

    @validate_arguments
    def update_instrument_identifier_with_http_info(self, identifier_type : Annotated[StrictStr, Field(..., description="The unique identifier type to search, for example 'Figi'.")], identifier : Annotated[StrictStr, Field(..., description="An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'.")], update_instrument_identifier_request : Annotated[UpdateInstrumentIdentifierRequest, Field(..., description="The identifier to update or delete. This need not be the same value as the              'identifier' parameter used to retrieve the instrument.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """UpdateInstrumentIdentifier: Update instrument identifier  # noqa: E501

        Create, update or delete a particular instrument identifier for an instrument.              To delete the identifier, leave the value unspecified in the request. If not being deleted, the identifier is updated if it exists and created if it does not.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_instrument_identifier_with_http_info(identifier_type, identifier, update_instrument_identifier_request, scope, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param identifier_type: The unique identifier type to search, for example 'Figi'. (required)
        :type identifier_type: str
        :param identifier: An <i>identifierType</i> value to use to identify the instrument, for example 'BBG000BLNNV0'. (required)
        :type identifier: str
        :param update_instrument_identifier_request: The identifier to update or delete. This need not be the same value as the              'identifier' parameter used to retrieve the instrument. (required)
        :type update_instrument_identifier_request: UpdateInstrumentIdentifierRequest
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Instrument, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'identifier_type',
            'identifier',
            'update_instrument_identifier_request',
            'scope',
            'data_model_scope',
            'data_model_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instrument_identifier" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['identifier_type']:
            _path_params['identifierType'] = _params['identifier_type']

        if _params['identifier']:
            _path_params['identifier'] = _params['identifier']


        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('data_model_scope') is not None:  # noqa: E501
            _query_params.append(('dataModelScope', _params['data_model_scope']))

        if _params.get('data_model_code') is not None:  # noqa: E501
            _query_params.append(('dataModelCode', _params['data_model_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_instrument_identifier_request'] is not None:
            _body_params = _params['update_instrument_identifier_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Instrument",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/{identifierType}/{identifier}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_instruments(self, request_body : Annotated[Dict[str, InstrumentDefinition], Field(..., description="The definitions of the instruments to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> UpsertInstrumentsResponse:  # noqa: E501
        ...

    @overload
    def upsert_instruments(self, request_body : Annotated[Dict[str, InstrumentDefinition], Field(..., description="The definitions of the instruments to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=True, **kwargs) -> UpsertInstrumentsResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_instruments(self, request_body : Annotated[Dict[str, InstrumentDefinition], Field(..., description="The definitions of the instruments to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[UpsertInstrumentsResponse, Awaitable[UpsertInstrumentsResponse]]:  # noqa: E501
        """UpsertInstruments: Upsert instruments  # noqa: E501

        Create or update one or more instruments in the instrument master. An instrument is updated if it already exists and created if it does not.              In the request, each instrument definition should be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each instrument in the response.              Note that an instrument must have at least one unique identifier, which is a combination of a type (such as 'Figi') and a value (such as 'BBG000BS1N49'). In addition, a random value is automatically generated for a LUSID Instrument ID (LUID) unique type by the system. For more information, see https://support.lusid.com/knowledgebase/article/KA-01862.              The response returns both the collection of successfully created or updated instruments, as well as those that failed. For each failure, a reason is provided. It is important to check the failed set for unsuccessful results.  The maximum number of instruments that this method can upsert per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_instruments(request_body, scope, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param request_body: The definitions of the instruments to create or update. (required)
        :type request_body: Dict[str, InstrumentDefinition]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertInstrumentsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_instruments_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_instruments_with_http_info(request_body, scope, data_model_scope, data_model_code, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_instruments_with_http_info(self, request_body : Annotated[Dict[str, InstrumentDefinition], Field(..., description="The definitions of the instruments to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertInstruments: Upsert instruments  # noqa: E501

        Create or update one or more instruments in the instrument master. An instrument is updated if it already exists and created if it does not.              In the request, each instrument definition should be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each instrument in the response.              Note that an instrument must have at least one unique identifier, which is a combination of a type (such as 'Figi') and a value (such as 'BBG000BS1N49'). In addition, a random value is automatically generated for a LUSID Instrument ID (LUID) unique type by the system. For more information, see https://support.lusid.com/knowledgebase/article/KA-01862.              The response returns both the collection of successfully created or updated instruments, as well as those that failed. For each failure, a reason is provided. It is important to check the failed set for unsuccessful results.  The maximum number of instruments that this method can upsert per request is 2,000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_instruments_with_http_info(request_body, scope, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param request_body: The definitions of the instruments to create or update. (required)
        :type request_body: Dict[str, InstrumentDefinition]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertInstrumentsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'request_body',
            'scope',
            'data_model_scope',
            'data_model_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_instruments" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('data_model_scope') is not None:  # noqa: E501
            _query_params.append(('dataModelScope', _params['data_model_scope']))

        if _params.get('data_model_code') is not None:  # noqa: E501
            _query_params.append(('dataModelCode', _params['data_model_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "UpsertInstrumentsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_instruments_properties(self, upsert_instrument_property_request : Annotated[conlist(UpsertInstrumentPropertyRequest), Field(..., description="A list of instruments and associated instrument properties to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> UpsertInstrumentPropertiesResponse:  # noqa: E501
        ...

    @overload
    def upsert_instruments_properties(self, upsert_instrument_property_request : Annotated[conlist(UpsertInstrumentPropertyRequest), Field(..., description="A list of instruments and associated instrument properties to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=True, **kwargs) -> UpsertInstrumentPropertiesResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_instruments_properties(self, upsert_instrument_property_request : Annotated[conlist(UpsertInstrumentPropertyRequest), Field(..., description="A list of instruments and associated instrument properties to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[UpsertInstrumentPropertiesResponse, Awaitable[UpsertInstrumentPropertiesResponse]]:  # noqa: E501
        """UpsertInstrumentsProperties: Upsert instruments properties  # noqa: E501

        Create or update one or more properties for particular instruments.              Each instrument property is updated if it exists and created if it does not. For any failures, a reason is provided.              Properties have an <i>effectiveFrom</i> datetime from which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_instruments_properties(upsert_instrument_property_request, scope, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param upsert_instrument_property_request: A list of instruments and associated instrument properties to create or update. (required)
        :type upsert_instrument_property_request: List[UpsertInstrumentPropertyRequest]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertInstrumentPropertiesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_instruments_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_instruments_properties_with_http_info(upsert_instrument_property_request, scope, data_model_scope, data_model_code, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_instruments_properties_with_http_info(self, upsert_instrument_property_request : Annotated[conlist(UpsertInstrumentPropertyRequest), Field(..., description="A list of instruments and associated instrument properties to create or update.")], scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies. When not supplied the scope is 'default'.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertInstrumentsProperties: Upsert instruments properties  # noqa: E501

        Create or update one or more properties for particular instruments.              Each instrument property is updated if it exists and created if it does not. For any failures, a reason is provided.              Properties have an <i>effectiveFrom</i> datetime from which the property is valid, and an <i>effectiveUntil</i> datetime until which the property is valid. Not supplying an <i>effectiveUntil</i> datetime results in the property being valid indefinitely, or until the next <i>effectiveFrom</i> datetime of the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_instruments_properties_with_http_info(upsert_instrument_property_request, scope, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param upsert_instrument_property_request: A list of instruments and associated instrument properties to create or update. (required)
        :type upsert_instrument_property_request: List[UpsertInstrumentPropertyRequest]
        :param scope: The scope in which the instrument lies. When not supplied the scope is 'default'.
        :type scope: str
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertInstrumentPropertiesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'upsert_instrument_property_request',
            'scope',
            'data_model_scope',
            'data_model_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_instruments_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        if _params.get('data_model_scope') is not None:  # noqa: E501
            _query_params.append(('dataModelScope', _params['data_model_scope']))

        if _params.get('data_model_code') is not None:  # noqa: E501
            _query_params.append(('dataModelCode', _params['data_model_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_instrument_property_request'] is not None:
            _body_params = _params['upsert_instrument_property_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "UpsertInstrumentPropertiesResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/instruments/$upsertproperties', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
