# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.order import Order
from lusid.models.order_set_request import OrderSetRequest
from lusid.models.paged_resource_list_of_order import PagedResourceListOfOrder
from lusid.models.resource_list_of_order import ResourceListOfOrder

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class OrdersApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def delete_order(self, scope : Annotated[StrictStr, Field(..., description="The order scope.")], code : Annotated[StrictStr, Field(..., description="The order's code. This, together with the scope uniquely identifies the order to delete.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_order(self, scope : Annotated[StrictStr, Field(..., description="The order scope.")], code : Annotated[StrictStr, Field(..., description="The order's code. This, together with the scope uniquely identifies the order to delete.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_order(self, scope : Annotated[StrictStr, Field(..., description="The order scope.")], code : Annotated[StrictStr, Field(..., description="The order's code. This, together with the scope uniquely identifies the order to delete.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EARLY ACCESS] DeleteOrder: Delete order  # noqa: E501

        Delete an order. Deletion will be valid from the order's creation datetime. This means that the order will no longer exist at any effective datetime from the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_order(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The order scope. (required)
        :type scope: str
        :param code: The order's code. This, together with the scope uniquely identifies the order to delete. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_order_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_order_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_order_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The order scope.")], code : Annotated[StrictStr, Field(..., description="The order's code. This, together with the scope uniquely identifies the order to delete.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeleteOrder: Delete order  # noqa: E501

        Delete an order. Deletion will be valid from the order's creation datetime. This means that the order will no longer exist at any effective datetime from the asAt datetime of deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_order_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The order scope. (required)
        :type scope: str
        :param code: The order's code. This, together with the scope uniquely identifies the order to delete. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_order" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/orders/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_order(self, scope : Annotated[StrictStr, Field(..., description="The scope to which the order belongs.")], code : Annotated[StrictStr, Field(..., description="The order's unique identifier.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Orders\" domain to decorate onto the order.             These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".")] = None, **kwargs) -> Order:  # noqa: E501
        ...

    @overload
    def get_order(self, scope : Annotated[StrictStr, Field(..., description="The scope to which the order belongs.")], code : Annotated[StrictStr, Field(..., description="The order's unique identifier.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Orders\" domain to decorate onto the order.             These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".")] = None, async_req: Optional[bool]=True, **kwargs) -> Order:  # noqa: E501
        ...

    @validate_arguments
    def get_order(self, scope : Annotated[StrictStr, Field(..., description="The scope to which the order belongs.")], code : Annotated[StrictStr, Field(..., description="The order's unique identifier.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Orders\" domain to decorate onto the order.             These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Order, Awaitable[Order]]:  # noqa: E501
        """[EARLY ACCESS] GetOrder: Get Order  # noqa: E501

        Fetch an Order that matches the specified identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_order(scope, code, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope to which the order belongs. (required)
        :type scope: str
        :param code: The order's unique identifier. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the \"Orders\" domain to decorate onto the order.             These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Order
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_order_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_order_with_http_info(scope, code, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_order_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope to which the order belongs.")], code : Annotated[StrictStr, Field(..., description="The order's unique identifier.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Orders\" domain to decorate onto the order.             These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetOrder: Get Order  # noqa: E501

        Fetch an Order that matches the specified identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_order_with_http_info(scope, code, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope to which the order belongs. (required)
        :type scope: str
        :param code: The order's unique identifier. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the \"Orders\" domain to decorate onto the order.             These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Order, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Order",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/orders/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_orders(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing orders from a previous call to list orders.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields             must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Orders\" domain to decorate onto each order.                 These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".                 All properties, except derived properties, are returned by default, without specifying here.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, membership_type : Annotated[Optional[StrictStr], Field( description="The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.")] = None, **kwargs) -> PagedResourceListOfOrder:  # noqa: E501
        ...

    @overload
    def list_orders(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing orders from a previous call to list orders.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields             must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Orders\" domain to decorate onto each order.                 These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".                 All properties, except derived properties, are returned by default, without specifying here.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, membership_type : Annotated[Optional[StrictStr], Field( description="The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfOrder:  # noqa: E501
        ...

    @validate_arguments
    def list_orders(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing orders from a previous call to list orders.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields             must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Orders\" domain to decorate onto each order.                 These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".                 All properties, except derived properties, are returned by default, without specifying here.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, membership_type : Annotated[Optional[StrictStr], Field( description="The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfOrder, Awaitable[PagedResourceListOfOrder]]:  # noqa: E501
        """ListOrders: List Orders  # noqa: E501

        Fetch the last pre-AsAt date version of each order with optional filtering (does not fetch the entire history).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_orders(as_at, page, sort_by, limit, filter, property_keys, data_model_scope, data_model_code, membership_type, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing orders from a previous call to list orders.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields             must not have changed since the original request.
        :type page: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param property_keys: A list of property keys from the \"Orders\" domain to decorate onto each order.                 These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".                 All properties, except derived properties, are returned by default, without specifying here.
        :type property_keys: List[str]
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param membership_type: The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.
        :type membership_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfOrder
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_orders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_orders_with_http_info(as_at, page, sort_by, limit, filter, property_keys, data_model_scope, data_model_code, membership_type, **kwargs)  # noqa: E501

    @validate_arguments
    def list_orders_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing orders from a previous call to list orders.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields             must not have changed since the original request.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the \"Orders\" domain to decorate onto each order.                 These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".                 All properties, except derived properties, are returned by default, without specifying here.")] = None, data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, membership_type : Annotated[Optional[StrictStr], Field( description="The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListOrders: List Orders  # noqa: E501

        Fetch the last pre-AsAt date version of each order with optional filtering (does not fetch the entire history).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_orders_with_http_info(as_at, page, sort_by, limit, filter, property_keys, data_model_scope, data_model_code, membership_type, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the order. Defaults to return the latest version of the order if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing orders from a previous call to list orders.             This value is returned from the previous call. If a pagination token is provided the sortBy, filter, effectiveAt, and asAt fields             must not have changed since the original request.
        :type page: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\".
        :type sort_by: List[str]
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param property_keys: A list of property keys from the \"Orders\" domain to decorate onto each order.                 These take the format {domain}/{scope}/{code} e.g. \"Orders/system/Name\".                 All properties, except derived properties, are returned by default, without specifying here.
        :type property_keys: List[str]
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param membership_type: The membership types of the specified Custom Data Model to return. Allowable values are Member, Candidate and All. Defaults to Member.
        :type membership_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfOrder, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'sort_by',
            'limit',
            'filter',
            'property_keys',
            'data_model_scope',
            'data_model_code',
            'membership_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_orders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('data_model_scope') is not None:  # noqa: E501
            _query_params.append(('dataModelScope', _params['data_model_scope']))

        if _params.get('data_model_code') is not None:  # noqa: E501
            _query_params.append(('dataModelCode', _params['data_model_code']))

        if _params.get('membership_type') is not None:  # noqa: E501
            _query_params.append(('membershipType', _params['membership_type']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfOrder",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/orders', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_orders(self, order_set_request : Annotated[OrderSetRequest, Field(..., description="The collection of order requests.")], data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> ResourceListOfOrder:  # noqa: E501
        ...

    @overload
    def upsert_orders(self, order_set_request : Annotated[OrderSetRequest, Field(..., description="The collection of order requests.")], data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfOrder:  # noqa: E501
        ...

    @validate_arguments
    def upsert_orders(self, order_set_request : Annotated[OrderSetRequest, Field(..., description="The collection of order requests.")], data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfOrder, Awaitable[ResourceListOfOrder]]:  # noqa: E501
        """UpsertOrders: Upsert Order  # noqa: E501

        Upsert; update existing orders with given ids, or create new orders otherwise.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_orders(order_set_request, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param order_set_request: The collection of order requests. (required)
        :type order_set_request: OrderSetRequest
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfOrder
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_orders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_orders_with_http_info(order_set_request, data_model_scope, data_model_code, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_orders_with_http_info(self, order_set_request : Annotated[OrderSetRequest, Field(..., description="The collection of order requests.")], data_model_scope : Annotated[Optional[StrictStr], Field( description="The optional scope of a Custom Data Model to use")] = None, data_model_code : Annotated[Optional[StrictStr], Field( description="The optional code of a Custom Data Model to use")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertOrders: Upsert Order  # noqa: E501

        Upsert; update existing orders with given ids, or create new orders otherwise.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_orders_with_http_info(order_set_request, data_model_scope, data_model_code, async_req=True)
        >>> result = thread.get()

        :param order_set_request: The collection of order requests. (required)
        :type order_set_request: OrderSetRequest
        :param data_model_scope: The optional scope of a Custom Data Model to use
        :type data_model_scope: str
        :param data_model_code: The optional code of a Custom Data Model to use
        :type data_model_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfOrder, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'order_set_request',
            'data_model_scope',
            'data_model_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_orders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('data_model_scope') is not None:  # noqa: E501
            _query_params.append(('dataModelScope', _params['data_model_scope']))

        if _params.get('data_model_code') is not None:  # noqa: E501
            _query_params.append(('dataModelCode', _params['data_model_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['order_set_request'] is not None:
            _body_params = _params['order_set_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "ResourceListOfOrder",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/orders', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
