# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, conlist, constr, validator

from typing import Dict, Optional

from lusid.models.batch_upsert_property_definition_properties_response import BatchUpsertPropertyDefinitionPropertiesResponse
from lusid.models.create_derived_property_definition_request import CreateDerivedPropertyDefinitionRequest
from lusid.models.create_property_definition_request import CreatePropertyDefinitionRequest
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.model_property import ModelProperty
from lusid.models.paged_resource_list_of_property_definition import PagedResourceListOfPropertyDefinition
from lusid.models.property_definition import PropertyDefinition
from lusid.models.resource_list_of_property_definition import ResourceListOfPropertyDefinition
from lusid.models.resource_list_of_property_interval import ResourceListOfPropertyInterval
from lusid.models.update_derived_property_definition_request import UpdateDerivedPropertyDefinitionRequest
from lusid.models.update_property_definition_request import UpdatePropertyDefinitionRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class PropertyDefinitionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_derived_property_definition(self, create_derived_property_definition_request : Annotated[CreateDerivedPropertyDefinitionRequest, Field(..., description="The definition of the new derived property.")], **kwargs) -> PropertyDefinition:  # noqa: E501
        ...

    @overload
    def create_derived_property_definition(self, create_derived_property_definition_request : Annotated[CreateDerivedPropertyDefinitionRequest, Field(..., description="The definition of the new derived property.")], async_req: Optional[bool]=True, **kwargs) -> PropertyDefinition:  # noqa: E501
        ...

    @validate_arguments
    def create_derived_property_definition(self, create_derived_property_definition_request : Annotated[CreateDerivedPropertyDefinitionRequest, Field(..., description="The definition of the new derived property.")], async_req: Optional[bool]=None, **kwargs) -> Union[PropertyDefinition, Awaitable[PropertyDefinition]]:  # noqa: E501
        """[EARLY ACCESS] CreateDerivedPropertyDefinition: Create derived property definition  # noqa: E501

        Define a new derived property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_derived_property_definition(create_derived_property_definition_request, async_req=True)
        >>> result = thread.get()

        :param create_derived_property_definition_request: The definition of the new derived property. (required)
        :type create_derived_property_definition_request: CreateDerivedPropertyDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PropertyDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_derived_property_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_derived_property_definition_with_http_info(create_derived_property_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_derived_property_definition_with_http_info(self, create_derived_property_definition_request : Annotated[CreateDerivedPropertyDefinitionRequest, Field(..., description="The definition of the new derived property.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CreateDerivedPropertyDefinition: Create derived property definition  # noqa: E501

        Define a new derived property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_derived_property_definition_with_http_info(create_derived_property_definition_request, async_req=True)
        >>> result = thread.get()

        :param create_derived_property_definition_request: The definition of the new derived property. (required)
        :type create_derived_property_definition_request: CreateDerivedPropertyDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PropertyDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_derived_property_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_derived_property_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_derived_property_definition_request'] is not None:
            _body_params = _params['create_derived_property_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "PropertyDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions/derived', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def create_property_definition(self, create_property_definition_request : Annotated[CreatePropertyDefinitionRequest, Field(..., description="The definition of the new property.")], **kwargs) -> PropertyDefinition:  # noqa: E501
        ...

    @overload
    def create_property_definition(self, create_property_definition_request : Annotated[CreatePropertyDefinitionRequest, Field(..., description="The definition of the new property.")], async_req: Optional[bool]=True, **kwargs) -> PropertyDefinition:  # noqa: E501
        ...

    @validate_arguments
    def create_property_definition(self, create_property_definition_request : Annotated[CreatePropertyDefinitionRequest, Field(..., description="The definition of the new property.")], async_req: Optional[bool]=None, **kwargs) -> Union[PropertyDefinition, Awaitable[PropertyDefinition]]:  # noqa: E501
        """CreatePropertyDefinition: Create property definition  # noqa: E501

        Define a new property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_property_definition(create_property_definition_request, async_req=True)
        >>> result = thread.get()

        :param create_property_definition_request: The definition of the new property. (required)
        :type create_property_definition_request: CreatePropertyDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PropertyDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_property_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_property_definition_with_http_info(create_property_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_property_definition_with_http_info(self, create_property_definition_request : Annotated[CreatePropertyDefinitionRequest, Field(..., description="The definition of the new property.")], **kwargs) -> ApiResponse:  # noqa: E501
        """CreatePropertyDefinition: Create property definition  # noqa: E501

        Define a new property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_property_definition_with_http_info(create_property_definition_request, async_req=True)
        >>> result = thread.get()

        :param create_property_definition_request: The definition of the new property. (required)
        :type create_property_definition_request: CreatePropertyDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PropertyDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_property_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_property_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_property_definition_request'] is not None:
            _body_params = _params['create_property_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "PropertyDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_property_definition(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property to be deleted.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the property to be deleted. Together with the domain and scope this uniquely             identifies the property.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_property_definition(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property to be deleted.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the property to be deleted. Together with the domain and scope this uniquely             identifies the property.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_property_definition(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property to be deleted.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the property to be deleted. Together with the domain and scope this uniquely             identifies the property.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """DeletePropertyDefinition: Delete property definition  # noqa: E501

        Delete the definition of the specified property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_property_definition(domain, scope, code, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the property to be deleted. (required)
        :type domain: str
        :param scope: The scope of the property to be deleted. (required)
        :type scope: str
        :param code: The code of the property to be deleted. Together with the domain and scope this uniquely             identifies the property. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_property_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_property_definition_with_http_info(domain, scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_property_definition_with_http_info(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property to be deleted.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the property to be deleted. Together with the domain and scope this uniquely             identifies the property.")], **kwargs) -> ApiResponse:  # noqa: E501
        """DeletePropertyDefinition: Delete property definition  # noqa: E501

        Delete the definition of the specified property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_property_definition_with_http_info(domain, scope, code, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the property to be deleted. (required)
        :type domain: str
        :param scope: The scope of the property to be deleted. (required)
        :type scope: str
        :param code: The code of the property to be deleted. Together with the domain and scope this uniquely             identifies the property. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'domain',
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_property_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['domain']:
            _path_params['domain'] = _params['domain']

        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions/{domain}/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_property_definition_properties(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property definition to delete properties from.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property definition to delete properties from.")], code : Annotated[StrictStr, Field(..., description="The code of the property definition to delete properties from.")], request_body : Annotated[conlist(StrictStr), Field(..., description="The property keys of the properties to delete. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is before             the time-variant property exists then a failure is returned. Do not specify this parameter if an of the properties to delete are perpetual.")] = None, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_property_definition_properties(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property definition to delete properties from.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property definition to delete properties from.")], code : Annotated[StrictStr, Field(..., description="The code of the property definition to delete properties from.")], request_body : Annotated[conlist(StrictStr), Field(..., description="The property keys of the properties to delete. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is before             the time-variant property exists then a failure is returned. Do not specify this parameter if an of the properties to delete are perpetual.")] = None, async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_property_definition_properties(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property definition to delete properties from.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property definition to delete properties from.")], code : Annotated[StrictStr, Field(..., description="The code of the property definition to delete properties from.")], request_body : Annotated[conlist(StrictStr), Field(..., description="The property keys of the properties to delete. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is before             the time-variant property exists then a failure is returned. Do not specify this parameter if an of the properties to delete are perpetual.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EARLY ACCESS] DeletePropertyDefinitionProperties: Delete property definition properties  # noqa: E501

        Delete one or more properties from a single property definition. If the properties are time-variant then an effective date time from which the properties will be deleted must be specified. If the properties are perpetual then it is invalid to specify an effective date time for deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_property_definition_properties(domain, scope, code, request_body, effective_at, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the property definition to delete properties from. (required)
        :type domain: str
        :param scope: The scope of the property definition to delete properties from. (required)
        :type scope: str
        :param code: The code of the property definition to delete properties from. (required)
        :type code: str
        :param request_body: The property keys of the properties to delete. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain. (required)
        :type request_body: List[str]
        :param effective_at: The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is before             the time-variant property exists then a failure is returned. Do not specify this parameter if an of the properties to delete are perpetual.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_property_definition_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_property_definition_properties_with_http_info(domain, scope, code, request_body, effective_at, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_property_definition_properties_with_http_info(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property definition to delete properties from.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property definition to delete properties from.")], code : Annotated[StrictStr, Field(..., description="The code of the property definition to delete properties from.")], request_body : Annotated[conlist(StrictStr), Field(..., description="The property keys of the properties to delete. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is before             the time-variant property exists then a failure is returned. Do not specify this parameter if an of the properties to delete are perpetual.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeletePropertyDefinitionProperties: Delete property definition properties  # noqa: E501

        Delete one or more properties from a single property definition. If the properties are time-variant then an effective date time from which the properties will be deleted must be specified. If the properties are perpetual then it is invalid to specify an effective date time for deletion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_property_definition_properties_with_http_info(domain, scope, code, request_body, effective_at, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the property definition to delete properties from. (required)
        :type domain: str
        :param scope: The scope of the property definition to delete properties from. (required)
        :type scope: str
        :param code: The code of the property definition to delete properties from. (required)
        :type code: str
        :param request_body: The property keys of the properties to delete. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain. (required)
        :type request_body: List[str]
        :param effective_at: The effective datetime or cut label at which to delete time-variant properties from.             The property must exist at the specified 'effectiveAt' datetime. If the 'effectiveAt' is not provided or is before             the time-variant property exists then a failure is returned. Do not specify this parameter if an of the properties to delete are perpetual.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'domain',
            'scope',
            'code',
            'request_body',
            'effective_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_property_definition_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['domain']:
            _path_params['domain'] = _params['domain']

        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions/{domain}/{scope}/{code}/properties/$delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_multiple_property_definitions(self, property_keys : Annotated[conlist(StrictStr), Field(..., description="One or more property keys which identify each property that a definition should             be retrieved for. The format for each property key is {domain}/{scope}/{code}, e.g. 'Portfolio/Manager/Id'.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definitions. Defaults to return             the latest version of each definition if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              For example, to filter on the Lifetime, use \"lifeTime eq 'Perpetual'\"             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.")] = None, **kwargs) -> ResourceListOfPropertyDefinition:  # noqa: E501
        ...

    @overload
    def get_multiple_property_definitions(self, property_keys : Annotated[conlist(StrictStr), Field(..., description="One or more property keys which identify each property that a definition should             be retrieved for. The format for each property key is {domain}/{scope}/{code}, e.g. 'Portfolio/Manager/Id'.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definitions. Defaults to return             the latest version of each definition if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              For example, to filter on the Lifetime, use \"lifeTime eq 'Perpetual'\"             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfPropertyDefinition:  # noqa: E501
        ...

    @validate_arguments
    def get_multiple_property_definitions(self, property_keys : Annotated[conlist(StrictStr), Field(..., description="One or more property keys which identify each property that a definition should             be retrieved for. The format for each property key is {domain}/{scope}/{code}, e.g. 'Portfolio/Manager/Id'.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definitions. Defaults to return             the latest version of each definition if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              For example, to filter on the Lifetime, use \"lifeTime eq 'Perpetual'\"             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfPropertyDefinition, Awaitable[ResourceListOfPropertyDefinition]]:  # noqa: E501
        """GetMultiplePropertyDefinitions: Get multiple property definitions  # noqa: E501

        Retrieve the definition of one or more specified properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_multiple_property_definitions(property_keys, as_at, filter, effective_at, async_req=True)
        >>> result = thread.get()

        :param property_keys: One or more property keys which identify each property that a definition should             be retrieved for. The format for each property key is {domain}/{scope}/{code}, e.g. 'Portfolio/Manager/Id'. (required)
        :type property_keys: List[str]
        :param as_at: The asAt datetime at which to retrieve the property definitions. Defaults to return             the latest version of each definition if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the result set.              For example, to filter on the Lifetime, use \"lifeTime eq 'Perpetual'\"             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param effective_at: The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfPropertyDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_multiple_property_definitions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_multiple_property_definitions_with_http_info(property_keys, as_at, filter, effective_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_multiple_property_definitions_with_http_info(self, property_keys : Annotated[conlist(StrictStr), Field(..., description="One or more property keys which identify each property that a definition should             be retrieved for. The format for each property key is {domain}/{scope}/{code}, e.g. 'Portfolio/Manager/Id'.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definitions. Defaults to return             the latest version of each definition if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.              For example, to filter on the Lifetime, use \"lifeTime eq 'Perpetual'\"             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetMultiplePropertyDefinitions: Get multiple property definitions  # noqa: E501

        Retrieve the definition of one or more specified properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_multiple_property_definitions_with_http_info(property_keys, as_at, filter, effective_at, async_req=True)
        >>> result = thread.get()

        :param property_keys: One or more property keys which identify each property that a definition should             be retrieved for. The format for each property key is {domain}/{scope}/{code}, e.g. 'Portfolio/Manager/Id'. (required)
        :type property_keys: List[str]
        :param as_at: The asAt datetime at which to retrieve the property definitions. Defaults to return             the latest version of each definition if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the result set.              For example, to filter on the Lifetime, use \"lifeTime eq 'Perpetual'\"             Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param effective_at: The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfPropertyDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'property_keys',
            'as_at',
            'filter',
            'effective_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_multiple_property_definitions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfPropertyDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_property_definition(self, domain : Annotated[StrictStr, Field(..., description="The domain of the specified property.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified property.")], code : Annotated[StrictStr, Field(..., description="The code of the specified property. Together with the domain and scope this uniquely             identifies the property.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.")] = None, **kwargs) -> PropertyDefinition:  # noqa: E501
        ...

    @overload
    def get_property_definition(self, domain : Annotated[StrictStr, Field(..., description="The domain of the specified property.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified property.")], code : Annotated[StrictStr, Field(..., description="The code of the specified property. Together with the domain and scope this uniquely             identifies the property.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> PropertyDefinition:  # noqa: E501
        ...

    @validate_arguments
    def get_property_definition(self, domain : Annotated[StrictStr, Field(..., description="The domain of the specified property.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified property.")], code : Annotated[StrictStr, Field(..., description="The code of the specified property. Together with the domain and scope this uniquely             identifies the property.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PropertyDefinition, Awaitable[PropertyDefinition]]:  # noqa: E501
        """GetPropertyDefinition: Get property definition  # noqa: E501

        Retrieve the definition of a specified property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_property_definition(domain, scope, code, as_at, effective_at, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the specified property. (required)
        :type domain: str
        :param scope: The scope of the specified property. (required)
        :type scope: str
        :param code: The code of the specified property. Together with the domain and scope this uniquely             identifies the property. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the property definition. Defaults to return             the latest version of the definition if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PropertyDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_property_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_property_definition_with_http_info(domain, scope, code, as_at, effective_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_property_definition_with_http_info(self, domain : Annotated[StrictStr, Field(..., description="The domain of the specified property.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified property.")], code : Annotated[StrictStr, Field(..., description="The code of the specified property. Together with the domain and scope this uniquely             identifies the property.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the property definition. Defaults to return             the latest version of the definition if not specified.")] = None, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetPropertyDefinition: Get property definition  # noqa: E501

        Retrieve the definition of a specified property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_property_definition_with_http_info(domain, scope, code, as_at, effective_at, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the specified property. (required)
        :type domain: str
        :param scope: The scope of the specified property. (required)
        :type scope: str
        :param code: The code of the specified property. Together with the domain and scope this uniquely             identifies the property. (required)
        :type code: str
        :param as_at: The asAt datetime at which to retrieve the property definition. Defaults to return             the latest version of the definition if not specified.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to list properties attached to the Property Definition.             Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PropertyDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'domain',
            'scope',
            'code',
            'as_at',
            'effective_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_property_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['domain']:
            _path_params['domain'] = _params['domain']

        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PropertyDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions/{domain}/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_property_definition_property_time_series(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property definition to which the property is attached")], scope : Annotated[StrictStr, Field(..., description="The scope of the property definition to which the property is attached")], code : Annotated[StrictStr, Field(..., description="The code of the property definition to which the property is attached")], property_key : Annotated[StrictStr, Field(..., description="The property key of the property whose history to show. This must be from the \"Property Definition\" domain and in the format             {domain}/{scope}/{code}, for example \"PropertyDefinition/myScope/someAttributeKey\".")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to show the history. Defaults to the current datetime if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties from a previous call to get property time series.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, **kwargs) -> ResourceListOfPropertyInterval:  # noqa: E501
        ...

    @overload
    def get_property_definition_property_time_series(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property definition to which the property is attached")], scope : Annotated[StrictStr, Field(..., description="The scope of the property definition to which the property is attached")], code : Annotated[StrictStr, Field(..., description="The code of the property definition to which the property is attached")], property_key : Annotated[StrictStr, Field(..., description="The property key of the property whose history to show. This must be from the \"Property Definition\" domain and in the format             {domain}/{scope}/{code}, for example \"PropertyDefinition/myScope/someAttributeKey\".")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to show the history. Defaults to the current datetime if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties from a previous call to get property time series.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfPropertyInterval:  # noqa: E501
        ...

    @validate_arguments
    def get_property_definition_property_time_series(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property definition to which the property is attached")], scope : Annotated[StrictStr, Field(..., description="The scope of the property definition to which the property is attached")], code : Annotated[StrictStr, Field(..., description="The code of the property definition to which the property is attached")], property_key : Annotated[StrictStr, Field(..., description="The property key of the property whose history to show. This must be from the \"Property Definition\" domain and in the format             {domain}/{scope}/{code}, for example \"PropertyDefinition/myScope/someAttributeKey\".")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to show the history. Defaults to the current datetime if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties from a previous call to get property time series.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfPropertyInterval, Awaitable[ResourceListOfPropertyInterval]]:  # noqa: E501
        """[EARLY ACCESS] GetPropertyDefinitionPropertyTimeSeries: Get Property Definition Property Time Series  # noqa: E501

        List the complete time series of a property definition property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_property_definition_property_time_series(domain, scope, code, property_key, as_at, filter, page, limit, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the property definition to which the property is attached (required)
        :type domain: str
        :param scope: The scope of the property definition to which the property is attached (required)
        :type scope: str
        :param code: The code of the property definition to which the property is attached (required)
        :type code: str
        :param property_key: The property key of the property whose history to show. This must be from the \"Property Definition\" domain and in the format             {domain}/{scope}/{code}, for example \"PropertyDefinition/myScope/someAttributeKey\". (required)
        :type property_key: str
        :param as_at: The asAt datetime at which to show the history. Defaults to the current datetime if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the results. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param page: The pagination token to use to continue listing properties from a previous call to get property time series.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfPropertyInterval
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_property_definition_property_time_series_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_property_definition_property_time_series_with_http_info(domain, scope, code, property_key, as_at, filter, page, limit, **kwargs)  # noqa: E501

    @validate_arguments
    def get_property_definition_property_time_series_with_http_info(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property definition to which the property is attached")], scope : Annotated[StrictStr, Field(..., description="The scope of the property definition to which the property is attached")], code : Annotated[StrictStr, Field(..., description="The code of the property definition to which the property is attached")], property_key : Annotated[StrictStr, Field(..., description="The property key of the property whose history to show. This must be from the \"Property Definition\" domain and in the format             {domain}/{scope}/{code}, for example \"PropertyDefinition/myScope/someAttributeKey\".")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to show the history. Defaults to the current datetime if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing properties from a previous call to get property time series.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetPropertyDefinitionPropertyTimeSeries: Get Property Definition Property Time Series  # noqa: E501

        List the complete time series of a property definition property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_property_definition_property_time_series_with_http_info(domain, scope, code, property_key, as_at, filter, page, limit, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the property definition to which the property is attached (required)
        :type domain: str
        :param scope: The scope of the property definition to which the property is attached (required)
        :type scope: str
        :param code: The code of the property definition to which the property is attached (required)
        :type code: str
        :param property_key: The property key of the property whose history to show. This must be from the \"Property Definition\" domain and in the format             {domain}/{scope}/{code}, for example \"PropertyDefinition/myScope/someAttributeKey\". (required)
        :type property_key: str
        :param as_at: The asAt datetime at which to show the history. Defaults to the current datetime if not specified.
        :type as_at: datetime
        :param filter: Expression to filter the results. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param page: The pagination token to use to continue listing properties from a previous call to get property time series.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfPropertyInterval, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'domain',
            'scope',
            'code',
            'property_key',
            'as_at',
            'filter',
            'page',
            'limit'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_property_definition_property_time_series" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['domain']:
            _path_params['domain'] = _params['domain']

        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('property_key') is not None:  # noqa: E501
            _query_params.append(('propertyKey', _params['property_key']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfPropertyInterval",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions/{domain}/{scope}/{code}/properties/time-series', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_property_definitions(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the property definitions. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the property definitions. Defaults to returning the latest version             of each property definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Property Definition' domain to decorate onto             property definitions. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing property definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the display name, specify \"DisplayName eq 'DisplayName'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, **kwargs) -> PagedResourceListOfPropertyDefinition:  # noqa: E501
        ...

    @overload
    def list_property_definitions(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the property definitions. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the property definitions. Defaults to returning the latest version             of each property definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Property Definition' domain to decorate onto             property definitions. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing property definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the display name, specify \"DisplayName eq 'DisplayName'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfPropertyDefinition:  # noqa: E501
        ...

    @validate_arguments
    def list_property_definitions(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the property definitions. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the property definitions. Defaults to returning the latest version             of each property definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Property Definition' domain to decorate onto             property definitions. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing property definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the display name, specify \"DisplayName eq 'DisplayName'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfPropertyDefinition, Awaitable[PagedResourceListOfPropertyDefinition]]:  # noqa: E501
        """ListPropertyDefinitions: List property definitions  # noqa: E501

        List all the property definitions matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_property_definitions(effective_at, as_at, property_keys, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the property definitions. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the property definitions. Defaults to returning the latest version             of each property definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Property Definition' domain to decorate onto             property definitions. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain.
        :type property_keys: List[str]
        :param page: The pagination token to use to continue listing property definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the display name, specify \"DisplayName eq 'DisplayName'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfPropertyDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_property_definitions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_property_definitions_with_http_info(effective_at, as_at, property_keys, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_property_definitions_with_http_info(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the property definitions. Defaults to the current LUSID             system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the property definitions. Defaults to returning the latest version             of each property definition if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Property Definition' domain to decorate onto             property definitions. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing property definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.             For example, to filter on the display name, specify \"DisplayName eq 'DisplayName'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListPropertyDefinitions: List property definitions  # noqa: E501

        List all the property definitions matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_property_definitions_with_http_info(effective_at, as_at, property_keys, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the property definitions. Defaults to the current LUSID             system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the property definitions. Defaults to returning the latest version             of each property definition if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Property Definition' domain to decorate onto             property definitions. These must take the format             {domain}/{scope}/{code} e.g \"PropertyDefinition/myScope/someAttributeKey\". Each property must be from the \"PropertyDefinition\" domain.
        :type property_keys: List[str]
        :param page: The pagination token to use to continue listing property definitions; this             value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt             and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.             For example, to filter on the display name, specify \"DisplayName eq 'DisplayName'\". For more information about filtering             results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfPropertyDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'effective_at',
            'as_at',
            'property_keys',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_property_definitions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfPropertyDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions/$list', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_derived_property_definition(self, domain : Annotated[StrictStr, Field(..., description="Domain of the property definition")], scope : Annotated[StrictStr, Field(..., description="Scope of the property definition")], code : Annotated[StrictStr, Field(..., description="Code of the property definition")], update_derived_property_definition_request : Annotated[UpdateDerivedPropertyDefinitionRequest, Field(..., description="Information about the derived property definition being updated")], **kwargs) -> PropertyDefinition:  # noqa: E501
        ...

    @overload
    def update_derived_property_definition(self, domain : Annotated[StrictStr, Field(..., description="Domain of the property definition")], scope : Annotated[StrictStr, Field(..., description="Scope of the property definition")], code : Annotated[StrictStr, Field(..., description="Code of the property definition")], update_derived_property_definition_request : Annotated[UpdateDerivedPropertyDefinitionRequest, Field(..., description="Information about the derived property definition being updated")], async_req: Optional[bool]=True, **kwargs) -> PropertyDefinition:  # noqa: E501
        ...

    @validate_arguments
    def update_derived_property_definition(self, domain : Annotated[StrictStr, Field(..., description="Domain of the property definition")], scope : Annotated[StrictStr, Field(..., description="Scope of the property definition")], code : Annotated[StrictStr, Field(..., description="Code of the property definition")], update_derived_property_definition_request : Annotated[UpdateDerivedPropertyDefinitionRequest, Field(..., description="Information about the derived property definition being updated")], async_req: Optional[bool]=None, **kwargs) -> Union[PropertyDefinition, Awaitable[PropertyDefinition]]:  # noqa: E501
        """[EARLY ACCESS] UpdateDerivedPropertyDefinition: Update a pre-existing derived property definition  # noqa: E501

        This will fail if the property definition does not exist  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_derived_property_definition(domain, scope, code, update_derived_property_definition_request, async_req=True)
        >>> result = thread.get()

        :param domain: Domain of the property definition (required)
        :type domain: str
        :param scope: Scope of the property definition (required)
        :type scope: str
        :param code: Code of the property definition (required)
        :type code: str
        :param update_derived_property_definition_request: Information about the derived property definition being updated (required)
        :type update_derived_property_definition_request: UpdateDerivedPropertyDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PropertyDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_derived_property_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_derived_property_definition_with_http_info(domain, scope, code, update_derived_property_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_derived_property_definition_with_http_info(self, domain : Annotated[StrictStr, Field(..., description="Domain of the property definition")], scope : Annotated[StrictStr, Field(..., description="Scope of the property definition")], code : Annotated[StrictStr, Field(..., description="Code of the property definition")], update_derived_property_definition_request : Annotated[UpdateDerivedPropertyDefinitionRequest, Field(..., description="Information about the derived property definition being updated")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateDerivedPropertyDefinition: Update a pre-existing derived property definition  # noqa: E501

        This will fail if the property definition does not exist  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_derived_property_definition_with_http_info(domain, scope, code, update_derived_property_definition_request, async_req=True)
        >>> result = thread.get()

        :param domain: Domain of the property definition (required)
        :type domain: str
        :param scope: Scope of the property definition (required)
        :type scope: str
        :param code: Code of the property definition (required)
        :type code: str
        :param update_derived_property_definition_request: Information about the derived property definition being updated (required)
        :type update_derived_property_definition_request: UpdateDerivedPropertyDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PropertyDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'domain',
            'scope',
            'code',
            'update_derived_property_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_derived_property_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['domain']:
            _path_params['domain'] = _params['domain']

        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_derived_property_definition_request'] is not None:
            _body_params = _params['update_derived_property_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PropertyDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions/derived/{domain}/{scope}/{code}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_property_definition(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property being updated.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property being updated.")], code : Annotated[StrictStr, Field(..., description="The code of the property being updated. Together with the domain and scope this uniquely             identifies the property.")], update_property_definition_request : Annotated[UpdatePropertyDefinitionRequest, Field(..., description="The updated definition of the property.")], **kwargs) -> PropertyDefinition:  # noqa: E501
        ...

    @overload
    def update_property_definition(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property being updated.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property being updated.")], code : Annotated[StrictStr, Field(..., description="The code of the property being updated. Together with the domain and scope this uniquely             identifies the property.")], update_property_definition_request : Annotated[UpdatePropertyDefinitionRequest, Field(..., description="The updated definition of the property.")], async_req: Optional[bool]=True, **kwargs) -> PropertyDefinition:  # noqa: E501
        ...

    @validate_arguments
    def update_property_definition(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property being updated.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property being updated.")], code : Annotated[StrictStr, Field(..., description="The code of the property being updated. Together with the domain and scope this uniquely             identifies the property.")], update_property_definition_request : Annotated[UpdatePropertyDefinitionRequest, Field(..., description="The updated definition of the property.")], async_req: Optional[bool]=None, **kwargs) -> Union[PropertyDefinition, Awaitable[PropertyDefinition]]:  # noqa: E501
        """UpdatePropertyDefinition: Update property definition  # noqa: E501

        Update the definition of a specified existing property. Not all elements within a property definition are modifiable due to the potential implications for values already stored against the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_property_definition(domain, scope, code, update_property_definition_request, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the property being updated. (required)
        :type domain: str
        :param scope: The scope of the property being updated. (required)
        :type scope: str
        :param code: The code of the property being updated. Together with the domain and scope this uniquely             identifies the property. (required)
        :type code: str
        :param update_property_definition_request: The updated definition of the property. (required)
        :type update_property_definition_request: UpdatePropertyDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PropertyDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_property_definition_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_property_definition_with_http_info(domain, scope, code, update_property_definition_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_property_definition_with_http_info(self, domain : Annotated[StrictStr, Field(..., description="The domain of the property being updated.")], scope : Annotated[StrictStr, Field(..., description="The scope of the property being updated.")], code : Annotated[StrictStr, Field(..., description="The code of the property being updated. Together with the domain and scope this uniquely             identifies the property.")], update_property_definition_request : Annotated[UpdatePropertyDefinitionRequest, Field(..., description="The updated definition of the property.")], **kwargs) -> ApiResponse:  # noqa: E501
        """UpdatePropertyDefinition: Update property definition  # noqa: E501

        Update the definition of a specified existing property. Not all elements within a property definition are modifiable due to the potential implications for values already stored against the property.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_property_definition_with_http_info(domain, scope, code, update_property_definition_request, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the property being updated. (required)
        :type domain: str
        :param scope: The scope of the property being updated. (required)
        :type scope: str
        :param code: The code of the property being updated. Together with the domain and scope this uniquely             identifies the property. (required)
        :type code: str
        :param update_property_definition_request: The updated definition of the property. (required)
        :type update_property_definition_request: UpdatePropertyDefinitionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PropertyDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'domain',
            'scope',
            'code',
            'update_property_definition_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_property_definition" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['domain']:
            _path_params['domain'] = _params['domain']

        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_property_definition_request'] is not None:
            _body_params = _params['update_property_definition_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PropertyDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions/{domain}/{scope}/{code}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_property_definition_properties(self, domain : Annotated[StrictStr, Field(..., description="The domain of the specified property.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified property.")], code : Annotated[StrictStr, Field(..., description="The code of the specified property. Together with the domain and scope this uniquely")], request_body : Annotated[Dict[str, ModelProperty], Field(..., description="The properties to be created or updated. Each property in             the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code}, for example             'PropertyDefinition/Manager/Id'.")], success_mode : Annotated[Optional[StrictStr], Field( description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")] = None, **kwargs) -> BatchUpsertPropertyDefinitionPropertiesResponse:  # noqa: E501
        ...

    @overload
    def upsert_property_definition_properties(self, domain : Annotated[StrictStr, Field(..., description="The domain of the specified property.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified property.")], code : Annotated[StrictStr, Field(..., description="The code of the specified property. Together with the domain and scope this uniquely")], request_body : Annotated[Dict[str, ModelProperty], Field(..., description="The properties to be created or updated. Each property in             the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code}, for example             'PropertyDefinition/Manager/Id'.")], success_mode : Annotated[Optional[StrictStr], Field( description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")] = None, async_req: Optional[bool]=True, **kwargs) -> BatchUpsertPropertyDefinitionPropertiesResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_property_definition_properties(self, domain : Annotated[StrictStr, Field(..., description="The domain of the specified property.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified property.")], code : Annotated[StrictStr, Field(..., description="The code of the specified property. Together with the domain and scope this uniquely")], request_body : Annotated[Dict[str, ModelProperty], Field(..., description="The properties to be created or updated. Each property in             the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code}, for example             'PropertyDefinition/Manager/Id'.")], success_mode : Annotated[Optional[StrictStr], Field( description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[BatchUpsertPropertyDefinitionPropertiesResponse, Awaitable[BatchUpsertPropertyDefinitionPropertiesResponse]]:  # noqa: E501
        """UpsertPropertyDefinitionProperties: Upsert properties to a property definition  # noqa: E501

        Create or update properties for a particular property definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_property_definition_properties(domain, scope, code, request_body, success_mode, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the specified property. (required)
        :type domain: str
        :param scope: The scope of the specified property. (required)
        :type scope: str
        :param code: The code of the specified property. Together with the domain and scope this uniquely (required)
        :type code: str
        :param request_body: The properties to be created or updated. Each property in             the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code}, for example             'PropertyDefinition/Manager/Id'. (required)
        :type request_body: Dict[str, ModelProperty]
        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.
        :type success_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BatchUpsertPropertyDefinitionPropertiesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_property_definition_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_property_definition_properties_with_http_info(domain, scope, code, request_body, success_mode, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_property_definition_properties_with_http_info(self, domain : Annotated[StrictStr, Field(..., description="The domain of the specified property.")], scope : Annotated[StrictStr, Field(..., description="The scope of the specified property.")], code : Annotated[StrictStr, Field(..., description="The code of the specified property. Together with the domain and scope this uniquely")], request_body : Annotated[Dict[str, ModelProperty], Field(..., description="The properties to be created or updated. Each property in             the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code}, for example             'PropertyDefinition/Manager/Id'.")], success_mode : Annotated[Optional[StrictStr], Field( description="Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertPropertyDefinitionProperties: Upsert properties to a property definition  # noqa: E501

        Create or update properties for a particular property definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_property_definition_properties_with_http_info(domain, scope, code, request_body, success_mode, async_req=True)
        >>> result = thread.get()

        :param domain: The domain of the specified property. (required)
        :type domain: str
        :param scope: The scope of the specified property. (required)
        :type scope: str
        :param code: The code of the specified property. Together with the domain and scope this uniquely (required)
        :type code: str
        :param request_body: The properties to be created or updated. Each property in             the request must be keyed by its unique property key. This has the format {domain}/{scope}/{code}, for example             'PropertyDefinition/Manager/Id'. (required)
        :type request_body: Dict[str, ModelProperty]
        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial.
        :type success_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BatchUpsertPropertyDefinitionPropertiesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'domain',
            'scope',
            'code',
            'request_body',
            'success_mode'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_property_definition_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['domain']:
            _path_params['domain'] = _params['domain']

        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('success_mode') is not None:  # noqa: E501
            _query_params.append(('successMode', _params['success_mode']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "BatchUpsertPropertyDefinitionPropertiesResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/propertydefinitions/{domain}/{scope}/{code}/properties', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
