# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conlist, constr, validator

from typing import Optional

from lusid.models.create_reference_portfolio_request import CreateReferencePortfolioRequest
from lusid.models.get_reference_portfolio_constituents_response import GetReferencePortfolioConstituentsResponse
from lusid.models.portfolio import Portfolio
from lusid.models.resource_list_of_constituents_adjustment_header import ResourceListOfConstituentsAdjustmentHeader
from lusid.models.upsert_reference_portfolio_constituent_properties_request import UpsertReferencePortfolioConstituentPropertiesRequest
from lusid.models.upsert_reference_portfolio_constituent_properties_response import UpsertReferencePortfolioConstituentPropertiesResponse
from lusid.models.upsert_reference_portfolio_constituents_request import UpsertReferencePortfolioConstituentsRequest
from lusid.models.upsert_reference_portfolio_constituents_response import UpsertReferencePortfolioConstituentsResponse

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class ReferencePortfolioApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_reference_portfolio(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create the reference portfolio.")], create_reference_portfolio_request : Annotated[CreateReferencePortfolioRequest, Field(..., description="The definition of the reference portfolio.")], **kwargs) -> Portfolio:  # noqa: E501
        ...

    @overload
    def create_reference_portfolio(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create the reference portfolio.")], create_reference_portfolio_request : Annotated[CreateReferencePortfolioRequest, Field(..., description="The definition of the reference portfolio.")], async_req: Optional[bool]=True, **kwargs) -> Portfolio:  # noqa: E501
        ...

    @validate_arguments
    def create_reference_portfolio(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create the reference portfolio.")], create_reference_portfolio_request : Annotated[CreateReferencePortfolioRequest, Field(..., description="The definition of the reference portfolio.")], async_req: Optional[bool]=None, **kwargs) -> Union[Portfolio, Awaitable[Portfolio]]:  # noqa: E501
        """CreateReferencePortfolio: Create reference portfolio  # noqa: E501

        Create a reference portfolio in a particular scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_reference_portfolio(scope, create_reference_portfolio_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to create the reference portfolio. (required)
        :type scope: str
        :param create_reference_portfolio_request: The definition of the reference portfolio. (required)
        :type create_reference_portfolio_request: CreateReferencePortfolioRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Portfolio
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_reference_portfolio_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_reference_portfolio_with_http_info(scope, create_reference_portfolio_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_reference_portfolio_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create the reference portfolio.")], create_reference_portfolio_request : Annotated[CreateReferencePortfolioRequest, Field(..., description="The definition of the reference portfolio.")], **kwargs) -> ApiResponse:  # noqa: E501
        """CreateReferencePortfolio: Create reference portfolio  # noqa: E501

        Create a reference portfolio in a particular scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_reference_portfolio_with_http_info(scope, create_reference_portfolio_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to create the reference portfolio. (required)
        :type scope: str
        :param create_reference_portfolio_request: The definition of the reference portfolio. (required)
        :type create_reference_portfolio_request: CreateReferencePortfolioRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Portfolio, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'create_reference_portfolio_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_reference_portfolio" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_reference_portfolio_request'] is not None:
            _body_params = _params['create_reference_portfolio_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Portfolio",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/referenceportfolios/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_reference_portfolio_constituents(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective date of the constituents to retrieve. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve constituents. Defaults to return the latest version             of each constituent if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' or 'ReferenceHolding' domain to decorate onto             constituents. These take the format {domain}/{scope}/{code} e.g. 'Instrument/system/Name' or             'ReferenceHolding/strategy/quantsignal'. Defaults to return all available instrument and reference holding properties if not specified.")] = None, **kwargs) -> GetReferencePortfolioConstituentsResponse:  # noqa: E501
        ...

    @overload
    def get_reference_portfolio_constituents(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective date of the constituents to retrieve. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve constituents. Defaults to return the latest version             of each constituent if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' or 'ReferenceHolding' domain to decorate onto             constituents. These take the format {domain}/{scope}/{code} e.g. 'Instrument/system/Name' or             'ReferenceHolding/strategy/quantsignal'. Defaults to return all available instrument and reference holding properties if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> GetReferencePortfolioConstituentsResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_reference_portfolio_constituents(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective date of the constituents to retrieve. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve constituents. Defaults to return the latest version             of each constituent if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' or 'ReferenceHolding' domain to decorate onto             constituents. These take the format {domain}/{scope}/{code} e.g. 'Instrument/system/Name' or             'ReferenceHolding/strategy/quantsignal'. Defaults to return all available instrument and reference holding properties if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[GetReferencePortfolioConstituentsResponse, Awaitable[GetReferencePortfolioConstituentsResponse]]:  # noqa: E501
        """GetReferencePortfolioConstituents: Get reference portfolio constituents  # noqa: E501

        Get constituents from a reference portfolio at a particular effective time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_reference_portfolio_constituents(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reference portfolio. (required)
        :type scope: str
        :param code: The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio. (required)
        :type code: str
        :param effective_at: The effective date of the constituents to retrieve. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve constituents. Defaults to return the latest version             of each constituent if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Instrument' or 'ReferenceHolding' domain to decorate onto             constituents. These take the format {domain}/{scope}/{code} e.g. 'Instrument/system/Name' or             'ReferenceHolding/strategy/quantsignal'. Defaults to return all available instrument and reference holding properties if not specified.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetReferencePortfolioConstituentsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_reference_portfolio_constituents_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_reference_portfolio_constituents_with_http_info(scope, code, effective_at, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_reference_portfolio_constituents_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective date of the constituents to retrieve. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve constituents. Defaults to return the latest version             of each constituent if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Instrument' or 'ReferenceHolding' domain to decorate onto             constituents. These take the format {domain}/{scope}/{code} e.g. 'Instrument/system/Name' or             'ReferenceHolding/strategy/quantsignal'. Defaults to return all available instrument and reference holding properties if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetReferencePortfolioConstituents: Get reference portfolio constituents  # noqa: E501

        Get constituents from a reference portfolio at a particular effective time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_reference_portfolio_constituents_with_http_info(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reference portfolio. (required)
        :type scope: str
        :param code: The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio. (required)
        :type code: str
        :param effective_at: The effective date of the constituents to retrieve. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve constituents. Defaults to return the latest version             of each constituent if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Instrument' or 'ReferenceHolding' domain to decorate onto             constituents. These take the format {domain}/{scope}/{code} e.g. 'Instrument/system/Name' or             'ReferenceHolding/strategy/quantsignal'. Defaults to return all available instrument and reference holding properties if not specified.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetReferencePortfolioConstituentsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reference_portfolio_constituents" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GetReferencePortfolioConstituentsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/referenceportfolios/{scope}/{code}/constituents', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_constituents_adjustments(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], from_effective_at : Annotated[StrictStr, Field(..., description="Events between this time (inclusive) and the toEffectiveAt are returned.")], to_effective_at : Annotated[StrictStr, Field(..., description="Events between this time (inclusive) and the fromEffectiveAt are returned.")], as_at_time : Annotated[Optional[datetime], Field(description="The asAt time for which the result is valid.")] = None, **kwargs) -> ResourceListOfConstituentsAdjustmentHeader:  # noqa: E501
        ...

    @overload
    def list_constituents_adjustments(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], from_effective_at : Annotated[StrictStr, Field(..., description="Events between this time (inclusive) and the toEffectiveAt are returned.")], to_effective_at : Annotated[StrictStr, Field(..., description="Events between this time (inclusive) and the fromEffectiveAt are returned.")], as_at_time : Annotated[Optional[datetime], Field(description="The asAt time for which the result is valid.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfConstituentsAdjustmentHeader:  # noqa: E501
        ...

    @validate_arguments
    def list_constituents_adjustments(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], from_effective_at : Annotated[StrictStr, Field(..., description="Events between this time (inclusive) and the toEffectiveAt are returned.")], to_effective_at : Annotated[StrictStr, Field(..., description="Events between this time (inclusive) and the fromEffectiveAt are returned.")], as_at_time : Annotated[Optional[datetime], Field(description="The asAt time for which the result is valid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfConstituentsAdjustmentHeader, Awaitable[ResourceListOfConstituentsAdjustmentHeader]]:  # noqa: E501
        """ListConstituentsAdjustments: List constituents adjustments  # noqa: E501

        List adjustments made to constituents in a reference portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_constituents_adjustments(scope, code, from_effective_at, to_effective_at, as_at_time, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reference portfolio. (required)
        :type scope: str
        :param code: The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio. (required)
        :type code: str
        :param from_effective_at: Events between this time (inclusive) and the toEffectiveAt are returned. (required)
        :type from_effective_at: str
        :param to_effective_at: Events between this time (inclusive) and the fromEffectiveAt are returned. (required)
        :type to_effective_at: str
        :param as_at_time: The asAt time for which the result is valid.
        :type as_at_time: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfConstituentsAdjustmentHeader
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_constituents_adjustments_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_constituents_adjustments_with_http_info(scope, code, from_effective_at, to_effective_at, as_at_time, **kwargs)  # noqa: E501

    @validate_arguments
    def list_constituents_adjustments_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], from_effective_at : Annotated[StrictStr, Field(..., description="Events between this time (inclusive) and the toEffectiveAt are returned.")], to_effective_at : Annotated[StrictStr, Field(..., description="Events between this time (inclusive) and the fromEffectiveAt are returned.")], as_at_time : Annotated[Optional[datetime], Field(description="The asAt time for which the result is valid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ListConstituentsAdjustments: List constituents adjustments  # noqa: E501

        List adjustments made to constituents in a reference portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_constituents_adjustments_with_http_info(scope, code, from_effective_at, to_effective_at, as_at_time, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reference portfolio. (required)
        :type scope: str
        :param code: The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio. (required)
        :type code: str
        :param from_effective_at: Events between this time (inclusive) and the toEffectiveAt are returned. (required)
        :type from_effective_at: str
        :param to_effective_at: Events between this time (inclusive) and the fromEffectiveAt are returned. (required)
        :type to_effective_at: str
        :param as_at_time: The asAt time for which the result is valid.
        :type as_at_time: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfConstituentsAdjustmentHeader, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'from_effective_at',
            'to_effective_at',
            'as_at_time'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_constituents_adjustments" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('from_effective_at') is not None:  # noqa: E501
            _query_params.append(('fromEffectiveAt', _params['from_effective_at']))

        if _params.get('to_effective_at') is not None:  # noqa: E501
            _query_params.append(('toEffectiveAt', _params['to_effective_at']))

        if _params.get('as_at_time') is not None:  # noqa: E501
            if isinstance(_params['as_at_time'], datetime):
                _query_params.append(('asAtTime', _params['as_at_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAtTime', _params['as_at_time']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfConstituentsAdjustmentHeader",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/referenceportfolios/{scope}/{code}/constituentsadjustments', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_reference_portfolio_constituent_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], upsert_reference_portfolio_constituent_properties_request : Annotated[UpsertReferencePortfolioConstituentPropertiesRequest, Field(..., description="The request to modify properties for the constituent.")], **kwargs) -> UpsertReferencePortfolioConstituentPropertiesResponse:  # noqa: E501
        ...

    @overload
    def upsert_reference_portfolio_constituent_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], upsert_reference_portfolio_constituent_properties_request : Annotated[UpsertReferencePortfolioConstituentPropertiesRequest, Field(..., description="The request to modify properties for the constituent.")], async_req: Optional[bool]=True, **kwargs) -> UpsertReferencePortfolioConstituentPropertiesResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_reference_portfolio_constituent_properties(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], upsert_reference_portfolio_constituent_properties_request : Annotated[UpsertReferencePortfolioConstituentPropertiesRequest, Field(..., description="The request to modify properties for the constituent.")], async_req: Optional[bool]=None, **kwargs) -> Union[UpsertReferencePortfolioConstituentPropertiesResponse, Awaitable[UpsertReferencePortfolioConstituentPropertiesResponse]]:  # noqa: E501
        """[EARLY ACCESS] UpsertReferencePortfolioConstituentProperties: Upsert constituent properties  # noqa: E501

        Create or update one or more constituent properties for a single constituent in the reference portfolio. Each property will be updated if it already exists, created if it does not and deleted if value is null. Both constituent and portfolio must exist at the time when properties are created or updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_reference_portfolio_constituent_properties(scope, code, upsert_reference_portfolio_constituent_properties_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reference portfolio. (required)
        :type scope: str
        :param code: The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio. (required)
        :type code: str
        :param upsert_reference_portfolio_constituent_properties_request: The request to modify properties for the constituent. (required)
        :type upsert_reference_portfolio_constituent_properties_request: UpsertReferencePortfolioConstituentPropertiesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertReferencePortfolioConstituentPropertiesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_reference_portfolio_constituent_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_reference_portfolio_constituent_properties_with_http_info(scope, code, upsert_reference_portfolio_constituent_properties_request, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_reference_portfolio_constituent_properties_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], upsert_reference_portfolio_constituent_properties_request : Annotated[UpsertReferencePortfolioConstituentPropertiesRequest, Field(..., description="The request to modify properties for the constituent.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertReferencePortfolioConstituentProperties: Upsert constituent properties  # noqa: E501

        Create or update one or more constituent properties for a single constituent in the reference portfolio. Each property will be updated if it already exists, created if it does not and deleted if value is null. Both constituent and portfolio must exist at the time when properties are created or updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_reference_portfolio_constituent_properties_with_http_info(scope, code, upsert_reference_portfolio_constituent_properties_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reference portfolio. (required)
        :type scope: str
        :param code: The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio. (required)
        :type code: str
        :param upsert_reference_portfolio_constituent_properties_request: The request to modify properties for the constituent. (required)
        :type upsert_reference_portfolio_constituent_properties_request: UpsertReferencePortfolioConstituentPropertiesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertReferencePortfolioConstituentPropertiesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'upsert_reference_portfolio_constituent_properties_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_reference_portfolio_constituent_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_reference_portfolio_constituent_properties_request'] is not None:
            _body_params = _params['upsert_reference_portfolio_constituent_properties_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertReferencePortfolioConstituentPropertiesResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/referenceportfolios/{scope}/{code}/constituents/properties', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_reference_portfolio_constituents(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], upsert_reference_portfolio_constituents_request : Annotated[UpsertReferencePortfolioConstituentsRequest, Field(..., description="The constituents to upload to the reference portfolio.")], **kwargs) -> UpsertReferencePortfolioConstituentsResponse:  # noqa: E501
        ...

    @overload
    def upsert_reference_portfolio_constituents(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], upsert_reference_portfolio_constituents_request : Annotated[UpsertReferencePortfolioConstituentsRequest, Field(..., description="The constituents to upload to the reference portfolio.")], async_req: Optional[bool]=True, **kwargs) -> UpsertReferencePortfolioConstituentsResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_reference_portfolio_constituents(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], upsert_reference_portfolio_constituents_request : Annotated[UpsertReferencePortfolioConstituentsRequest, Field(..., description="The constituents to upload to the reference portfolio.")], async_req: Optional[bool]=None, **kwargs) -> Union[UpsertReferencePortfolioConstituentsResponse, Awaitable[UpsertReferencePortfolioConstituentsResponse]]:  # noqa: E501
        """UpsertReferencePortfolioConstituents: Upsert reference portfolio constituents  # noqa: E501

        Add constituents to a reference portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_reference_portfolio_constituents(scope, code, upsert_reference_portfolio_constituents_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reference portfolio. (required)
        :type scope: str
        :param code: The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio. (required)
        :type code: str
        :param upsert_reference_portfolio_constituents_request: The constituents to upload to the reference portfolio. (required)
        :type upsert_reference_portfolio_constituents_request: UpsertReferencePortfolioConstituentsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertReferencePortfolioConstituentsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_reference_portfolio_constituents_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_reference_portfolio_constituents_with_http_info(scope, code, upsert_reference_portfolio_constituents_request, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_reference_portfolio_constituents_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reference portfolio.")], code : Annotated[StrictStr, Field(..., description="The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio.")], upsert_reference_portfolio_constituents_request : Annotated[UpsertReferencePortfolioConstituentsRequest, Field(..., description="The constituents to upload to the reference portfolio.")], **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertReferencePortfolioConstituents: Upsert reference portfolio constituents  # noqa: E501

        Add constituents to a reference portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_reference_portfolio_constituents_with_http_info(scope, code, upsert_reference_portfolio_constituents_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reference portfolio. (required)
        :type scope: str
        :param code: The code of the reference portfolio. Together with the scope this uniquely identifies             the reference portfolio. (required)
        :type code: str
        :param upsert_reference_portfolio_constituents_request: The constituents to upload to the reference portfolio. (required)
        :type upsert_reference_portfolio_constituents_request: UpsertReferencePortfolioConstituentsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertReferencePortfolioConstituentsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'upsert_reference_portfolio_constituents_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_reference_portfolio_constituents" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_reference_portfolio_constituents_request'] is not None:
            _body_params = _params['upsert_reference_portfolio_constituents_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertReferencePortfolioConstituentsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/referenceportfolios/{scope}/{code}/constituents', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
