# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, constr, validator

from typing import Optional

from lusid.models.dialect import Dialect
from lusid.models.paged_resource_list_of_dialect_id import PagedResourceListOfDialectId
from lusid.models.paged_resource_list_of_translation_script_id import PagedResourceListOfTranslationScriptId
from lusid.models.translate_entities_inlined_request import TranslateEntitiesInlinedRequest
from lusid.models.translate_entities_request import TranslateEntitiesRequest
from lusid.models.translate_entities_response import TranslateEntitiesResponse
from lusid.models.translation_script import TranslationScript
from lusid.models.upsert_dialect_request import UpsertDialectRequest
from lusid.models.upsert_translation_script_request import UpsertTranslationScriptRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class ScriptedTranslationApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def get_translation_dialect(self, scope : Annotated[StrictStr, Field(..., description="The scope of the dialect.")], vendor : Annotated[StrictStr, Field(..., description="The vendor of the dialect, the entity that created it. e.g. ISDA, FINBOURNE.")], source_system : Annotated[StrictStr, Field(..., description="The source system of the dialect, the system that understands it. e.g. LUSID, QuantLib.")], entity_type : Annotated[StrictStr, Field(..., description="The type of entity this dialect describes e.g. Instrument.")], serialisation_format : Annotated[StrictStr, Field(..., description="The serialisation format of a document in this dialect. e.g. JSON, XML.")], version : Annotated[StrictStr, Field(..., description="The semantic version of the dialect: MAJOR.MINOR.PATCH.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the dialect. Defaults to return the latest version of the dialect if not specified.")] = None, **kwargs) -> Dialect:  # noqa: E501
        ...

    @overload
    def get_translation_dialect(self, scope : Annotated[StrictStr, Field(..., description="The scope of the dialect.")], vendor : Annotated[StrictStr, Field(..., description="The vendor of the dialect, the entity that created it. e.g. ISDA, FINBOURNE.")], source_system : Annotated[StrictStr, Field(..., description="The source system of the dialect, the system that understands it. e.g. LUSID, QuantLib.")], entity_type : Annotated[StrictStr, Field(..., description="The type of entity this dialect describes e.g. Instrument.")], serialisation_format : Annotated[StrictStr, Field(..., description="The serialisation format of a document in this dialect. e.g. JSON, XML.")], version : Annotated[StrictStr, Field(..., description="The semantic version of the dialect: MAJOR.MINOR.PATCH.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the dialect. Defaults to return the latest version of the dialect if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> Dialect:  # noqa: E501
        ...

    @validate_arguments
    def get_translation_dialect(self, scope : Annotated[StrictStr, Field(..., description="The scope of the dialect.")], vendor : Annotated[StrictStr, Field(..., description="The vendor of the dialect, the entity that created it. e.g. ISDA, FINBOURNE.")], source_system : Annotated[StrictStr, Field(..., description="The source system of the dialect, the system that understands it. e.g. LUSID, QuantLib.")], entity_type : Annotated[StrictStr, Field(..., description="The type of entity this dialect describes e.g. Instrument.")], serialisation_format : Annotated[StrictStr, Field(..., description="The serialisation format of a document in this dialect. e.g. JSON, XML.")], version : Annotated[StrictStr, Field(..., description="The semantic version of the dialect: MAJOR.MINOR.PATCH.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the dialect. Defaults to return the latest version of the dialect if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Dialect, Awaitable[Dialect]]:  # noqa: E501
        """[EARLY ACCESS] GetTranslationDialect: Get a dialect.  # noqa: E501

        Get the dialect with the given identifier at the specific asAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_translation_dialect(scope, vendor, source_system, entity_type, serialisation_format, version, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the dialect. (required)
        :type scope: str
        :param vendor: The vendor of the dialect, the entity that created it. e.g. ISDA, FINBOURNE. (required)
        :type vendor: str
        :param source_system: The source system of the dialect, the system that understands it. e.g. LUSID, QuantLib. (required)
        :type source_system: str
        :param entity_type: The type of entity this dialect describes e.g. Instrument. (required)
        :type entity_type: str
        :param serialisation_format: The serialisation format of a document in this dialect. e.g. JSON, XML. (required)
        :type serialisation_format: str
        :param version: The semantic version of the dialect: MAJOR.MINOR.PATCH. (required)
        :type version: str
        :param as_at: The asAt datetime at which to retrieve the dialect. Defaults to return the latest version of the dialect if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dialect
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_translation_dialect_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_translation_dialect_with_http_info(scope, vendor, source_system, entity_type, serialisation_format, version, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_translation_dialect_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the dialect.")], vendor : Annotated[StrictStr, Field(..., description="The vendor of the dialect, the entity that created it. e.g. ISDA, FINBOURNE.")], source_system : Annotated[StrictStr, Field(..., description="The source system of the dialect, the system that understands it. e.g. LUSID, QuantLib.")], entity_type : Annotated[StrictStr, Field(..., description="The type of entity this dialect describes e.g. Instrument.")], serialisation_format : Annotated[StrictStr, Field(..., description="The serialisation format of a document in this dialect. e.g. JSON, XML.")], version : Annotated[StrictStr, Field(..., description="The semantic version of the dialect: MAJOR.MINOR.PATCH.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the dialect. Defaults to return the latest version of the dialect if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetTranslationDialect: Get a dialect.  # noqa: E501

        Get the dialect with the given identifier at the specific asAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_translation_dialect_with_http_info(scope, vendor, source_system, entity_type, serialisation_format, version, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the dialect. (required)
        :type scope: str
        :param vendor: The vendor of the dialect, the entity that created it. e.g. ISDA, FINBOURNE. (required)
        :type vendor: str
        :param source_system: The source system of the dialect, the system that understands it. e.g. LUSID, QuantLib. (required)
        :type source_system: str
        :param entity_type: The type of entity this dialect describes e.g. Instrument. (required)
        :type entity_type: str
        :param serialisation_format: The serialisation format of a document in this dialect. e.g. JSON, XML. (required)
        :type serialisation_format: str
        :param version: The semantic version of the dialect: MAJOR.MINOR.PATCH. (required)
        :type version: str
        :param as_at: The asAt datetime at which to retrieve the dialect. Defaults to return the latest version of the dialect if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dialect, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'vendor',
            'source_system',
            'entity_type',
            'serialisation_format',
            'version',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_translation_dialect" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['vendor']:
            _path_params['vendor'] = _params['vendor']

        if _params['source_system']:
            _path_params['sourceSystem'] = _params['source_system']

        if _params['entity_type']:
            _path_params['entityType'] = _params['entity_type']

        if _params['serialisation_format']:
            _path_params['serialisationFormat'] = _params['serialisation_format']

        if _params['version']:
            _path_params['version'] = _params['version']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Dialect",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/scriptedtranslation/dialects/{scope}/{vendor}/{sourceSystem}/{entityType}/{serialisationFormat}/{version}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_translation_script(self, scope : Annotated[StrictStr, Field(..., description="Scope of the translation script.")], code : Annotated[StrictStr, Field(..., description="Code of the translation script.")], version : Annotated[StrictStr, Field(..., description="Semantic version of the translation script.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the translation script. Defaults to latest.")] = None, **kwargs) -> TranslationScript:  # noqa: E501
        ...

    @overload
    def get_translation_script(self, scope : Annotated[StrictStr, Field(..., description="Scope of the translation script.")], code : Annotated[StrictStr, Field(..., description="Code of the translation script.")], version : Annotated[StrictStr, Field(..., description="Semantic version of the translation script.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the translation script. Defaults to latest.")] = None, async_req: Optional[bool]=True, **kwargs) -> TranslationScript:  # noqa: E501
        ...

    @validate_arguments
    def get_translation_script(self, scope : Annotated[StrictStr, Field(..., description="Scope of the translation script.")], code : Annotated[StrictStr, Field(..., description="Code of the translation script.")], version : Annotated[StrictStr, Field(..., description="Semantic version of the translation script.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the translation script. Defaults to latest.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[TranslationScript, Awaitable[TranslationScript]]:  # noqa: E501
        """[EARLY ACCESS] GetTranslationScript: Retrieve a translation script by its identifier.  # noqa: E501

        Retrieves a translation script to be used for translating financial entities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_translation_script(scope, code, version, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the translation script. (required)
        :type scope: str
        :param code: Code of the translation script. (required)
        :type code: str
        :param version: Semantic version of the translation script. (required)
        :type version: str
        :param as_at: The asAt datetime at which to retrieve the translation script. Defaults to latest.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TranslationScript
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_translation_script_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_translation_script_with_http_info(scope, code, version, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_translation_script_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of the translation script.")], code : Annotated[StrictStr, Field(..., description="Code of the translation script.")], version : Annotated[StrictStr, Field(..., description="Semantic version of the translation script.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the translation script. Defaults to latest.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetTranslationScript: Retrieve a translation script by its identifier.  # noqa: E501

        Retrieves a translation script to be used for translating financial entities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_translation_script_with_http_info(scope, code, version, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of the translation script. (required)
        :type scope: str
        :param code: Code of the translation script. (required)
        :type code: str
        :param version: Semantic version of the translation script. (required)
        :type version: str
        :param as_at: The asAt datetime at which to retrieve the translation script. Defaults to latest.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TranslationScript, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'version',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_translation_script" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['version']:
            _path_params['version'] = _params['version']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TranslationScript",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/scriptedtranslation/scripts/{scope}/{code}/{version}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_dialect_ids(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the dialects.             Defaults to return the latest version of the dialect if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing dialect IDs from a previous call to list dialect IDs.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> PagedResourceListOfDialectId:  # noqa: E501
        ...

    @overload
    def list_dialect_ids(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the dialects.             Defaults to return the latest version of the dialect if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing dialect IDs from a previous call to list dialect IDs.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfDialectId:  # noqa: E501
        ...

    @validate_arguments
    def list_dialect_ids(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the dialects.             Defaults to return the latest version of the dialect if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing dialect IDs from a previous call to list dialect IDs.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfDialectId, Awaitable[PagedResourceListOfDialectId]]:  # noqa: E501
        """[EARLY ACCESS] ListDialectIds: List dialect identifiers matching an optional filter.  # noqa: E501

        List the stored dialects' identifiers with pagination and filtering at the specified asAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_dialect_ids(as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the dialects.             Defaults to return the latest version of the dialect if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing dialect IDs from a previous call to list dialect IDs.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfDialectId
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_dialect_ids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_dialect_ids_with_http_info(as_at, page, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_dialect_ids_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the dialects.             Defaults to return the latest version of the dialect if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing dialect IDs from a previous call to list dialect IDs.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListDialectIds: List dialect identifiers matching an optional filter.  # noqa: E501

        List the stored dialects' identifiers with pagination and filtering at the specified asAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_dialect_ids_with_http_info(as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the dialects.             Defaults to return the latest version of the dialect if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing dialect IDs from a previous call to list dialect IDs.             This value is returned from the previous call. If a pagination token is provided the filter and asAt fields             must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:             https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfDialectId, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_dialect_ids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfDialectId",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/scriptedtranslation/dialects/ids', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_translation_script_ids(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the script identifiers. Defaults to latest.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For example, Id.Version.Major eq 1 to list IDs with major version 1             or Id.Scope eq 'my-scripts' to list result only for a particular scope.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing translation script IDs; this             value is returned from the previous call. If a pagination token is provided, the filter field             must not have changed since the original request.")] = None, **kwargs) -> PagedResourceListOfTranslationScriptId:  # noqa: E501
        ...

    @overload
    def list_translation_script_ids(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the script identifiers. Defaults to latest.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For example, Id.Version.Major eq 1 to list IDs with major version 1             or Id.Scope eq 'my-scripts' to list result only for a particular scope.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing translation script IDs; this             value is returned from the previous call. If a pagination token is provided, the filter field             must not have changed since the original request.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfTranslationScriptId:  # noqa: E501
        ...

    @validate_arguments
    def list_translation_script_ids(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the script identifiers. Defaults to latest.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For example, Id.Version.Major eq 1 to list IDs with major version 1             or Id.Scope eq 'my-scripts' to list result only for a particular scope.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing translation script IDs; this             value is returned from the previous call. If a pagination token is provided, the filter field             must not have changed since the original request.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfTranslationScriptId, Awaitable[PagedResourceListOfTranslationScriptId]]:  # noqa: E501
        """[EARLY ACCESS] ListTranslationScriptIds: List translation script identifiers.  # noqa: E501

        List translation script ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_translation_script_ids(as_at, limit, filter, page, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the script identifiers. Defaults to latest.
        :type as_at: datetime
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results. For example, Id.Version.Major eq 1 to list IDs with major version 1             or Id.Scope eq 'my-scripts' to list result only for a particular scope.
        :type filter: str
        :param page: The pagination token to use to continue listing translation script IDs; this             value is returned from the previous call. If a pagination token is provided, the filter field             must not have changed since the original request.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfTranslationScriptId
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_translation_script_ids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_translation_script_ids_with_http_info(as_at, limit, filter, page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_translation_script_ids_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the script identifiers. Defaults to latest.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results. For example, Id.Version.Major eq 1 to list IDs with major version 1             or Id.Scope eq 'my-scripts' to list result only for a particular scope.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing translation script IDs; this             value is returned from the previous call. If a pagination token is provided, the filter field             must not have changed since the original request.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListTranslationScriptIds: List translation script identifiers.  # noqa: E501

        List translation script ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_translation_script_ids_with_http_info(as_at, limit, filter, page, async_req=True)
        >>> result = thread.get()

        :param as_at: The asAt datetime at which to retrieve the script identifiers. Defaults to latest.
        :type as_at: datetime
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results. For example, Id.Version.Major eq 1 to list IDs with major version 1             or Id.Scope eq 'my-scripts' to list result only for a particular scope.
        :type filter: str
        :param page: The pagination token to use to continue listing translation script IDs; this             value is returned from the previous call. If a pagination token is provided, the filter field             must not have changed since the original request.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfTranslationScriptId, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'limit',
            'filter',
            'page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_translation_script_ids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfTranslationScriptId",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/scriptedtranslation/scripts/ids', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def translate_entities(self, translate_entities_request : Annotated[TranslateEntitiesRequest, Field(..., description="The entities to translate, along with identifiers for the script and (optional) dialect to use.")], **kwargs) -> TranslateEntitiesResponse:  # noqa: E501
        ...

    @overload
    def translate_entities(self, translate_entities_request : Annotated[TranslateEntitiesRequest, Field(..., description="The entities to translate, along with identifiers for the script and (optional) dialect to use.")], async_req: Optional[bool]=True, **kwargs) -> TranslateEntitiesResponse:  # noqa: E501
        ...

    @validate_arguments
    def translate_entities(self, translate_entities_request : Annotated[TranslateEntitiesRequest, Field(..., description="The entities to translate, along with identifiers for the script and (optional) dialect to use.")], async_req: Optional[bool]=None, **kwargs) -> Union[TranslateEntitiesResponse, Awaitable[TranslateEntitiesResponse]]:  # noqa: E501
        """[EARLY ACCESS] TranslateEntities: Translate a collection of entities with a specified translation script.  # noqa: E501

        Run the provided translation request. The entities to translate are specified in the request body as a dictionary with (ephemeral) unique correlation IDs. The script to use and optional dialect to validate results against are sourced from the database.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.translate_entities(translate_entities_request, async_req=True)
        >>> result = thread.get()

        :param translate_entities_request: The entities to translate, along with identifiers for the script and (optional) dialect to use. (required)
        :type translate_entities_request: TranslateEntitiesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TranslateEntitiesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the translate_entities_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.translate_entities_with_http_info(translate_entities_request, **kwargs)  # noqa: E501

    @validate_arguments
    def translate_entities_with_http_info(self, translate_entities_request : Annotated[TranslateEntitiesRequest, Field(..., description="The entities to translate, along with identifiers for the script and (optional) dialect to use.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] TranslateEntities: Translate a collection of entities with a specified translation script.  # noqa: E501

        Run the provided translation request. The entities to translate are specified in the request body as a dictionary with (ephemeral) unique correlation IDs. The script to use and optional dialect to validate results against are sourced from the database.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.translate_entities_with_http_info(translate_entities_request, async_req=True)
        >>> result = thread.get()

        :param translate_entities_request: The entities to translate, along with identifiers for the script and (optional) dialect to use. (required)
        :type translate_entities_request: TranslateEntitiesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TranslateEntitiesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'translate_entities_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method translate_entities" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['translate_entities_request'] is not None:
            _body_params = _params['translate_entities_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TranslateEntitiesResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/scriptedtranslation/translateentities', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def translate_entities_inlined(self, translate_entities_inlined_request : Annotated[TranslateEntitiesInlinedRequest, Field(..., description="The entities to translate, along with the script to use and an optional schema for validation.")], **kwargs) -> TranslateEntitiesResponse:  # noqa: E501
        ...

    @overload
    def translate_entities_inlined(self, translate_entities_inlined_request : Annotated[TranslateEntitiesInlinedRequest, Field(..., description="The entities to translate, along with the script to use and an optional schema for validation.")], async_req: Optional[bool]=True, **kwargs) -> TranslateEntitiesResponse:  # noqa: E501
        ...

    @validate_arguments
    def translate_entities_inlined(self, translate_entities_inlined_request : Annotated[TranslateEntitiesInlinedRequest, Field(..., description="The entities to translate, along with the script to use and an optional schema for validation.")], async_req: Optional[bool]=None, **kwargs) -> Union[TranslateEntitiesResponse, Awaitable[TranslateEntitiesResponse]]:  # noqa: E501
        """[EARLY ACCESS] TranslateEntitiesInlined: Translate a collection of entities, inlining the body of the translation script.  # noqa: E501

        Run the provided translation request. The entities to translate, script to use and dialect to validate results against are all specified in the request body. The entities are given as a dictionary with (ephemeral) unique correlation IDs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.translate_entities_inlined(translate_entities_inlined_request, async_req=True)
        >>> result = thread.get()

        :param translate_entities_inlined_request: The entities to translate, along with the script to use and an optional schema for validation. (required)
        :type translate_entities_inlined_request: TranslateEntitiesInlinedRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TranslateEntitiesResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the translate_entities_inlined_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.translate_entities_inlined_with_http_info(translate_entities_inlined_request, **kwargs)  # noqa: E501

    @validate_arguments
    def translate_entities_inlined_with_http_info(self, translate_entities_inlined_request : Annotated[TranslateEntitiesInlinedRequest, Field(..., description="The entities to translate, along with the script to use and an optional schema for validation.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] TranslateEntitiesInlined: Translate a collection of entities, inlining the body of the translation script.  # noqa: E501

        Run the provided translation request. The entities to translate, script to use and dialect to validate results against are all specified in the request body. The entities are given as a dictionary with (ephemeral) unique correlation IDs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.translate_entities_inlined_with_http_info(translate_entities_inlined_request, async_req=True)
        >>> result = thread.get()

        :param translate_entities_inlined_request: The entities to translate, along with the script to use and an optional schema for validation. (required)
        :type translate_entities_inlined_request: TranslateEntitiesInlinedRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TranslateEntitiesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'translate_entities_inlined_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method translate_entities_inlined" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['translate_entities_inlined_request'] is not None:
            _body_params = _params['translate_entities_inlined_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TranslateEntitiesResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/scriptedtranslation/translateentitiesinlined', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_translation_dialect(self, upsert_dialect_request : Annotated[UpsertDialectRequest, Field(..., description="The dialect to upsert.")], **kwargs) -> Dialect:  # noqa: E501
        ...

    @overload
    def upsert_translation_dialect(self, upsert_dialect_request : Annotated[UpsertDialectRequest, Field(..., description="The dialect to upsert.")], async_req: Optional[bool]=True, **kwargs) -> Dialect:  # noqa: E501
        ...

    @validate_arguments
    def upsert_translation_dialect(self, upsert_dialect_request : Annotated[UpsertDialectRequest, Field(..., description="The dialect to upsert.")], async_req: Optional[bool]=None, **kwargs) -> Union[Dialect, Awaitable[Dialect]]:  # noqa: E501
        """[EARLY ACCESS] UpsertTranslationDialect: Upsert a Dialect.  # noqa: E501

        Upsert the given dialect.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_translation_dialect(upsert_dialect_request, async_req=True)
        >>> result = thread.get()

        :param upsert_dialect_request: The dialect to upsert. (required)
        :type upsert_dialect_request: UpsertDialectRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dialect
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_translation_dialect_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_translation_dialect_with_http_info(upsert_dialect_request, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_translation_dialect_with_http_info(self, upsert_dialect_request : Annotated[UpsertDialectRequest, Field(..., description="The dialect to upsert.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertTranslationDialect: Upsert a Dialect.  # noqa: E501

        Upsert the given dialect.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_translation_dialect_with_http_info(upsert_dialect_request, async_req=True)
        >>> result = thread.get()

        :param upsert_dialect_request: The dialect to upsert. (required)
        :type upsert_dialect_request: UpsertDialectRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dialect, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'upsert_dialect_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_translation_dialect" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_dialect_request'] is not None:
            _body_params = _params['upsert_dialect_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Dialect",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/scriptedtranslation/dialects', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_translation_script(self, upsert_translation_script_request : Annotated[UpsertTranslationScriptRequest, Field(..., description="The translation script to be upserted.")], **kwargs) -> TranslationScript:  # noqa: E501
        ...

    @overload
    def upsert_translation_script(self, upsert_translation_script_request : Annotated[UpsertTranslationScriptRequest, Field(..., description="The translation script to be upserted.")], async_req: Optional[bool]=True, **kwargs) -> TranslationScript:  # noqa: E501
        ...

    @validate_arguments
    def upsert_translation_script(self, upsert_translation_script_request : Annotated[UpsertTranslationScriptRequest, Field(..., description="The translation script to be upserted.")], async_req: Optional[bool]=None, **kwargs) -> Union[TranslationScript, Awaitable[TranslationScript]]:  # noqa: E501
        """[EARLY ACCESS] UpsertTranslationScript: Upsert a translation script.  # noqa: E501

        Upserts a translation script to be used for translating financial entities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_translation_script(upsert_translation_script_request, async_req=True)
        >>> result = thread.get()

        :param upsert_translation_script_request: The translation script to be upserted. (required)
        :type upsert_translation_script_request: UpsertTranslationScriptRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TranslationScript
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_translation_script_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_translation_script_with_http_info(upsert_translation_script_request, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_translation_script_with_http_info(self, upsert_translation_script_request : Annotated[UpsertTranslationScriptRequest, Field(..., description="The translation script to be upserted.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertTranslationScript: Upsert a translation script.  # noqa: E501

        Upserts a translation script to be used for translating financial entities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_translation_script_with_http_info(upsert_translation_script_request, async_req=True)
        >>> result = thread.get()

        :param upsert_translation_script_request: The translation script to be upserted. (required)
        :type upsert_translation_script_request: UpsertTranslationScriptRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TranslationScript, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'upsert_translation_script_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_translation_script" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_translation_script_request'] is not None:
            _body_params = _params['upsert_translation_script_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TranslationScript",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/scriptedtranslation/scripts', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
