# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic.v1 import Field, StrictBool, StrictInt, StrictStr, conlist, constr, validator

from typing import List, Optional

from lusid.models.instrument_match import InstrumentMatch
from lusid.models.instrument_search_property import InstrumentSearchProperty
from lusid.models.paged_resource_list_of_portfolio_group_search_result import PagedResourceListOfPortfolioGroupSearchResult
from lusid.models.paged_resource_list_of_portfolio_search_result import PagedResourceListOfPortfolioSearchResult
from lusid.models.paged_resource_list_of_property_definition_search_result import PagedResourceListOfPropertyDefinitionSearchResult

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class SearchApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def instruments_search(self, instrument_search_property : Annotated[conlist(InstrumentSearchProperty), Field(..., description="A collection of instrument properties to search for. LUSID will return instruments for any matched             properties.")], mastered_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label to use when searching mastered instruments. This parameter has no effect on instruments that have not been mastered within LUSID. Defaults to the current LUSID system datetime if not specified.")] = None, mastered_only : Annotated[Optional[StrictBool], Field(description="If set to true, only search over instruments that have been mastered within LUSID. Defaults to false.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies.")] = None, **kwargs) -> List[InstrumentMatch]:  # noqa: E501
        ...

    @overload
    def instruments_search(self, instrument_search_property : Annotated[conlist(InstrumentSearchProperty), Field(..., description="A collection of instrument properties to search for. LUSID will return instruments for any matched             properties.")], mastered_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label to use when searching mastered instruments. This parameter has no effect on instruments that have not been mastered within LUSID. Defaults to the current LUSID system datetime if not specified.")] = None, mastered_only : Annotated[Optional[StrictBool], Field(description="If set to true, only search over instruments that have been mastered within LUSID. Defaults to false.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies.")] = None, async_req: Optional[bool]=True, **kwargs) -> List[InstrumentMatch]:  # noqa: E501
        ...

    @validate_arguments
    def instruments_search(self, instrument_search_property : Annotated[conlist(InstrumentSearchProperty), Field(..., description="A collection of instrument properties to search for. LUSID will return instruments for any matched             properties.")], mastered_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label to use when searching mastered instruments. This parameter has no effect on instruments that have not been mastered within LUSID. Defaults to the current LUSID system datetime if not specified.")] = None, mastered_only : Annotated[Optional[StrictBool], Field(description="If set to true, only search over instruments that have been mastered within LUSID. Defaults to false.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[List[InstrumentMatch], Awaitable[List[InstrumentMatch]]]:  # noqa: E501
        """[EARLY ACCESS] InstrumentsSearch: Instruments search  # noqa: E501

        Search across all instruments that have been mastered in LUSID. Optionally augment the results with instruments from an external symbology service, currently OpenFIGI.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.instruments_search(instrument_search_property, mastered_effective_at, mastered_only, scope, async_req=True)
        >>> result = thread.get()

        :param instrument_search_property: A collection of instrument properties to search for. LUSID will return instruments for any matched             properties. (required)
        :type instrument_search_property: List[InstrumentSearchProperty]
        :param mastered_effective_at: The effective datetime or cut label to use when searching mastered instruments. This parameter has no effect on instruments that have not been mastered within LUSID. Defaults to the current LUSID system datetime if not specified.
        :type mastered_effective_at: str
        :param mastered_only: If set to true, only search over instruments that have been mastered within LUSID. Defaults to false.
        :type mastered_only: bool
        :param scope: The scope in which the instrument lies.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[InstrumentMatch]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the instruments_search_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.instruments_search_with_http_info(instrument_search_property, mastered_effective_at, mastered_only, scope, **kwargs)  # noqa: E501

    @validate_arguments
    def instruments_search_with_http_info(self, instrument_search_property : Annotated[conlist(InstrumentSearchProperty), Field(..., description="A collection of instrument properties to search for. LUSID will return instruments for any matched             properties.")], mastered_effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label to use when searching mastered instruments. This parameter has no effect on instruments that have not been mastered within LUSID. Defaults to the current LUSID system datetime if not specified.")] = None, mastered_only : Annotated[Optional[StrictBool], Field(description="If set to true, only search over instruments that have been mastered within LUSID. Defaults to false.")] = None, scope : Annotated[Optional[StrictStr], Field( description="The scope in which the instrument lies.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] InstrumentsSearch: Instruments search  # noqa: E501

        Search across all instruments that have been mastered in LUSID. Optionally augment the results with instruments from an external symbology service, currently OpenFIGI.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.instruments_search_with_http_info(instrument_search_property, mastered_effective_at, mastered_only, scope, async_req=True)
        >>> result = thread.get()

        :param instrument_search_property: A collection of instrument properties to search for. LUSID will return instruments for any matched             properties. (required)
        :type instrument_search_property: List[InstrumentSearchProperty]
        :param mastered_effective_at: The effective datetime or cut label to use when searching mastered instruments. This parameter has no effect on instruments that have not been mastered within LUSID. Defaults to the current LUSID system datetime if not specified.
        :type mastered_effective_at: str
        :param mastered_only: If set to true, only search over instruments that have been mastered within LUSID. Defaults to false.
        :type mastered_only: bool
        :param scope: The scope in which the instrument lies.
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[InstrumentMatch], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'instrument_search_property',
            'mastered_effective_at',
            'mastered_only',
            'scope'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method instruments_search" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('mastered_effective_at') is not None:  # noqa: E501
            _query_params.append(('masteredEffectiveAt', _params['mastered_effective_at']))

        if _params.get('mastered_only') is not None:  # noqa: E501
            _query_params.append(('masteredOnly', _params['mastered_only']))

        if _params.get('scope') is not None:  # noqa: E501
            _query_params.append(('scope', _params['scope']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['instrument_search_property'] is not None:
            _body_params = _params['instrument_search_property']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "List[InstrumentMatch]",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/search/instruments', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def search_portfolio_groups(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any portfolio group field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the Scope, use \"id.scope eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, **kwargs) -> PagedResourceListOfPortfolioGroupSearchResult:  # noqa: E501
        ...

    @overload
    def search_portfolio_groups(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any portfolio group field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the Scope, use \"id.scope eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfPortfolioGroupSearchResult:  # noqa: E501
        ...

    @validate_arguments
    def search_portfolio_groups(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any portfolio group field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the Scope, use \"id.scope eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfPortfolioGroupSearchResult, Awaitable[PagedResourceListOfPortfolioGroupSearchResult]]:  # noqa: E501
        """SearchPortfolioGroups: Search Portfolio Groups  # noqa: E501

        Search through all portfolio groups  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_portfolio_groups(search, filter, sort_by, limit, page, async_req=True)
        >>> result = thread.get()

        :param search: A parameter used for searching any portfolio group field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type search: str
        :param filter: Expression to filter the result set.  For example, to filter on the Scope, use \"id.scope eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName
        :type sort_by: str
        :param limit: When paginating, only return this number of records
        :type limit: int
        :param page: Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfPortfolioGroupSearchResult
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the search_portfolio_groups_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.search_portfolio_groups_with_http_info(search, filter, sort_by, limit, page, **kwargs)  # noqa: E501

    @validate_arguments
    def search_portfolio_groups_with_http_info(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any portfolio group field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the Scope, use \"id.scope eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """SearchPortfolioGroups: Search Portfolio Groups  # noqa: E501

        Search through all portfolio groups  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_portfolio_groups_with_http_info(search, filter, sort_by, limit, page, async_req=True)
        >>> result = thread.get()

        :param search: A parameter used for searching any portfolio group field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type search: str
        :param filter: Expression to filter the result set.  For example, to filter on the Scope, use \"id.scope eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName
        :type sort_by: str
        :param limit: When paginating, only return this number of records
        :type limit: int
        :param page: Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfPortfolioGroupSearchResult, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'search',
            'filter',
            'sort_by',
            'limit',
            'page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_portfolio_groups" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfPortfolioGroupSearchResult",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/search/portfoliogroups', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def search_portfolios(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any portfolio field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the portfolio Type, use \"type eq 'Transaction'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, **kwargs) -> PagedResourceListOfPortfolioSearchResult:  # noqa: E501
        ...

    @overload
    def search_portfolios(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any portfolio field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the portfolio Type, use \"type eq 'Transaction'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfPortfolioSearchResult:  # noqa: E501
        ...

    @validate_arguments
    def search_portfolios(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any portfolio field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the portfolio Type, use \"type eq 'Transaction'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfPortfolioSearchResult, Awaitable[PagedResourceListOfPortfolioSearchResult]]:  # noqa: E501
        """SearchPortfolios: Search Portfolios  # noqa: E501

        Search through all portfolios  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_portfolios(search, filter, sort_by, limit, page, async_req=True)
        >>> result = thread.get()

        :param search: A parameter used for searching any portfolio field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type search: str
        :param filter: Expression to filter the result set.  For example, to filter on the portfolio Type, use \"type eq 'Transaction'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName
        :type sort_by: str
        :param limit: When paginating, only return this number of records
        :type limit: int
        :param page: Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfPortfolioSearchResult
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the search_portfolios_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.search_portfolios_with_http_info(search, filter, sort_by, limit, page, **kwargs)  # noqa: E501

    @validate_arguments
    def search_portfolios_with_http_info(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any portfolio field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the portfolio Type, use \"type eq 'Transaction'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """SearchPortfolios: Search Portfolios  # noqa: E501

        Search through all portfolios  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_portfolios_with_http_info(search, filter, sort_by, limit, page, async_req=True)
        >>> result = thread.get()

        :param search: A parameter used for searching any portfolio field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type search: str
        :param filter: Expression to filter the result set.  For example, to filter on the portfolio Type, use \"type eq 'Transaction'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName
        :type sort_by: str
        :param limit: When paginating, only return this number of records
        :type limit: int
        :param page: Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfPortfolioSearchResult, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'search',
            'filter',
            'sort_by',
            'limit',
            'page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_portfolios" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfPortfolioSearchResult",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/search/portfolios', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def search_properties(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the Value Type, use \"valueType eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, **kwargs) -> PagedResourceListOfPropertyDefinitionSearchResult:  # noqa: E501
        ...

    @overload
    def search_properties(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the Value Type, use \"valueType eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfPropertyDefinitionSearchResult:  # noqa: E501
        ...

    @validate_arguments
    def search_properties(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the Value Type, use \"valueType eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfPropertyDefinitionSearchResult, Awaitable[PagedResourceListOfPropertyDefinitionSearchResult]]:  # noqa: E501
        """SearchProperties: Search Property Definitions  # noqa: E501

        Search through all Property Definitions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_properties(search, filter, sort_by, limit, page, async_req=True)
        >>> result = thread.get()

        :param search: A parameter used for searching any field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type search: str
        :param filter: Expression to filter the result set.  For example, to filter on the Value Type, use \"valueType eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName
        :type sort_by: str
        :param limit: When paginating, only return this number of records
        :type limit: int
        :param page: Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfPropertyDefinitionSearchResult
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the search_properties_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.search_properties_with_http_info(search, filter, sort_by, limit, page, **kwargs)  # noqa: E501

    @validate_arguments
    def search_properties_with_http_info(self, search : Annotated[Optional[StrictStr], Field( description="A parameter used for searching any field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set.  For example, to filter on the Value Type, use \"valueType eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[StrictStr], Field( description="Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="When paginating, only return this number of records")] = None, page : Annotated[Optional[StrictStr], Field( description="Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """SearchProperties: Search Property Definitions  # noqa: E501

        Search through all Property Definitions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_properties_with_http_info(search, filter, sort_by, limit, page, async_req=True)
        >>> result = thread.get()

        :param search: A parameter used for searching any field. Wildcards(*) are supported at the end of words (e.g. 'Port*'). Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type search: str
        :param filter: Expression to filter the result set.  For example, to filter on the Value Type, use \"valueType eq 'string'\" Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName. Multiple fields can be denoted by a comma e.g. -MyFieldName,AnotherFieldName,-AFurtherFieldName
        :type sort_by: str
        :param limit: When paginating, only return this number of records
        :type limit: int
        :param page: Encoded page string returned from a previous search result that will retrieve the next page of data. When this field is supplied, filter, sortBy and search fields should not be supplied.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfPropertyDefinitionSearchResult, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'search',
            'filter',
            'sort_by',
            'limit',
            'page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_properties" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfPropertyDefinitionSearchResult",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/search/propertydefinitions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
