# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictStr, conint, constr, validator

from typing import Dict, Optional

from lusid.models.annul_structured_data_response import AnnulStructuredDataResponse
from lusid.models.create_data_map_request import CreateDataMapRequest
from lusid.models.data_map_key import DataMapKey
from lusid.models.get_data_map_response import GetDataMapResponse
from lusid.models.get_structured_result_data_response import GetStructuredResultDataResponse
from lusid.models.get_virtual_document_response import GetVirtualDocumentResponse
from lusid.models.paged_resource_list_of_virtual_row import PagedResourceListOfVirtualRow
from lusid.models.resource_list_of_address_key_definition import ResourceListOfAddressKeyDefinition
from lusid.models.structured_result_data_id import StructuredResultDataId
from lusid.models.upsert_result_values_data_request import UpsertResultValuesDataRequest
from lusid.models.upsert_structured_data_response import UpsertStructuredDataResponse
from lusid.models.upsert_structured_result_data_request import UpsertStructuredResultDataRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class StructuredResultDataApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_data_map(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create or update data maps.")], request_body : Annotated[Dict[str, CreateDataMapRequest], Field(..., description="Individual data map creation requests.")], **kwargs) -> UpsertStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def create_data_map(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create or update data maps.")], request_body : Annotated[Dict[str, CreateDataMapRequest], Field(..., description="Individual data map creation requests.")], async_req: Optional[bool]=True, **kwargs) -> UpsertStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def create_data_map(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create or update data maps.")], request_body : Annotated[Dict[str, CreateDataMapRequest], Field(..., description="Individual data map creation requests.")], async_req: Optional[bool]=None, **kwargs) -> Union[UpsertStructuredDataResponse, Awaitable[UpsertStructuredDataResponse]]:  # noqa: E501
        """CreateDataMap: Create data map  # noqa: E501

        Create or update one or more structured result store address definition data maps in a particular scope. Note these are immutable and cannot be changed once created.              In the request, each data map must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data map object in the response.              The response returns both the collection of successfully created or updated data maps, as well as those that failed. For each failure, a reason is provided.              It is important to check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_data_map(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to create or update data maps. (required)
        :type scope: str
        :param request_body: Individual data map creation requests. (required)
        :type request_body: Dict[str, CreateDataMapRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_data_map_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_data_map_with_http_info(scope, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def create_data_map_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create or update data maps.")], request_body : Annotated[Dict[str, CreateDataMapRequest], Field(..., description="Individual data map creation requests.")], **kwargs) -> ApiResponse:  # noqa: E501
        """CreateDataMap: Create data map  # noqa: E501

        Create or update one or more structured result store address definition data maps in a particular scope. Note these are immutable and cannot be changed once created.              In the request, each data map must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data map object in the response.              The response returns both the collection of successfully created or updated data maps, as well as those that failed. For each failure, a reason is provided.              It is important to check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_data_map_with_http_info(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to create or update data maps. (required)
        :type scope: str
        :param request_body: Individual data map creation requests. (required)
        :type request_body: Dict[str, CreateDataMapRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_data_map" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/unitresults/datamap/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_structured_result_data(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to delete data items.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The data IDs to delete, each keyed by a unique, ephemeral correlation ID.")], **kwargs) -> AnnulStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def delete_structured_result_data(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to delete data items.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The data IDs to delete, each keyed by a unique, ephemeral correlation ID.")], async_req: Optional[bool]=True, **kwargs) -> AnnulStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_structured_result_data(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to delete data items.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The data IDs to delete, each keyed by a unique, ephemeral correlation ID.")], async_req: Optional[bool]=None, **kwargs) -> Union[AnnulStructuredDataResponse, Awaitable[AnnulStructuredDataResponse]]:  # noqa: E501
        """DeleteStructuredResultData: Delete structured result data  # noqa: E501

        Delete one or more structured result data items from a particular scope. Each item is identified by a unique ID which includes information about its type as well as the exact effective datetime (to the microsecond) at which it entered the system (became valid).              In the request, each data item must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data item in the response.              The response returns both the collection of successfully deleted data items, as well as those that failed. For each failure, a reason is provided.              It is important to check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_structured_result_data(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope from which to delete data items. (required)
        :type scope: str
        :param request_body: The data IDs to delete, each keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, StructuredResultDataId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnnulStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_structured_result_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_structured_result_data_with_http_info(scope, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_structured_result_data_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to delete data items.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The data IDs to delete, each keyed by a unique, ephemeral correlation ID.")], **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteStructuredResultData: Delete structured result data  # noqa: E501

        Delete one or more structured result data items from a particular scope. Each item is identified by a unique ID which includes information about its type as well as the exact effective datetime (to the microsecond) at which it entered the system (became valid).              In the request, each data item must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data item in the response.              The response returns both the collection of successfully deleted data items, as well as those that failed. For each failure, a reason is provided.              It is important to check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_structured_result_data_with_http_info(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope from which to delete data items. (required)
        :type scope: str
        :param request_body: The data IDs to delete, each keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, StructuredResultDataId]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AnnulStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_structured_result_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "AnnulStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/unitresults/{scope}/$delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_address_key_definitions_for_document(self, scope : Annotated[StrictStr, Field(..., description="The scope of the document for which address key definitions are retrieved.")], code : Annotated[StrictStr, Field(..., description="The code of the document for which address key definitions are retrieved.")], source : Annotated[StrictStr, Field(..., description="The source of the document for which address key definitions are retrieved.")], result_type : Annotated[StrictStr, Field(..., description="The result type of the document for which address key definitions are retrieved.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.")] = None, **kwargs) -> ResourceListOfAddressKeyDefinition:  # noqa: E501
        ...

    @overload
    def get_address_key_definitions_for_document(self, scope : Annotated[StrictStr, Field(..., description="The scope of the document for which address key definitions are retrieved.")], code : Annotated[StrictStr, Field(..., description="The code of the document for which address key definitions are retrieved.")], source : Annotated[StrictStr, Field(..., description="The source of the document for which address key definitions are retrieved.")], result_type : Annotated[StrictStr, Field(..., description="The result type of the document for which address key definitions are retrieved.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfAddressKeyDefinition:  # noqa: E501
        ...

    @validate_arguments
    def get_address_key_definitions_for_document(self, scope : Annotated[StrictStr, Field(..., description="The scope of the document for which address key definitions are retrieved.")], code : Annotated[StrictStr, Field(..., description="The code of the document for which address key definitions are retrieved.")], source : Annotated[StrictStr, Field(..., description="The source of the document for which address key definitions are retrieved.")], result_type : Annotated[StrictStr, Field(..., description="The result type of the document for which address key definitions are retrieved.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfAddressKeyDefinition, Awaitable[ResourceListOfAddressKeyDefinition]]:  # noqa: E501
        """GetAddressKeyDefinitionsForDocument: Get AddressKeyDefinitions for a virtual document.  # noqa: E501

        For a given virtual document retrieve all the address key definitions that are in use.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_address_key_definitions_for_document(scope, code, source, result_type, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the document for which address key definitions are retrieved. (required)
        :type scope: str
        :param code: The code of the document for which address key definitions are retrieved. (required)
        :type code: str
        :param source: The source of the document for which address key definitions are retrieved. (required)
        :type source: str
        :param result_type: The result type of the document for which address key definitions are retrieved. (required)
        :type result_type: str
        :param effective_at: The effective datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfAddressKeyDefinition
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_address_key_definitions_for_document_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_address_key_definitions_for_document_with_http_info(scope, code, source, result_type, effective_at, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_address_key_definitions_for_document_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the document for which address key definitions are retrieved.")], code : Annotated[StrictStr, Field(..., description="The code of the document for which address key definitions are retrieved.")], source : Annotated[StrictStr, Field(..., description="The source of the document for which address key definitions are retrieved.")], result_type : Annotated[StrictStr, Field(..., description="The result type of the document for which address key definitions are retrieved.")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetAddressKeyDefinitionsForDocument: Get AddressKeyDefinitions for a virtual document.  # noqa: E501

        For a given virtual document retrieve all the address key definitions that are in use.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_address_key_definitions_for_document_with_http_info(scope, code, source, result_type, effective_at, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the document for which address key definitions are retrieved. (required)
        :type scope: str
        :param code: The code of the document for which address key definitions are retrieved. (required)
        :type code: str
        :param source: The source of the document for which address key definitions are retrieved. (required)
        :type source: str
        :param result_type: The result type of the document for which address key definitions are retrieved. (required)
        :type result_type: str
        :param effective_at: The effective datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime to query the document for which the address key definitions are retrieved.             Defaults to querying the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfAddressKeyDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'source',
            'result_type',
            'effective_at',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_address_key_definitions_for_document" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['source']:
            _path_params['source'] = _params['source']

        if _params['result_type']:
            _path_params['resultType'] = _params['result_type']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfAddressKeyDefinition",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/unitresults/virtualdocument/{scope}/{code}/{source}/{resultType}/addresskeydefinitions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_data_map(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to retrieve data maps.")], request_body : Annotated[Dict[str, DataMapKey], Field(..., description="The data map keys to look up, each keyed by a unique, ephemeral correlation ID.")], **kwargs) -> GetDataMapResponse:  # noqa: E501
        ...

    @overload
    def get_data_map(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to retrieve data maps.")], request_body : Annotated[Dict[str, DataMapKey], Field(..., description="The data map keys to look up, each keyed by a unique, ephemeral correlation ID.")], async_req: Optional[bool]=True, **kwargs) -> GetDataMapResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_data_map(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to retrieve data maps.")], request_body : Annotated[Dict[str, DataMapKey], Field(..., description="The data map keys to look up, each keyed by a unique, ephemeral correlation ID.")], async_req: Optional[bool]=None, **kwargs) -> Union[GetDataMapResponse, Awaitable[GetDataMapResponse]]:  # noqa: E501
        """GetDataMap: Get data map  # noqa: E501

        Retrieve one or more structured result store address definition data maps from a particular scope.              Each data map can be identified by its invariant key, which can be thought of as a permanent URL. For each ID, LUSID returns the most recently matched item.              In the request, each data map must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data map in the response.              The response returns three collections. The first contains successfully retrieved data maps. The second contains those with a valid identifier but that could not be found. The third contains those that failed because LUSID could not construct a valid identifier from the request.              For the IDs that failed to resolve or could not be found, a reason is provided.              It is important to check the failed sets for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_map(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope from which to retrieve data maps. (required)
        :type scope: str
        :param request_body: The data map keys to look up, each keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, DataMapKey]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDataMapResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_data_map_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_data_map_with_http_info(scope, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def get_data_map_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to retrieve data maps.")], request_body : Annotated[Dict[str, DataMapKey], Field(..., description="The data map keys to look up, each keyed by a unique, ephemeral correlation ID.")], **kwargs) -> ApiResponse:  # noqa: E501
        """GetDataMap: Get data map  # noqa: E501

        Retrieve one or more structured result store address definition data maps from a particular scope.              Each data map can be identified by its invariant key, which can be thought of as a permanent URL. For each ID, LUSID returns the most recently matched item.              In the request, each data map must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data map in the response.              The response returns three collections. The first contains successfully retrieved data maps. The second contains those with a valid identifier but that could not be found. The third contains those that failed because LUSID could not construct a valid identifier from the request.              For the IDs that failed to resolve or could not be found, a reason is provided.              It is important to check the failed sets for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_data_map_with_http_info(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope from which to retrieve data maps. (required)
        :type scope: str
        :param request_body: The data map keys to look up, each keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, DataMapKey]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDataMapResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_map" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GetDataMapResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/unitresults/datamap/{scope}/$get', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_structured_result_data(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to retrieve data items.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look-back window in ISO8601 time interval format, for example 'P1Y2M3DT4H30M' (1 year, 2 months, 3 days, 4 hours and 30 minutes).              This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a data item must exist to be retrieved.")] = None, **kwargs) -> GetStructuredResultDataResponse:  # noqa: E501
        ...

    @overload
    def get_structured_result_data(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to retrieve data items.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look-back window in ISO8601 time interval format, for example 'P1Y2M3DT4H30M' (1 year, 2 months, 3 days, 4 hours and 30 minutes).              This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a data item must exist to be retrieved.")] = None, async_req: Optional[bool]=True, **kwargs) -> GetStructuredResultDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_structured_result_data(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to retrieve data items.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look-back window in ISO8601 time interval format, for example 'P1Y2M3DT4H30M' (1 year, 2 months, 3 days, 4 hours and 30 minutes).              This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a data item must exist to be retrieved.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[GetStructuredResultDataResponse, Awaitable[GetStructuredResultDataResponse]]:  # noqa: E501
        """GetStructuredResultData: Get structured result data  # noqa: E501

        Retrieve one or more structured result data items from a particular scope.              Each item can be identified by its time invariant structured result data identifier. For each ID, LUSID returns the most recently matched item with respect to the provided (or default) effective datetime.               An optional maximum age range window can be specified to control how far back to look from the specified effective datetime. LUSID returns the most recent item within this window.              In the request, each data item must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data item in the response.  The response returns three collections. The first contains successfully retrieved data items. The second contains those with a valid identifier but that could not be found. The third contains those that failed because LUSID could not construct a valid identifier from the request.  For the IDs that failed to resolve or could not be found, a reason is provided.              It is important to check the failed sets for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_structured_result_data(scope, request_body, as_at, max_age, async_req=True)
        >>> result = thread.get()

        :param scope: The scope from which to retrieve data items. (required)
        :type scope: str
        :param request_body: The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, StructuredResultDataId]
        :param as_at: The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.
        :type as_at: datetime
        :param max_age: The duration of the look-back window in ISO8601 time interval format, for example 'P1Y2M3DT4H30M' (1 year, 2 months, 3 days, 4 hours and 30 minutes).              This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a data item must exist to be retrieved.
        :type max_age: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStructuredResultDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_structured_result_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_structured_result_data_with_http_info(scope, request_body, as_at, max_age, **kwargs)  # noqa: E501

    @validate_arguments
    def get_structured_result_data_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope from which to retrieve data items.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.")] = None, max_age : Annotated[Optional[StrictStr], Field( description="The duration of the look-back window in ISO8601 time interval format, for example 'P1Y2M3DT4H30M' (1 year, 2 months, 3 days, 4 hours and 30 minutes).              This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a data item must exist to be retrieved.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetStructuredResultData: Get structured result data  # noqa: E501

        Retrieve one or more structured result data items from a particular scope.              Each item can be identified by its time invariant structured result data identifier. For each ID, LUSID returns the most recently matched item with respect to the provided (or default) effective datetime.               An optional maximum age range window can be specified to control how far back to look from the specified effective datetime. LUSID returns the most recent item within this window.              In the request, each data item must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data item in the response.  The response returns three collections. The first contains successfully retrieved data items. The second contains those with a valid identifier but that could not be found. The third contains those that failed because LUSID could not construct a valid identifier from the request.  For the IDs that failed to resolve or could not be found, a reason is provided.              It is important to check the failed sets for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_structured_result_data_with_http_info(scope, request_body, as_at, max_age, async_req=True)
        >>> result = thread.get()

        :param scope: The scope from which to retrieve data items. (required)
        :type scope: str
        :param request_body: The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, StructuredResultDataId]
        :param as_at: The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.
        :type as_at: datetime
        :param max_age: The duration of the look-back window in ISO8601 time interval format, for example 'P1Y2M3DT4H30M' (1 year, 2 months, 3 days, 4 hours and 30 minutes).              This is subtracted from the provided effectiveAt datetime to generate a effective datetime window inside which a data item must exist to be retrieved.
        :type max_age: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStructuredResultDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body',
            'as_at',
            'max_age'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_structured_result_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('max_age') is not None:  # noqa: E501
            _query_params.append(('maxAge', _params['max_age']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GetStructuredResultDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/unitresults/{scope}/$get', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_virtual_document(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to construct the virtual documents.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.")] = None, **kwargs) -> GetVirtualDocumentResponse:  # noqa: E501
        ...

    @overload
    def get_virtual_document(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to construct the virtual documents.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.")] = None, async_req: Optional[bool]=True, **kwargs) -> GetVirtualDocumentResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_virtual_document(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to construct the virtual documents.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[GetVirtualDocumentResponse, Awaitable[GetVirtualDocumentResponse]]:  # noqa: E501
        """GetVirtualDocument: Get Virtual Documents  # noqa: E501

        Retrieve one or more virtual documents from a particular scope.              Each item can be identified by its time invariant structured result data identifier. For each ID, LUSID returns the most recently matched item with respect to the provided effective datetime.              In the request, each data item must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data item in the response.              The response returns two collections. The first contains successfully retrieved data items. The second contains those with a valid identifier but that could not be found, or those that failed because LUSID could not construct a valid identifier from the request.              For the IDs that failed to resolve or could not be found, a reason is provided.              It is important to check the failed sets for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_virtual_document(scope, request_body, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to construct the virtual documents. (required)
        :type scope: str
        :param request_body: The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, StructuredResultDataId]
        :param as_at: The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetVirtualDocumentResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_virtual_document_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_virtual_document_with_http_info(scope, request_body, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_virtual_document_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to construct the virtual documents.")], request_body : Annotated[Dict[str, StructuredResultDataId], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetVirtualDocument: Get Virtual Documents  # noqa: E501

        Retrieve one or more virtual documents from a particular scope.              Each item can be identified by its time invariant structured result data identifier. For each ID, LUSID returns the most recently matched item with respect to the provided effective datetime.              In the request, each data item must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data item in the response.              The response returns two collections. The first contains successfully retrieved data items. The second contains those with a valid identifier but that could not be found, or those that failed because LUSID could not construct a valid identifier from the request.              For the IDs that failed to resolve or could not be found, a reason is provided.              It is important to check the failed sets for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_virtual_document_with_http_info(scope, request_body, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to construct the virtual documents. (required)
        :type scope: str
        :param request_body: The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, StructuredResultDataId]
        :param as_at: The asAt datetime at which to retrieve the structured result data. Defaults to returning the latest version if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetVirtualDocumentResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_virtual_document" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "GetVirtualDocumentResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/unitresults/virtualdocument/{scope}/$get', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_virtual_document_rows(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to retrieve the virtual document.")], code : Annotated[StrictStr, Field(..., description="The code of the virtual document to retrieve.")], source : Annotated[StrictStr, Field(..., description="The source of the virtual document to retrieve.")], result_type : Annotated[StrictStr, Field(..., description="The result type of the virtual document to retrieve.")], effective_at : Annotated[StrictStr, Field(..., description="The effectiveAt datetime at which to retrieve the virtual document.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the virtual document. Defaults to returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing virtual document rows from a previous              call to list virtual document rows. This value is returned from the previous call. If a pagination token is              provided the filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> PagedResourceListOfVirtualRow:  # noqa: E501
        ...

    @overload
    def get_virtual_document_rows(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to retrieve the virtual document.")], code : Annotated[StrictStr, Field(..., description="The code of the virtual document to retrieve.")], source : Annotated[StrictStr, Field(..., description="The source of the virtual document to retrieve.")], result_type : Annotated[StrictStr, Field(..., description="The result type of the virtual document to retrieve.")], effective_at : Annotated[StrictStr, Field(..., description="The effectiveAt datetime at which to retrieve the virtual document.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the virtual document. Defaults to returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing virtual document rows from a previous              call to list virtual document rows. This value is returned from the previous call. If a pagination token is              provided the filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfVirtualRow:  # noqa: E501
        ...

    @validate_arguments
    def get_virtual_document_rows(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to retrieve the virtual document.")], code : Annotated[StrictStr, Field(..., description="The code of the virtual document to retrieve.")], source : Annotated[StrictStr, Field(..., description="The source of the virtual document to retrieve.")], result_type : Annotated[StrictStr, Field(..., description="The result type of the virtual document to retrieve.")], effective_at : Annotated[StrictStr, Field(..., description="The effectiveAt datetime at which to retrieve the virtual document.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the virtual document. Defaults to returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing virtual document rows from a previous              call to list virtual document rows. This value is returned from the previous call. If a pagination token is              provided the filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfVirtualRow, Awaitable[PagedResourceListOfVirtualRow]]:  # noqa: E501
        """GetVirtualDocumentRows: Get Virtual Document Rows  # noqa: E501

        Retrieve the rows of the virtual document with the specified identifiers and the given effectiveAt date time.  Get virtual document rows merges multiple StructuredResultData items upserted with UpsertStructuredResultData for a single StructuredResultDataId.              Since an item of StructuredResultData is always upserted with a StructuredResultDataId, of which effectiveAt is a part, then merging across the asAt dimension is supported but not merging across the effectiveAt dimension.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_virtual_document_rows(scope, code, source, result_type, effective_at, as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to retrieve the virtual document. (required)
        :type scope: str
        :param code: The code of the virtual document to retrieve. (required)
        :type code: str
        :param source: The source of the virtual document to retrieve. (required)
        :type source: str
        :param result_type: The result type of the virtual document to retrieve. (required)
        :type result_type: str
        :param effective_at: The effectiveAt datetime at which to retrieve the virtual document. (required)
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the virtual document. Defaults to returning the latest version if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing virtual document rows from a previous              call to list virtual document rows. This value is returned from the previous call. If a pagination token is              provided the filter, effectiveAt, and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfVirtualRow
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_virtual_document_rows_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_virtual_document_rows_with_http_info(scope, code, source, result_type, effective_at, as_at, page, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def get_virtual_document_rows_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to retrieve the virtual document.")], code : Annotated[StrictStr, Field(..., description="The code of the virtual document to retrieve.")], source : Annotated[StrictStr, Field(..., description="The source of the virtual document to retrieve.")], result_type : Annotated[StrictStr, Field(..., description="The result type of the virtual document to retrieve.")], effective_at : Annotated[StrictStr, Field(..., description="The effectiveAt datetime at which to retrieve the virtual document.")], as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the virtual document. Defaults to returning the latest version if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing virtual document rows from a previous              call to list virtual document rows. This value is returned from the previous call. If a pagination token is              provided the filter, effectiveAt, and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GetVirtualDocumentRows: Get Virtual Document Rows  # noqa: E501

        Retrieve the rows of the virtual document with the specified identifiers and the given effectiveAt date time.  Get virtual document rows merges multiple StructuredResultData items upserted with UpsertStructuredResultData for a single StructuredResultDataId.              Since an item of StructuredResultData is always upserted with a StructuredResultDataId, of which effectiveAt is a part, then merging across the asAt dimension is supported but not merging across the effectiveAt dimension.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_virtual_document_rows_with_http_info(scope, code, source, result_type, effective_at, as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to retrieve the virtual document. (required)
        :type scope: str
        :param code: The code of the virtual document to retrieve. (required)
        :type code: str
        :param source: The source of the virtual document to retrieve. (required)
        :type source: str
        :param result_type: The result type of the virtual document to retrieve. (required)
        :type result_type: str
        :param effective_at: The effectiveAt datetime at which to retrieve the virtual document. (required)
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the virtual document. Defaults to returning the latest version if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing virtual document rows from a previous              call to list virtual document rows. This value is returned from the previous call. If a pagination token is              provided the filter, effectiveAt, and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Expression to filter the result set. Read more about filtering results from LUSID here:              https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfVirtualRow, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'source',
            'result_type',
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_virtual_document_rows" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['source']:
            _path_params['source'] = _params['source']

        if _params['result_type']:
            _path_params['resultType'] = _params['result_type']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfVirtualRow",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/unitresults/virtualdocument/{scope}/{code}/{source}/{resultType}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_result_value(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to construct the virtual documents.")], request_body : Annotated[Dict[str, UpsertResultValuesDataRequest], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], **kwargs) -> UpsertStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def upsert_result_value(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to construct the virtual documents.")], request_body : Annotated[Dict[str, UpsertResultValuesDataRequest], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], async_req: Optional[bool]=True, **kwargs) -> UpsertStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_result_value(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to construct the virtual documents.")], request_body : Annotated[Dict[str, UpsertResultValuesDataRequest], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], async_req: Optional[bool]=None, **kwargs) -> Union[UpsertStructuredDataResponse, Awaitable[UpsertStructuredDataResponse]]:  # noqa: E501
        """UpsertResultValue: Upsert result value  # noqa: E501

        Create or update one or more Upsert one or more result values in a particular scope. An item is updated if it already exists and created if it does not.              In the request, each data item must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data item in the response.              The response returns both the collection of successfully created or updated data items, as well as those that failed. For each failure, a reason is provided.              It is important to check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_result_value(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to construct the virtual documents. (required)
        :type scope: str
        :param request_body: The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, UpsertResultValuesDataRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_result_value_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_result_value_with_http_info(scope, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_result_value_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to construct the virtual documents.")], request_body : Annotated[Dict[str, UpsertResultValuesDataRequest], Field(..., description="The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID.")], **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertResultValue: Upsert result value  # noqa: E501

        Create or update one or more Upsert one or more result values in a particular scope. An item is updated if it already exists and created if it does not.              In the request, each data item must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data item in the response.              The response returns both the collection of successfully created or updated data items, as well as those that failed. For each failure, a reason is provided.              It is important to check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_result_value_with_http_info(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to construct the virtual documents. (required)
        :type scope: str
        :param request_body: The time invariant set of structured data identifiers to retrieve, keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, UpsertResultValuesDataRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_result_value" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/unitresults/resultvalue/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_structured_result_data(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create or update data items.")], request_body : Annotated[Dict[str, UpsertStructuredResultDataRequest], Field(..., description="The set of data items to create or update, keyed by a unique, ephemeral correlation ID.")], **kwargs) -> UpsertStructuredDataResponse:  # noqa: E501
        ...

    @overload
    def upsert_structured_result_data(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create or update data items.")], request_body : Annotated[Dict[str, UpsertStructuredResultDataRequest], Field(..., description="The set of data items to create or update, keyed by a unique, ephemeral correlation ID.")], async_req: Optional[bool]=True, **kwargs) -> UpsertStructuredDataResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_structured_result_data(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create or update data items.")], request_body : Annotated[Dict[str, UpsertStructuredResultDataRequest], Field(..., description="The set of data items to create or update, keyed by a unique, ephemeral correlation ID.")], async_req: Optional[bool]=None, **kwargs) -> Union[UpsertStructuredDataResponse, Awaitable[UpsertStructuredDataResponse]]:  # noqa: E501
        """UpsertStructuredResultData: Upsert structured result data  # noqa: E501

        Create or update one or more structured result data items in a particular scope. An item is updated if it already exists and created if it does not.              In the request, each data item must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data item in the response.              The response returns both the collection of successfully created or updated data items, as well as those that failed. For each failure, a reason is provided.              It is important to check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_structured_result_data(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to create or update data items. (required)
        :type scope: str
        :param request_body: The set of data items to create or update, keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, UpsertStructuredResultDataRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertStructuredDataResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_structured_result_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_structured_result_data_with_http_info(scope, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_structured_result_data_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope in which to create or update data items.")], request_body : Annotated[Dict[str, UpsertStructuredResultDataRequest], Field(..., description="The set of data items to create or update, keyed by a unique, ephemeral correlation ID.")], **kwargs) -> ApiResponse:  # noqa: E501
        """UpsertStructuredResultData: Upsert structured result data  # noqa: E501

        Create or update one or more structured result data items in a particular scope. An item is updated if it already exists and created if it does not.              In the request, each data item must be keyed by a unique correlation ID. This ID is ephemeral and not stored by LUSID. It serves only to easily identify each data item in the response.              The response returns both the collection of successfully created or updated data items, as well as those that failed. For each failure, a reason is provided.              It is important to check the failed set for any unsuccessful results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_structured_result_data_with_http_info(scope, request_body, async_req=True)
        >>> result = thread.get()

        :param scope: The scope in which to create or update data items. (required)
        :type scope: str
        :param request_body: The set of data items to create or update, keyed by a unique, ephemeral correlation ID. (required)
        :type request_body: Dict[str, UpsertStructuredResultDataRequest]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertStructuredDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_structured_result_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertStructuredDataResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/unitresults/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
