# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool 

class AggregationOptions(BaseModel):
    """
    Options for controlling the default aspects and behaviour of the aggregation.  # noqa: E501
    """
    use_ansi_like_syntax: Optional[StrictBool] = Field(None, alias="useAnsiLikeSyntax", description="Should the aggregation behave like ANSI Sql or MySql with respect to a conceptual request which is equivalent to \"select a,sum(a) from results\"; ANSI Sql would report an error if a was not unique where MySql would simply view a,suma(a) as equivalent to firstof(a),sum(a).")
    allow_partial_entitlement_success: Optional[StrictBool] = Field(None, alias="allowPartialEntitlementSuccess", description="In the case of valuing a portfolio group where some, but not all entitlements fail, should the aggregation return the valuations applied only to those portfolios where entitlements checks succeeded.")
    apply_iso4217_rounding: Optional[StrictBool] = Field(None, alias="applyIso4217Rounding", description="Various results that are units of currency might need to be rounded. This will round according to the ISO4217 standard number of decimal places for a currency.")
    __properties = ["useAnsiLikeSyntax", "allowPartialEntitlementSuccess", "applyIso4217Rounding"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AggregationOptions:
        """Create an instance of AggregationOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AggregationOptions:
        """Create an instance of AggregationOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AggregationOptions.parse_obj(obj)

        _obj = AggregationOptions.parse_obj({
            "use_ansi_like_syntax": obj.get("useAnsiLikeSyntax"),
            "allow_partial_entitlement_success": obj.get("allowPartialEntitlementSuccess"),
            "apply_iso4217_rounding": obj.get("applyIso4217Rounding")
        })
        return _obj
