# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, constr 

class ChangeItem(BaseModel):
    """
    Information about a change to a field / property. At least one of 'PreviousValue' or 'NewValue' will be set.  # noqa: E501
    """
    field_name:  StrictStr = Field(...,alias="fieldName", description="The name of the field or property that has been changed.") 
    previous_value:  Optional[StrictStr] = Field(None,alias="previousValue", description="The previous value for this field / property.") 
    new_value:  Optional[StrictStr] = Field(None,alias="newValue", description="The new value for this field / property.") 
    effective_from: Optional[datetime] = Field(None, alias="effectiveFrom", description="The market data time, i.e. the time to run the change from.")
    effective_until: Optional[datetime] = Field(None, alias="effectiveUntil", description="The market data time, i.e. the time to run the change until.")
    __properties = ["fieldName", "previousValue", "newValue", "effectiveFrom", "effectiveUntil"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChangeItem:
        """Create an instance of ChangeItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if previous_value (nullable) is None
        # and __fields_set__ contains the field
        if self.previous_value is None and "previous_value" in self.__fields_set__:
            _dict['previousValue'] = None

        # set to None if new_value (nullable) is None
        # and __fields_set__ contains the field
        if self.new_value is None and "new_value" in self.__fields_set__:
            _dict['newValue'] = None

        # set to None if effective_from (nullable) is None
        # and __fields_set__ contains the field
        if self.effective_from is None and "effective_from" in self.__fields_set__:
            _dict['effectiveFrom'] = None

        # set to None if effective_until (nullable) is None
        # and __fields_set__ contains the field
        if self.effective_until is None and "effective_until" in self.__fields_set__:
            _dict['effectiveUntil'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChangeItem:
        """Create an instance of ChangeItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChangeItem.parse_obj(obj)

        _obj = ChangeItem.parse_obj({
            "field_name": obj.get("fieldName"),
            "previous_value": obj.get("previousValue"),
            "new_value": obj.get("newValue"),
            "effective_from": obj.get("effectiveFrom"),
            "effective_until": obj.get("effectiveUntil")
        })
        return _obj
