# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field 
from lusid.models.data_map_key import DataMapKey
from lusid.models.data_mapping import DataMapping

class CreateDataMapRequest(BaseModel):
    """
    Request to create a new data map  # noqa: E501
    """
    id: DataMapKey = Field(...)
    data: Optional[DataMapping] = None
    __properties = ["id", "data"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateDataMapRequest:
        """Create an instance of CreateDataMapRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateDataMapRequest:
        """Create an instance of CreateDataMapRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateDataMapRequest.parse_obj(obj)

        _obj = CreateDataMapRequest.parse_obj({
            "id": DataMapKey.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "data": DataMapping.from_dict(obj.get("data")) if obj.get("data") is not None else None
        })
        return _obj
