# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, constr 

class FlowConventionName(BaseModel):
    """
    Representation of an abstract definition of a flow convention set consisting of currency, tenor and an index name (arbitrary string but likely something like \"IBOR\").  # noqa: E501
    """
    currency:  StrictStr = Field(...,alias="currency", description="Currency of the flow convention name.") 
    index_name:  Optional[StrictStr] = Field(None,alias="indexName", description="The index, if present, that is required. e.g. \"IBOR\", \"OIS\" or \"SONIA\".") 
    tenor:  StrictStr = Field(...,alias="tenor", description="Tenor for the convention name.  For more information on tenors, see [knowledge base article KA-02097](https://support.lusid.com/knowledgebase/article/KA-02097)") 
    __properties = ["currency", "indexName", "tenor"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FlowConventionName:
        """Create an instance of FlowConventionName from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if index_name (nullable) is None
        # and __fields_set__ contains the field
        if self.index_name is None and "index_name" in self.__fields_set__:
            _dict['indexName'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FlowConventionName:
        """Create an instance of FlowConventionName from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FlowConventionName.parse_obj(obj)

        _obj = FlowConventionName.parse_obj({
            "currency": obj.get("currency"),
            "index_name": obj.get("indexName"),
            "tenor": obj.get("tenor")
        })
        return _obj
