# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, Field, StrictStr, conlist, constr, validator 
from lusid.models.complex_market_data import ComplexMarketData
from lusid.models.fx_tenor_convention import FxTenorConvention
from lusid.models.market_data_options import MarketDataOptions

class FxForwardCurveByQuoteReference(ComplexMarketData):
    """
    Contains data (i.e. tenors and rates + metadata) for building fx forward curves (when combined with a date to build on)  # noqa: E501
    """
    dom_ccy:  StrictStr = Field(...,alias="domCcy", description="Domestic currency of the fx forward") 
    fgn_ccy:  StrictStr = Field(...,alias="fgnCcy", description="Foreign currency of the fx forward") 
    tenors: conlist(StrictStr) = Field(..., description="Tenors for which the forward rates apply. For more information on tenors, see [knowledge base article KA-02097](https://support.lusid.com/knowledgebase/article/KA-02097)")
    quote_references: conlist(Dict[str, StrictStr]) = Field(..., alias="quoteReferences", description="For each tenor, a collection of identifiers. These will be looked up in the LUSID Quote Store to resolve the actual rates. Accepts an array of Dictionary<string, string>. The keys of each dictionary must be chosen from the following enumeration: [LusidInstrumentId, Isin, Sedol, Cusip, ClientInternal, Figi, RIC, QuotePermId, REDCode, BBGId, ICECode]. For example:  \"quoteReferences\": [{\"ClientInternal\": \"SomeIdentifierForFirstTenor\"},{\"ClientInternal\": \"SomeIdentifierForSecondTenor\"}")
    lineage:  Optional[StrictStr] = Field(None,alias="lineage", description="Description of the complex market data's lineage e.g. 'FundAccountant_GreenQuality'.") 
    market_data_options: Optional[MarketDataOptions] = Field(None, alias="marketDataOptions")
    calendars: Optional[conlist(FxTenorConvention)] = Field(None, description="The list of conventions that should be used when interpreting tenors as dates.")
    spot_days_calculation_type:  Optional[StrictStr] = Field(None,alias="spotDaysCalculationType", description="Configures how to calculate the spot date from the build date using the Calendars provided. Supported string (enumeration) values are: [ SingleCalendar, UnionCalendars ]") 
    market_data_type:  StrictStr = Field(...,alias="marketDataType", description="The available values are: DiscountFactorCurveData, EquityVolSurfaceData, FxVolSurfaceData, IrVolCubeData, OpaqueMarketData, YieldCurveData, FxForwardCurveData, FxForwardPipsCurveData, FxForwardTenorCurveData, FxForwardTenorPipsCurveData, FxForwardCurveByQuoteReference, CreditSpreadCurveData, EquityCurveByPricesData, ConstantVolatilitySurface") 
    additional_properties: Dict[str, Any] = {}
    __properties = ["marketDataType", "domCcy", "fgnCcy", "tenors", "quoteReferences", "lineage", "marketDataOptions", "calendars", "spotDaysCalculationType"]

    @validator('market_data_type')
    def market_data_type_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'FxForwardCurveByQuoteReference' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse']:
           return value
        
        # Only validate the 'type' property of the class
        if "market_data_type" != "type":
            return value

        if value not in ('DiscountFactorCurveData', 'EquityVolSurfaceData', 'FxVolSurfaceData', 'IrVolCubeData', 'OpaqueMarketData', 'YieldCurveData', 'FxForwardCurveData', 'FxForwardPipsCurveData', 'FxForwardTenorCurveData', 'FxForwardTenorPipsCurveData', 'FxForwardCurveByQuoteReference', 'CreditSpreadCurveData', 'EquityCurveByPricesData', 'ConstantVolatilitySurface'):
            raise ValueError("must be one of enum values ('DiscountFactorCurveData', 'EquityVolSurfaceData', 'FxVolSurfaceData', 'IrVolCubeData', 'OpaqueMarketData', 'YieldCurveData', 'FxForwardCurveData', 'FxForwardPipsCurveData', 'FxForwardTenorCurveData', 'FxForwardTenorPipsCurveData', 'FxForwardCurveByQuoteReference', 'CreditSpreadCurveData', 'EquityCurveByPricesData', 'ConstantVolatilitySurface')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FxForwardCurveByQuoteReference:
        """Create an instance of FxForwardCurveByQuoteReference from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of market_data_options
        if self.market_data_options:
            _dict['marketDataOptions'] = self.market_data_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in calendars (list)
        _items = []
        if self.calendars:
            for _item in self.calendars:
                if _item:
                    _items.append(_item.to_dict())
            _dict['calendars'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if lineage (nullable) is None
        # and __fields_set__ contains the field
        if self.lineage is None and "lineage" in self.__fields_set__:
            _dict['lineage'] = None

        # set to None if calendars (nullable) is None
        # and __fields_set__ contains the field
        if self.calendars is None and "calendars" in self.__fields_set__:
            _dict['calendars'] = None

        # set to None if spot_days_calculation_type (nullable) is None
        # and __fields_set__ contains the field
        if self.spot_days_calculation_type is None and "spot_days_calculation_type" in self.__fields_set__:
            _dict['spotDaysCalculationType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FxForwardCurveByQuoteReference:
        """Create an instance of FxForwardCurveByQuoteReference from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FxForwardCurveByQuoteReference.parse_obj(obj)

        _obj = FxForwardCurveByQuoteReference.parse_obj({
            "market_data_type": obj.get("marketDataType"),
            "dom_ccy": obj.get("domCcy"),
            "fgn_ccy": obj.get("fgnCcy"),
            "tenors": obj.get("tenors"),
            "quote_references": obj.get("quoteReferences"),
            "lineage": obj.get("lineage"),
            "market_data_options": MarketDataOptions.from_dict(obj.get("marketDataOptions")) if obj.get("marketDataOptions") is not None else None,
            "calendars": [FxTenorConvention.from_dict(_item) for _item in obj.get("calendars")] if obj.get("calendars") is not None else None,
            "spot_days_calculation_type": obj.get("spotDaysCalculationType")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
