# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt, conlist 
from lusid.models.movement_settlement_summary import MovementSettlementSummary
from lusid.models.transaction import Transaction

class HoldingContributor(BaseModel):
    """
    A list of transactions contributed to a holding.  # noqa: E501
    """
    transaction: Transaction = Field(...)
    holding_id: Optional[StrictInt] = Field(None, alias="holdingId", description="The unique holding identifier")
    movements: Optional[conlist(MovementSettlementSummary)] = Field(None, description="Movements contributed to holding")
    __properties = ["transaction", "holdingId", "movements"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> HoldingContributor:
        """Create an instance of HoldingContributor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of transaction
        if self.transaction:
            _dict['transaction'] = self.transaction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in movements (list)
        _items = []
        if self.movements:
            for _item in self.movements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['movements'] = _items
        # set to None if holding_id (nullable) is None
        # and __fields_set__ contains the field
        if self.holding_id is None and "holding_id" in self.__fields_set__:
            _dict['holdingId'] = None

        # set to None if movements (nullable) is None
        # and __fields_set__ contains the field
        if self.movements is None and "movements" in self.__fields_set__:
            _dict['movements'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> HoldingContributor:
        """Create an instance of HoldingContributor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return HoldingContributor.parse_obj(obj)

        _obj = HoldingContributor.parse_obj({
            "transaction": Transaction.from_dict(obj.get("transaction")) if obj.get("transaction") is not None else None,
            "holding_id": obj.get("holdingId"),
            "movements": [MovementSettlementSummary.from_dict(_item) for _item in obj.get("movements")] if obj.get("movements") is not None else None
        })
        return _obj
