# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist 
from lusid.models.order_rule_breach import OrderRuleBreach
from lusid.models.resource_id import ResourceId

class OrderBreachHistory(BaseModel):
    """
    OrderBreachHistory
    """
    id: ResourceId = Field(...)
    order_id: ResourceId = Field(..., alias="orderId")
    run_id: ResourceId = Field(..., alias="runId")
    breaches_by_rule: Optional[Dict[str, conlist(OrderRuleBreach)]] = Field(None, alias="breachesByRule", description="Compliance rule breaches associations with the order and run.")
    as_at: datetime = Field(..., alias="asAt", description="The asAt datetime at which the order breach was created in LUSID.")
    __properties = ["id", "orderId", "runId", "breachesByRule", "asAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrderBreachHistory:
        """Create an instance of OrderBreachHistory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_id
        if self.order_id:
            _dict['orderId'] = self.order_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of run_id
        if self.run_id:
            _dict['runId'] = self.run_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in breaches_by_rule (dict of array)
        _field_dict_of_array = {}
        if self.breaches_by_rule:
            for _key in self.breaches_by_rule:
                if self.breaches_by_rule[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.breaches_by_rule[_key]
                    ]
            _dict['breachesByRule'] = _field_dict_of_array
        # set to None if breaches_by_rule (nullable) is None
        # and __fields_set__ contains the field
        if self.breaches_by_rule is None and "breaches_by_rule" in self.__fields_set__:
            _dict['breachesByRule'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrderBreachHistory:
        """Create an instance of OrderBreachHistory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrderBreachHistory.parse_obj(obj)

        _obj = OrderBreachHistory.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "order_id": ResourceId.from_dict(obj.get("orderId")) if obj.get("orderId") is not None else None,
            "run_id": ResourceId.from_dict(obj.get("runId")) if obj.get("runId") is not None else None,
            "breaches_by_rule": dict(
                (_k,
                        [OrderRuleBreach.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("breachesByRule").items()
            ),
            "as_at": obj.get("asAt")
        })
        return _obj
