# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, Field, StrictStr, constr, validator 
from lusid.models.result_key_rule import ResultKeyRule

class PortfolioResultDataKeyRule(ResultKeyRule):
    """
    PortfolioResultDataKeyRule
    """
    supplier:  StrictStr = Field(...,alias="supplier", description="the result resource supplier (where the data comes from)") 
    data_scope:  StrictStr = Field(...,alias="dataScope", description="which is the scope in which the data should be found") 
    document_code:  StrictStr = Field(...,alias="documentCode", description="document code that defines which document is desired") 
    quote_interval:  Optional[StrictStr] = Field(None,alias="quoteInterval", description="Shorthand for the time interval used to select result data. This must be a dot-separated string             specifying a start and end date, for example '5D.0D' to look back 5 days from today (0 days ago).") 
    as_at: Optional[datetime] = Field(None, alias="asAt", description="The AsAt predicate specification.")
    portfolio_code:  Optional[StrictStr] = Field(None,alias="portfolioCode") 
    portfolio_scope:  Optional[StrictStr] = Field(None,alias="portfolioScope") 
    result_key_rule_type:  StrictStr = Field(...,alias="resultKeyRuleType", description="The available values are: Invalid, ResultDataKeyRule, PortfolioResultDataKeyRule") 
    additional_properties: Dict[str, Any] = {}
    __properties = ["resultKeyRuleType", "supplier", "dataScope", "documentCode", "quoteInterval", "asAt", "portfolioCode", "portfolioScope"]

    @validator('result_key_rule_type')
    def result_key_rule_type_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'PortfolioResultDataKeyRule' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse']:
           return value
        
        # Only validate the 'type' property of the class
        if "result_key_rule_type" != "type":
            return value

        if value not in ('Invalid', 'ResultDataKeyRule', 'PortfolioResultDataKeyRule'):
            raise ValueError("must be one of enum values ('Invalid', 'ResultDataKeyRule', 'PortfolioResultDataKeyRule')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PortfolioResultDataKeyRule:
        """Create an instance of PortfolioResultDataKeyRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if quote_interval (nullable) is None
        # and __fields_set__ contains the field
        if self.quote_interval is None and "quote_interval" in self.__fields_set__:
            _dict['quoteInterval'] = None

        # set to None if as_at (nullable) is None
        # and __fields_set__ contains the field
        if self.as_at is None and "as_at" in self.__fields_set__:
            _dict['asAt'] = None

        # set to None if portfolio_code (nullable) is None
        # and __fields_set__ contains the field
        if self.portfolio_code is None and "portfolio_code" in self.__fields_set__:
            _dict['portfolioCode'] = None

        # set to None if portfolio_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.portfolio_scope is None and "portfolio_scope" in self.__fields_set__:
            _dict['portfolioScope'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PortfolioResultDataKeyRule:
        """Create an instance of PortfolioResultDataKeyRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PortfolioResultDataKeyRule.parse_obj(obj)

        _obj = PortfolioResultDataKeyRule.parse_obj({
            "result_key_rule_type": obj.get("resultKeyRuleType"),
            "supplier": obj.get("supplier"),
            "data_scope": obj.get("dataScope"),
            "document_code": obj.get("documentCode"),
            "quote_interval": obj.get("quoteInterval"),
            "as_at": obj.get("asAt"),
            "portfolio_code": obj.get("portfolioCode"),
            "portfolio_scope": obj.get("portfolioScope")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
