# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt, StrictStr, constr 

class RelativeDateOffset(BaseModel):
    """
    Defines a date offset which is relative to some anchor date.  # noqa: E501
    """
    days: StrictInt = Field(..., description="The number of days to add to the anchor date.")
    business_day_convention:  StrictStr = Field(...,alias="businessDayConvention", description="The adjustment type to apply to dates that fall upon a non-business day, e.g. modified following or following.  Supported string (enumeration) values are: [NoAdjustment, Previous, P, Following, F, ModifiedPrevious, MP, ModifiedFollowing, MF, HalfMonthModifiedFollowing, Nearest].") 
    day_type:  Optional[StrictStr] = Field(None,alias="dayType", description="Indicates if consideration is given to whether a day is a good business day or not when calculating the offset date.  Supported string (enumeration) values are: [Business, Calendar].") 
    __properties = ["days", "businessDayConvention", "dayType"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RelativeDateOffset:
        """Create an instance of RelativeDateOffset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if day_type (nullable) is None
        # and __fields_set__ contains the field
        if self.day_type is None and "day_type" in self.__fields_set__:
            _dict['dayType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RelativeDateOffset:
        """Create an instance of RelativeDateOffset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RelativeDateOffset.parse_obj(obj)

        _obj = RelativeDateOffset.parse_obj({
            "days": obj.get("days"),
            "business_day_convention": obj.get("businessDayConvention"),
            "day_type": obj.get("dayType")
        })
        return _obj
